/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.HealpixProgen;
import cds.allsky.Action;
import cds.allsky.Builder;
import cds.allsky.BuilderAllsky;
import cds.allsky.Context;
import cds.tools.pixtools.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;

public class BuilderDetails
extends Builder {
    public static final int MINORDER = 3;
    private int detailOrder;
    private int maxOrder;
    private long[] nbItemPerOrder;
    private int statNbFile;
    private long startTime;
    private long totalTime;
    private static final String METADATA = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n<!-- VOTable HiPS hpxfinder mapping file.\n     Use to map and build from a HpxFinder JSON tile a classical VOTable HiPS tile.\n     Adapt it according to your own (see examples below in the comments)\n-->\n\n<VOTABLE version=\"1.2\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xmlns=\"http://www.ivoa.net/xml/VOTable/v1.2\"\n  xsi:schemaLocation=\"http://www.ivoa.net/xml/VOTable/v1.2 http://www.ivoa.net/xml/VOTable/v1.2\">\n \n<RESOURCE>\n  <COOSYS ID=\"J2000\" system=\"eq_FK5\" equinox=\"J2000\"/>\n  <TABLE name=\"YOUR_SURVEY_LABEL\">\n    <FIELD name=\"RAJ2000\" ucd=\"pos.eq.ra\" ref=\"J2000\" datatype=\"double\" precision=\"5\" unit=\"deg\">\n      <DESCRIPTION>Right ascension</DESCRIPTION>\n    </FIELD>\n    <FIELD name=\"DEJ2000\" ucd=\"pos.eq.dec\" ref=\"J2000\" datatype=\"double\" precision=\"5\" unit=\"deg\">\n      <DESCRIPTION>Declination</DESCRIPTION>\n    </FIELD>\n    <FIELD name=\"id\" ucd=\"meta.id;meta.dataset\" datatype=\"char\" arraysize=\"13*\">\n      <DESCRIPTION>Dataset name, uniquely identifies the data for a given exposure.</DESCRIPTION>\n       <!-- Simple HTTP link description (Aladin will open it in a Web navigator)\n         <LINK href=\"http://your.server.edu/info?param=${id}&amp;otherparam=foo\"/>\n       -->\n     </FIELD>\n    <FIELD name=\"access\" datatype=\"char\" arraysize=\"9*\">\n      <DESCRIPTION>Display original image</DESCRIPTION>\n       <LINK content-type=\"image/fits\" href=\"${access}\"/>\n       <!--  Image HTTP link description (Aladin will load it)\n          <LINK content-type=\"image/fits\" href=\"http://your.server.edu/getdata?param=${id}&amp;otherparam=foo\" title=\"remote img\"/>\n        -->\n    </FIELD>\n    <FIELD name=\"FoV\" datatype=\"char\" utype=\"stc:ObservationLocation.AstroCoordArea.Region\" arraysize=\"12*\">\n       <DESCRIPTION>Field of View (STC description)</DESCRIPTION>\n    </FIELD>\n    <!-- Additional Field for extracting Instrument name from original filepath\n         see also associated TD example below\n       <FIELD name=\"Instrument\" datatype=\"char\" arraysize=\"12*\">\n          <DESCRIPTION>Instrument</DESCRIPTION>\n       </FIELD \n     -->\n<DATA>\n   <TABLEDATA> \n      <TR>\n      <TD>$[ra]</TD>\n      <TD>$[dec]</TD>\n      <TD>$[name]</TD>\n      <TD>$[path:([^\\[]*).*]</TD>\n      <TD>$[stc]</TD>\n      <!-- Extended example via prefix and regular expression mapping\n           (here, the instrument name is coded in the original path after \"data\" directory)\n           <TD>Instrument: $[path:.*/data/(.+)/.*]</TD> \n        -->\n      </TR>\n   </TABLEDATA>\n</DATA>\n</TABLE>\n</RESOURCE>\n</VOTABLE>\n\n";

    public BuilderDetails(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.DETAILS;
    }

    @Override
    public void run() throws Exception {
        this.build();
    }

    @Override
    public void validateContext() throws Exception {
        this.validateOutput();
        this.validateIndex();
        this.maxOrder = Util.getMaxOrderByPath(this.context.getHpxFinderPath());
        if (this.maxOrder == -1) {
            throw new Exception("HpxFinder seems to be not yet ready ! (order=-1)");
        }
        this.context.info("Order retrieved from HpxFinder => " + this.maxOrder);
        if (this.context.getOrder() < this.maxOrder) {
            this.context.setMinOrder(this.context.getOrder());
        }
        this.context.setOrder(this.maxOrder);
        this.detailOrder = this.context.getMinOrder();
        if (this.detailOrder != -1) {
            this.context.info("Detail table min order determined by \"minOrder\" parameter => " + this.detailOrder);
        } else {
            this.validateImgWidth();
            if (this.context.typicalImgWidth == -1) {
                this.detailOrder = this.maxOrder - 5;
                this.context.warning("Detail table min order determined in function of max order => " + this.detailOrder);
            } else {
                this.detailOrder = this.maxOrder - this.context.typicalImgWidth / this.context.getTileSide() - 2;
                this.context.info("Detail table min order determined by original image resolution => " + this.detailOrder);
            }
        }
        if (this.detailOrder < 3) {
            this.detailOrder = 3;
        }
        if (this.detailOrder > this.maxOrder) {
            this.context.warning("The target Order (" + this.detailOrder + ") is greater than the index order (" + this.maxOrder + ") => assuming " + this.maxOrder + "...");
            this.detailOrder = this.maxOrder;
        }
        this.context.mocIndex = null;
        this.context.initRegion();
    }

    private void validateIndex() throws Exception {
        String string = this.context.getHpxFinderPath();
        if (string == null) {
            throw new Exception("HEALPix index directory [HpxFinder] not defined => specify the output (or input) directory");
        }
        File file = new File(string);
        if (!(file.exists() && file.isDirectory() && file.canRead())) {
            throw new Exception("HEALPix index directory not available [" + string + "]");
        }
    }

    private void validateImgWidth() throws Exception {
        String string = this.context.getImgEtalon();
        if (string == null && this.context.getInputPath() != null && (string = this.context.justFindImgEtalon(this.context.getInputPath())) != null) {
            this.context.info("Use this reference image => " + string);
        }
        if (string != null) {
            try {
                this.context.setImgEtalon(string);
            }
            catch (Exception exception) {
                this.context.warning("Reference image problem [" + string + "] => " + exception.getMessage());
            }
        }
    }

    @Override
    public void showStatistics() {
        this.context.showJpgStat(this.statNbFile, this.totalTime, 0, 0);
    }

    public void build() throws Exception {
        this.initStat();
        this.context.setProgressMax(768.0);
        String string = this.context.getHpxFinderPath();
        HealpixProgen healpixProgen = null;
        this.nbItemPerOrder = new long[this.maxOrder + 1];
        for (int i = 0; i < 768; ++i) {
            HealpixProgen healpixProgen2 = this.createTree(string, 3, i);
            if (healpixProgen2 != null) {
                if (healpixProgen == null) {
                    healpixProgen = new HealpixProgen();
                }
                if (!healpixProgen.hasTooMany()) {
                    healpixProgen.merge(healpixProgen2);
                    if (healpixProgen.size() > HealpixProgen.TOOMANY) {
                        healpixProgen.setTooMany(true);
                    }
                }
            }
            this.context.setProgress(i);
        }
        if (this.detailOrder > 3) {
            long l = 768L;
            int n = 3;
            while (n < this.detailOrder && this.nbItemPerOrder[n] > (long)HealpixProgen.TOOMANY * l) {
                String string2 = cds.tools.Util.concatDir(string, "Norder" + n);
                this.context.info("Removing HpxFinder detail order " + n + " (too many entries [" + this.nbItemPerOrder[n] + "])...");
                cds.tools.Util.deleteDir(new File(string2));
                if (n == 3) {
                    healpixProgen = null;
                }
                ++n;
                l *= 4L;
            }
            this.detailOrder = n;
        }
        if (healpixProgen != null && !healpixProgen.hasTooMany()) {
            String string3 = BuilderAllsky.getFileName(this.context.getHpxFinderPath(), 3, 0);
            this.writeIndexFile(string3, healpixProgen);
        }
        this.generateMedataFile();
    }

    private void initStat() {
        this.statNbFile = 0;
        this.startTime = System.currentTimeMillis();
    }

    private void updateStat() {
        ++this.statNbFile;
        this.totalTime = System.currentTimeMillis() - this.startTime;
    }

    private HealpixProgen createTree(String string, int n, long l) throws Exception {
        if (this.context.isTaskAborting()) {
            throw new Exception("Task abort !");
        }
        if (!this.context.isInMocTree(n - 1, l / 4L)) {
            return null;
        }
        String string2 = Util.getFilePath(string, n, l);
        HealpixProgen healpixProgen = null;
        if (n == this.maxOrder) {
            healpixProgen = this.createLeave(string2);
        } else {
            HealpixProgen[] healpixProgenArray = new HealpixProgen[4];
            boolean bl = false;
            for (int i = 0; i < 4; ++i) {
                healpixProgenArray[i] = this.createTree(string, n + 1, l * 4L + (long)i);
                if (healpixProgenArray[i] == null || bl) continue;
                bl = true;
            }
            if (bl) {
                healpixProgen = this.createNode(healpixProgenArray);
            }
        }
        if (n < this.detailOrder && healpixProgen != null && healpixProgen.size() > HealpixProgen.TOOMANY) {
            healpixProgen.setTooMany(true);
        }
        if (healpixProgen != null && this.context.isInMocTree(n, l)) {
            int n2 = n;
            this.nbItemPerOrder[n2] = this.nbItemPerOrder[n2] + (long)healpixProgen.size();
            if (!healpixProgen.hasTooMany()) {
                this.writeIndexFile(string2, healpixProgen);
            }
        }
        if (healpixProgen != null && healpixProgen.hasTooMany()) {
            healpixProgen = null;
        }
        return healpixProgen;
    }

    private void writeIndexFile(String string, HealpixProgen healpixProgen) throws Exception {
        cds.tools.Util.createPath(string);
        healpixProgen.writeStream(new FileOutputStream(string));
    }

    private HealpixProgen createLeave(String string) throws Exception {
        File file = new File(string);
        if (!file.exists()) {
            return null;
        }
        HealpixProgen healpixProgen = new HealpixProgen();
        healpixProgen.loadStream(new FileInputStream(file));
        this.updateStat();
        return healpixProgen;
    }

    private HealpixProgen createNode(HealpixProgen[] healpixProgenArray) throws Exception {
        HealpixProgen healpixProgen = new HealpixProgen();
        for (int i = 0; i < 4; ++i) {
            if (healpixProgenArray[i] == null) continue;
            if (healpixProgenArray[i].hasTooMany()) {
                healpixProgen.setTooMany(true);
                break;
            }
            healpixProgen.merge(healpixProgenArray[i]);
            healpixProgenArray[i] = null;
        }
        return healpixProgen;
    }

    private void generateMedataFile() throws Exception {
        String string = cds.tools.Util.concatDir(this.context.getHpxFinderPath(), "metadata.xml");
        if (new File(string).exists()) {
            this.context.info("Pre-existing metadata.xml file => keep it");
        } else {
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
            String string2 = METADATA.replace("YOUR_SURVEY_LABEL", this.context.getLabel() + " details");
            randomAccessFile.write(string2.getBytes());
            randomAccessFile.close();
            this.context.info("Mapping hpxFinder/metadata.xml file has been generated");
        }
        this.context.writeHpxFinderProperties();
        this.context.writeIndexHtml();
    }
}

