/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.MyInputStream;
import cds.allsky.Action;
import cds.allsky.Builder;
import cds.allsky.Context;
import cds.moc.Healpix;
import cds.tools.pixtools.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public class BuilderGzip
extends Builder {
    private int nbFile = 0;

    public BuilderGzip(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.GZIP;
    }

    @Override
    public void validateContext() throws Exception {
        this.validateOutput();
        this.validateDepth();
    }

    @Override
    public void run() throws Exception {
        this.gzipRec(true);
    }

    @Override
    public boolean isAlreadyDone() {
        if (!this.context.actionPrecedeAction(Action.INDEX, Action.TILES)) {
            return false;
        }
        if (!this.context.actionPrecedeAction(Action.TILES, Action.GZIP)) {
            return false;
        }
        if (this.context.actionAlreadyDone(Action.GUNZIP) && !this.context.actionPrecedeAction(Action.GZIP, Action.GUNZIP)) {
            return false;
        }
        this.context.info("GZIP seems to be already done");
        return true;
    }

    protected void gzipRec(boolean bl) throws Exception {
        String string = this.context.getOutputPath();
        int n = Util.getMaxOrderByPath(string);
        for (File file : new File(string).listFiles()) {
            int n2;
            if (this.context.isTaskAborting()) {
                throw new Exception("Task abort !");
            }
            String string2 = file.getName();
            if (!string2.startsWith("Norder") || !file.isDirectory()) continue;
            try {
                n2 = Integer.parseInt(string2.substring(6));
            }
            catch (Exception exception) {
                continue;
            }
            for (int i = 0; i < this.context.depth; ++i) {
                String string3;
                if (n2 == 3 && new File(string3 = string + cds.tools.Util.FS + "Norder3" + cds.tools.Util.FS + "Allsky" + (i == 0 ? "" : "_" + i) + ".fits").isFile()) {
                    this.gzip(string3, bl);
                    ++this.nbFile;
                }
                if (bl && (n2 > 5 || n2 == n)) continue;
                long l = Healpix.pow2(n2);
                l = 12L * l * l;
                for (long j = 0L; j < l; ++j) {
                    String string4 = Util.getFilePath(string, n2, j, i) + ".fits";
                    if (!new File(string4).isFile()) continue;
                    this.gzip(string4, bl);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gzip(String string, boolean bl) throws Exception {
        MyInputStream myInputStream = null;
        OutputStream outputStream = null;
        OutputStream outputStream2 = null;
        try {
            int n;
            String string2;
            File file;
            File file2 = new File(string);
            if (!file2.isFile()) {
                throw new Exception(string + " does not exist !");
            }
            myInputStream = new MyInputStream(new FileInputStream(file2));
            if (bl) {
                if (myInputStream.isGZ()) {
                    throw new Exception(string + " already gzipped");
                }
            } else {
                if (!myInputStream.isGZ()) {
                    throw new Exception(string + " not gzipped");
                }
                myInputStream = myInputStream.startRead();
            }
            if ((file = new File(string2 = string + ".tmp")).isFile()) {
                file.delete();
            }
            outputStream2 = new FileOutputStream(string2);
            outputStream = bl ? new GZIPOutputStream(outputStream2) : outputStream2;
            byte[] byArray = new byte[8192];
            while ((n = myInputStream.read(byArray)) >= 0) {
                outputStream.write(byArray, 0, n);
                if (!this.context.isTaskAborting()) continue;
            }
            if (this.context.isTaskAborting()) {
                file.delete();
            } else {
                file2.delete();
                file.renameTo(file2);
                ++this.nbFile;
                if (this.context != null) {
                    this.context.setProgress(this.nbFile);
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (myInputStream != null) {
                myInputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
            if (outputStream2 != null) {
                outputStream2.close();
            }
        }
        if (this.context.isTaskAborting()) {
            throw new Exception("Task abort !");
        }
    }
}

