/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.Coord;
import cds.allsky.Action;
import cds.allsky.Builder;
import cds.allsky.BuilderMocIndex;
import cds.allsky.Context;
import cds.allsky.ContextGui;
import cds.fits.Fits;
import cds.moc.HealpixMoc;
import cds.tools.pixtools.CDSHealpix;
import cds.tools.pixtools.Util;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class BuilderIndex
extends Builder {
    private int[] borderSize = new int[]{0, 0, 0, 0};
    private String currentfile = null;
    private boolean partitioning;
    private double maxRatio;
    private int[] hdu = null;
    private HealpixMoc area;
    private boolean flagAppend;
    private int statNbFile;
    private int statNbZipFile;
    private int statBlocFile;
    private long statMemFile;
    private long statPixSize;
    private long statMaxSize;
    private long statTime;
    private int statMaxWidth;
    private int statMaxHeight;
    private int statMaxDepth;
    private int statMaxNbyte;
    boolean stopped = false;
    private ArrayList<String> badFiles = null;

    public BuilderIndex(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.INDEX;
    }

    @Override
    public void run() throws Exception {
        this.build();
        this.report();
        this.context.writeHpxFinderProperties();
        BuilderMocIndex builderMocIndex = new BuilderMocIndex(this.context);
        builderMocIndex.run();
        this.context.setMocIndex(builderMocIndex.getMoc());
    }

    private void addBadFile(String string, String string2) {
        if (this.badFiles == null) {
            this.badFiles = new ArrayList();
        }
        this.badFiles.add(string + (string2 != null && string2.length() > 0 ? " => " + string2 : ""));
    }

    private void report() throws Exception {
        if (this.badFiles != null) {
            int n = this.badFiles.size();
            this.context.warning("Index report: " + n + " input file" + (n > 1 ? "s" : "") + " not incorporated:");
            for (String string : this.badFiles) {
                this.context.warning("   " + string);
            }
        }
        if (this.statNbFile == 0) {
            throw new Exception("No available image found ! => Aborted");
        }
    }

    @Override
    public boolean isAlreadyDone() {
        if (!this.context.isExistingIndexDir()) {
            return false;
        }
        if (!this.context.actionAlreadyDone(Action.INDEX)) {
            return false;
        }
        if (this.context.getMocIndex() == null) {
            try {
                this.context.loadMocIndex();
            }
            catch (Exception exception) {
                return false;
            }
        }
        this.context.info("Pre-existing HEALPix index seems to be ready");
        return true;
    }

    @Override
    public void validateContext() throws Exception {
        Object object;
        int n;
        if (this.context instanceof ContextGui) {
            this.context.setProgressBar(((ContextGui)this.context).mainPanel.getProgressBarIndex());
        }
        this.partitioning = this.context.partitioning;
        if (this.partitioning) {
            this.context.info("Partitioning large original image files in blocks of 1024x1024 pixels");
        }
        this.validateInput();
        this.validateOutput();
        this.validateLabel();
        boolean bl = this.flagAppend = !this.context.isExistingIndexDir();
        if (!this.flagAppend) {
            this.context.info("Pre-existing HpxFinder index => will add new images only...");
        }
        if ((n = this.context.getOrder()) == -1) {
            String string = this.context.getImgEtalon();
            if (string == null && (string = this.context.justFindImgEtalon(this.context.getInputPath())) != null) {
                this.context.info("Use this reference image => " + string);
            }
            if (string == null) {
                throw new Exception("No source image found in " + this.context.getInputPath());
            }
            try {
                object = new Fits();
                ((Fits)object).loadHeaderFITS(string);
                long l = BuilderIndex.calculateNSide(((Fits)object).getCalib().GetResol()[0] * 3600.0);
                n = Util.order((int)l) - this.context.getTileOrder();
                if (n < 3) {
                    n = 3;
                }
                this.context.setOrder(n);
            }
            catch (Exception exception) {
                this.context.warning("The reference image has no astrometrical calibration [" + string + "] => order can not be computed");
            }
        }
        if (n == -1) {
            throw new Exception("Argument \"order\" is required");
        }
        if (n < this.context.getOrder()) {
            this.context.warning("The provided order [" + n + "] is less than the optimal order [" + this.context.getOrder() + "] => OVER-sample will be applied");
        } else if (n > this.context.getOrder()) {
            this.context.warning("The provided order [" + n + "] is greater than the optimal order [" + this.context.getOrder() + "] => SUB-sample will be applied");
        } else {
            this.context.info("Order=" + this.context.getOrder() + " => PixelAngularRes=" + Coord.getUnit(CDSHealpix.pixRes(CDSHealpix.pow2(this.context.getOrder() + this.context.getTileOrder())) / 3600.0));
        }
        int n2 = this.context.getTileSide();
        this.context.info("TileOrder=" + this.context.getTileOrder() + " => tileSize=" + n2 + "x" + n2 + " pixels");
        this.hdu = this.context.getHDU();
        if (this.hdu == null) {
            this.context.info("MEF stategy => extension 0, otherwise 1");
        } else if (this.hdu.length > 0 && this.hdu[0] == -1) {
            this.context.info("MEF stategy => all images found in the MEF");
        } else {
            object = new StringBuilder("MEF stategy: extensions ");
            for (int i = 0; i < this.hdu.length; ++i) {
                if (i > 0) {
                    ((StringBuilder)object).append(',');
                }
                ((StringBuilder)object).append(this.hdu[i] + "");
            }
            this.context.info(object + "");
        }
        if (this.context.fitsKeys != null) {
            object = null;
            for (String string : this.context.fitsKeys) {
                if (object == null) {
                    object = new StringBuilder();
                } else {
                    ((StringBuilder)object).append(", ");
                }
                ((StringBuilder)object).append(string);
            }
            this.context.info("Extended metadata extraction based on FITS keys: " + object);
        }
        this.area = this.context.getArea();
    }

    public static int calculateNSide(double d) {
        double d2 = 4.84813681109536E-6;
        double d3 = Math.sqrt(1.0471975511965976) / (d2 * d);
        int n = Math.max(0, Math.min(29, 1 + (int)CDSHealpix.log2((long)d3)));
        return 1 << n;
    }

    @Override
    public void showStatistics() {
        if (this.statNbFile <= 0) {
            return;
        }
        long l = System.currentTimeMillis() - this.statTime;
        this.context.showIndexStat(this.statNbFile, this.statBlocFile, this.statNbZipFile, this.statMemFile, this.statPixSize, this.statMaxSize, this.statMaxWidth, this.statMaxHeight, this.statMaxDepth, this.statMaxNbyte, l);
    }

    private boolean build() throws Exception {
        this.initStat();
        String string = this.context.getInputPath();
        String string2 = this.context.getOutputPath();
        int n = this.context.getOrder();
        this.borderSize = this.context.getBorderSize();
        this.maxRatio = this.context.getMaxRatio();
        File file = new File(string2);
        if (!file.exists()) {
            file.mkdir();
        }
        String string3 = this.context.getHpxFinderPath();
        this.create(string, string3, n);
        return true;
    }

    private void initStat() {
        this.statBlocFile = 0;
        this.statNbZipFile = 0;
        this.statNbFile = 0;
        this.statMemFile = 0L;
        this.statPixSize = 0L;
        this.statMaxSize = -1L;
        this.statTime = System.currentTimeMillis();
    }

    private void updateStat(File file, int n, int n2, int n3, int n4, int n5, int n6) {
        ++this.statNbFile;
        this.statBlocFile += n6;
        if ((n & 1) != 0) {
            ++this.statNbZipFile;
        }
        long l = file.length();
        this.statPixSize += (long)(n2 * n3 * n4);
        this.statMemFile += l;
        if (this.statMaxSize < l) {
            this.statMaxSize = l;
            this.statMaxWidth = n2;
            this.statMaxHeight = n3;
            this.statMaxDepth = n4;
            this.statMaxNbyte = n5;
        }
    }

    private RandomAccessFile openFile(String string) throws Exception {
        File file = new File(string);
        if (!file.exists()) {
            cds.tools.Util.createPath(string);
        }
        return new RandomAccessFile(file, "rw");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAFile(RandomAccessFile randomAccessFile, String string, Coord coord, long l, String string2, String string3) throws IOException {
        try {
            int n;
            int n2 = string.lastIndexOf(47);
            int n3 = string.lastIndexOf(92);
            if (n3 > n2) {
                n2 = n3;
            }
            int n4 = string.lastIndexOf(46);
            int n5 = n = string.charAt(string.length() - 1) == ']' ? string.lastIndexOf(91) : -1;
            if (n > n4) {
                n4 = n;
            }
            if (n4 == -1 || n4 <= n2) {
                n4 = string.length();
            }
            String string4 = string.substring(n2 + 1, n4);
            if (string3 == null) {
                string3 = "";
            }
            String string5 = "{ \"name\": \"" + string4 + "\", \"path\": \"" + string + "\", \"ra\": \"" + coord.al + "\", \"dec\": \"" + coord.del + "\", \"cellmem\": \"" + l + "\", \"stc\": \"" + string2 + "\"" + string3 + " }\n";
            if (this.flagAppend) {
                randomAccessFile.seek(randomAccessFile.length());
            } else {
                String string6;
                while ((string6 = randomAccessFile.readLine()) != null) {
                    if (!(string6 + "\n").equals(string5)) continue;
                    return;
                }
            }
            randomAccessFile.write(string5.getBytes());
        }
        finally {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
    }

    private void create(String string, String string2, int n) throws Exception {
        File[] fileArray;
        File[] fileArray2;
        File file = new File(string);
        ArrayList<File> arrayList = new ArrayList<File>();
        if (this.context.isInputFile) {
            File[] fileArray3 = new File[1];
            fileArray2 = fileArray3;
            fileArray3[0] = file;
        } else {
            fileArray2 = fileArray = file.listFiles();
        }
        if (fileArray == null) {
            return;
        }
        int n2 = 0;
        this.context.setProgress(0.0, fileArray.length - 1);
        block6: for (File file2 : fileArray) {
            if (this.context.isTaskAborting()) {
                throw new Exception("Task abort !");
            }
            this.context.setProgress(n2++);
            if (!this.context.isInputFile && file2.isDirectory()) {
                arrayList.add(file2);
                continue;
            }
            this.currentfile = file2.getPath();
            Fits fits = new Fits();
            boolean bl = this.hdu == null;
            boolean bl2 = this.hdu != null && this.hdu.length > 0 && this.hdu[0] == -1;
            int n3 = 1024;
            int n4 = 0;
            for (int i = 0; bl2 || bl || i < this.hdu.length; ++i) {
                block22: {
                    int n5 = bl ? 0 : (bl2 ? i : this.hdu[i]);
                    try {
                        int n6 = fits.loadHeaderFITS(this.currentfile + (n5 == 0 ? "" : "[" + n5 + "]"));
                        if (bl2 && (n6 & 0x10) != 0) continue;
                        if (fits.calib == null) {
                            if (!bl) continue;
                            continue block6;
                        }
                        if (n4 == 0) {
                            n4 = fits.depth;
                        } else if (fits.depth != n4) continue;
                        Aladin.trace(4, "HiPS indexing " + this.currentfile + (n5 == 0 ? "" : "[" + n5 + "]..."));
                        try {
                            if (!this.partitioning) {
                                this.testAndInsert(fits, string2, this.currentfile, null, n);
                                this.updateStat(file2, n6, fits.width, fits.height, fits.depth, fits.bitpix == 0 ? 4 : Math.abs(fits.bitpix) / 8, 0);
                            } else {
                                int n7 = fits.width - this.borderSize[3];
                                int n8 = fits.height - this.borderSize[2];
                                for (int j = this.borderSize[1]; j < n7; j += n3) {
                                    for (int k = this.borderSize[0]; k < n8; k += n3) {
                                        fits.widthCell = j + n3 > n7 ? n7 - j : n3;
                                        fits.heightCell = k + n3 > n8 ? n8 - k : n3;
                                        fits.depth = 1;
                                        fits.depthCell = 1;
                                        fits.xCell = j;
                                        fits.yCell = k;
                                        fits.zCell = 0;
                                        fits.ext = n5;
                                        String string3 = fits.getCellSuffix();
                                        this.testAndInsert(fits, string2, this.currentfile, string3, n);
                                    }
                                }
                                this.updateStat(file2, n6, n7, n8, fits.depth, fits.bitpix == 0 ? 4 : Math.abs(fits.bitpix) / 8, 1);
                            }
                            break block22;
                        }
                        catch (Exception exception) {
                            this.addBadFile(this.currentfile, exception.getMessage());
                        }
                    }
                    catch (Exception exception) {
                        Aladin.trace(3, exception.getMessage() + " " + this.currentfile);
                    }
                    continue block6;
                }
                if (bl) continue block6;
            }
        }
        fileArray = null;
        if (arrayList.size() > 0) {
            for (File file3 : arrayList) {
                if (!file3.isDirectory()) continue;
                this.currentfile = file3.getPath();
                try {
                    this.create(this.currentfile, string2, n);
                }
                catch (Exception exception) {
                    Aladin.trace(3, exception.getMessage() + " " + this.currentfile);
                }
            }
        }
    }

    private void testAndInsert(Fits fits, String string, String string2, String string3, int n) throws Exception {
        long[] lArray;
        Coord coord = new Coord();
        String string4 = null;
        Calib calib = fits.getCalib();
        ArrayList<double[]> arrayList = new ArrayList<double[]>(4);
        Coord coord2 = new Coord();
        Coord[] coordArray = new Coord[4];
        StringBuffer stringBuffer = new StringBuffer("POLYGON J2000");
        boolean bl = fits.hasCell();
        for (int i = 0; i < 4; ++i) {
            coord2.x = i == 0 || i == 3 ? fits.xCell : fits.xCell + fits.widthCell;
            coord2.y = i < 2 ? fits.yCell : fits.yCell + fits.heightCell;
            coord2.y = (double)fits.height - coord2.y - 1.0;
            calib.GetCoord(coord2);
            arrayList.add(this.context.ICRS2galIfRequired(coord2.al, coord2.del));
            if (bl) {
                coord2.x = i == 0 || i == 3 ? 0 : fits.width;
                coord2.y = i < 2 ? 0 : fits.height;
                coord2.y = (double)fits.height - coord2.y - 1.0;
                calib.GetCoord(coord2);
            }
            stringBuffer.append(" " + coord2.al + " " + coord2.del);
            coordArray[i] = new Coord(coord2.al, coord2.del);
        }
        if (this.maxRatio > 0.0 && this.statNbFile > 0) {
            double d = Coord.getDist(coordArray[0], coordArray[1]) / (double)fits.width;
            double d2 = Coord.getDist(coordArray[1], coordArray[2]) / (double)fits.height;
            if (d2 > d * this.maxRatio || d > d2 * this.maxRatio) {
                throw new Exception("Suspicious image calibration (pixel size=" + Coord.getUnit(d) + "x" + Coord.getUnit(d2) + ") => see -maxRatio=xx parameter");
            }
        }
        coord.x = fits.width / 2;
        coord.y = fits.height / 2;
        coord.y = (double)fits.height - coord.y - 1.0;
        calib.GetCoord(coord);
        if (this.context.fitsKeys != null) {
            StringBuilder stringBuilder = null;
            for (String string5 : this.context.fitsKeys) {
                String string6 = fits.headerFits.getStringFromHeader(string5);
                if (string6 == null && (fits.headerFits0 == null || fits.headerFits0 != null && (string6 = fits.headerFits0.getStringFromHeader(string5)) == null)) continue;
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder();
                }
                stringBuilder.append(", \"" + string5 + "\": \"" + string6.replace("\"", "\\\"") + "\"");
            }
            if (stringBuilder != null) {
                string4 = stringBuilder.toString();
            }
        }
        long l = fits.widthCell * fits.heightCell * (fits.bitpix == 0 ? 32 : Math.abs(fits.bitpix) / 8);
        long l2 = CDSHealpix.pow2(n);
        double d = Coord.getDist(coord, new Coord(((double[])arrayList.get(0))[0], ((double[])arrayList.get(0))[1]));
        if (d < 30.0) {
            lArray = CDSHealpix.query_polygon(l2, arrayList);
        } else {
            try {
                lArray = CDSHealpix.query_disc(l2, coord.al, coord.del, d);
            }
            catch (Exception exception) {
                throw new Exception("BuilderIndex error in CDSHealpix.query_disc() order=" + n + " radius=" + d + "deg file=" + fits.getFilename() + " => ignored");
            }
        }
        for (int i = 0; i < lArray.length; ++i) {
            long l3 = lArray[i];
            if (this.area != null && !this.area.isIntersecting(n, l3) || !this.isInImage(fits, Util.getCorners(n, l3))) continue;
            String string7 = cds.tools.Util.concatDir(string, Util.getFilePath("", n, l3));
            RandomAccessFile randomAccessFile = this.openFile(string7);
            String string8 = string2 + (string3 == null ? "" : string3);
            this.createAFile(randomAccessFile, string8, coord, l, stringBuffer.toString(), string4);
            randomAccessFile.close();
        }
    }

    private boolean isInImage(Fits fits, Coord[] coordArray) {
        int n = 0;
        int n2 = 0;
        try {
            int n3 = 2;
            for (int i = 0; i < coordArray.length; ++i) {
                Coord coord = coordArray[i];
                if (this.context.getFrame() != 0) {
                    double[] dArray = this.context.gal2ICRSIfRequired(coord.al, coord.del);
                    coord.al = dArray[0];
                    coord.del = dArray[1];
                }
                fits.getCalib().GetXY(coord);
                if (Double.isNaN(coord.x)) continue;
                coord.y = (double)fits.height - coord.y - 1.0;
                int n4 = fits.widthCell + n3;
                int n5 = fits.heightCell + n3;
                if (coord.x >= (double)(fits.xCell - n3) && coord.x < (double)(fits.xCell + n4) && coord.y >= (double)(fits.yCell - n3) && coord.y < (double)(fits.yCell + n5)) {
                    return true;
                }
                n += coord.x >= (double)(fits.xCell + n4) ? 1 : (coord.x < (double)(fits.xCell - n3) ? -1 : 0);
                n2 += coord.y >= (double)(fits.yCell + n5) ? 1 : (coord.y < (double)(fits.yCell - n3) ? -1 : 0);
            }
        }
        catch (Exception exception) {
            return false;
        }
        return Math.abs(n) != Math.abs(coordArray.length) && Math.abs(n2) != Math.abs(coordArray.length);
    }
}

