/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.Aladin;
import cds.aladin.CanvasColorMap;
import cds.allsky.Action;
import cds.allsky.BuilderAllsky;
import cds.allsky.BuilderTiles;
import cds.allsky.Context;
import cds.allsky.ContextGui;
import cds.allsky.ThreadBuilderTile;
import cds.fits.Fits;
import cds.tools.Util;
import java.awt.image.IndexColorModel;

public class BuilderJpg
extends BuilderTiles {
    private double[] cut;
    protected byte[] tcm;
    private int bitpix;
    private int width;
    private double blank;
    private double bscale;
    private double bzero;
    private int statNbFile;
    protected String fmt;
    protected String ext;
    private boolean first = true;

    public BuilderJpg(Context context) {
        super(context);
        this.init();
    }

    protected void init() {
        this.fmt = "jpeg";
        this.ext = ".jpg";
    }

    @Override
    public Action getAction() {
        return Action.JPEG;
    }

    @Override
    public void validateContext() throws Exception {
        this.validateOutput();
        if (!this.context.isExistingAllskyDir()) {
            throw new Exception("No Fits tile found");
        }
        this.validateOrder(this.context.getOutputPath());
        this.validateDepth();
        if (!this.context.isColor()) {
            this.validateCut();
        }
        try {
            this.context.loadMoc();
        }
        catch (Exception exception) {
            this.context.warning("Tile MOC not found => use index MOC");
        }
        if (!this.context.hasFrame()) {
            this.context.setFrameName(this.getFrame());
        }
        this.context.initRegion();
    }

    protected int getMinCM() {
        return 0;
    }

    @Override
    public void run() throws Exception {
        IndexColorModel indexColorModel = this.context.getFct() == null ? null : CanvasColorMap.getCM(0, 128, 255, false, 0, this.context.getFct().code());
        this.tcm = indexColorModel == null ? null : Util.getTableCM(indexColorModel, 2);
        this.cut = this.context.getCut();
        double d = this.context.bzero;
        double d2 = this.context.bscale;
        this.context.info("Map pixel cut [" + this.ip(this.cut[0], d, d2) + " .. " + this.ip(this.cut[1], d, d2) + "] to [" + this.getMinCM() + "..255] (" + this.context.getTransfertFct() + ")");
        this.context.info("Tile aggregation method=" + (Object)((Object)this.context.getJpegMethod()));
        this.build();
        if (!this.context.isTaskAborting()) {
            new BuilderAllsky(this.context).runJpegOrPngOnly(this.fmt);
            if (this.context instanceof ContextGui && ((ContextGui)this.context).mainPanel.planPreview != null) {
                if (this.fmt.equals("jpeg")) {
                    ((ContextGui)this.context).mainPanel.planPreview.inJPEG = true;
                } else {
                    ((ContextGui)this.context).mainPanel.planPreview.inPNG = true;
                }
            }
        }
    }

    @Override
    public boolean isAlreadyDone() {
        if (this.context.isColor()) {
            this.context.info("Jpeg conversion not required for Healpix colored survey");
            return true;
        }
        if (!this.context.actionPrecedeAction(Action.INDEX, Action.TILES)) {
            return false;
        }
        if (!this.context.actionPrecedeAction(Action.TILES, this.getAction())) {
            return false;
        }
        this.context.info("Pre-existing HEALPix JPEG survey seems to be ready");
        return true;
    }

    @Override
    public void showStatistics() {
        this.context.showJpgStat(this.statNbFile, this.totalTime, this.statNbThread, this.statNbThreadRunning);
        if (!(this.context instanceof ContextGui)) {
            super.showStatistics();
        }
    }

    @Override
    public void build() throws Exception {
        this.initStat();
        super.build();
    }

    @Override
    protected void activateCache(long l, long l2) {
    }

    @Override
    protected Fits createLeaveHpx(ThreadBuilderTile threadBuilderTile, String string, String string2, int n, long l, int n2) throws Exception {
        Fits fits = this.createLeaveJpg(string);
        if (fits == null) {
            return null;
        }
        fits.writeCompressed(string + this.ext, this.cut[0], this.cut[1], this.tcm, this.fmt);
        Aladin.trace(4, "Writing " + string + this.ext);
        this.updateStat();
        return fits;
    }

    @Override
    protected Fits createNodeHpx(String string, String string2, int n, long l, Fits[] fitsArray, int n2) throws Exception {
        Context.JpegMethod jpegMethod = this.context.getJpegMethod();
        Fits fits = this.createNodeJpg(fitsArray, jpegMethod);
        if (fits == null) {
            return null;
        }
        fits.writeCompressed(string + this.ext, this.cut[0], this.cut[1], this.tcm, this.fmt);
        Aladin.trace(4, "Writing " + string + this.ext);
        return fits;
    }

    @Override
    protected void setProgressBar(int n) {
        this.context.setProgress(n);
    }

    private void initStat() {
        this.context.setProgressMax(768.0);
        this.statNbFile = 0;
        this.startTime = System.currentTimeMillis();
    }

    private void updateStat() {
        ++this.statNbFile;
        this.totalTime = System.currentTimeMillis() - this.startTime;
    }

    private Fits createLeaveJpg(String string) throws Exception {
        Fits fits = null;
        if (this.context.isTaskAborting()) {
            throw new Exception("Task abort !");
        }
        try {
            fits = new Fits();
            fits.loadFITS(string + ".fits");
            if (this.first) {
                this.first = false;
                this.setConstantes(fits);
            }
        }
        catch (Exception exception) {
            fits = null;
        }
        return fits;
    }

    private void setConstantes(Fits fits) {
        this.bitpix = fits.bitpix;
        this.blank = fits.blank;
        this.bscale = fits.bscale;
        this.bzero = fits.bzero;
        this.width = fits.width;
    }

    private Fits createNodeJpg(Fits[] fitsArray, Context.JpegMethod jpegMethod) throws Exception {
        int n;
        if (this.width == 0 || fitsArray[0] == null && fitsArray[1] == null && fitsArray[2] == null && fitsArray[3] == null) {
            return null;
        }
        Fits fits = new Fits(this.width, this.width, this.bitpix);
        fits.setBlank(this.blank);
        fits.setBscale(this.bscale);
        fits.setBzero(this.bzero);
        double[] dArray = new double[4];
        double[] dArray2 = new double[4];
        for (n = 0; n < 2; ++n) {
            for (int i = 0; i < 2; ++i) {
                int n2 = n << 1 | i;
                Fits fits2 = fitsArray[n2];
                int n3 = n * this.width / 2;
                int n4 = (1 - i) * this.width / 2;
                for (int j = 0; j < this.width; j += 2) {
                    for (int k = 0; k < this.width; k += 2) {
                        double d = this.blank;
                        if (fits2 != null) {
                            double d2;
                            if (jpegMethod == Context.JpegMethod.MEAN) {
                                int n5;
                                d2 = 0.0;
                                for (n5 = 0; n5 < 4; ++n5) {
                                    int n6 = n5 == 1 || n5 == 3 ? 1 : 0;
                                    int n7 = n5 >= 2 ? 1 : 0;
                                    dArray[n5] = fits2.getPixelDouble(k + n6, j + n7);
                                    dArray2[n5] = fits2.isBlankPixel(dArray[n5]) ? 0.0 : 1.0;
                                    d2 += dArray2[n5];
                                }
                                if (d2 != 0.0) {
                                    d = 0.0;
                                    for (n5 = 0; n5 < 4; ++n5) {
                                        if (dArray2[n5] == 0.0) continue;
                                        d += dArray[n5] * (dArray2[n5] / d2);
                                    }
                                }
                            } else {
                                double d3;
                                double d4;
                                double d5;
                                d2 = fits2.getPixelDouble(k, j);
                                if (fits2.isBlankPixel(d2)) {
                                    d2 = Double.NaN;
                                }
                                if (fits2.isBlankPixel(d5 = fits2.getPixelDouble(k + 1, j))) {
                                    d2 = Double.NaN;
                                }
                                if (fits2.isBlankPixel(d4 = fits2.getPixelDouble(k, j + 1))) {
                                    d2 = Double.NaN;
                                }
                                if (fits2.isBlankPixel(d3 = fits2.getPixelDouble(k + 1, j + 1))) {
                                    d2 = Double.NaN;
                                }
                                d = d2 > d5 && (d2 < d4 || d2 < d3) || d2 < d5 && (d2 > d4 || d2 > d3) ? d2 : (d5 > d2 && (d5 < d4 || d5 < d3) || d5 < d2 && (d5 > d4 || d5 > d3) ? d5 : (d4 > d2 && (d4 < d5 || d4 < d3) || d4 < d2 && (d4 > d5 || d4 > d3) ? d4 : d3));
                            }
                        }
                        fits.setPixelDouble(n3 + k / 2, n4 + j / 2, d);
                    }
                }
            }
        }
        for (n = 0; n < 4; ++n) {
            if (fitsArray[n] == null) continue;
            fitsArray[n].free();
        }
        return fits;
    }
}

