/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.PlanImage;
import cds.aladin.Save;
import cds.allsky.Action;
import cds.allsky.Builder;
import cds.allsky.Context;
import cds.fits.Fits;
import cds.tools.pixtools.CDSHealpix;
import cds.tools.pixtools.Util;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Vector;

public final class BuilderMap
extends Builder {
    private int bitpix;
    private String output;
    private int frame;
    private int losangeWidth;
    private long nside;

    public BuilderMap(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.MAP;
    }

    @Override
    public void validateContext() throws Exception {
        this.validateOutput();
        this.output = this.context.getOutputPath();
        this.nside = this.context.getMapNside();
        this.bitpix = this.context.getBitpix();
        if (this.bitpix == -1) {
            this.context.loadProperties();
            this.bitpix = Integer.parseInt(this.context.prop.getProperty("hips_pixel_bitpix"));
            this.frame = this.context.prop.getProperty("hips_frame").startsWith("G") ? 3 : 0;
            this.losangeWidth = Integer.parseInt(this.context.prop.getProperty("hips_tile_width"));
        } else {
            this.frame = this.context.getFrame();
            this.losangeWidth = this.context.getTileSide();
        }
        this.nside = 4096L;
    }

    @Override
    public void run() throws Exception {
        this.exportHpx();
        this.context.info("HEALPix map generation in progress: NSIDE=" + this.nside + " frame=" + this.context.getFrameCode() + " bitpix=" + this.bitpix + " in " + this.output + Util.FS + "Map.fits");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportHpx() throws Exception {
        OutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(this.output + Util.FS + "Map.fits");
            int n = 0;
            int n2 = (int)CDSHealpix.log2(this.losangeWidth);
            int n3 = (int)CDSHealpix.log2(this.nside);
            int n4 = Math.abs(this.bitpix) / 8;
            long l = 768L;
            boolean bl = false;
            int n5 = 1024;
            Vector vector = Save.generateHealpixHDU0(false);
            n = Save.writeFitsLines(outputStream, vector, n);
            byte[] byArray = Save.getEndBourrage(n);
            outputStream.write(byArray);
            n += byArray.length;
            vector = Save.generateHealpixHDU1(n3, this.bitpix, bl, n5, this.frame);
            n = Save.writeFitsLines(outputStream, vector, n);
            byArray = Save.getEndBourrage(n);
            outputStream.write(byArray);
            n += byArray.length;
            byte[] byArray2 = new byte[n5 * n4];
            int n6 = 0;
            int n7 = this.losangeWidth * this.losangeWidth;
            byte[] byArray3 = new byte[n7 * n4];
            for (int i = 0; i < n7; ++i) {
                PlanImage.setPixVal(byArray3, this.bitpix, i, Double.NaN);
            }
            int[] nArray = Util.createHpx2xy(n2);
            int n8 = 0;
            while ((long)n8 < l) {
                boolean bl2 = true;
                String string = Util.getFilePath(this.output, 3, (long)n8);
                Fits fits = new Fits();
                try {
                    fits.loadFITS(string + ".fits");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    bl2 = false;
                }
                if (!bl2) {
                    outputStream.write(byArray2, 0, n6);
                    n += n6;
                    n6 = 0;
                    outputStream.write(byArray3);
                    n6 = 0;
                    n += byArray3.length;
                } else {
                    for (int i = 0; i < n7; ++i) {
                        int n9 = nArray[i];
                        int n10 = n9 / this.losangeWidth;
                        int n11 = n9 - n10 * this.losangeWidth;
                        double d = fits.getPixelDouble(n11, n10);
                        PlanImage.setPixVal(byArray2, this.bitpix, n6++, d);
                        if (n6 != n5) continue;
                        outputStream.write(byArray2);
                        n6 = 0;
                        n += byArray2.length;
                    }
                }
                ++n8;
            }
            if (n6 > 0) {
                outputStream.write(byArray2, 0, n6);
                n += n6;
            }
            byArray = Save.getEndBourrage(n);
            outputStream.write(byArray);
            n += byArray.length;
        }
        finally {
            outputStream.close();
        }
    }
}

