/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.MyInputStream;
import cds.aladin.PlanImage;
import cds.allsky.Action;
import cds.allsky.Builder;
import cds.allsky.BuilderAllsky;
import cds.allsky.BuilderMoc;
import cds.allsky.BuilderTree;
import cds.allsky.CacheFitsWriter;
import cds.allsky.Context;
import cds.allsky.ContextGui;
import cds.fits.Fits;
import cds.fits.HeaderFits;
import cds.tools.pixtools.CDSHealpix;
import cds.tools.pixtools.Util;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import javax.swing.JProgressBar;

public class BuilderMapTiles
extends Builder {
    private HeaderFits headerFits;
    private CacheFitsWriter cache;
    protected int bitpixOrig = -1;
    protected int maxOrder = -1;
    private long nside = -1L;
    private String ordering = null;
    private long initialOffsetHpx;
    private long startTime = 0L;
    private long nbRecord = -1L;
    private long cRecord = -1L;
    private String info = "";
    private Builder b = null;

    public BuilderMapTiles(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.MAPTILES;
    }

    @Override
    public void run() throws Exception {
        this.build();
        if (!this.context.isTaskAborting()) {
            this.b = new BuilderMoc(this.context);
            this.b.run();
            this.b = null;
            if (this.context.getOrder() <= 3) {
                new BuilderAllsky(this.context).run();
                this.context.info("ALLSKY file done");
            } else {
                new BuilderTree(this.context).run();
                this.context.info("HiPS TREE done");
            }
            this.context.setProgressLastNorder3(1);
        }
    }

    @Override
    public void validateContext() throws Exception {
        this.validateMap();
        this.validateOutput();
        if (this.context instanceof ContextGui) {
            JProgressBar jProgressBar = ((ContextGui)this.context).mainPanel.getProgressBarTile();
            this.context.setProgressBar(jProgressBar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateMap() throws Exception {
        String string = this.context.getInputPath();
        MyInputStream myInputStream = null;
        try {
            myInputStream = new MyInputStream(new FileInputStream(string));
            this.headerFits = new HeaderFits(myInputStream);
            int n = this.headerFits.getIntFromHeader("NAXIS");
            if (n <= 1 && this.headerFits.getStringFromHeader("EXTEND") != null) {
                try {
                    int n2 = this.headerFits.getIntFromHeader("NAXIS1");
                    try {
                        this.nside = this.headerFits.getIntFromHeader("NSIDE");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        this.ordering = this.headerFits.getStringFromHeader("ORDERING");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    myInputStream.skip(n2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                myInputStream.skipOnNext2880();
                this.headerFits = new HeaderFits(myInputStream);
                this.context.setHeader(this.headerFits);
            }
            this.initialOffsetHpx = myInputStream.getPos();
        }
        finally {
            if (myInputStream != null) {
                myInputStream.close();
            }
        }
    }

    private void initStat(long l) {
        this.nbRecord = l;
        this.cRecord = 0L;
        this.context.setProgressMax(l);
        this.startTime = System.currentTimeMillis();
    }

    private void updateStat(long l) {
        this.cRecord = l;
    }

    @Override
    public void showStatistics() {
        if (this.b != null) {
            this.b.showStatistics();
            return;
        }
        if (this.nbRecord <= 0L) {
            return;
        }
        long l = System.currentTimeMillis();
        long l2 = l - this.startTime;
        if (l2 < 2000L) {
            return;
        }
        this.context.showMapStat(this.cRecord, this.nbRecord, l2, this.cache, this.info);
    }

    protected void build() throws Exception {
        this.build(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void build(boolean bl) throws Exception {
        long l;
        int n;
        int n2;
        String string;
        int n3 = 0;
        String string2 = this.context.getOutputPath();
        long l2 = this.headerFits.getIntFromHeader("NAXIS1");
        long l3 = this.headerFits.getIntFromHeader("NAXIS2");
        int n4 = this.headerFits.getIntFromHeader("TFIELDS");
        double d = Double.NaN;
        String string3 = "G";
        double d2 = 0.0;
        double d3 = 1.0;
        double d4 = Double.NaN;
        boolean bl2 = false;
        boolean bl3 = true;
        if (this.nside == -1L) {
            this.nside = this.headerFits.getIntFromHeader("NSIDE");
        }
        try {
            d = Double.parseDouble(this.headerFits.getStringFromHeader("BAD_DATA"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            string = this.headerFits.getStringFromHeader("COORDSYS");
            if (string != null) {
                string3 = string;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            d2 = this.headerFits.getDoubleFromHeader("BZERO");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            d3 = this.headerFits.getDoubleFromHeader("BSCALE");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            d4 = this.headerFits.getDoubleFromHeader("BLANK");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String string4 = string = this.ordering != null ? this.ordering : this.headerFits.getStringFromHeader("ORDERING");
            if (string != null && string.equals("RING")) {
                bl3 = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            string = this.headerFits.getStringFromHeader("OBJECT");
            if (string != null) {
                if (string.equalsIgnoreCase("PARTIAL")) {
                    bl2 = true;
                }
            } else {
                string = this.headerFits.getStringFromHeader("TTYPE1");
                if (string.equalsIgnoreCase("PIXEL")) {
                    bl2 = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.context.setFrameName(string3);
        if (bl2) {
            n3 = 1;
        }
        this.info = "HEALPix FITS map " + (bl2 ? " PARTIAL" : "") + " nside=" + this.nside + " ordering=" + (bl3 ? "NESTED" : "RING") + " frame=" + this.context.getFrameName();
        if (!bl) {
            this.context.info(this.info);
        }
        if (this.nside < (long)(n2 = this.context.getTileSide())) {
            n2 = (int)this.nside;
        }
        if (this.context.getOrder() == -1) {
            n = 2 * n2;
            do {
                this.maxOrder = this.getLevelImage(this.nside, n /= 2);
            } while (this.maxOrder < 3);
        } else {
            this.maxOrder = this.context.getOrder();
            l = 12L * this.nside * this.nside;
            long l4 = 12L * CDSHealpix.pow2(this.maxOrder) * CDSHealpix.pow2(this.maxOrder);
            long l5 = l / l4;
            n = (int)Math.sqrt(l5);
        }
        l = CDSHealpix.pow2(this.maxOrder);
        if (!bl) {
            this.context.info("HiPS maxOrder=" + this.maxOrder + " tileWidth=" + n);
        }
        this.context.setOrder(this.maxOrder);
        int n5 = (int)(CDSHealpix.log2(this.nside) - CDSHealpix.log2((long)n * l)) * 2;
        char c = 'D';
        char c2 = 'J';
        int n6 = 0;
        int n7 = 0;
        int n8 = 1;
        int n9 = 0;
        int n10 = 8;
        int n11 = 4;
        for (int i = 1; i <= n4; ++i) {
            String string5 = this.headerFits.getStringFromHeader("TFORM" + i).trim();
            if (i == n3 + 1) {
                c = string5.charAt(string5.length() - 1);
                n10 = cds.tools.Util.binSizeOf(c, 1);
                if (string5.length() > 1) {
                    n8 = Integer.parseInt(string5.substring(0, string5.length() - 1));
                }
                n7 = n9;
            } else if (bl2 && i == 1) {
                c2 = string5.charAt(string5.length() - 1);
                n11 = cds.tools.Util.binSizeOf(c2, 1);
                n6 = n9;
            }
            n9 += cds.tools.Util.binSizeOf(string5);
        }
        long l6 = l2 * l3 / (long)n9;
        this.bitpixOrig = this.getBitpixFromFormat(c);
        if (bl) {
            return;
        }
        this.context.setBitpixOrig(this.bitpixOrig);
        this.context.setBlankOrig(d4);
        this.context.setBZeroOrig(d2);
        this.context.setBScaleOrig(d3);
        this.context.info("Original BITPIX=" + this.bitpixOrig + " BLANK=" + d4 + (d2 != 0.0 ? " BZERO=" + d2 : "") + (d3 != 1.0 ? " BSCALE=" + d3 : ""));
        double d5 = this.context.getBScale();
        double d6 = this.context.getBZero();
        double d7 = this.context.getBScale();
        int n12 = this.context.getBitpix();
        double[] dArray = this.context.getPixelRangeCut();
        double[] dArray2 = null;
        double[] dArray3 = null;
        int n13 = this.getBitpixFromFormat(c2);
        long l7 = n * n;
        int n14 = (int)CDSHealpix.log2(n);
        int[] nArray = Util.createHpx2xy(n14);
        this.context.info("MAP structure: nbRecord=" + l6 + " nbValPerSegment=" + n8 + " valType=" + c);
        RandomAccessFile randomAccessFile = null;
        Fits fits = null;
        Fits fits2 = null;
        String string6 = "";
        long l8 = 12L * l * l;
        long l9 = l7 * (long)(Math.abs(n12) / 8) + 4000L;
        long l10 = l8 * l9;
        long l11 = (long)((double)this.context.getMem() * 0.75);
        if (l10 < l11) {
            l11 = l10;
        }
        this.context.info("Writer cache RAM=" + cds.tools.Util.getUnitDisk(l11) + " (" + l11 / l9 + " tiles)");
        this.cache = new CacheFitsWriter(l11);
        this.cache.setContext(this.context);
        int n15 = 512;
        int n16 = n15 / n9;
        if (n16 < 1) {
            n16 = 1;
        }
        n15 = n16 * n9;
        byte[] byArray = new byte[n15];
        Fits fits3 = null;
        int n17 = 0;
        try {
            int n18;
            long l12;
            int n19;
            randomAccessFile = new RandomAccessFile(this.context.getInputPath(), "rw");
            boolean bl4 = dArray == null || Double.isNaN(dArray[0]);
            boolean bl5 = dArray == null || Double.isNaN(dArray[2]);
            int n20 = bl4 || bl5 ? 2 : 1;
            int n21 = 1;
            if (n20 == 2) {
                n19 = Math.abs(this.bitpixOrig) / 8;
                l12 = l11 / (long)n19;
                n18 = n17 = (int)(l6 * (long)n8);
                int n22 = (int)Math.sqrt(n17);
                n21 = 1;
                while ((long)n17 > l12 || n22 > 4096) {
                    n17 = n18 / n21;
                    n22 = (int)Math.sqrt(n17);
                    ++n21;
                }
                n17 = n22 * n22;
                fits3 = new Fits(n22, n22, this.bitpixOrig);
                fits3.setBlank(d4);
                fits3.setBzero(d2);
                fits3.setBscale(d3);
                this.context.info("Pixel dynamic estimation on " + n17 + " values" + (n21 > 1 ? " (gapSample=" + n21 + ")" : "") + "...");
            }
            block22: for (n19 = 0; n19 < n20; ++n19) {
                if (n19 == n20 - 1) {
                    this.initStat(l6);
                    if (fits3 != null) {
                        this.context.initCut(fits3);
                    }
                    dArray2 = this.context.getCutOrig();
                    if (dArray != null && !Double.isNaN(dArray[0])) {
                        if (dArray2 == null) {
                            dArray2 = new double[5];
                        }
                        dArray2[0] = dArray[0];
                        dArray2[1] = dArray[1];
                    }
                    if (dArray != null && !Double.isNaN(dArray[2])) {
                        if (dArray2 == null) {
                            dArray3 = new double[5];
                        }
                        dArray2[2] = dArray[2];
                        dArray2[3] = dArray[3];
                    }
                    this.context.setCutOrig(dArray2);
                    this.context.initParameters();
                    dArray3 = this.context.getCut();
                    if (this.bitpixOrig != n12) {
                        d7 = this.context.getBlank();
                        d6 = this.context.getBZero();
                        d5 = this.context.getBScale();
                    }
                    if (fits3 != null) {
                        fits3.free();
                    }
                    this.context.setValidateCut(true);
                    this.context.info("Pixel dynamic range=[" + this.ip(dArray3[2], d6, d5) + " .. " + this.ip(dArray3[3], d6, d5) + "] cut=[" + this.ip(dArray3[0], d6, d5) + " .. " + this.ip(dArray3[1], d6, d5) + "]");
                    this.context.setTileOrder(n14);
                }
                int n23 = 0;
                long l13 = 0L;
                int n24 = n16;
                randomAccessFile.seek(this.initialOffsetHpx);
                l12 = 0L;
                while (l12 < l6) {
                    if (n24 == n16) {
                        randomAccessFile.readFully(byArray);
                        n24 = 0;
                    }
                    if (this.context.isTaskAborting()) {
                        throw new Exception("Task abort !");
                    }
                    if (n19 == n20 - 1) {
                        this.updateStat(l12);
                    }
                    for (n18 = 0; n18 < n8; ++n18) {
                        int n25;
                        long l14;
                        String string7;
                        double d8;
                        long l15 = bl2 ? BuilderMapTiles.getNpix(byArray, n13, n6 + n24 * n9 + n18 * n11) : l13;
                        ++l13;
                        if (!bl3) {
                            l15 = CDSHealpix.ring2nest(this.nside, l15);
                        }
                        if ((d8 = BuilderMapTiles.getVal(byArray, this.bitpixOrig, n7 + n24 * n9 + n18 * n10)) == d) {
                            d8 = d4;
                        }
                        if (n19 == 0 && n20 == 2) {
                            if (n23 >= fits3.width * fits3.width) continue block22;
                            if (l13 % (long)n21 != 0L) continue;
                            Fits.setPixValDouble(fits3.pixels, this.bitpixOrig, n23++, d8);
                            continue;
                        }
                        if (n12 != this.bitpixOrig) {
                            double d9 = Double.isNaN(d8) || d8 == d4 ? d7 : (d8 <= dArray2[2] ? dArray3[2] : (d8 = d8 >= dArray2[3] ? dArray3[3] : (d8 - dArray2[2]) * this.context.coef + dArray3[2]));
                            if (n12 > 0 && (double)((long)d8) == d7 && d8 != d7) {
                                d8 += 0.5;
                            }
                        }
                        if (n5 != 0) {
                            l15 >>>= n5;
                        }
                        if ((string7 = Util.getFilePath(string2, this.maxOrder, l14 = l15 / l7) + ".fits").equals(string6)) {
                            fits = fits2;
                        } else {
                            try {
                                fits = this.cache.getFits(string7);
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                fits = new Fits(n, n, n12);
                                fits.setBlank(d7);
                                fits.setBzero(d6);
                                fits.setBscale(d5);
                                for (int i = 0; i < n; ++i) {
                                    for (n25 = 0; n25 < n; ++n25) {
                                        fits.setPixelDouble(n25, i, d7);
                                    }
                                }
                                this.cache.addFits(string7, fits);
                            }
                            fits2 = fits;
                        }
                        long l16 = l14 * (long)n * (long)n;
                        n25 = nArray[(int)(l15 - l16)];
                        Fits.setPixValDouble(fits.pixels, n12, n25, d8);
                    }
                    ++l12;
                    ++n24;
                }
            }
        }
        finally {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
        this.cache.close();
    }

    public static final long getNpix(byte[] byArray, int n, int n2) {
        try {
            switch (n) {
                case 8: {
                    return PlanImage.getByte(byArray, n2);
                }
                case 16: {
                    return PlanImage.getShort(byArray, n2);
                }
                case 32: {
                    return PlanImage.getInt(byArray, n2);
                }
                case 64: {
                    return PlanImage.getLong(byArray, n2);
                }
            }
            return 0L;
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public static final double getVal(byte[] byArray, int n, int n2) {
        try {
            switch (n) {
                case 8: {
                    return PlanImage.getByte(byArray, n2);
                }
                case 16: {
                    return PlanImage.getShort(byArray, n2);
                }
                case 32: {
                    return PlanImage.getInt(byArray, n2);
                }
                case 64: {
                    return PlanImage.getLong(byArray, n2);
                }
                case -32: {
                    return PlanImage.getFloat(byArray, n2);
                }
                case -64: {
                    return PlanImage.getDouble(byArray, n2);
                }
            }
            return Double.NaN;
        }
        catch (Exception exception) {
            return Double.NaN;
        }
    }

    private int getLevelImage(long l, long l2) {
        long l3 = 12L * l * l;
        long l4 = l3 / (l2 * l2);
        if (l4 < 1L) {
            return -1;
        }
        long l5 = (long)Math.sqrt(l4 / 12L);
        return (int)CDSHealpix.log2(l5);
    }

    private int getBitpixFromFormat(char c) throws Exception {
        int n;
        int n2 = c == 'B' ? 8 : (c == 'I' ? 16 : (c == 'J' ? 32 : (c == 'K' ? 64 : (c == 'E' ? -32 : (n = c == 'D' ? -64 : 0)))));
        if (n == 0) {
            throw new Exception("Unsupported data type => [" + c + "]");
        }
        return n;
    }

    @Override
    public boolean isAlreadyDone() {
        return false;
    }
}

