/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.MyInputStream;
import cds.aladin.MyProperties;
import cds.aladin.Tok;
import cds.allsky.Action;
import cds.allsky.BuilderMoc;
import cds.allsky.BuilderTiles;
import cds.allsky.BuilderTree;
import cds.allsky.Context;
import cds.allsky.ThreadBuilderTile;
import cds.fits.Fits;
import cds.moc.HealpixMoc;
import cds.tools.pixtools.Util;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

public class BuilderMirror
extends BuilderTiles {
    private Fits bidon;
    private MyProperties prop;
    private boolean isPartial = false;
    private boolean isSmaller = false;
    private boolean isUpdate = false;
    private boolean flagIsUpToDate = false;
    private String dateRelease = "";
    private boolean isLocal = false;
    int statNbFile = 0;
    long statCumul = 0L;
    long lastCumul = 0L;
    long lastTime = 0L;

    public BuilderMirror(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.MIRROR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateContext() throws Exception {
        Object object;
        this.validateOutput();
        String string = this.context.getInputPath();
        boolean bl = this.isLocal = !string.startsWith("http://") && !string.startsWith("https://") && !string.startsWith("ftp://");
        if (this.isLocal) {
            this.context.info("Local mirror copy");
        }
        this.prop = new MyProperties();
        MyInputStream myInputStream = null;
        try {
            myInputStream = cds.tools.Util.openAnyStream(this.context.getInputPath() + "/properties");
            this.prop.load(myInputStream);
        }
        finally {
            if (myInputStream != null) {
                myInputStream.close();
            }
        }
        String string2 = this.prop.getProperty("hips_status");
        if (string2 != null && this.context.testClonable && string2.indexOf("unclonable") >= 0) {
            throw new Exception("This HiPS is unclonable => status: " + string2);
        }
        string2 = this.prop.getProperty("hips_order");
        if (string2 == null) {
            string2 = this.prop.getProperty("maxOrder");
        }
        if (string2 == null) {
            this.context.warning("No order specified in the remote HiPS properties file !");
        }
        int n = string2 == null ? -1 : Integer.parseInt(string2);
        int n2 = this.context.getOrder();
        if (n2 == -1) {
            if (n == -1) {
                throw new Exception("Order unknown !");
            }
            this.context.setOrder(n);
        } else if (n != -1) {
            if (n2 > n) {
                throw new Exception("Order greater than the original");
            }
            if (n != n2) {
                this.isPartial = true;
            }
        }
        string2 = this.prop.getProperty("hips_tile_format");
        if (string2 == null) {
            string2 = this.prop.getProperty("format");
        }
        if (this.context.tileTypes == null) {
            if (string2 == null) {
                throw new Exception("tile format unknown");
            }
            object = new Tok(string2);
            while (((Tok)object).hasMoreTokens()) {
                this.context.addTileType(((Tok)object).nextToken());
            }
        } else if (string2 != null && !this.context.getTileTypes().equals(string2)) {
            this.isPartial = true;
        }
        this.context.info("Mirroring tiles: " + this.context.getTileTypes() + "...");
        object = new HealpixMoc();
        myInputStream = null;
        try {
            myInputStream = cds.tools.Util.openAnyStream(this.context.getInputPath() + "/Moc.fits");
            ((HealpixMoc)object).read(myInputStream);
            if (this.context.getArea() == null) {
                this.context.setMocArea((HealpixMoc)object);
            } else if (!this.context.getArea().equals(object)) {
                this.isPartial = true;
                this.isSmaller = true;
                this.context.setMocArea(((HealpixMoc)object).intersection(this.context.getArea()));
                this.context.info("Partial spacial mirror");
            }
        }
        finally {
            if (myInputStream != null) {
                myInputStream.close();
            }
        }
        string2 = this.prop.getProperty("dataproduct_subtype");
        if (string2 != null) {
            if (string2.equals("color")) {
                this.context.setBitpixOrig(0);
            }
        } else {
            string2 = this.prop.getProperty("isColored");
            if (string2 != null && string2.equals("true")) {
                this.context.setBitpixOrig(0);
            }
        }
        if (this.context.isColor()) {
            this.context.info("Mirroring colored HiPS");
        }
        if ((string2 = this.prop.getProperty("hips_frame")) == null) {
            string2 = this.prop.getProperty("coordsys");
        }
        if (string2 != null) {
            this.context.setFrameName(string2);
        }
        if ((string2 = this.prop.getProperty("hips_cube_depth")) == null) {
            string2 = this.prop.getProperty("cubeDepth");
        }
        if (string2 != null) {
            int n3 = Integer.parseInt(string2);
            this.context.setDepth(n3);
        }
        if (this.context.isCube()) {
            this.context.info("Mirroring cube HiPS (depth=" + this.context.depth + ")");
        }
        this.context.moc = this.context.mocArea;
        this.context.setValidateRegion(true);
        if (new File(this.context.getOutputPath() + "/properties").exists()) {
            MyProperties myProperties = new MyProperties();
            myInputStream = null;
            try {
                myInputStream = cds.tools.Util.openAnyStream(this.context.getOutputPath() + "/properties");
                myProperties.load(myInputStream);
                String string3 = myProperties.getProperty("hips_release_date");
                String string4 = this.prop.getProperty("hips_release_date");
                if (string3 != null && string4 != null && string3.equals(string4)) {
                    this.dateRelease = string3;
                    this.flagIsUpToDate = !this.isSmaller && !this.isPartial;
                }
                this.isUpdate = true;
                this.context.info("Updating a previous HiPS copy [" + this.context.getOutputPath() + "]...");
            }
            finally {
                if (myInputStream != null) {
                    myInputStream.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        if (this.flagIsUpToDate) {
            this.context.info("Local HiPS copy seems to be already up-to-date (same hips_release_date=" + this.dateRelease + ")");
            this.context.info("Only the properties file will be updated");
        } else {
            this.build();
            if (!this.context.isTaskAborting()) {
                this.b = new BuilderMoc(this.context);
                this.b.run();
                this.b = null;
            }
            if (!this.context.isTaskAborting()) {
                this.copyX(this.context.getInputPath() + "/index.html", this.context.getOutputPath() + "/index.html");
                this.copyAllsky();
                if (this.isSmaller) {
                    this.b = new BuilderTree(this.context);
                    this.b.run();
                    this.b = null;
                }
            }
        }
        if (!this.context.isTaskAborting()) {
            Object object;
            StringBuilder stringBuilder;
            this.prop.remove("hips_service_url");
            this.prop.remove("moc_access_url");
            this.prop.remove("hips_estsize");
            double d = this.context.moc.getCoverage();
            this.prop.replaceValue("moc_sky_fraction", cds.tools.Util.myRound(d));
            this.prop.replaceValue("hips_tile_format", this.context.getTileTypes());
            String string = this.prop.getProperty("hips_status");
            if (string == null) {
                stringBuilder = new StringBuilder("public mirror clonableOnce");
            } else {
                object = new Tok(string);
                stringBuilder = new StringBuilder();
                while (((Tok)object).hasMoreTokens()) {
                    String string2 = ((Tok)object).nextToken();
                    if (string2.equals("master")) {
                        String string3 = string2 = this.isPartial ? "partial" : "mirror";
                    }
                    if (string2.equals("clonableOnce")) {
                        string2 = "unclonable";
                    }
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append(string2);
                }
            }
            this.prop.replaceValue("hips_status", stringBuilder.toString());
            object = null;
            try {
                object = new FileOutputStream(this.context.getOutputPath() + "/properties");
                this.prop.store((OutputStream)object, null);
            }
            finally {
                if (object != null) {
                    ((FileOutputStream)object).close();
                }
            }
        }
    }

    @Override
    public void showStatistics() {
        if (this.flagIsUpToDate) {
            return;
        }
        long l = System.currentTimeMillis();
        long l2 = l - this.lastTime;
        long l3 = l2 > 1000L && this.lastTime > 0L ? this.lastCumul / (l2 / 1000L) : 0L;
        this.lastTime = l;
        this.lastCumul = 0L;
        this.context.showMirrorStat(this.statNbFile, this.statCumul, l3, this.totalTime, this.statNbThread, this.statNbThreadRunning);
    }

    @Override
    public void build() throws Exception {
        this.bidon = new Fits();
        this.initStat();
        super.build();
    }

    @Override
    protected Fits createLeaveHpx(ThreadBuilderTile threadBuilderTile, String string, String string2, int n, long l, int n2) throws Exception {
        return this.createLeaveHpx(threadBuilderTile, string, string2, n, l, n2, true);
    }

    private Fits createLeaveHpx(ThreadBuilderTile threadBuilderTile, String string, String string2, int n, long l, int n2, boolean bl) throws Exception {
        String string3 = this.context.getInputPath() + "/" + Util.getFilePath(n, l, n2);
        try {
            long l2 = 0L;
            for (String string4 : this.context.tileTypes) {
                String string5 = string3 + string4;
                String string6 = string + string4;
                l2 += (long)this.copy(string5, string6);
            }
            if (bl) {
                this.updateStat(l2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.context.taskAbort();
        }
        return this.bidon;
    }

    private void copyAllsky() throws Exception {
        for (int i = 0; i < this.context.depth; ++i) {
            for (String string : this.context.tileTypes) {
                String string2 = i == 0 ? "" : "_" + i;
                String string3 = this.context.getInputPath() + "/Norder3/Allsky" + string2 + string;
                String string4 = this.context.getOutputPath() + "/Norder3/Allsky" + string2 + string;
                this.copyX(string3, string4);
            }
        }
    }

    private int copyX(String string, String string2) throws Exception {
        try {
            return this.copy(string, string2);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private int copy(String string, String string2) throws Exception {
        if (this.isLocal) {
            return this.copyLocal(string, string2);
        }
        return this.copyRemote(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int copyRemote(String string, String string2) throws Exception {
        long l = -1L;
        byte[] byArray = null;
        try {
            if (this.context.mirrorDelay > 0) {
                Thread.currentThread().wait(this.context.mirrorDelay);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < 3; ++i) {
            File file;
            long l2;
            Object object;
            MyInputStream myInputStream = null;
            try {
                Object object2;
                object = new URL(string);
                URLConnection uRLConnection = ((URL)object).openConnection();
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                l2 = httpURLConnection.getLastModified();
                file = new File(string2);
                if (file.exists() && file.length() > 0L && (l = (long)httpURLConnection.getContentLength()) == file.length() && l2 <= file.lastModified()) {
                    InputStream inputStream = httpURLConnection.getInputStream();
                    object2 = new byte[512];
                    while (inputStream.read((byte[])object2) > 0) {
                    }
                    inputStream.close();
                    int n = 0;
                    return n;
                }
                myInputStream = new MyInputStream(httpURLConnection.getInputStream());
                try {
                    byArray = myInputStream.readFully();
                    myInputStream.close();
                    myInputStream = null;
                }
                catch (IOException iOException) {
                    object2 = httpURLConnection.getErrorStream();
                    byte[] byArray2 = new byte[512];
                    while (((InputStream)object2).read(byArray2) > 0) {
                    }
                    ((InputStream)object2).close();
                }
            }
            finally {
                if (myInputStream != null) {
                    try {
                        myInputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
            object = null;
            try {
                cds.tools.Util.createPath(string2);
                object = new RandomAccessFile(string2, "rw");
                ((RandomAccessFile)object).write(byArray);
                ((RandomAccessFile)object).close();
                object = null;
            }
            finally {
                if (object != null) {
                    try {
                        ((RandomAccessFile)object).close();
                    }
                    catch (Exception exception) {}
                }
            }
            file.setLastModified(l2);
            if (l <= 0L || new File(string2).length() >= l) break;
            if (i == 2) {
                throw new Exception("Truncated file copy");
            }
            this.context.warning("Truncated file copy => try again [" + string + "]");
        }
        return byArray == null ? 0 : byArray.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int copyLocal(String string, String string2) throws Exception {
        long l = -1L;
        File file = new File(string);
        long l2 = file.lastModified();
        File file2 = new File(string2);
        if (file2.exists() && file2.length() > 0L && (l = file.length()) == file2.length() && l2 <= file2.lastModified()) {
            return 0;
        }
        l = 0L;
        RandomAccessFile randomAccessFile = null;
        RandomAccessFile randomAccessFile2 = null;
        byte[] byArray = new byte[512];
        try {
            int n;
            cds.tools.Util.createPath(string2);
            randomAccessFile = new RandomAccessFile(string2, "rw");
            randomAccessFile2 = new RandomAccessFile(string, "r");
            while ((n = randomAccessFile2.read(byArray)) > 0) {
                randomAccessFile.write(byArray, 0, n);
                l += (long)n;
            }
            randomAccessFile.close();
            randomAccessFile = null;
            randomAccessFile2.close();
            randomAccessFile2 = null;
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (Exception exception) {}
            }
            if (randomAccessFile2 != null) {
                try {
                    randomAccessFile2.close();
                }
                catch (Exception exception) {}
            }
        }
        file2.setLastModified(l2);
        return (int)l;
    }

    @Override
    protected Fits createNodeHpx(String string, String string2, int n, long l, Fits[] fitsArray, int n2) throws Exception {
        if (!this.isSmaller) {
            return this.createLeaveHpx(null, string, string2, n, l, n2, false);
        }
        return this.bidon;
    }

    @Override
    public Fits findLeaf(String string) throws Exception {
        return null;
    }

    private void initStat() {
        this.statNbFile = 0;
        this.statCumul = 0L;
        this.startTime = System.currentTimeMillis();
    }

    private void updateStat(long l) {
        ++this.statNbFile;
        this.lastCumul += l;
        this.statCumul += l;
        this.totalTime = System.currentTimeMillis() - this.startTime;
    }
}

