/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.MyInputStream;
import cds.allsky.Action;
import cds.allsky.Builder;
import cds.allsky.Context;
import cds.fits.Fits;
import cds.moc.HealpixMoc;
import cds.tools.pixtools.CDSHealpix;
import cds.tools.pixtools.Util;
import java.io.File;
import java.io.FileInputStream;

public class BuilderMoc
extends Builder {
    protected HealpixMoc moc;
    protected int mocOrder;
    protected int fileOrder;
    protected int tileOrder;
    protected boolean isMocHight;
    private String ext = null;
    long startTime = 0L;
    int nbTiles = -1;

    public BuilderMoc(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.MOC;
    }

    @Override
    public void run() throws Exception {
        this.createMoc(this.context.getOutputPath());
    }

    @Override
    public void validateContext() throws Exception {
        this.validateOutput();
        if (!this.context.verifTileOrder()) {
            throw new Exception("Uncompatible tileOrder !");
        }
    }

    public HealpixMoc getMoc() {
        return this.moc;
    }

    protected void createMoc(String string) throws Exception {
        this.moc = new HealpixMoc();
        this.fileOrder = this.mocOrder = Util.getMaxOrderByPath(string);
        this.tileOrder = this.context.getTileOrder();
        boolean bl = true;
        try {
            if (this.context.mocIndex == null) {
                this.context.loadMocIndex();
            }
            bl = this.context.mocIndex.getCoverage() > 0.16666666666666666;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.context.getMocOrder() != -1) {
            this.mocOrder = this.context.getMocOrder();
        } else {
            if (this.mocOrder < 8 || !bl) {
                this.mocOrder = this.context.getOrder() + this.context.getTileOrder() - 4;
            }
            if (this.mocOrder < 8) {
                this.mocOrder = 8;
            }
        }
        if (this.mocOrder > this.tileOrder + this.fileOrder) {
            this.mocOrder = this.tileOrder + this.fileOrder;
        }
        if (this.context.isColor()) {
            this.mocOrder = this.fileOrder;
        }
        this.ext = this.getDefaultExt(string);
        if (this.ext != null) {
            this.context.info("MOC generation based on " + this.ext + " tiles");
        }
        this.isMocHight = this.mocOrder > this.fileOrder && this.ext != null && this.ext.equals("fits");
        this.moc.setMocOrder(this.mocOrder);
        String string2 = string + cds.tools.Util.FS + "Moc.fits";
        long l = System.currentTimeMillis();
        this.context.info("MOC generation (" + (this.isMocHight ? "hight resolution" : "low resolution") + " mocOrder=" + this.moc.getMocOrder() + ")...");
        this.moc.setCoordSys(this.getFrame());
        this.moc.setCheckConsistencyFlag(false);
        this.generateMoc(this.moc, this.fileOrder, string);
        this.moc.setCheckConsistencyFlag(true);
        this.moc.write(string2);
        long l2 = System.currentTimeMillis() - l;
        this.context.info("MOC done in " + cds.tools.Util.getTemps(l2, true) + ": mocOrder=" + this.moc.getMocOrder() + " size=" + cds.tools.Util.getUnitDisk(this.moc.getSize()));
    }

    private String getDefaultExt(String string) {
        if (new File(string + cds.tools.Util.FS + "Norder3" + cds.tools.Util.FS + "Allsky.fits").exists()) {
            return "fits";
        }
        if (new File(string + cds.tools.Util.FS + "Norder3" + cds.tools.Util.FS + "Allsky.jpg").exists()) {
            return "jpg";
        }
        if (new File(string + cds.tools.Util.FS + "Norder3" + cds.tools.Util.FS + "Allsky.png").exists()) {
            return "png";
        }
        return null;
    }

    private void initStat() {
        this.startTime = System.currentTimeMillis();
        this.nbTiles = 1;
    }

    private void updateStat() {
        ++this.nbTiles;
    }

    @Override
    public void showStatistics() {
        long l = System.currentTimeMillis();
        long l2 = l - this.startTime;
        if (l2 < 2000L) {
            return;
        }
        this.context.stat(this.nbTiles + " tile" + (this.nbTiles > 1 ? "s" : "") + " scanned in " + cds.tools.Util.getTemps(l2));
    }

    public long getUsedArea() {
        return this.moc.getUsedArea();
    }

    public long getArea() {
        return this.moc.getArea();
    }

    protected void generateMoc(HealpixMoc healpixMoc, int n, String string) throws Exception {
        this.initStat();
        File file = new File(string + Util.FS + "Norder" + n);
        File[] fileArray = file.listFiles();
        if (fileArray == null || fileArray.length == 0) {
            throw new Exception("No tiles found !");
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (this.context.isTaskAborting()) {
                throw new Exception("Task abort !");
            }
            if (!fileArray[i].isDirectory()) continue;
            File[] fileArray2 = fileArray[i].listFiles();
            for (int j = 0; j < fileArray2.length; ++j) {
                String string2 = fileArray2[j].getAbsolutePath();
                long l = Util.getNpixFromPath(string2);
                if (l == -1L) continue;
                String string3 = this.getExt(string2);
                if (this.ext == null) {
                    this.ext = string3;
                } else if (!this.ext.equals(string3)) continue;
                this.generateTileMoc(healpixMoc, fileArray2[j], n, l);
            }
            healpixMoc.checkAndFix();
        }
    }

    private void generateTileMoc(HealpixMoc healpixMoc, File file, int n, long l) throws Exception {
        this.updateStat();
        if (this.isMocHight) {
            this.generateHighTileMoc(healpixMoc, n, file, l);
        } else {
            healpixMoc.add(n, l);
        }
    }

    private void generateHighTileMoc(HealpixMoc healpixMoc, int n, File file, long l) throws Exception {
        Fits fits = new Fits();
        MyInputStream myInputStream = new MyInputStream(new FileInputStream(file));
        myInputStream = myInputStream.startRead();
        try {
            fits.loadFITS(myInputStream);
        }
        catch (Exception exception) {
            System.err.println("f=" + file.getAbsolutePath());
            throw exception;
        }
        myInputStream.close();
        long l2 = fits.width;
        long l3 = l2 * l2 * l;
        int n2 = healpixMoc.getMocOrder();
        int n3 = (int)CDSHealpix.log2(l2);
        int n4 = (n + n3 - n2) * 2;
        this.context.createHealpixOrder(n3);
        long l4 = -1L;
        for (int i = 0; i < fits.height; ++i) {
            for (int j = 0; j < fits.width; ++j) {
                try {
                    double d;
                    l = l3 + (long)this.context.xy2hpx(i * fits.width + j);
                    if ((l >>>= n4) == l4 || fits.isBlankPixel(d = fits.getPixelDouble(j, i))) continue;
                    healpixMoc.add(n2, l);
                    l4 = l;
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        healpixMoc.checkAndFix();
    }

    private String getExt(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return "";
        }
        int n2 = string.indexOf(Util.FS, n);
        if (n2 != -1) {
            return "";
        }
        return string.substring(n + 1, string.length());
    }
}

