/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.CanvasColorMap;
import cds.aladin.KernelList;
import cds.aladin.MyProperties;
import cds.aladin.PlanImage;
import cds.aladin.Tok;
import cds.allsky.Action;
import cds.allsky.BuilderAllsky;
import cds.allsky.BuilderMoc;
import cds.allsky.BuilderTiles;
import cds.allsky.Context;
import cds.allsky.ContextGui;
import cds.allsky.Mode;
import cds.allsky.ThreadBuilderTile;
import cds.fits.Fits;
import cds.moc.HealpixMoc;
import cds.tools.pixtools.Util;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.FileInputStream;

public class BuilderRgb
extends BuilderTiles {
    private String[] inputs;
    private HealpixMoc[] moc;
    private MyProperties[] prop;
    private String[] labels;
    private String[] transfertFcts;
    private double[] pixelMin;
    private double[] pixelMax;
    private double[] pixelMiddle;
    private String output;
    private int width = -1;
    private double[] blank;
    private double[] bscale;
    private double[] bzero;
    private byte[][] tcm;
    private int[] bitpix;
    private int maxOrder = -1;
    private String frame = null;
    private int missing = -1;
    private boolean flagGauss;
    private int statNbFile;
    private Mode coaddMode = Mode.REPLACETILE;
    private int format;
    static final double[] kernel = KernelList.createFastGaussienMatrix(2, 0.8);

    public BuilderRgb(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.RGB;
    }

    @Override
    public void run() throws Exception {
        Fits.setToolKit();
        this.build();
        this.context.setPropriete("hips_hierarchy", this.context.getJpegMethod().toString().toLowerCase());
        if (!this.context.isTaskAborting()) {
            new BuilderMoc(this.context).createMoc(this.output);
        }
        if (!this.context.isTaskAborting()) {
            new BuilderAllsky(this.context).run();
            this.context.info("ALLSKY file done");
        }
    }

    @Override
    protected void activateCache(long l, long l2) {
    }

    @Override
    public void showStatistics() {
        this.context.showRGBStat(this.statNbFile, this.totalTime, this.statNbThread, this.statNbThreadRunning);
    }

    @Override
    protected void setProgressBar(int n) {
        this.context.setProgress(n);
    }

    private void initStat() {
        this.context.setProgressMax(768.0);
        this.statNbFile = 0;
        this.startTime = System.currentTimeMillis();
    }

    private void updateStat() {
        ++this.statNbFile;
        this.totalTime = System.currentTimeMillis() - this.startTime;
    }

    @Override
    protected int getBitpix0() {
        return 0;
    }

    @Override
    public void build() throws Exception {
        this.initStat();
        super.build();
    }

    @Override
    public void validateContext() throws Exception {
        int n;
        String string = this.context.getRgbOutput();
        this.format = this.context.getRgbFormat();
        this.coaddMode = this.context.getMode();
        if (this.coaddMode != Mode.KEEPTILE && this.coaddMode != Mode.REPLACETILE) {
            if (this.context instanceof ContextGui) {
                this.context.setMode(Mode.REPLACETILE);
            } else {
                throw new Exception("Only KEEPTILE and REPLACETILE modes are supported for RGB HiPS generation");
            }
        }
        String string2 = null;
        this.inputs = new String[3];
        this.labels = new String[3];
        this.moc = new HealpixMoc[3];
        this.prop = new MyProperties[3];
        this.pixelMin = new double[3];
        this.pixelMiddle = new double[3];
        this.pixelMax = new double[3];
        this.transfertFcts = new String[3];
        this.bitpix = new int[3];
        for (n = 0; n < 3; ++n) {
            this.bitpix[n] = 0;
        }
        this.blank = new double[3];
        this.bzero = new double[3];
        this.bscale = new double[3];
        this.tcm = new byte[3][];
        if (this.context.hasFrame()) {
            this.frame = this.context.getFrameName();
        }
        for (n = 0; n < 3; ++n) {
            this.inputs[n] = this.context.plansRGB[n];
            if (this.inputs[n] == null) {
                if (this.missing != -1) {
                    throw new Exception("HiPS RGB generation required at least 2 original components");
                }
                this.missing = n;
                continue;
            }
            if (!this.context.isExistingAllskyDir(this.inputs[n])) {
                throw new Exception("Input HiPS missing [" + this.inputs[n] + "]");
            }
            if (string2 == null) {
                string2 = this.inputs[n];
            }
            this.prop[n] = this.loadProperties(this.inputs[n]);
            this.labels[n] = this.getLabelFromProp(this.prop[n], this.inputs[n]);
            String string3 = this.context.cmsRGB[n];
            if (string3 == null && (string3 = this.getCmParamFromProp(this.prop[n])) == null) {
                throw new Exception("Unknown pixelcut for " + this.labels[n]);
            }
            this.setCmParamExact(string3, n);
            int n2 = this.getOrderFromProp(this.prop[n], this.inputs[n]);
            if (n2 > this.maxOrder) {
                this.maxOrder = n2;
            }
            HealpixMoc healpixMoc = this.moc[n] = this.loadMoc(this.inputs[n]);
            this.context.moc = this.context.moc == null ? healpixMoc : this.context.moc.union(healpixMoc);
            String string4 = this.getFrameFromProp(this.prop[n]);
            if (this.frame == null) {
                this.frame = string4;
                continue;
            }
            if (this.frame.equals(string4)) continue;
            throw new Exception("Uncompatible coordsys for " + this.labels[n]);
        }
        if (string == null) {
            n = string2.length() - 1;
            int n3 = Math.max(string2.lastIndexOf(47, n), string2.lastIndexOf(92, n));
            string = string2.substring(0, n3 + 1) + "RGBHiPS";
            this.context.warning("Missing \"out\" parameter. Assuming \"" + string + "\"");
        }
        this.output = string;
        if (this.context instanceof ContextGui) {
            HealpixMoc healpixMoc = this.context.moc;
            ((ContextGui)this.context).mainPanel.clearForms();
            this.context.moc = healpixMoc;
        }
        if (this.context.getOrder() == -1) {
            this.context.setOrder(this.maxOrder);
            this.context.info("Using order = " + this.maxOrder);
        } else {
            this.maxOrder = this.context.getOrder();
        }
        if (!this.context.hasFrame()) {
            this.context.setFrameName(this.frame);
            this.context.info("Using coordys = " + this.context.getFrameName());
        }
        this.context.setOutputPath(string);
        this.context.setBitpixOrig(0);
        for (int i = 0; i < 3; ++i) {
            if (i == this.missing) continue;
            String string5 = this.labels[i] + " [" + this.pixelMin[i] + " " + this.pixelMiddle[i] + " " + this.pixelMax[i] + " " + this.transfertFcts[i] + "]";
            if (i == 0) {
                this.context.redInfo = string5;
                continue;
            }
            if (i == 1) {
                this.context.greenInfo = string5;
                continue;
            }
            this.context.blueInfo = string5;
        }
        if (this.context.mocArea != null) {
            this.context.moc = this.context.moc.intersection(this.context.mocArea);
        }
        if (this.context.gaussFilter) {
            this.context.info("Gauss filter activated...");
        }
        this.flagGauss = this.context.gaussFilter;
        this.context.writeMetaFile();
    }

    private HealpixMoc loadMoc(String string) throws Exception {
        String string2 = string + Util.FS + "Moc.fits";
        if (!new File(string2).canRead()) {
            return new HealpixMoc("0/0-11");
        }
        HealpixMoc healpixMoc = new HealpixMoc();
        healpixMoc.read(string2);
        return healpixMoc;
    }

    private String getFrameFromProp(MyProperties myProperties) throws Exception {
        String string = myProperties.getProperty("hips_frame");
        if (string == null) {
            string = myProperties.getProperty("coordsys");
        }
        if (string == null) {
            string = "G";
        }
        return Context.getCanonicalFrameName(string);
    }

    private String getCmParamFromProp(MyProperties myProperties) throws Exception {
        String string = myProperties.getProperty("hips_pixel_cut");
        if (string == null) {
            string = myProperties.getProperty("pixelCut");
        }
        return string;
    }

    private String getLabelFromProp(MyProperties myProperties, String string) throws Exception {
        String string2 = null;
        if (myProperties != null && (string2 = myProperties.getProperty("obs_collection")) == null) {
            myProperties.getProperty("label");
        }
        if (string2 == null) {
            int n = string.lastIndexOf(47);
            if (n == -1) {
                n = string.lastIndexOf(92);
            }
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    private int getOrderFromProp(MyProperties myProperties, String string) throws Exception {
        int n = -1;
        String string2 = null;
        if (myProperties != null) {
            string2 = myProperties.getProperty("hips_order");
            if (string2 == null) {
                myProperties.getProperty("maxOrder");
            }
            try {
                n = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (n == -1) {
            n = Util.getMaxOrderByPath(string);
        }
        return n;
    }

    private MyProperties loadProperties(String string) throws Exception {
        String string2 = string + Util.FS + "properties";
        MyProperties myProperties = new MyProperties();
        File file = new File(string2);
        if (file.exists()) {
            if (!file.canRead()) {
                throw new Exception("Propertie file not available ! [" + string2 + "]");
            }
            FileInputStream fileInputStream = new FileInputStream(string2);
            myProperties.load(fileInputStream);
            fileInputStream.close();
        }
        return myProperties;
    }

    private void setCmParamExact(String string, int n) throws Exception {
        int n2;
        double d;
        double d2;
        Tok tok = new Tok(string);
        try {
            d2 = Double.parseDouble(tok.nextToken());
            d = Double.parseDouble(tok.nextToken());
        }
        catch (Exception exception) {
            throw new Exception("Colormap parameter error [" + string + "] => usage: min [middle] max [fct]");
        }
        if (d <= d2) {
            throw new Exception("Colormap parameter error [" + string + "] => max<=min");
        }
        double d3 = Double.NaN;
        String string2 = null;
        if (tok.hasMoreTokens()) {
            String string3 = tok.nextToken();
            try {
                double d4 = Double.parseDouble(string3);
                d3 = d;
                d = d4;
            }
            catch (Exception exception) {
                string2 = string3;
            }
        }
        if (tok.hasMoreTokens()) {
            string2 = tok.nextToken();
        }
        if (string2 != null) {
            int n3 = cds.tools.Util.indexInArrayOf(string2, PlanImage.TRANSFERTFCT, true);
            if (n3 < 0) {
                throw new Exception("Colormap parameter error [" + string + "] => Unknown transfert function [" + string2 + "]");
            }
            n2 = n3;
        } else {
            n2 = 3;
        }
        this.transfertFcts[n] = PlanImage.getTransfertFctInfo(n2);
        double d5 = 0.0;
        double d6 = 1.0;
        Fits fits = new Fits();
        String string4 = this.inputs[n] + Util.FS + "Norder3" + Util.FS + "Allsky.fits";
        File file = new File(string4);
        if (!file.canRead()) {
            throw new Exception("Cannot determine BZERO and BSCALE for component " + n + " => missing Allsky.fits");
        }
        fits.loadHeaderFITS(string4);
        try {
            d5 = fits.headerFits.getDoubleFromHeader("BZERO");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            d6 = fits.headerFits.getDoubleFromHeader("BSCALE");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.pixelMin[n] = (d2 - d5) / d6;
        this.pixelMiddle[n] = (d3 - d5) / d6;
        this.pixelMax[n] = (d - d5) / d6;
        int n4 = 128;
        if (!Double.isNaN(d3)) {
            if (d3 < d2 || d3 > d) {
                throw new Exception("Colormap parameter error [" + string + "] => med<min || med>max");
            }
            n4 = (int)((d3 - d2) / (d - d2) * 255.0);
        }
        this.context.info("Using pixelCut " + this.L(n) + " = " + d2 + (Double.isNaN(d3) ? "" : " " + d3) + " " + d + (n2 != 3 ? " " + PlanImage.getTransfertFctInfo(n2) : ""));
        IndexColorModel indexColorModel = CanvasColorMap.getCM(0, n4, 255, false, 0, n2, true);
        this.tcm[n] = cds.tools.Util.getTableCM(indexColorModel, 2);
    }

    private String L(int n) {
        return n == 0 ? "red" : (n == 1 ? "green" : "blue");
    }

    @Override
    protected Fits createLeaveHpx(ThreadBuilderTile threadBuilderTile, String string, String string2, int n, long l, int n2) throws Exception {
        Fits fits;
        long l2 = System.currentTimeMillis();
        Fits[] fitsArray = this.getLeaves(n, l);
        Fits fits2 = fits = fitsArray == null ? null : this.createLeaveRGB(fitsArray);
        if (fits == null) {
            long l3 = System.currentTimeMillis() - l2;
            this.updateStat(0, 0, 1, l3, 0, 0L);
            return null;
        }
        this.write(string, fits);
        long l4 = System.currentTimeMillis() - l2;
        this.updateStat(0, 1, 0, l4, 0, 0L);
        this.updateStat();
        return fits;
    }

    private Fits createLeaveRGB(Fits[] fitsArray) throws Exception {
        if (this.flagGauss) {
            for (int i = 0; i < 3; ++i) {
                this.gaussian(fitsArray[i]);
            }
        }
        double d = 0.0;
        double d2 = 256.0;
        if (Fits.isTransparent(this.format == 0 ? 4 : 3)) {
            d2 = 255.0;
            d = 1.0;
        }
        Fits fits = new Fits(this.width, this.width, 0);
        double[] dArray = new double[3];
        int n = 0;
        for (int i = 0; i < this.width; ++i) {
            int n2 = 0;
            while (n2 < this.width) {
                int n3;
                double d3 = 0.0;
                for (n3 = 0; n3 < 3; ++n3) {
                    if (n3 == this.missing || fitsArray[n3] == null) continue;
                    double d4 = fitsArray[n3].getPixelDouble(n2, i);
                    if (fitsArray[n3].isBlankPixel(d4)) {
                        dArray[n3] = 0.0;
                        continue;
                    }
                    dArray[n3] = d + (d4 < this.pixelMin[n3] ? 0.0 : (d4 > this.pixelMax[n3] ? d2 - d - 1.0 : d2 * ((d4 - this.pixelMin[n3]) / (this.pixelMax[n3] - this.pixelMin[n3]))));
                    d3 += dArray[n3];
                }
                if (this.missing != -1) {
                    dArray[this.missing] = d3 / 2.0;
                }
                double[] dArray2 = new double[3];
                if (d3 == 0.0) {
                    n3 = 0;
                } else {
                    n3 = 255;
                    for (int j = 0; j < 3; ++j) {
                        int n4 = (int)Math.floor(dArray[j]);
                        if (this.tcm[j] == null) {
                            dArray2[j] = n4;
                        } else if (n4 >= 255) {
                            dArray2[j] = this.tcm[j][255];
                        } else if ((double)n4 <= d) {
                            dArray2[j] = this.tcm[j][(int)d];
                        } else {
                            double d5 = dArray[j] - (double)n4;
                            if (d5 == 0.0) {
                                dArray2[j] = this.tcm[j][n4] & 0xFF;
                            } else {
                                double d6 = 1.0 - d5;
                                double d7 = this.tcm[j][n4] & 0xFF;
                                double d8 = this.tcm[j][n4 + 1] & 0xFF;
                                dArray2[j] = (int)Math.round(d7 * d6 + d8 * d5);
                            }
                        }
                        n3 = n3 << 8 | (int)dArray2[j] & 0xFF;
                    }
                }
                fits.rgb[n] = n3;
                ++n2;
                ++n;
            }
        }
        return fits;
    }

    private void gaussian(Fits fits) {
        int n;
        int n2;
        if (fits == null) {
            return;
        }
        double[] dArray = new double[fits.width * fits.height];
        int n3 = 0;
        for (n2 = 0; n2 < fits.height; ++n2) {
            for (n = 0; n < fits.width; ++n) {
                dArray[n3++] = fits.getPixelDouble(n, n2);
            }
        }
        double[] dArray2 = new double[dArray.length];
        this.convolveAndTranspose(kernel, dArray, dArray2, fits.width, fits.height);
        this.convolveAndTranspose(kernel, dArray2, dArray, fits.height, fits.width);
        n3 = 0;
        for (n2 = 0; n2 < fits.height; ++n2) {
            for (n = 0; n < this.width; ++n) {
                fits.setPixelDouble(n, n2, dArray[n3++]);
            }
        }
    }

    protected void convolveAndTranspose(double[] dArray, double[] dArray2, double[] dArray3, int n, int n2) {
        int n3 = dArray.length;
        int n4 = n3 / 2;
        for (int i = 0; i < n2; ++i) {
            int n5 = i;
            int n6 = i * n;
            for (int j = 0; j < n; ++j) {
                double d = 0.0;
                for (int k = -n4; k <= n4; ++k) {
                    int n7 = j + k;
                    if (n7 < 0) {
                        n7 = 0;
                    } else if (n7 >= n) {
                        n7 = n - 1;
                    }
                    d += dArray2[n6 + n7] * dArray[k + n4];
                }
                dArray3[n5] = d;
                n5 += n2;
            }
        }
    }

    private Fits[] getLeaves(int n, long l) throws Exception {
        if (this.context.isTaskAborting()) {
            new Exception("Task abort !");
        }
        Fits[] fitsArray = null;
        fitsArray = new Fits[3];
        for (int i = 0; i < 3; ++i) {
            if (i == this.missing) continue;
            if (!this.moc[i].isIntersecting(n, l)) {
                fitsArray[i] = null;
            } else {
                try {
                    fitsArray[i] = this.createSubLeaveRGB(n, l, i);
                }
                catch (Exception exception) {
                    fitsArray[i] = null;
                }
            }
            if (fitsArray[i] == null || this.bitpix[i] != 0) continue;
            this.bitpix[i] = fitsArray[i].bitpix;
            this.blank[i] = fitsArray[i].blank;
            this.bscale[i] = fitsArray[i].bscale;
            this.bzero[i] = fitsArray[i].bzero;
            if (this.width != -1) continue;
            this.width = fitsArray[i].width;
        }
        if (fitsArray[0] == null && fitsArray[1] == null && fitsArray[2] == null) {
            fitsArray = null;
        }
        return fitsArray;
    }

    private Fits createSubLeaveRGB(int n, long l, int n2) throws Exception {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = n;
        String string = null;
        long l2 = l;
        n8 = n;
        while (n8 >= 3 && !new File(string = Util.getFilePath(this.inputs[n2], n8, l2) + ".fits").exists()) {
            --n8;
            l2 /= 4L;
        }
        if (n8 < 3) {
            return null;
        }
        Fits fits = new Fits();
        fits.loadFITS(string);
        if (n8 == n) {
            return fits;
        }
        int n9 = 0;
        int n10 = fits.height - 1;
        int n11 = fits.width;
        for (n7 = n; n7 > n8; --n7) {
            n11 /= 2;
        }
        n7 = 1;
        int n12 = n11;
        int n13 = n;
        while (n13 > n8) {
            n7 *= 2;
            int n14 = (int)(l % 4L);
            n6 = n14 == 2 || n14 == 3 ? n12 : 0;
            n5 = n14 == 1 || n14 == 3 ? n12 : 0;
            n9 += n6;
            n10 -= n5;
            --n13;
            l /= 4L;
            n12 *= 2;
        }
        n13 = Math.abs(fits.bitpix) / 8;
        byte[] byArray = new byte[n11 * n11 * n13];
        for (n6 = n11 - 1; n6 >= 0; --n6) {
            for (n5 = 0; n5 < n11; ++n5) {
                n4 = ((n10 - (n11 - n6 - 1)) * fits.width + (n9 + n5)) * n13;
                n3 = (n6 * n11 + n5) * n13;
                System.arraycopy(fits.pixels, n4, byArray, n3, n13);
            }
        }
        for (n6 = n11 - 1; n6 >= 0; --n6) {
            for (n5 = 0; n5 < n11; ++n5) {
                n4 = (n6 * n11 + n5) * n13;
                for (n3 = 0; n3 < n7; ++n3) {
                    for (int i = 0; i < n7; ++i) {
                        int n15 = ((n6 * n7 + n3) * fits.width + (n5 * n7 + i)) * n13;
                        System.arraycopy(byArray, n4, fits.pixels, n15, n13);
                    }
                }
            }
        }
        return fits;
    }
}

