/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.Aladin;
import cds.aladin.MyInputStream;
import cds.allsky.Action;
import cds.allsky.Builder;
import cds.allsky.BuilderAllsky;
import cds.allsky.BuilderMoc;
import cds.allsky.Constante;
import cds.allsky.Context;
import cds.allsky.ContextGui;
import cds.allsky.Mode;
import cds.allsky.ThreadBuilderTile;
import cds.fits.CacheFits;
import cds.fits.Fits;
import cds.moc.HealpixMoc;
import cds.tools.pixtools.Util;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;

public class BuilderTiles
extends Builder {
    private boolean isColor;
    protected int bitpix;
    protected double bzero;
    protected double bscale;
    protected double blank;
    private Context.JpegMethod method;
    protected ArrayList<ThreadBuilder> threadList = new ArrayList();
    private Mode coaddMode = Mode.REPLACETILE;
    protected int ordermin = 3;
    protected int ordermax;
    protected long nummin = 0L;
    protected long nummax = 0L;
    protected LinkedList<Item> fifo;
    protected double automin = 0.0;
    protected double automax = 0.0;
    public static boolean DEBUG = true;
    public static String FS = System.getProperty("file.separator");
    private boolean stopped = false;
    protected int statNbThreadRunning = -1;
    protected int statNbThread;
    protected int statNbTile;
    protected long statMinTime;
    protected long statMaxTime;
    protected long statTotalTime;
    protected long statAvgTime;
    protected int statEmptyTile;
    protected int statNodeTile;
    protected long statNodeTotalTime;
    protected long statNodeAvgTime;
    protected long startTime;
    protected long totalTime;
    long lastTime = 0L;
    long lastNbTile = 0L;
    Hashtable<Thread, ArrayList<Fits>> memPerThread;
    private static final Object objItem = new Object();
    static final String[] MODE = new String[]{"START", "WAIT", "EXEC", "DIED"};
    private Object lockObj = new Object();

    public BuilderTiles(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.TILES;
    }

    @Override
    public void run() throws Exception {
        this.context.info("Creating " + this.context.getTileExt() + " tiles and allsky (max depth=" + this.context.getOrder() + ")...");
        this.context.info("sky area to process: " + this.context.getNbLowCells() + " low level HEALPix cells");
        if (!this.context.isColor()) {
            int n;
            int n2 = this.context.getBitpixOrig();
            if (n2 != (n = this.context.getBitpix())) {
                this.context.info("BITPIX conversion from " + this.context.getBitpixOrig() + " to " + this.context.getBitpix());
                double[] dArray = this.context.getCutOrig();
                double[] dArray2 = this.context.getCut();
                this.context.info("Map original raw pixel range [" + dArray[2] + " .. " + dArray[3] + "] to [" + dArray2[2] + " .. " + dArray2[3] + "]");
            } else {
                this.context.info("BITPIX = " + n + " (no conversion)");
            }
            if (this.context.getDiskMem() != -1L) {
                this.context.info("Disk requirement (upper approximation) : " + cds.tools.Util.getUnitDisk((long)((double)this.context.getDiskMem() * 1.25)));
            }
            double d = this.context.getBScale();
            double d2 = this.context.getBZero();
            if (d != 1.0 || d2 != 0.0) {
                this.context.info("BSCALE=" + d + " BZERO=" + d2);
            }
            double d3 = this.context.getBlankOrig();
            double d4 = this.context.getBlank();
            if (this.context.hasAlternateBlank()) {
                this.context.info("BLANK conversion from " + (Double.isNaN(d3) ? "NaN" : Double.valueOf(d3)) + " to " + (Double.isNaN(d4) ? "NaN" : Double.valueOf(d4)));
            } else {
                this.context.info("BLANK=" + (Double.isNaN(d4) ? "NaN" : Double.valueOf(d4)));
            }
            if (this.context.good != null) {
                this.context.info("Good pixel values [" + this.ip(this.context.good[0], d2, d) + " .. " + this.ip(this.context.good[1], d2, d) + "] => other values are ignored");
            }
            this.context.info("Tile aggregation method=" + (Object)((Object)Context.JpegMethod.MEAN));
            if (this.context.live) {
                this.context.info("Live HiPS => Weight tiles saved for potential future additions");
            }
        }
        this.build();
        if (!this.context.isColor()) {
            if (this.context.bitpix != -1) {
                this.context.setPropriete("hips_pixel_bitpix", this.context.bitpix + "");
            }
            if (this.context.bitpixOrig != -1) {
                this.context.setPropriete("data_pixel_bitpix", this.context.bitpixOrig + "");
            }
            this.context.setPropriete("hips_sampling", this.context.isMap() ? "none" : "bilinear");
            if (this.context.skyvalName != null) {
                this.context.setPropriete("hips_skyval_method", this.context.skyvalName);
                StringBuilder stringBuilder = null;
                double[] dArray = this.context.getCutOrig();
                for (int i = 0; i < 4; ++i) {
                    double d = dArray[i];
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder("" + d);
                        continue;
                    }
                    stringBuilder.append(" " + d);
                }
                this.context.setPropriete("hips_skyval_value", stringBuilder.toString());
            }
        }
        this.context.setPropriete("hips_overlay", this.context.isMap() ? "none" : (this.context.mode == Mode.ADD ? "add" : (this.context.fading ? "border_fading" : (this.context.mixing ? "mean" : "first"))));
        this.context.setPropriete("hips_hierarchy", this.context.getJpegMethod().toString().toLowerCase());
        if (!this.context.isTaskAborting()) {
            new BuilderAllsky(this.context).run();
            this.context.info("ALLSKY file done");
        }
        if (!this.context.isTaskAborting()) {
            this.b = new BuilderMoc(this.context);
            this.b.run();
            this.b = null;
        }
    }

    @Override
    public void validateContext() throws Exception {
        Object object;
        if (this.context instanceof ContextGui) {
            this.context.setProgressBar(((ContextGui)this.context).mainPanel.getProgressBarTile());
        }
        this.validateInput();
        this.validateOutput();
        try {
            this.validateOrder(this.context.getHpxFinderPath());
        }
        catch (Exception exception) {
            if (Aladin.levelTrace >= 3) {
                exception.printStackTrace();
            }
            this.context.warning(exception.getMessage());
            this.validateOrder(this.context.getOutputPath());
        }
        String string = this.context.getImgEtalon();
        if (string == null) {
            string = this.context.justFindImgEtalon(this.context.getInputPath());
        }
        double[] dArray = this.context.getCutOrig();
        boolean bl = this.context.hasAlternateBlank();
        double d = this.context.getBlankOrig();
        int n = this.context.getBitpixOrig();
        if (string == null) {
            throw new Exception("No source image found in " + this.context.getInputPath());
        }
        this.context.info("Reference image: " + string);
        try {
            this.context.setImgEtalon(string);
        }
        catch (Exception exception) {
            this.context.warning("Reference image problem [" + string + "] => " + exception.getMessage());
        }
        if (!this.context.isColor()) {
            if (n == -1) {
                this.context.info("BITPIX found in the reference image => " + this.context.getBitpixOrig());
            } else if (n != this.context.getBitpixOrig()) {
                this.context.warning("The provided BITPIX (" + n + ") is different than the original one (" + this.context.getBitpixOrig() + ") => bitpix conversion will be applied");
                this.context.setBitpixOrig(n);
            }
            if (this.context.depth > 1) {
                this.context.info("Original images are cubes (depth=" + this.context.depth + ")");
            }
            if ((object = (Object)this.context.getPixelRangeCut()) != null) {
                dArray = new double[4];
                for (int i = 0; i < 4; ++i) {
                    if (Double.isNaN((double)object[i])) continue;
                    dArray[i] = (double)((object[i] - this.context.bZeroOrig) / this.context.bScaleOrig);
                }
            }
            double[] dArray2 = this.context.getCutOrig();
            double d2 = this.context.bScaleOrig;
            double d3 = this.context.bZeroOrig;
            if (dArray != null) {
                if (dArray[0] != 0.0 || dArray[1] != 0.0) {
                    dArray2[0] = dArray[0];
                    dArray2[1] = dArray[1];
                }
                if (dArray[2] != 0.0 || dArray[3] != 0.0) {
                    dArray2[2] = dArray[2];
                    dArray2[3] = dArray[3];
                }
                this.context.setCutOrig(dArray2);
            }
            if (dArray2[0] == dArray2[1]) {
                this.context.warning("BAD PIXEL CUT: [" + this.ip(dArray2[0], d3, d2) + " .. " + this.ip(dArray2[1], d3, d2) + "] => YOU WILL HAVE TO CHANGE/EDIT THE properties FILE VALUES");
            }
            this.context.setValidateCut(true);
            if (bl) {
                this.context.setBlankOrig(d);
            }
            this.context.initParameters();
            this.context.info("Data range [" + this.ip(dArray2[2], d3, d2) + " .. " + this.ip(dArray2[3], d3, d2) + "], pixel cut [" + this.ip(dArray2[0], d3, d2) + " .. " + this.ip(dArray2[1], d3, d2) + "]");
        } else {
            this.context.initParameters();
        }
        if (!this.context.verifCoherence()) {
            throw new Exception("Uncompatible pre-existing HEALPix survey");
        }
        if (!this.context.isColor() && this.context.getBScale() == 0.0) {
            throw new Exception("Big bug => BSCALE=0 !! please contact CDS");
        }
        object = this.context.getMode();
        if (!this.context.isColor() || object == Mode.KEEPTILE || object == Mode.REPLACETILE) {
            this.context.info("mode=" + Mode.getExplanation(object));
        }
    }

    @Override
    public void showStatistics() {
        if (this.b != null) {
            this.b.showStatistics();
            return;
        }
        if (this.statNbThreadRunning == 0 || this.statNbTile == 0) {
            return;
        }
        long l = System.currentTimeMillis();
        this.totalTime = l - this.startTime;
        long l2 = l - this.lastTime;
        long l3 = (long)this.statNbTile - this.lastNbTile;
        this.lastTime = l;
        this.lastNbTile = this.statNbTile;
        this.context.showTilesStat(this.statNbThreadRunning, this.statNbThread, this.totalTime, this.statNbTile, this.statEmptyTile, this.statNodeTile, this.statMinTime, this.statMaxTime, this.statAvgTime, this.statNodeAvgTime, this.getUsedMem(), l2, l3);
    }

    private void initStat(int n) {
        this.statNbThread = n;
        this.statNbThreadRunning = 0;
        this.statNodeTile = 0;
        this.statNbTile = 0;
        this.statNodeTotalTime = 0L;
        this.statTotalTime = 0L;
        this.startTime = System.currentTimeMillis();
        this.totalTime = 0L;
        this.memPerThread = new Hashtable();
    }

    private void rmThread(Thread thread) {
        Long l = new Long(thread.hashCode());
        ArrayList<Fits> arrayList = this.memPerThread.get(l);
        if (arrayList != null) {
            for (Fits fits : arrayList) {
                fits.free();
            }
        }
        this.memPerThread.remove(l);
    }

    protected void addFits(Thread thread, Fits fits) {
        ArrayList<Fits> arrayList;
        if (fits == null) {
            return;
        }
        if (fits.width == 0) {
            try {
                throw new Exception();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if ((arrayList = this.memPerThread.get(thread)) == null) {
            arrayList = new ArrayList();
            this.memPerThread.put(thread, arrayList);
        }
        arrayList.add(fits);
    }

    protected void rmFits(Thread thread, Fits fits) {
        ArrayList<Fits> arrayList = this.memPerThread.get(thread);
        if (arrayList == null) {
            return;
        }
        arrayList.remove(fits);
    }

    protected long releaseBitmap() {
        long l = 0L;
        try {
            for (Thread thread : this.memPerThread.keySet()) {
                ArrayList<Fits> arrayList = this.memPerThread.get(thread);
                for (Fits fits : arrayList) {
                    if (!fits.isReleasable()) continue;
                    l += fits.releaseBitmap();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l;
    }

    private long getUsedMem() {
        long l = 0L;
        try {
            for (Thread thread : this.memPerThread.keySet()) {
                ArrayList<Fits> arrayList = this.memPerThread.get(thread);
                l += this.getUsedMem(arrayList);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l;
    }

    private String showMem() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Thread thread : this.memPerThread.keySet()) {
            ArrayList<Fits> arrayList = this.memPerThread.get(thread);
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(thread.getName() + ":" + arrayList.size() + "tiles/" + cds.tools.Util.getUnitDisk(this.getUsedMem(arrayList)));
        }
        return stringBuffer.toString();
    }

    private long getUsedMem(ArrayList<Fits> arrayList) {
        if (arrayList == null) {
            return 0L;
        }
        long l = 0L;
        try {
            for (Fits fits : arrayList) {
                l += fits.getMem();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l;
    }

    protected void updateStat(int n, int n2, int n3, long l, int n4, long l2) {
        this.statNbThreadRunning += n;
        this.statNbTile += n2;
        this.statNodeTile += n4;
        this.statEmptyTile += n3;
        if (l > 0L) {
            if (this.statNbTile == 1 || l < this.statMinTime) {
                this.statMinTime = l;
            }
            if (this.statNbTile == 1 || l > this.statMaxTime) {
                this.statMaxTime = l;
            }
            if (n2 == 1) {
                this.statTotalTime += l;
                this.statAvgTime = this.statTotalTime / (long)this.statNbTile;
            }
        }
        if (l2 > 0L && n4 == 1) {
            this.statNodeTotalTime += l2;
            this.statNodeAvgTime = this.statNodeTotalTime / (long)this.statNodeTile;
        }
    }

    protected int getBitpix0() {
        return this.context.getBitpix();
    }

    protected void build() throws Exception {
        this.ordermax = this.context.getOrder();
        long l = System.currentTimeMillis();
        HealpixMoc healpixMoc = new HealpixMoc();
        HealpixMoc healpixMoc2 = this.context.getRegion();
        if (healpixMoc2 == null) {
            healpixMoc2 = new HealpixMoc("0/1-11");
        }
        healpixMoc.add(healpixMoc2);
        healpixMoc.setMocOrder(3);
        int n = this.context.getDepth();
        this.fifo = new LinkedList();
        Iterator<Long> iterator = healpixMoc.pixelIterator();
        while (iterator.hasNext()) {
            long l2 = iterator.next();
            for (int i = 0; i < n; ++i) {
                this.fifo.add(new Item(3, l2, i, null));
            }
        }
        this.isColor = this.context.isColor();
        this.bitpix = this.getBitpix0();
        this.coaddMode = this.context.getMode();
        this.method = this.context.getJpegMethod();
        if (!this.isColor) {
            this.bzero = this.context.getBZero();
            this.bscale = this.context.getBScale();
            this.blank = this.context.getBlank();
        }
        int n2 = Runtime.getRuntime().availableProcessors();
        long l3 = this.context.getMem();
        long l4 = 0x400000L * (long)this.context.getNpixOrig();
        long l5 = this.context.getTileSide() * this.context.getTileSide() * this.context.getNpix();
        long l6 = 4L * l5 + l4;
        if (this.isColor) {
            l6 += l5 * (long)(this.ordermax - this.ordermin);
        }
        int n3 = (int)(l3 / l6);
        int n4 = this.context.getMaxNbThread();
        if (n4 > 0 && n3 > n4) {
            n3 = n4;
        }
        if (n3 == 0) {
            n3 = 1;
        }
        if (n3 > n2) {
            n3 = n2;
        }
        Aladin.trace(4, "BuildController.build(): Found " + n2 + " processor(s) for " + l3 / 0x100000L + "MB RAM => Launch " + n3 + " thread(s)");
        this.context.info("Will use " + n3 + " thread" + (n3 > 1 ? "s" : ""));
        this.activateCache(l3, 2L * l3 / 3L);
        this.launchThreadBuilderHpx(n3);
        while (!(this.stopped || this.allWaiting() && this.fifo.isEmpty())) {
            cds.tools.Util.pause(1000);
        }
        this.destroyThreadBuilderHpx();
        if (this.stopped) {
            return;
        }
        if (!this.context.isTaskAborting()) {
            if (ThreadBuilderTile.statMaxOverlays > 0) {
                this.context.info("Tile overlay stats : max overlays=" + ThreadBuilderTile.statMaxOverlays + ", " + ThreadBuilderTile.statOnePass + " in one step, " + ThreadBuilderTile.statMultiPass + " in multi steps");
            }
            if (this.context.cacheFits != null) {
                Aladin.trace(3, "Cache FITS status: " + this.context.cacheFits);
            }
            Aladin.trace(3, "Healpix survey build in " + cds.tools.Util.getTemps(System.currentTimeMillis() - l));
        }
        if (this.context.cacheFits != null) {
            this.context.cacheFits.reset();
        }
    }

    protected void activateCache(long l, long l2) {
        this.context.setCache(new CacheFits(l2));
        this.context.info("Available RAM: " + cds.tools.Util.getUnitDisk(l) + " => Cache size: " + cds.tools.Util.getUnitDisk(l2));
    }

    private Fits createHpx(ThreadBuilderTile threadBuilderTile, String string, int n, long l, int n2) throws Exception {
        Fits fits;
        String string2 = Util.getFilePath(string, n, l, n2);
        if (this.stopped) {
            return null;
        }
        if (!this.context.isInMocTree(n, l)) {
            return this.findLeaf(string2);
        }
        if (this.coaddMode == Mode.KEEPTILE && (fits = this.findLeaf(string2)) != null) {
            HealpixMoc healpixMoc = this.context.getRegion();
            healpixMoc = healpixMoc.intersection(new HealpixMoc(n + "/" + l));
            int n3 = (int)healpixMoc.getUsedArea();
            this.updateStat(0, 0, n3, 0L, n3 / 4, 0L);
            return fits;
        }
        fits = null;
        if (n == this.ordermax) {
            try {
                fits = this.createLeaveHpx(threadBuilderTile, string2, string, n, l, n2);
            }
            catch (Exception exception) {
                System.err.println("BuilderTiles.createLeave error: " + string2);
                exception.printStackTrace();
                return null;
            }
        }
        Fits[] fitsArray = new Fits[4];
        if (this.fifo.isEmpty() && this.oneWaiting()) {
            this.multiThreadCreateHpx(threadBuilderTile, fitsArray, string, n, l, n2);
        } else {
            for (int i = 0; !this.stopped && i < 4; ++i) {
                if (this.context.isTaskAborting()) {
                    throw new Exception("Task abort !");
                }
                fitsArray[i] = this.createHpx(threadBuilderTile, string, n + 1, l * 4L + (long)i, n2);
            }
        }
        try {
            fits = this.createNodeHpx(string2, string, n, l, fitsArray, n2);
        }
        catch (Exception exception) {
            System.err.println("BuilderTiles.createNodeHpx error: " + string2);
            exception.printStackTrace();
            return null;
        }
        return fits;
    }

    private void multiThreadCreateHpx(ThreadBuilderTile threadBuilderTile, Fits[] fitsArray, String string, int n, long l, int n2) throws Exception {
        int n3;
        Item[] itemArray = new Item[3];
        for (n3 = 0; n3 < 3; ++n3) {
            itemArray[n3] = this.addNpix(n + 1, l * 4L + (long)n3, n2, Thread.currentThread());
        }
        this.wakeUp();
        fitsArray[3] = this.createHpx(threadBuilderTile, string, n + 1, l * 4L + 3L, n2);
        while (!(itemArray[0].isReady() && itemArray[1].isReady() && itemArray[2].isReady())) {
            try {
                Thread.currentThread();
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
        }
        for (n3 = 0; n3 < 3; ++n3) {
            fitsArray[n3] = itemArray[n3].getFits();
        }
    }

    protected void setProgressBar(int n) {
        this.context.setProgressLastNorder3(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Item getNextNpix() {
        Item item = null;
        Object object = this.lockObj;
        synchronized (object) {
            if (this.fifo.isEmpty()) {
                return null;
            }
            item = this.fifo.removeFirst();
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Item addNpix(int n, long l, int n2, Thread thread) {
        Item item = new Item(n, l, n2, thread);
        Object object = this.lockObj;
        synchronized (object) {
            this.fifo.add(item);
        }
        return item;
    }

    private void launchThreadBuilderHpx(int n) throws Exception {
        this.initStat(n);
        this.context.createHealpixOrder(this.context.getTileOrder());
        ThreadBuilderTile.nbThreadRunning = n;
        ThreadBuilderTile.hashPolygon = new HashMap();
        for (int i = 0; i < n; ++i) {
            if (this.context.isTaskAborting()) {
                throw new Exception("Task abort !");
            }
            ThreadBuilderTile threadBuilderTile = new ThreadBuilderTile(this.context, this);
            ThreadBuilder threadBuilder = new ThreadBuilder("Builder" + i, threadBuilderTile);
            this.threadList.add(threadBuilder);
            threadBuilder.start();
        }
    }

    void destroyThreadBuilderHpx() {
        for (ThreadBuilder threadBuilder : this.threadList) {
            threadBuilder.tue();
        }
    }

    int nbThreadRunning() {
        int n = 0;
        Iterator<ThreadBuilder> iterator = this.threadList.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().isExec()) continue;
            ++n;
        }
        return n;
    }

    boolean stillAlive() {
        Iterator<ThreadBuilder> iterator = this.threadList.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().isDied()) continue;
            return true;
        }
        return false;
    }

    boolean allWaiting() {
        Iterator<ThreadBuilder> iterator = this.threadList.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().isWait()) continue;
            return false;
        }
        return true;
    }

    boolean oneWaiting() {
        try {
            Iterator<ThreadBuilder> iterator = this.threadList.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().isWait()) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    void wakeUp() {
        try {
            for (ThreadBuilder threadBuilder : this.threadList) {
                if (!threadBuilder.isWait()) continue;
                threadBuilder.interrupt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Fits createNodeHpx(String string, String string2, int n, long l, Fits[] fitsArray, int n2) throws Exception {
        Fits fits;
        int n3;
        long l2 = System.currentTimeMillis();
        int n4 = this.context.getTileSide();
        double[] dArray = new double[4];
        boolean bl = this.context.isInMocTree(n, l);
        if (!bl || fitsArray[0] == null && fitsArray[1] == null && fitsArray[2] == null && fitsArray[3] == null) {
            if (this.isColor) {
                return null;
            }
            Fits fits2 = this.findLeaf(string);
            this.addFits(Thread.currentThread(), fits2);
            return fits2;
        }
        for (Fits fits3 : fitsArray) {
            if (fits3 == null) continue;
            fits3.reloadBitmap();
        }
        Fits fits4 = new Fits(n4, n4, this.bitpix);
        if (!this.isColor) {
            fits4.setBlank(this.blank);
            fits4.setBzero(this.bzero);
            fits4.setBscale(this.bscale);
        }
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                n3 = i << 1 | j;
                int n5 = i * n4 >>> 1;
                int n6 = (1 - j) * n4 >>> 1;
                Fits fits5 = fitsArray[n3];
                for (int k = 0; k < n4; k += 2) {
                    for (int i2 = 0; i2 < n4; i2 += 2) {
                        int n7;
                        int n8;
                        int n9;
                        int n10;
                        if (this.isColor) {
                            int n11 = 0;
                            if (fits5 != null) {
                                int n12;
                                int n13;
                                int n14;
                                int n15;
                                if (this.method == Context.JpegMethod.MEAN) {
                                    int n16 = 0;
                                    n10 = 0;
                                    n9 = 0;
                                    n8 = 0;
                                    for (n7 = 0; n7 < 4; ++n7) {
                                        n15 = n7 == 1 || n7 == 3 ? 1 : 0;
                                        n13 = fits5.getPixelRGBJPG(i2 + n15, k + (n14 = n7 > 1 ? 1 : 0));
                                        n12 = n13 >> 24 & 0xFF;
                                        if (n12 == 0) continue;
                                        ++n8;
                                        n16 += n13 >> 16 & 0xFF;
                                        n10 += n13 >> 8 & 0xFF;
                                        n9 += n13 & 0xFF;
                                    }
                                    if (n8 != 0) {
                                        n11 = 0xFF000000 | n16 / n8 << 16 | n10 / n8 << 8 | n9 / n8;
                                    }
                                } else if (this.method == Context.JpegMethod.MEDIAN) {
                                    int[] nArray = new int[4];
                                    int[] nArray2 = new int[4];
                                    int[] nArray3 = new int[4];
                                    n8 = 0;
                                    for (n7 = 0; n7 < 4; ++n7) {
                                        n15 = n7 == 1 || n7 == 3 ? 1 : 0;
                                        n13 = fits5.getPixelRGBJPG(i2 + n15, k + (n14 = n7 > 1 ? 1 : 0));
                                        n12 = n13 >> 24 & 0xFF;
                                        if (n12 == 0) continue;
                                        ++n8;
                                        nArray[n7] = n13 >> 16 & 0xFF;
                                        nArray2[n7] = n13 >> 8 & 0xFF;
                                        nArray3[n7] = n13 & 0xFF;
                                    }
                                    if (n8 != 0) {
                                        n7 = nArray[0] > nArray[1] && (nArray[0] < nArray[2] || nArray[0] < nArray[3]) || nArray[0] < nArray[1] && (nArray[0] > nArray[2] || nArray[0] > nArray[3]) ? nArray[0] : (nArray[1] > nArray[0] && (nArray[1] < nArray[2] || nArray[1] < nArray[3]) || nArray[1] < nArray[0] && (nArray[1] > nArray[2] || nArray[1] > nArray[3]) ? nArray[1] : (nArray[2] > nArray[0] && (nArray[2] < nArray[1] || nArray[2] < nArray[3]) || nArray[2] < nArray[0] && (nArray[2] > nArray[1] || nArray[2] > nArray[3]) ? nArray[2] : nArray[3]));
                                        n14 = nArray2[0] > nArray2[1] && (nArray2[0] < nArray2[2] || nArray2[0] < nArray2[3]) || nArray2[0] < nArray2[1] && (nArray2[0] > nArray2[2] || nArray2[0] > nArray2[3]) ? nArray2[0] : (nArray2[1] > nArray2[0] && (nArray2[1] < nArray2[2] || nArray2[1] < nArray2[3]) || nArray2[1] < nArray2[0] && (nArray2[1] > nArray2[2] || nArray2[1] > nArray2[3]) ? nArray2[1] : (nArray2[2] > nArray2[0] && (nArray2[2] < nArray2[1] || nArray2[2] < nArray2[3]) || nArray2[2] < nArray2[0] && (nArray2[2] > nArray2[1] || nArray2[2] > nArray2[3]) ? nArray2[2] : nArray2[3]));
                                        n15 = nArray3[0] > nArray3[1] && (nArray3[0] < nArray3[2] || nArray3[0] < nArray3[3]) || nArray3[0] < nArray3[1] && (nArray3[0] > nArray3[2] || nArray3[0] > nArray3[3]) ? nArray3[0] : (nArray3[1] > nArray3[0] && (nArray3[1] < nArray3[2] || nArray3[1] < nArray3[3]) || nArray3[1] < nArray3[0] && (nArray3[1] > nArray3[2] || nArray3[1] > nArray3[3]) ? nArray3[1] : (nArray3[2] > nArray3[0] && (nArray3[2] < nArray3[1] || nArray3[2] < nArray3[3]) || nArray3[2] < nArray3[0] && (nArray3[2] > nArray3[1] || nArray3[2] > nArray3[3]) ? nArray3[2] : nArray3[3]));
                                        n11 = 0xFF000000 | n7 << 16 | n14 << 8 | n15;
                                    }
                                } else {
                                    n11 = fits5.getPixelRGBJPG(i2, k);
                                }
                            }
                            fits4.setPixelRGBJPG(n5 + (i2 >>> 1), n6 + (k >>> 1), n11);
                            continue;
                        }
                        double d = this.blank;
                        n10 = 0;
                        if (fits5 != null) {
                            for (n9 = 0; n9 < 4; ++n9) {
                                n8 = n9 == 1 || n9 == 3 ? 1 : 0;
                                n7 = n9 > 1 ? 1 : 0;
                                dArray[n9] = fits5.getPixelDouble(i2 + n8, k + n7);
                                if (fits5.isBlankPixel(dArray[n9])) continue;
                                ++n10;
                            }
                            if (n10 == 0) {
                                d = this.blank;
                            } else {
                                d = 0.0;
                                for (n9 = 0; n9 < 4; ++n9) {
                                    if (fits5.isBlankPixel(dArray[n9])) continue;
                                    d += dArray[n9] / (double)n10;
                                }
                            }
                        }
                        fits4.setPixelDouble(n5 + (i2 >>> 1), n6 + (k >>> 1), d);
                    }
                }
            }
        }
        if (!this.isColor && this.coaddMode != Mode.REPLACETILE && this.coaddMode != Mode.KEEPTILE && (fits = this.findLeaf(string)) != null) {
            fits4.mergeOnNaN(fits);
        }
        this.context.updateHeader(fits4, n, l);
        this.write(string, fits4);
        long l3 = System.currentTimeMillis() - l2;
        if (l % 10L == 0L || DEBUG) {
            Aladin.trace(4, Thread.currentThread().getName() + ".createNodeHpx(" + n + "/" + l + ") " + (Object)((Object)this.coaddMode) + " in " + l3 + "ms");
        }
        this.updateStat(0, 0, 0, 0L, 1, l3);
        for (n3 = 0; n3 < 4; ++n3) {
            if (fitsArray[n3] == null) continue;
            this.rmFits(Thread.currentThread(), fitsArray[n3]);
            fitsArray[n3].free();
            fitsArray[n3] = null;
        }
        this.addFits(Thread.currentThread(), fits4);
        return fits4;
    }

    protected void write(String string, Fits fits) throws Exception {
        String string2 = string + this.context.getTileExt();
        if (this.isColor) {
            fits.writeCompressed(string2, 0.0, 0.0, null, Constante.TILE_MODE[this.context.targetColorMode]);
        } else {
            fits.writeFITS(string2);
        }
    }

    protected Fits createLeaveHpx(ThreadBuilderTile threadBuilderTile, String string, String string2, int n, long l, int n2) throws Exception {
        long l2 = System.currentTimeMillis();
        Fits fits = null;
        boolean bl = this.context.isInMoc(n, l);
        if (!(bl || this.coaddMode == Mode.REPLACETILE || (fits = this.findLeaf(string)) == null && this.context.isMocDescendant(n, l))) {
            this.addFits(Thread.currentThread(), fits);
            return fits;
        }
        Fits fits2 = threadBuilderTile.buildHealpix(this, string2, n, l, n2);
        if (fits2 != null && this.coaddMode != Mode.REPLACETILE) {
            if (fits == null) {
                fits = this.findLeaf(string);
            }
            if (fits != null && this.coaddMode == Mode.KEEPTILE) {
                fits2 = null;
                this.addFits(Thread.currentThread(), fits);
                return fits;
            }
            if (fits != null) {
                if (fits.bitpix > 0 && Double.isNaN(fits.blank)) {
                    fits.setBlank(this.blank);
                }
                if (this.coaddMode == Mode.AVERAGE) {
                    fits2.coadd(fits, true);
                } else if (this.coaddMode == Mode.ADD) {
                    fits2.coadd(fits, false);
                } else if (this.coaddMode == Mode.OVERWRITE) {
                    fits2.mergeOnNaN(fits);
                } else if (this.coaddMode == Mode.KEEP) {
                    fits.mergeOnNaN(fits2);
                    fits2 = fits;
                    fits = null;
                }
            }
        }
        if (fits2 != null) {
            this.context.updateHeader(fits2, n, l);
            this.write(string, fits2);
            long l3 = System.currentTimeMillis() - l2;
            this.updateStat(0, 1, 0, l3, 0, 0L);
        } else {
            long l4 = System.currentTimeMillis() - l2;
            this.updateStat(0, 0, 1, l4, 0, 0L);
        }
        this.addFits(Thread.currentThread(), fits2);
        return fits2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Fits findLeaf(String string) throws Exception {
        String string2 = string + this.context.getTileExt();
        File file = new File(string2);
        if (!file.exists()) {
            return null;
        }
        Fits fits = new Fits();
        MyInputStream myInputStream = null;
        try {
            myInputStream = new MyInputStream(new FileInputStream(file));
            if (this.isColor) {
                fits.loadPreview(myInputStream, true);
            } else {
                fits.loadFITS(myInputStream);
            }
            fits.setFilename(string2);
        }
        catch (Exception exception) {
            Fits fits2 = null;
            return fits2;
        }
        finally {
            if (myInputStream != null) {
                myInputStream.close();
            }
        }
        return fits;
    }

    private class ThreadBuilder
    extends Thread {
        static final int START = 0;
        static final int WAIT = 1;
        static final int EXEC = 2;
        static final int DIED = 3;
        ThreadBuilderTile threadBuilderTile;
        private int mode;
        private boolean encore;

        public ThreadBuilder(String string, ThreadBuilderTile threadBuilderTile) {
            super(string);
            this.mode = 0;
            this.encore = true;
            this.threadBuilderTile = threadBuilderTile;
            Aladin.trace(3, "Creating " + this.getName());
        }

        public String getMode() {
            return MODE[this.mode];
        }

        public boolean isDied() {
            return this.mode == 3;
        }

        public boolean isExec() {
            return this.mode == 2;
        }

        public boolean isWait() {
            return this.mode == 1;
        }

        public void tue() {
            this.encore = false;
        }

        @Override
        public void run() {
            while (this.encore) {
                Item item = null;
                while (this.encore && (item = BuilderTiles.this.getNextNpix()) == null) {
                    this.mode = 1;
                    try {
                        Thread.currentThread();
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {}
                }
                if (!this.encore) continue;
                this.mode = 2;
                BuilderTiles.this.updateStat(1, 0, 0, 0L, 0, 0L);
                try {
                    Aladin.trace(4, Thread.currentThread().getName() + " process high level cell " + item + "...");
                    if (BuilderTiles.this.stopped || BuilderTiles.this.context.isTaskAborting()) break;
                    Fits fits = BuilderTiles.this.createHpx(this.threadBuilderTile, BuilderTiles.this.context.getOutputPath(), item.order, item.npix, item.z);
                    item.setFits(fits);
                    if (item.order == 3 && item.z == 0) {
                        BuilderTiles.this.setProgressBar((int)item.npix);
                    }
                }
                catch (Throwable throwable) {
                    Aladin.trace(1, "*** " + Thread.currentThread().getName() + " exception !!! (" + throwable.getMessage() + ")");
                    throwable.printStackTrace();
                    BuilderTiles.this.context.taskAbort();
                }
                BuilderTiles.this.updateStat(-1, 0, 0, 0L, 0, 0L);
            }
            this.mode = 3;
            BuilderTiles.this.rmThread(Thread.currentThread());
        }
    }

    class Item {
        int order;
        long npix;
        int z;
        boolean keepResult;
        Fits fits;
        boolean ready;
        Thread th;

        Item(int n, long l, int n2, Thread thread) {
            this.order = n;
            this.npix = l;
            this.z = n2;
            this.th = thread;
            this.ready = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isReady() {
            Object object = objItem;
            synchronized (object) {
                return this.ready;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Fits getFits() {
            Object object = objItem;
            synchronized (object) {
                return this.fits;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setFits(Fits fits) throws Exception {
            if (this.th == null) {
                return;
            }
            Object object = objItem;
            synchronized (object) {
                this.fits = fits;
                this.ready = true;
            }
            this.th.interrupt();
        }

        public String toString() {
            return this.order + "/" + this.npix + (this.z > 0 ? "-" + this.z : "") + (this.isReady() ? "R" : "");
        }
    }
}

