/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.allsky.Action;
import cds.allsky.BuilderAllsky;
import cds.allsky.BuilderMoc;
import cds.allsky.BuilderTiles;
import cds.allsky.Context;
import cds.allsky.ThreadBuilderTile;
import cds.fits.Fits;

public class BuilderTree
extends BuilderTiles {
    private boolean first = true;

    public BuilderTree(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.TREE;
    }

    @Override
    public void run() throws Exception {
        this.context.info("Creating " + this.context.getTileExt() + " tree and allsky (max depth=" + this.context.getOrder() + ")...");
        this.context.info("sky area to process: " + this.context.getNbLowCells() + " low level HEALPix cells");
        this.build();
        if (!this.context.isTaskAborting()) {
            new BuilderAllsky(this.context).run();
            this.context.info("ALLSKY file done");
        }
    }

    @Override
    public void validateContext() throws Exception {
        this.validateOutput();
        if (!this.context.isExistingAllskyDir()) {
            throw new Exception("No tile found");
        }
        this.validateOrder(this.context.getOutputPath());
        try {
            this.context.loadMoc();
        }
        catch (Exception exception) {
            new BuilderMoc(this.context).run();
            this.context.info("MOC rebuilt from low rhombs");
            this.context.loadMoc();
        }
        this.context.initRegion();
    }

    protected void setConstantes(Fits fits) {
        this.first = false;
        if (this.context.isColor()) {
            return;
        }
        this.context.bitpix = this.bitpix = fits.bitpix;
        this.context.blank = this.blank = fits.blank;
        this.context.bzero = this.bzero = fits.bzero;
        this.context.bscale = this.bscale = fits.bscale;
        if (this.context.bitpix != 0) {
            this.context.info("Found in first low rhomb: BITPIX=" + this.bitpix + " BLANK=" + this.blank + " BZERO=" + this.bzero + " BSCALE=" + this.bscale);
        } else {
            this.context.info("Colored pixels found in first low rhomb");
        }
    }

    @Override
    protected Fits createLeaveHpx(ThreadBuilderTile threadBuilderTile, String string, String string2, int n, long l, int n2) throws Exception {
        long l2 = System.currentTimeMillis();
        Fits fits = this.findLeaf(string);
        if (this.first && fits != null) {
            this.setConstantes(fits);
        }
        long l3 = System.currentTimeMillis() - l2;
        if (fits == null) {
            this.updateStat(0, 0, 1, l3, 0, 0L);
        } else {
            this.updateStat(0, 1, 0, l3, 0, 0L);
        }
        return fits;
    }
}

