/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.MyInputStream;
import cds.aladin.MyProperties;
import cds.aladin.Tok;
import cds.allsky.Action;
import cds.allsky.BuilderAllsky;
import cds.allsky.BuilderTiles;
import cds.allsky.Constante;
import cds.allsky.HipsGen;
import cds.allsky.Mode;
import cds.allsky.TransfertFct;
import cds.astro.Astrocoo;
import cds.astro.Astroframe;
import cds.astro.Galactic;
import cds.astro.ICRS;
import cds.fits.CacheFits;
import cds.fits.Fits;
import cds.fits.HeaderFits;
import cds.moc.HealpixMoc;
import cds.tools.pixtools.CDSHealpix;
import cds.tools.pixtools.Util;
import java.awt.Polygon;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JProgressBar;

public class Context {
    private static boolean verbose = false;
    protected String hipsId = null;
    protected String label;
    protected String inputPath;
    protected String outputPath;
    protected String hpxFinderPath;
    protected String imgEtalon;
    protected HeaderFits header = null;
    protected boolean isInputFile = false;
    public int depth = 1;
    protected boolean depthInit = false;
    public double crpix3 = 0.0;
    public double crval3 = 0.0;
    public double cdelt3 = 0.0;
    public String bunit3 = null;
    protected int[] hdu = null;
    public int bitpixOrig = -1;
    protected double blankOrig = Double.NaN;
    protected boolean hasAlternateBlank = false;
    public double bZeroOrig = 0.0;
    public double bScaleOrig = 1.0;
    protected boolean bscaleBzeroOrigSet = false;
    protected boolean flagNoInitEtalon = false;
    protected double[] cutOrig;
    protected double[] pixelRangeCut;
    public double[] pixelGood = null;
    public double[] good = null;
    public int[] borderSize = new int[]{0, 0, 0, 0};
    public Polygon polygon = null;
    public boolean scanFov = false;
    protected int circle = 0;
    public int dataArea = 0;
    public double maxRatio = 2.0;
    protected boolean fading = true;
    protected boolean mixing = true;
    protected boolean fake = false;
    protected boolean partitioning = true;
    public String skyvalName;
    public double pourcentMin = -1.0;
    public double pourcentMax = -1.0;
    public String expTimeName;
    protected double coef;
    protected ArrayList<String> fitsKeys = null;
    protected int typicalImgWidth = -1;
    protected int mirrorDelay = 0;
    protected int bitpix = -1;
    protected double blank = Double.NaN;
    protected double bzero = 0.0;
    protected double bscale = 1.0;
    protected double[] cut;
    protected TransfertFct fct = TransfertFct.LINEAR;
    private JpegMethod jpegMethod = JpegMethod.MEDIAN;
    protected Mode mode = Mode.getDefault();
    protected int maxNbThread = -1;
    protected String creator = null;
    protected String status = null;
    protected String redInfo;
    protected String greenInfo;
    protected String blueInfo;
    protected boolean gaussFilter = false;
    protected int order = -1;
    public int minOrder = -1;
    private int frame = -1;
    protected HealpixMoc mocArea = null;
    protected HealpixMoc mocIndex = null;
    protected HealpixMoc moc = null;
    protected int mocOrder = -1;
    protected int nside = 1024;
    protected int tileOrder = -1;
    protected CacheFits cacheFits;
    protected Vector<String> keyAddProp = null;
    protected Vector<String> valueAddProp = null;
    protected String target = null;
    protected String targetRadius = null;
    protected String resolution = null;
    protected String scriptCommand;
    protected int targetColorMode = 0;
    protected ArrayList<String> tileTypes = null;
    protected boolean testClonable = true;
    protected boolean live = false;
    private String addendum_id = null;
    private String lastImgEtalon = null;
    private static int nbFiles;
    protected String outputRGB;
    protected JpegMethod methodRgb;
    protected String[] plansRGB = new String[3];
    protected String[] cmsRGB = new String[3];
    protected int lastNorder3 = -2;
    protected Action action = null;
    protected double progress = -1.0;
    protected double progressMax = Double.MAX_VALUE;
    protected JProgressBar progressBar = null;
    protected MyProperties prop = null;
    private boolean isMap = false;
    protected boolean ignoreStamp;
    private boolean taskRunning = false;
    private boolean taskPause = false;
    protected boolean taskAborting = false;
    private static SimpleDateFormat DATEFORMAT;
    private boolean flagNL = false;
    private boolean validateOutputDone = false;
    private boolean validateInputDone = false;
    private boolean validateCutDone = false;
    private boolean validateRegion = false;
    private static final Astrocoo COO_GAL;
    private static final Astrocoo COO_EQU;
    private static Astroframe AF_GAL1;
    private static Astroframe AF_ICRS1;
    private String INDEX = "<HTML>\n<HEAD>\n   <script type=\"text/javascript\" src=\"http://code.jquery.com/jquery-1.10.1.min.js\"></script>\n   <link rel=\"stylesheet\" href=\"http://aladin.u-strasbg.fr/AladinLite/api/v2/latest/aladin.min.css\" >\n   <script type=\"text/javascript\">var jqMenu = jQuery.noConflict();</script>\n   <script type=\"text/javascript\">\nvar hipsDir=null;</script>\n</HEAD>\n<H1>\"$LABEL\" progressive survey</H1>\nThis Web resource contains HiPS(*) components for <B>$LABEL</B> progressive survey.\n<script type=\"text/javascript\">\nhipsDir = location.href;\nhipsDir = hipsDir.substring(0,hipsDir.lastIndexOf(\"/\",hipsDir.length));\ndocument.getElementById(\"hipsBase\").innerHTML=hipsDir;\n</script>\n<TABLE>\n<TR>\n<TD>\n   <script type=\"text/javascript\" src=\"http://aladin.u-strasbg.fr/AladinLite/api/v2/latest/aladin.min.js\" charset=\"utf-8\"></script>\n<div id=\"aladin-lite-div\" style=\"width:350px;height:350px;\"></div>\n<script type=\"text/javascript\">\n//var hipsDir = location.href;\n//hipsDir = hipsDir.substring(0,hipsDir.lastIndexOf(\"/\",hipsDir.length));\nvar aladin = $.aladin(\"#aladin-lite-div\");\naladin.setImageSurvey(aladin.createImageSurvey('$LABEL', '$LABEL',\nhipsDir, '$SYS', $ORDER, {imgFormat: '$FMT'}));\n</script>    \n</TD>\n<TD>\n<UL>\n$INFO   <LI> <B>Raw property file:</B> <A HREF=\"properties\">properties</A>\n   <LI> <B>Base URL:<p id=\"hipsBase\"></p></B> \n</UL>\n</TD>\n</TR>\n</TABLE>\nThis survey can be displayed by <A HREF=\"http://aladin.u-strasbg.fr/AladinLite\">Aladin Lite</A> (see above), \nby <A HREF=\"http://aladin.u-strasbg.fr/java/nph-aladin.pl?frame=downloading\">Aladin Desktop</A> client\n(just open the base URL)<BR>or any other HiPS aware clients .\n<HR>\n<I>(*) The HiPS technology allows a dedicated client to access an astronomical survey at any location and at any scale. \nHiPS is based on HEALPix sky tessellation and it is designed for astronomical scientifical usages (low distorsion, true pixel values...).HiPS technical documentation is available <A HREF=\"http://aladin.u-strasbg.fr/HiPS/HiPS%20technical%20doc.pdf\">here<A></I>\n<script type=\"text/javascript\">\ndocument.getElementById(\"hipsBase\").innerHTML=hipsDir;\n</script>\n</HTML>\n";
    private transient boolean lock;
    private final Object lockObj = new Object();
    public int[] xy2hpx = null;
    public int[] hpx2xy = null;

    public void reset() {
        this.moc = null;
        this.mocIndex = null;
        this.mocArea = null;
        this.mode = Mode.getDefault();
        this.hasAlternateBlank = false;
        this.bscaleBzeroOrigSet = false;
        this.outputPath = null;
        this.inputPath = null;
        this.hpxFinderPath = null;
        this.imgEtalon = null;
        this.lastNorder3 = -2;
        this.validateRegion = false;
        this.validateCutDone = false;
        this.validateInputDone = false;
        this.validateOutputDone = false;
        this.live = false;
        this.isMap = false;
        this.prop = null;
        this.pixelGood = null;
        this.good = null;
        this.pixelRangeCut = null;
        this.depth = 1;
        this.depthInit = false;
        this.cdelt3 = 0.0;
        this.crval3 = 0.0;
        this.crpix3 = 0.0;
        this.bunit3 = null;
        this.tileTypes = null;
        this.outputRGB = null;
        this.greenInfo = null;
        this.blueInfo = null;
        this.redInfo = null;
        this.gaussFilter = false;
        this.plansRGB = new String[3];
        this.cmsRGB = new String[3];
        this.flagNoInitEtalon = false;
    }

    public static String getFrameName(int n) {
        return n == 3 ? "galactic" : (n == 2 ? "ecliptic" : (n == -1 ? "?" : "equatorial"));
    }

    public static String getFrameCode(int n) {
        return n == 3 ? "G" : (n == 2 ? "E" : (n == -1 ? "?" : "C"));
    }

    public static int getFrameVal(String string) {
        return string.equals("G") || string.startsWith("gal") ? 3 : (string.equals("E") || string.startsWith("ecl") ? 2 : 0);
    }

    public static String getCanonicalFrameName(String string) {
        return Context.getFrameName(Context.getFrameVal(string));
    }

    public String getLabel() {
        if (this.label == null) {
            return this.getLabelFromHipsId();
        }
        return this.label;
    }

    public String getHipsId() {
        return this.hipsId;
    }

    public boolean getFading() {
        return this.fading;
    }

    public int[] getBorderSize() {
        int[] nArray;
        if (this.dataArea == 0) {
            nArray = this.borderSize;
        } else {
            int[] nArray2 = new int[4];
            nArray2[0] = 0;
            nArray2[1] = 0;
            nArray2[2] = 0;
            nArray = nArray2;
            nArray2[3] = 0;
        }
        return nArray;
    }

    public double getMaxRatio() {
        return this.maxRatio;
    }

    public int getOrder() {
        return this.order;
    }

    public boolean hasFrame() {
        return this.frame >= 0;
    }

    public int getFrame() {
        return this.hasFrame() ? this.frame : 0;
    }

    public String getFrameName() {
        return Context.getFrameName(this.getFrame());
    }

    public String getFrameCode() {
        return Context.getFrameCode(this.getFrame());
    }

    public CacheFits getCache() {
        return this.cacheFits;
    }

    public String getInputPath() {
        return this.inputPath;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public String getHpxFinderPath() {
        return this.hpxFinderPath != null ? this.hpxFinderPath : cds.tools.Util.concatDir(this.getOutputPath(), "HpxFinder");
    }

    public String getImgEtalon() {
        return this.imgEtalon;
    }

    public int getBitpixOrig() {
        return this.bitpixOrig;
    }

    public int getBitpix() {
        return this.isColor() ? this.bitpixOrig : this.bitpix;
    }

    public int getNpix() {
        return this.isColor() || this.bitpix == -1 ? 4 : Math.abs(this.bitpix) / 8;
    }

    public int getNpixOrig() {
        return this.isColor() || this.bitpixOrig == -1 ? 4 : Math.abs(this.bitpixOrig) / 8;
    }

    public double getBScaleOrig() {
        return this.bScaleOrig;
    }

    public double getBZeroOrig() {
        return this.bZeroOrig;
    }

    public double getBZero() {
        return this.bzero;
    }

    public double getBScale() {
        return this.bscale;
    }

    public double getBlank() {
        return this.blank;
    }

    public double getBlankOrig() {
        return this.blankOrig;
    }

    public boolean hasAlternateBlank() {
        return this.hasAlternateBlank;
    }

    public HealpixMoc getArea() {
        return this.mocArea;
    }

    public Mode getMode() {
        return this.mode;
    }

    public double[] getCut() throws Exception {
        return this.cut;
    }

    public double[] getCutOrig() throws Exception {
        return this.cutOrig;
    }

    public String getSkyval() {
        return this.skyvalName;
    }

    public boolean isColor() {
        return this.bitpixOrig == 0;
    }

    public boolean isCube() {
        return this.depth > 1;
    }

    public boolean isCubeCanal() {
        return this.crpix3 != 0.0 || this.crval3 != 0.0 || this.cdelt3 != 0.0;
    }

    public boolean isInMocTree(int n, long l) {
        return this.moc == null || this.moc.isIntersecting(n, l);
    }

    public boolean isInMoc(int n, long l) {
        return this.moc == null || this.moc.isIntersecting(n, l);
    }

    public boolean isMocDescendant(int n, long l) {
        return this.moc == null || this.moc.isDescendant(n, l);
    }

    public int getMaxNbThread() {
        return this.maxNbThread;
    }

    public int getMocOrder() {
        return this.mocOrder;
    }

    public long getMapNside() {
        return this.nside;
    }

    public int getMinOrder() {
        return this.minOrder;
    }

    public int getTileOrder() {
        return this.tileOrder == -1 ? 9 : this.tileOrder;
    }

    public int getTileSide() {
        return (int)CDSHealpix.pow2(this.getTileOrder());
    }

    public int getDepth() {
        return this.depth;
    }

    public void setLive(boolean bl) {
        this.live = bl;
    }

    public void setFlagInputFile(boolean bl) {
        this.isInputFile = bl;
    }

    public void setHeader(HeaderFits headerFits) {
        this.header = headerFits;
    }

    public void setCreator(String string) {
        this.creator = string;
    }

    public void setStatus(String string) {
        this.status = string;
    }

    public void setHipsId(String string) {
        this.hipsId = this.checkHipsId(string, true);
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public void setMaxNbThread(int n) {
        this.maxNbThread = n;
    }

    public void setFading(boolean bl) {
        this.fading = bl;
    }

    public void setFading(String string) {
        this.fading = !string.equalsIgnoreCase("false");
    }

    public void setMixing(String string) {
        this.mixing = !string.equalsIgnoreCase("false");
    }

    public void setPartitioning(String string) {
        this.partitioning = !string.equalsIgnoreCase("false");
    }

    public void setCircle(String string) throws Exception {
        this.circle = Integer.parseInt(string);
    }

    public void setMaxRatio(String string) throws Exception {
        this.maxRatio = Double.parseDouble(string);
    }

    public void setBorderSize(String string) throws ParseException {
        this.borderSize = this.parseBorderSize(string);
    }

    public void setBorderSize(int[] nArray) {
        this.borderSize = nArray;
    }

    public void setOrder(int n) {
        this.order = n;
    }

    public void setMinOrder(int n) {
        this.minOrder = n;
    }

    public void setMocOrder(int n) {
        this.mocOrder = n;
    }

    public void setMapNside(int n) {
        this.nside = n;
    }

    public void setTileOrder(int n) {
        this.tileOrder = n;
    }

    public void setFrame(int n) {
        this.frame = n;
    }

    public void setFrameName(String string) {
        this.frame = Context.getFrameVal(string);
    }

    public void setFilter(String string) throws Exception {
        if (!string.equalsIgnoreCase("gauss")) {
            throw new Exception("Unknown filter [" + string + "] (=> only \"gauss\" are presently supported)");
        }
        this.gaussFilter = true;
    }

    public void setSkyValName(String string) {
        this.skyvalName = string;
        if (string == null) {
            return;
        }
        if (string.equalsIgnoreCase("true")) {
            this.info("Skyval automatical adjustement activated...");
        } else {
            this.info("Skyval adjustement based on the FITS keyword [" + string + "]");
        }
    }

    public int[] getHDU() {
        return this.hdu;
    }

    public void setHDU(String string) throws Exception {
        this.hdu = Context.parseHDU(string);
    }

    public void setShape(String string) throws Exception {
        if (cds.tools.Util.indexOfIgnoreCase(string, "circle") >= 0 || cds.tools.Util.indexOfIgnoreCase(string, "ellipse") >= 0) {
            this.dataArea = 1;
            this.info("Ellipse shape data area autodetection");
        } else if (cds.tools.Util.indexOfIgnoreCase(string, "square") >= 0 || cds.tools.Util.indexOfIgnoreCase(string, "rectangular") >= 0) {
            this.dataArea = 2;
            this.info("Rectangular shape data area autodetection");
        } else {
            this.dataArea = 0;
            throw new Exception("Unknown observation shape [" + string + "] (=> circle, ellipse, square, rectangular)");
        }
    }

    public void setAddendum(String string) {
        this.addendum_id = string;
    }

    public void addAddendum(String string) throws Exception {
        if (string.equals(this.hipsId)) {
            throw new Exception("Addendum_id identical to the original HiPS ID [" + this.hipsId + "]");
        }
        if (this.addendum_id == null) {
            this.addendum_id = string;
        } else {
            Tok tok = new Tok(this.addendum_id, "\t");
            while (tok.hasMoreTokens()) {
                if (!tok.nextToken().equals(string)) continue;
                throw new Exception("Addendum_id already used  [" + this.addendum_id + "]");
            }
            this.addendum_id = this.addendum_id + "\t" + string;
        }
    }

    public String getRgbOutput() {
        return this.getOutputPath();
    }

    public JpegMethod getRgbMethod() {
        return this.getJpegMethod();
    }

    public int getRgbFormat() {
        return this.targetColorMode;
    }

    public void setPolygon(String string) throws Exception {
        boolean bl = this.scanFov = string.equalsIgnoreCase("true") || (this.polygon = Context.createPolygon(string)) != null;
        if (this.scanFov) {
            this.info("FoV files associated to the original images");
        }
    }

    public String getIdFromProp(MyProperties myProperties) {
        String string = myProperties.getProperty("creator_did");
        if (string != null) {
            return string;
        }
        string = myProperties.getProperty("publisher_did");
        if (string != null) {
            return string;
        }
        string = myProperties.getProperty("obs_id");
        if (string == null) {
            return null;
        }
        String string2 = myProperties.getProperty("creator_id");
        if (string2 == null) {
            string2 = myProperties.getProperty("publisher_id");
        }
        if (string2 == null) {
            string2 = "ivo://UNK.AUT";
        }
        return string2 + "?" + string;
    }

    public String checkHipsId(String string, boolean bl) {
        String string2;
        boolean bl2;
        CharSequence charSequence;
        String string3;
        boolean bl3 = false;
        if (string == null && this.prop != null) {
            string = this.getIdFromProp(this.prop);
        }
        if (string == null || string.trim().length() == 0) {
            bl = false;
            String string4 = string = this.getLabel() != null ? this.getLabel() : "";
        }
        if (string.startsWith("ivo://")) {
            string = string.substring(6);
        }
        int n = string.indexOf(47);
        int n2 = string.indexOf(63);
        if (n >= 0 || n2 >= 0) {
            if (n == -1) {
                n = string.length();
            }
            if (n2 == -1) {
                n2 = string.length();
            }
            if (n2 < n) {
                n = n2;
                bl3 = true;
            } else {
                bl3 = false;
            }
        }
        if (n == -1) {
            string3 = "UNK.AUTH";
            if (bl) {
                this.warning("Id error => missing authority => assuming " + string3);
            }
        } else {
            string3 = string.substring(0, n);
            string = string.substring(n + 1);
            if (string3.length() < 3) {
                while (string3.length() < 3) {
                    string3 = string3 + "_";
                }
                if (bl) {
                    this.warning("Creator ID error => at least 3 characters are required => assuming " + string3);
                }
            }
            charSequence = new StringBuilder();
            bl2 = false;
            for (int n3 : string3.toCharArray()) {
                if (!Character.isLetterOrDigit((char)n3) && n3 != 46 && n3 != 45) {
                    n3 = 46;
                    bl2 = true;
                }
                ((StringBuilder)charSequence).append((char)n3);
            }
            if (bl2) {
                string3 = ((StringBuilder)charSequence).toString();
                if (bl) {
                    this.warning("Creator ID error => some characters are not allowed => assuming " + string3);
                }
            }
        }
        if ((string2 = string.trim()).startsWith("P/") || string2.startsWith("C/")) {
            string2 = string2.substring(2);
        }
        if (string2.length() == 0) {
            string2 = "ID" + System.currentTimeMillis() / 1000L;
            if (bl) {
                this.warning("Id error => missing ID => assuming " + string2);
            }
        } else {
            charSequence = new StringBuilder();
            bl2 = false;
            for (char c : string2.toCharArray()) {
                if (Character.isSpaceChar(c)) {
                    c = '-';
                    bl2 = true;
                }
                ((StringBuilder)charSequence).append(c);
            }
            if (bl2) {
                string2 = ((StringBuilder)charSequence).toString();
                if (bl) {
                    this.warning("Id identifier error => some characters are not allowed => assuming " + string2);
                }
            }
        }
        charSequence = this.isCube() ? "C" : "P";
        return "ivo://" + string3 + (bl3 ? "?" : "/") + (String)charSequence + "/" + string2;
    }

    public String getLabelFromHipsId() {
        String string;
        if (this.hipsId == null) {
            return null;
        }
        String string2 = this.hipsId;
        if (string2 != null && string2.startsWith("ivo://")) {
            string2 = string2.substring(6);
        }
        int n = string2.indexOf(47);
        int n2 = string2.indexOf(63);
        if (n == -1 && n2 == -1) {
            return null;
        }
        if (n == -1) {
            n = string2.length();
        }
        if (n2 == -1) {
            n2 = string2.length();
        }
        if ((string = string2.substring((n = Math.min(n2, n)) + 1)).startsWith("P/")) {
            string = string.substring(2);
        }
        string = string.replace('/', ' ');
        return string;
    }

    public static Polygon createPolygon(String string) throws Exception {
        Polygon polygon = new Polygon();
        Tok tok = new Tok(string, " ,;\t");
        while (tok.hasMoreTokens()) {
            int n = (int)(Double.parseDouble(tok.nextToken()) + 0.5);
            int n2 = (int)(Double.parseDouble(tok.nextToken()) + 0.5);
            polygon.addPoint(n, n2);
        }
        return polygon;
    }

    protected void setTileTypes(String string) {
        Tok tok = new Tok(string);
        while (tok.hasMoreTokens()) {
            this.addTileType(tok.nextToken());
        }
    }

    protected void addTileType(String string) {
        if (string.equalsIgnoreCase("jpeg")) {
            string = "jpg";
        }
        if (this.tileTypes == null) {
            this.tileTypes = new ArrayList();
        }
        this.tileTypes.add(string.length() == 0 ? string : "." + string.toLowerCase());
    }

    protected String getTileTypes() {
        if (this.tileTypes == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.tileTypes) {
            if (string.length() == 0) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            if (string.equals(".jpg")) {
                stringBuilder.append("jpeg");
                continue;
            }
            stringBuilder.append(string.substring(1));
        }
        return stringBuilder.toString();
    }

    public static int[] parseHDU(String string) throws Exception {
        int[] nArray = null;
        if (string.length() == 0 || string.equals("0")) {
            return nArray;
        }
        if (string.equalsIgnoreCase("all")) {
            return new int[]{-1};
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,;-", true);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        boolean bl = false;
        int n = -1;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("-")) {
                bl = true;
                continue;
            }
            if (!Character.isDigit(string2.charAt(0))) continue;
            int n2 = Integer.parseInt(string2);
            if (bl) {
                for (int i = n + 1; i <= n2 && i < 1000; ++i) {
                    arrayList.add(i);
                }
                bl = false;
            } else {
                arrayList.add(n2);
            }
            n = n2;
        }
        nArray = new int[arrayList.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)arrayList.get(i);
        }
        return nArray;
    }

    public void setInputPath(String string) {
        this.inputPath = string;
    }

    public void setOutputPath(String string) {
        this.outputPath = string;
    }

    public void setImgEtalon(String string) throws Exception {
        this.imgEtalon = string;
        this.initFromImgEtalon();
    }

    public void setIndexFitskey(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        this.fitsKeys = new ArrayList(stringTokenizer.countTokens());
        while (stringTokenizer.hasMoreTokens()) {
            this.fitsKeys.add(stringTokenizer.nextToken());
        }
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public void setTarget(String string) {
        this.target = string;
    }

    public void setTargetRadius(String string) {
        this.targetRadius = string;
    }

    public void setBScaleOrig(double d) {
        this.bScaleOrig = d;
        this.bscaleBzeroOrigSet = true;
    }

    public void setBZeroOrig(double d) {
        this.bZeroOrig = d;
        this.bscaleBzeroOrigSet = true;
    }

    public void setBitpixOrig(int n) {
        this.bitpixOrig = n;
        if (this.bitpix == -1) {
            this.bitpix = n;
        }
    }

    public void setBitpix(int n) {
        this.bitpix = n;
    }

    public void setBlankOrig(double d) {
        this.blankOrig = d;
        this.hasAlternateBlank = true;
    }

    public void setColor(String string) {
        if (string.equalsIgnoreCase("false")) {
            return;
        }
        this.bitpixOrig = 0;
        this.targetColorMode = string.equalsIgnoreCase("png") ? 0 : 1;
    }

    public void setCut(double[] dArray) {
        this.cut = dArray;
    }

    public void setPixelCut(String string) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n = 0;
        if (this.pixelRangeCut == null) {
            this.pixelRangeCut = new double[]{Double.NaN, Double.NaN, Double.NaN, Double.NaN};
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            try {
                this.pixelRangeCut[n] = Double.parseDouble(string2);
                ++n;
            }
            catch (Exception exception) {
                this.setTransfertFct(string2);
            }
        }
        if (n == 1 || n > 2) {
            throw new Exception("pixelCut parameter error");
        }
    }

    public void setPixelGood(String string) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        if (this.pixelGood == null) {
            this.pixelGood = new double[]{Double.NaN, Double.NaN};
        }
        try {
            this.pixelGood[0] = Double.parseDouble(stringTokenizer.nextToken());
            this.pixelGood[1] = stringTokenizer.hasMoreTokens() ? Double.parseDouble(stringTokenizer.nextToken()) : this.pixelGood[0];
        }
        catch (Exception exception) {
            throw new Exception("pixelGood parameter error");
        }
    }

    public void setHistoPercent(String string) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n = stringTokenizer.countTokens();
        try {
            if (n > 2) {
                throw new Exception();
            }
            this.pourcentMin = Double.parseDouble(stringTokenizer.nextToken()) / 100.0;
            if (n == 1) {
                this.pourcentMin = (1.0 - this.pourcentMin) / 2.0;
                this.pourcentMax = 1.0 - this.pourcentMin;
            } else {
                this.pourcentMax = Double.parseDouble(stringTokenizer.nextToken()) / 100.0;
            }
        }
        catch (Exception exception) {
            throw new Exception("histoPercent parameter error");
        }
    }

    public double[] getPixelRangeCut() throws Exception {
        return this.pixelRangeCut;
    }

    public TransfertFct getFct() throws Exception {
        return this.fct;
    }

    public String getTransfertFct() throws Exception {
        return this.getFct().toString().toLowerCase();
    }

    public void setTransfertFct(String string) {
        this.fct = TransfertFct.valueOf(string.toUpperCase());
    }

    public String getTileExt() {
        return this.isColor() ? Constante.TILE_EXTENSION[this.targetColorMode] : ".fits";
    }

    public void setJpegMethod(JpegMethod jpegMethod) {
        this.jpegMethod = jpegMethod;
    }

    public void setMethod(String string) {
        this.jpegMethod = JpegMethod.valueOf(string.toUpperCase());
    }

    public JpegMethod getJpegMethod() {
        return this.jpegMethod;
    }

    public void setDataCut(String string) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n = 2;
        if (this.pixelRangeCut == null) {
            this.pixelRangeCut = new double[]{Double.NaN, Double.NaN, Double.NaN, Double.NaN};
        }
        while (stringTokenizer.hasMoreTokens() && n < 4) {
            String string2 = stringTokenizer.nextToken();
            this.pixelRangeCut[n] = Double.parseDouble(string2);
            ++n;
        }
        if (n < 4) {
            throw new Exception("Missing dataCut parameter");
        }
    }

    public void setCutOrig(double[] dArray) {
        this.cutOrig = dArray;
    }

    public void setDepth(int n) {
        this.depth = n;
        this.depthInit = true;
    }

    protected void initFromImgEtalon() throws Exception {
        Object object;
        if (this.lastImgEtalon != null && this.lastImgEtalon.equals(this.imgEtalon)) {
            return;
        }
        String string = this.imgEtalon;
        Fits fits = new Fits();
        fits.loadHeaderFITS(string);
        this.setBitpixOrig(fits.bitpix);
        if (!this.isColor()) {
            this.setBZeroOrig(fits.bzero);
            this.setBScaleOrig(fits.bscale);
            if (!Double.isNaN(fits.blank)) {
                this.setBlankOrig(fits.blank);
            }
        }
        this.typicalImgWidth = Math.max(fits.width, fits.height);
        try {
            this.setDepth(fits.headerFits.getIntFromHeader("NAXIS3"));
            try {
                this.crpix3 = fits.headerFits.getDoubleFromHeader("CRPIX3");
                this.crval3 = fits.headerFits.getDoubleFromHeader("CRVAL3");
                this.cdelt3 = fits.headerFits.getDoubleFromHeader("CDELT3");
                this.bunit3 = fits.headerFits.getStringFromHeader("BUNIT3");
            }
            catch (Exception exception) {
                this.cdelt3 = 0.0;
                this.crval3 = 0.0;
                this.crpix3 = 0.0;
                this.bunit3 = null;
            }
        }
        catch (Exception exception) {
            this.setDepth(1);
        }
        try {
            this.initCut(fits);
        }
        catch (Exception exception) {
            Aladin.trace(4, "initFromImgEtalon :" + exception.getMessage());
        }
        if (this.target == null) {
            object = fits.calib.getImgCenter();
            String string2 = cds.tools.Util.round(((Coord)object).al, 5) + " " + (((Coord)object).del >= 0.0 ? "+" : "") + cds.tools.Util.round(((Coord)object).del, 5);
            this.setTarget(string2);
            this.info("setTarget => " + string2);
            if (this.targetRadius == null) {
                double d = Math.max(fits.calib.getImgHeight(), fits.calib.getImgWidth());
                this.setTargetRadius(cds.tools.Util.round(d, 5) + "");
            }
        }
        object = fits.calib.GetResol();
        this.resolution = cds.tools.Util.myRound(Math.min((double)object[0], (double)object[1]));
        this.lastImgEtalon = this.imgEtalon;
    }

    protected void initCut(Fits fits) throws Exception {
        int n = fits.width;
        int n2 = fits.height;
        int n3 = fits.depth;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (n > 1024) {
            n = 1024;
            n4 = fits.width / 2 - 512;
        }
        if (n2 > 1024) {
            n2 = 1024;
            n5 = fits.height / 2 - 512;
        }
        if (n3 > 1) {
            n3 = 1;
            n6 = fits.depth / 2 - 0;
        }
        if (fits.getFilename() != null) {
            fits.loadFITS(fits.getFilename(), 0, n4, n5, n6, n, n2, n3);
        }
        if (!this.flagNoInitEtalon) {
            double d;
            double[] dArray = fits.findAutocutRange();
            double d2 = dArray[2] / 2.0 + dArray[3] / 2.0;
            if (!Double.isInfinite(d2 - (d = dArray[3] - dArray[2]))) {
                dArray[2] = d2 - d;
            }
            if (!Double.isInfinite(d2 + d)) {
                dArray[3] = d2 + d;
            }
            this.setCutOrig(dArray);
        }
    }

    boolean findImgEtalon(String string) {
        if (this.isInputFile) {
            try {
                this.setImgEtalon(string);
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }
        nbFiles = 0;
        return this.findImgEtalon1(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean findImgEtalon1(String string) {
        String string2;
        File file = new File(string);
        String[] stringArray = file.list();
        if (stringArray == null) {
            return false;
        }
        String string22 = string;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl;
            MyInputStream myInputStream;
            block22: {
                if (!string.endsWith(cds.tools.Util.FS)) {
                    string = string + cds.tools.Util.FS;
                }
                if (new File(string22 = string + stringArray[i]).isDirectory()) {
                    if (stringArray[i].equals(Constante.SURVEY)) continue;
                    arrayList.add(string22);
                    continue;
                }
                if (++nbFiles > 100) {
                    Aladin.trace(4, "Context.findImgEtalon: too many files - ignored this step...");
                    return false;
                }
                Object var7_9 = null;
                try {
                    myInputStream = new MyInputStream(new FileInputStream(string22)).startRead();
                    if ((myInputStream.getType() & 1L) != 1L && !myInputStream.hasCommentCalib()) {
                        if (myInputStream == null) continue;
                        break block22;
                    }
                    Aladin.trace(4, "Context.findImgEtalon: " + string22 + "...");
                    this.setImgEtalon(string22);
                    bl = true;
                    if (myInputStream == null) return bl;
                }
                catch (Exception exception) {
                    Aladin.trace(4, "findImgEtalon : " + exception.getMessage());
                    continue;
                }
            }
            try {
                myInputStream.close();
            }
            catch (Exception exception) {}
            continue;
            try {
                myInputStream.close();
                return bl;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return bl;
            finally {
                void object;
                if (object != null) {
                    try {
                        object.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        Iterator iterator = arrayList.iterator();
        do {
            if (!iterator.hasNext()) return false;
        } while (!this.findImgEtalon1(string2 = (String)iterator.next()));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String justFindImgEtalon(String string) {
        MyInputStream myInputStream = null;
        if (this.isInputFile) {
            return string;
        }
        File file = new File(string);
        String[] stringArray = file.list();
        if (stringArray == null) {
            return null;
        }
        String string2 = string;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string3;
            if (!string.endsWith(cds.tools.Util.FS)) {
                string = string + cds.tools.Util.FS;
            }
            if (new File(string2 = string + stringArray[i]).isDirectory()) {
                if (stringArray[i].equals(Constante.SURVEY)) continue;
                arrayList.add(string2);
                continue;
            }
            try {
                if (string2.endsWith(".hhh")) {
                    String string4 = string2;
                    return string4;
                }
                myInputStream = new MyInputStream(new FileInputStream(string2)).startRead();
                long l = myInputStream.getType();
                if ((l & 1L) != 1L && !myInputStream.hasCommentCalib()) continue;
                string3 = string2 + (this.hdu == null || this.hdu.length > 0 && this.hdu[0] == -1 ? "" : "[" + this.hdu[0] + "]");
            }
            catch (Exception exception) {
                Aladin.trace(4, "justFindImgEtalon : " + exception.getMessage());
                continue;
            }
            finally {
                if (myInputStream != null) {
                    try {
                        myInputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return string3;
        }
        for (String string5 : arrayList) {
            String string6 = this.justFindImgEtalon(string5);
            if (string6 == null) continue;
            return string6;
        }
        return null;
    }

    public void setRgbInput(String string, int n) {
        this.plansRGB[n] = string;
    }

    public void setRgbCmParam(String string, int n) {
        this.cmsRGB[n] = string;
    }

    public void setSkyval(String string) throws Exception {
        boolean bl = false;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            Double.parseDouble(stringTokenizer.nextToken());
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            this.skyvalName = "true";
            this.setHistoPercent(string);
        } else {
            this.skyvalName = string.toUpperCase();
        }
    }

    public void setSkyValues(String string) throws Exception {
        Tok tok = new Tok(string);
        this.cutOrig = new double[4];
        int n = 0;
        while (tok.hasMoreTokens()) {
            try {
                this.cutOrig[n] = Double.parseDouble(tok.nextToken());
            }
            catch (Exception exception) {
                throw new Exception("hips_skyval_values parsing error [" + string + "]");
            }
            ++n;
        }
        this.flagNoInitEtalon = true;
    }

    public void setExpTime(String string) {
        this.expTimeName = string.toUpperCase();
    }

    public void setCache(CacheFits cacheFits) {
        this.cacheFits = cacheFits;
        cacheFits.setContext(this);
    }

    protected void setMocArea(String string) throws Exception {
        if (string.length() == 0) {
            return;
        }
        this.mocArea = new HealpixMoc(string);
        if (this.mocArea.getSize() == 0) {
            throw new Exception("MOC sky area syntax error");
        }
    }

    public void setMocArea(HealpixMoc healpixMoc) throws Exception {
        this.mocArea = healpixMoc;
    }

    public double getSkyArea() {
        if (this.moc == null) {
            return 1.0;
        }
        return this.moc.getCoverage();
    }

    public double getIndexSkyArea() {
        if (this.mocIndex == null) {
            return 1.0;
        }
        return this.mocIndex.getCoverage();
    }

    public void initParameters() throws Exception {
        if (!this.isColor()) {
            this.bitpix = this.getBitpix();
            this.bitpixOrig = this.getBitpixOrig();
            this.cutOrig = this.getCutOrig();
            this.blankOrig = this.getBlankOrig();
            this.blank = this.getDefaultBlankFromBitpix(this.bitpix);
            this.cut = new double[5];
            if (this.cutOrig == null) {
                this.cutOrig = new double[5];
            }
            System.arraycopy(this.cutOrig, 0, this.cut, 0, this.cutOrig.length);
            if (this.cutOrig[2] >= this.cutOrig[3]) {
                double d = this.bitpixOrig == -64 ? -1.7976931348623157E308 : (this.bitpixOrig == -32 ? -3.4028234663852886E38 : (this.bitpixOrig == 64 ? -9.223372036854776E18 : (this.bitpixOrig == 32 ? -2.147483647E9 : (this.cutOrig[2] = this.bitpixOrig == 16 ? -32767.0 : 1.0))));
                double d2 = this.bitpixOrig == -64 ? Double.MAX_VALUE : (this.bitpixOrig == -32 ? 3.4028234663852886E38 : (this.bitpixOrig == 64 ? 9.223372036854776E18 : (this.bitpixOrig == 32 ? 2.147483647E9 : (this.cutOrig[3] = this.bitpixOrig == 16 ? 32767.0 : 255.0))));
            }
            if (this.bitpixOrig != -1 && this.bitpix != this.bitpixOrig) {
                double d = this.bitpix == -64 ? -1.7976931348623157E308 : (this.bitpix == -32 ? -3.4028234663852886E38 : (this.bitpix == 64 ? -9.223372036854776E18 : (this.bitpix == 32 ? -2.147483647E9 : (this.cut[2] = this.bitpix == 16 ? -32767.0 : 1.0))));
                this.cut[3] = this.bitpix == -64 ? Double.MAX_VALUE : (this.bitpix == -32 ? 3.4028234663852886E38 : (this.bitpix == 64 ? 9.223372036854776E18 : (this.bitpix == 32 ? 2.147483647E9 : (this.bitpix == 16 ? 32767.0 : 255.0))));
                this.coef = (this.cut[3] - this.cut[2]) / (this.cutOrig[3] - this.cutOrig[2]);
                this.cut[0] = (this.cutOrig[0] - this.cutOrig[2]) * this.coef + this.cut[2];
                this.cut[1] = (this.cutOrig[1] - this.cutOrig[2]) * this.coef + this.cut[2];
                this.bzero = this.bZeroOrig + this.bScaleOrig * (this.cutOrig[2] - this.cut[2] / this.coef);
                this.bscale = this.bScaleOrig / this.coef;
                this.info("Change BITPIX from " + this.bitpixOrig + " to " + this.bitpix);
                this.info("Map original pixel range [" + this.cutOrig[2] + " .. " + this.cutOrig[3] + "] to [" + this.cut[2] + " .. " + this.cut[3] + "]");
                this.info("Change BZERO,BSCALE,BLANK=" + this.bZeroOrig + "," + this.bScaleOrig + "," + this.blankOrig + " to " + this.bzero + "," + this.bscale + "," + this.blank);
                if (Double.isInfinite(this.bzero) || Double.isInfinite(this.bscale)) {
                    throw new Exception("pixelRange parameter required !");
                }
            } else {
                this.bzero = this.bZeroOrig;
                this.bscale = this.bScaleOrig;
                Aladin.trace(3, "BITPIX kept " + this.bitpix + " BZERO,BSCALE,BLANK=" + this.bzero + "," + this.bscale + "," + this.blank);
            }
            if (this.pixelGood != null) {
                this.good = new double[2];
                this.good[0] = (this.pixelGood[0] - this.bZeroOrig) / this.bScaleOrig;
                this.good[1] = (this.pixelGood[1] - this.bZeroOrig) / this.bScaleOrig;
            }
        }
        this.initRegion();
    }

    protected void initRegion() throws Exception {
        if (this.isValidateRegion()) {
            return;
        }
        try {
            if (this.mocIndex == null) {
                if (this.isMap()) {
                    this.mocIndex = new HealpixMoc("0/0-11");
                } else {
                    this.loadMocIndex();
                }
            }
        }
        catch (Exception exception) {
            this.mocIndex = new HealpixMoc("0/0-11");
        }
        this.moc = this.mocArea == null ? this.mocIndex : this.mocIndex.intersection(this.mocArea);
        this.setValidateRegion(true);
    }

    protected HealpixMoc getRegion() {
        return this.moc;
    }

    protected void loadMocIndex() throws Exception {
        HealpixMoc healpixMoc = new HealpixMoc();
        healpixMoc.read(this.getHpxFinderPath() + cds.tools.Util.FS + "Moc.fits");
        this.mocIndex = healpixMoc;
    }

    protected void loadMoc() throws Exception {
        HealpixMoc healpixMoc = new HealpixMoc();
        healpixMoc.read(this.getOutputPath() + cds.tools.Util.FS + "Moc.fits");
        this.mocIndex = healpixMoc;
    }

    protected HealpixMoc getMocIndex() {
        return this.mocIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifTileOrder() {
        InputStream inputStream = null;
        boolean bl = false;
        try {
            String string = this.getHpxFinderPath() + cds.tools.Util.FS + "properties";
            MyProperties myProperties = new MyProperties();
            inputStream = new FileInputStream(string);
            myProperties.load(inputStream);
            String string2 = myProperties.getProperty("hips_tile_width");
            int n = string2 != null ? (int)CDSHealpix.log2(Integer.parseInt(string2)) : Integer.parseInt(myProperties.getProperty("tileOrder"));
            if (n != this.getTileOrder()) {
                if (this.tileOrder != -1 && n != this.tileOrder) {
                    this.warning("Uncompatible tileOrder=" + this.tileOrder + " compared to pre-existing survey tileOrder=" + n);
                    boolean bl2 = false;
                    return bl2;
                }
                this.setTileOrder(n);
                int n2 = this.getTileSide();
                this.info("Specifical tileOrder=" + n + " tileSize=" + n2 + "x" + n2);
            }
            bl = true;
        }
        catch (Exception exception) {
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        if (!bl && this.getTileOrder() != 9) {
            this.warning("Uncompatible tileOrder=" + this.getTileOrder() + " compared to default pre-existing survey tileOrder=" + 9);
            return false;
        }
        return true;
    }

    public boolean verifCoherence() {
        int n;
        if (!this.verifTileOrder()) {
            return false;
        }
        if (this.mode == Mode.REPLACETILE) {
            return true;
        }
        if (!this.isColor()) {
            String string = this.getOutputPath() + cds.tools.Util.FS + "Norder3" + cds.tools.Util.FS + "Allsky.fits";
            if (!new File(string).exists()) {
                return true;
            }
            Fits fits = new Fits();
            try {
                fits.loadHeaderFITS(string);
            }
            catch (Exception exception) {
                return true;
            }
            if (fits.bitpix != this.bitpix) {
                this.warning("Uncompatible BITPIX=" + this.bitpix + " compared to pre-existing survey BITPIX=" + fits.bitpix);
                return false;
            }
            boolean bl = Double.isNaN(fits.blank);
            boolean bl2 = Double.isNaN(this.blank);
            if (this.bitpix > 0 && bl) {
                boolean bl3 = bl2 = !Double.isNaN(this.getBlankOrig());
            }
            if (bl != bl2 || !bl2 && fits.blank != this.blank) {
                this.warning("Uncompatible BLANK=" + this.blank + " compared to pre-existing survey BLANK=" + fits.blank);
                return false;
            }
        }
        if ((n = Util.getMaxOrderByPath(this.getOutputPath())) != -1 && n != this.getOrder()) {
            this.warning("Uncompatible order=" + this.getOrder() + " compared to pre-existing survey order=" + n);
            return false;
        }
        return true;
    }

    private double getDefaultBlankFromBitpix(int n) {
        return n < 0 ? Double.NaN : (n == 32 ? -2.147483648E9 : (n == 16 ? -32768.0 : 0.0));
    }

    private int[] parseBorderSize(String string) throws ParseException {
        int[] nArray = new int[]{0, 0, 0, 0};
        try {
            int n;
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,;-");
            for (n = 0; n < 4 && stringTokenizer.hasMoreTokens(); ++n) {
                String string2 = stringTokenizer.nextToken();
                nArray[n] = Integer.parseInt(string2);
                if (n != 0) continue;
                nArray[2] = nArray[1] = nArray[0];
                nArray[3] = nArray[1];
            }
            n = nArray[0];
            nArray[0] = nArray[2];
            nArray[2] = n;
        }
        catch (Exception exception) {
            throw new ParseException("Border error => assume 0", 0);
        }
        return nArray;
    }

    protected boolean isExistingDir() {
        String string = this.getInputPath();
        if (string == null) {
            return false;
        }
        return new File(string).isDirectory();
    }

    protected boolean isExistingAllskyDir() {
        return this.isExistingAllskyDir(this.getOutputPath());
    }

    protected boolean isExistingAllskyDir(String string) {
        if (string == null) {
            return false;
        }
        File file = new File(string);
        if (!file.exists()) {
            return false;
        }
        int n = Util.getMaxOrderByPath(string);
        return n != -1;
    }

    protected boolean hasPropertyFile(String string) {
        File file = new File(string + cds.tools.Util.FS + "properties");
        return file.exists();
    }

    protected boolean isExistingIndexDir() {
        String string = this.getHpxFinderPath();
        if (string == null) {
            return false;
        }
        File file = new File(string);
        if (!file.exists()) {
            return false;
        }
        for (File file2 : file.listFiles()) {
            if (!file2.isDirectory() || !file2.getName().startsWith("Norder")) continue;
            return true;
        }
        return false;
    }

    protected void setMocIndex(HealpixMoc healpixMoc) throws Exception {
        this.mocIndex = healpixMoc;
    }

    protected long getNbLowCells() {
        HealpixMoc healpixMoc;
        int n = this.getOrder();
        if (this.moc == null && this.mocIndex == null || n == -1) {
            return -1L;
        }
        HealpixMoc healpixMoc2 = healpixMoc = this.moc != null ? this.moc : this.mocIndex;
        if (n != healpixMoc.getMocOrder()) {
            healpixMoc = (HealpixMoc)healpixMoc.clone();
            try {
                healpixMoc.setMocOrder(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        long l = healpixMoc.getUsedArea() * (long)this.depth;
        return l;
    }

    protected long getDiskMem() {
        long l = this.getNbLowCells();
        if (l == -1L || this.bitpix == 0) {
            return -1L;
        }
        long l2 = l * (long)this.getTileSide() * (long)this.getTileSide() * (long)(Math.abs(this.bitpix) / 8);
        return l2;
    }

    protected void setProgressLastNorder3(int n) {
        this.lastNorder3 = n;
    }

    protected void showIndexStat(int n, int n2, int n3, long l, long l2, long l3, int n4, int n5, int n6, int n7, long l4) {
        String string;
        if (n == -1) {
            string = "";
        } else {
            String string2 = l4 > 1000L ? "" + cds.tools.Util.round((double)n / ((double)l4 / 1000.0), 1) : "";
            string = n + " file" + (n > 1 ? "s" : "") + " in " + cds.tools.Util.getTemps(l4) + (string2.length() == 0 ? "" : " => " + string2 + "/s") + (n > 0 && n3 == n ? " - all gzipped" : (n3 > 0 ? " (" + n3 + " gzipped)" : "")) + " => " + cds.tools.Util.getUnitDisk(l2).replace("B", "pix") + " using " + cds.tools.Util.getUnitDisk(l) + (n > 1 && l3 < 0L ? "" : " => biggest: [" + n4 + "x" + n5 + (n6 > 1 ? "x" + n6 : "") + " x" + n7 + "]");
        }
        this.stat(string);
    }

    protected void showTilesStat(int n, int n2, long l, int n3, int n4, int n5, long l2, long l3, long l4, long l5, long l6, long l7, long l8) {
        String string;
        String string2;
        if (n3 == 0) {
            return;
        }
        long l9 = this.getNbLowCells();
        long l10 = n3 + n4;
        String string3 = string2 = l9 == -1L ? "" : "/" + l9;
        String string4 = l9 == -1L ? "" : (string = l9 == 0L ? "-" : (double)Math.round((double)l10 / (double)l9 * 1000.0) / 10.0 + "%");
        long l11 = l10 == 0L ? 0L : (l9 == 0L ? 0L : l9 * (l / l10) - l);
        long l12 = l8 * 60000L / l7;
        String string5 = n3 + (n4 == 0 ? "" : "+" + n4) + string2 + " tiles + " + n5 + " nodes in " + cds.tools.Util.getTemps(l, true) + " (" + string + (l12 <= 0L ? "" : " " + l12 + " tiles/mn EndsIn:" + cds.tools.Util.getTemps(l11, true)) + ") " + (n2 == 0 ? "" : "by " + n + "/" + n2 + " threads");
        this.stat(string5);
        if (this.cacheFits != null && this.cacheFits.getStatNbOpen() > 0) {
            this.stat(this.cacheFits + "");
        }
        this.setProgress(n3 + n4, l9);
    }

    protected void showMapStat(long l, long l2, long l3, CacheFits cacheFits, String string) {
        double d = (double)l / (double)l2;
        long l4 = (long)((double)l3 / d);
        long l5 = l4 - l3;
        this.stat(cds.tools.Util.round(d * 100.0, 1) + "% in " + cds.tools.Util.getTemps(l3, true) + " endsIn:" + cds.tools.Util.getTemps(l5, true) + " (record=" + (l + 1L) + "/" + l2 + ")");
        if (cacheFits != null && cacheFits.getStatNbOpen() > 0) {
            this.stat(cacheFits + "");
        }
        this.setProgress(l, l2);
    }

    protected void showJpgStat(int n, long l, int n2, int n3) {
        String string;
        long l2 = this.getNbLowCells();
        double d = l2 <= 0L ? 0.0 : (double)n / (double)l2;
        long l3 = (long)((double)l / d);
        long l4 = l3 - l;
        String string2 = string = l2 == -1L ? "" : (double)Math.round((double)n / (double)l2 * 1000.0) / 10.0 + "%) ";
        String string3 = l2 <= 0L ? n + " tiles in " + cds.tools.Util.getTemps(l, true) : n + "/" + l2 + " tiles in " + cds.tools.Util.getTemps(l, true) + " (" + string + " endsIn:" + cds.tools.Util.getTemps(l4, true) + (n2 == 0 ? "" : " by " + n3 + "/" + n2 + " threads");
        this.stat(string3);
    }

    protected void showMirrorStat(int n, long l, long l2, long l3, int n2, int n3) {
        long l4 = this.getNbLowCells();
        double d = l4 <= 0L ? 0.0 : (double)n / (double)l4;
        long l5 = (long)((double)l3 / d);
        long l6 = l5 - l3;
        String string = l4 == -1L ? "" : (double)Math.round((double)n / (double)l4 * 1000.0) / 10.0 + "%) ";
        String string2 = l3 > 1000L ? cds.tools.Util.getUnitDisk(l / (l3 / 1000L)) + "/s" : "OB/s";
        String string3 = cds.tools.Util.getUnitDisk(l2) + "/s";
        String string4 = l4 <= 0L ? n + " tiles in " + cds.tools.Util.getTemps(l3, true) : n + "/" + l4 + " tiles in " + cds.tools.Util.getTemps(l3, true) + " (" + string + "endsIn:" + cds.tools.Util.getTemps(l6, true) + " speed:" + string3 + " avg:" + string2 + " for " + cds.tools.Util.getUnitDisk(l) + (n2 == 0 ? "" : " by " + n3 + "/" + n2 + " threads");
        this.stat(string4);
    }

    protected void showRGBStat(int n, long l, int n2, int n3) {
        String string;
        long l2 = this.getNbLowCells();
        double d = l2 <= 0L ? 0.0 : (double)n / (double)l2;
        long l3 = (long)((double)l / d);
        long l4 = l3 - l;
        String string2 = string = l2 == -1L ? "" : (double)Math.round((double)n / (double)l2 * 1000.0) / 10.0 + "%) ";
        String string3 = l2 <= 0L ? n + " tiles in " + cds.tools.Util.getTemps(l, true) : n + "/" + l2 + " tiles in " + cds.tools.Util.getTemps(l, true) + " (" + string + " endsIn:" + cds.tools.Util.getTemps(l4, true) + (n2 == 0 ? "" : " by " + n3 + "/" + n2 + " threads");
        this.stat(string3);
    }

    protected boolean isMap() {
        return this.isMap;
    }

    protected void setMap(boolean bl) {
        this.isMap = bl;
    }

    public void setIgnoreStamp(boolean bl) {
        this.ignoreStamp = true;
    }

    public boolean isTaskRunning() {
        return this.taskRunning;
    }

    public void setTaskRunning(boolean bl) {
        if (bl) {
            this.taskAborting = false;
        } else {
            this.progressBar = null;
        }
        this.taskRunning = bl;
        this.resumeWidgets();
    }

    public boolean isTaskPause() {
        return this.taskPause;
    }

    public void setTaskPause(boolean bl) {
        this.taskPause = bl;
        this.resumeWidgets();
    }

    public void taskAbort() {
        this.taskAborting = true;
        this.taskPause = false;
    }

    public boolean isTaskAborting() {
        if (this.taskAborting) {
            return true;
        }
        while (this.taskPause) {
            cds.tools.Util.pause(500);
        }
        return false;
    }

    protected static String getNow() {
        return Constante.getDate();
    }

    static long getTime(String string) throws Exception {
        return DATEFORMAT.parse(string).getTime();
    }

    private static String getKeyActionStart(Action action) {
        return "Processing." + (Object)((Object)action) + ".start";
    }

    private static String getKeyActionEnd(Action action) {
        return "Processing." + (Object)((Object)action) + ".end";
    }

    public void startAction(Action action) throws Exception {
        this.action = action;
        this.action.startTime();
        this.setProgress(0.0, -1.0);
    }

    public void endAction() throws Exception {
        if (this.action == null) {
            return;
        }
        if (this.isTaskAborting()) {
            this.abort((Object)((Object)this.action) + " abort (after " + cds.tools.Util.getTemps(this.action.getDuree()) + ")");
        } else {
            this.done((Object)((Object)this.action) + " done (in " + cds.tools.Util.getTemps(this.action.getDuree()) + ")");
        }
        this.action = null;
    }

    public Action getAction() {
        return this.action;
    }

    public boolean actionAlreadyDone(Action action) {
        if (this.ignoreStamp) {
            return false;
        }
        try {
            if (this.prop == null) {
                this.loadProperties();
            }
            if (this.prop == null) {
                return false;
            }
            String string = this.prop.getProperty(Context.getKeyActionEnd(action));
            if (string == null) {
                return false;
            }
            String string2 = this.prop.getProperty(Context.getKeyActionStart(action));
            if (string2 == null) {
                return false;
            }
            if (Context.getTime(string) < Context.getTime(string2)) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean actionPrecedeAction(Action action, Action action2) {
        if (this.ignoreStamp) {
            return false;
        }
        try {
            if (this.prop == null) {
                this.loadProperties();
            }
            if (this.prop == null) {
                return false;
            }
            if (!this.actionAlreadyDone(action) || !this.actionAlreadyDone(action2)) {
                return false;
            }
            String string = this.prop.getProperty(Context.getKeyActionEnd(action));
            String string2 = this.prop.getProperty(Context.getKeyActionEnd(action2));
            if (Context.getTime(string2) < Context.getTime(string)) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public void setProgress(double d, double d2) {
        this.setProgress(d);
        this.setProgressMax(d2);
    }

    public void setProgress(double d) {
        this.progress = d;
    }

    public void setProgressMax(double d) {
        this.progressMax = d;
    }

    public void progressStatus() {
        System.out.print('.');
        this.flagNL = true;
    }

    public void enableProgress(boolean bl) {
        System.out.println("progress [" + (Object)((Object)this.action) + "] enable=" + bl);
    }

    public void setProgressBar(JProgressBar jProgressBar) {
    }

    public void resumeWidgets() {
    }

    public void trace(int n, String string) {
        if (Aladin.levelTrace >= n) {
            System.out.println(string);
        }
    }

    public void setTrace(int n) {
        Aladin.levelTrace = n;
    }

    public static void setVerbose(boolean bl) {
        verbose = bl;
        BuilderTiles.DEBUG = true;
    }

    public static int getVerbose() {
        return Aladin.levelTrace;
    }

    public static void setVerbose(int n) {
        if (n >= 0) {
            verbose = true;
            Aladin.levelTrace = n;
        } else {
            verbose = false;
            Aladin.levelTrace = 0;
        }
    }

    private void nl() {
        if (this.flagNL) {
            System.out.println();
        }
        this.flagNL = false;
    }

    public void running(String string) {
        this.nl();
        System.out.println("RUN   : ================================ " + string + " ===============================");
    }

    public void done(String string) {
        this.nl();
        System.out.println("DONE  : " + string);
    }

    public void abort(String string) {
        this.nl();
        System.out.println("ABORT : " + string);
    }

    public void info(String string) {
        this.nl();
        System.out.println("INFO  : " + string);
    }

    public void warning(String string) {
        this.nl();
        System.out.println("*WARN*: " + string);
    }

    public void error(String string) {
        this.nl();
        System.out.println("*ERROR: " + string);
    }

    public void action(String string) {
        this.nl();
        System.out.println("ACTION: " + string);
    }

    public void stat(String string) {
        this.nl();
        System.out.println("STAT  : " + string);
    }

    public boolean isValidateOutput() {
        return this.validateOutputDone;
    }

    public void setValidateOutput(boolean bl) {
        this.validateOutputDone = bl;
    }

    public boolean isValidateInput() {
        return this.validateInputDone;
    }

    public void setValidateInput(boolean bl) {
        this.validateInputDone = bl;
    }

    public boolean isValidateCut() {
        return this.validateCutDone;
    }

    public void setValidateCut(boolean bl) {
        this.validateCutDone = bl;
    }

    public boolean isValidateRegion() {
        return this.validateRegion;
    }

    public void setValidateRegion(boolean bl) {
        this.validateRegion = bl;
    }

    protected void setComment(String string) {
        this.setPropriete1("#", "#" + string, false);
    }

    protected void insertPropriete(String string, String string2) {
        this.setPropriete1(string, string2, true);
    }

    protected void setPropriete(String string, String string2) {
        this.setPropriete1(string, string2, false);
    }

    private void setPropriete1(String string, String string2, boolean bl) {
        if (this.keyAddProp == null) {
            this.keyAddProp = new Vector();
            this.valueAddProp = new Vector();
        }
        if (bl) {
            this.keyAddProp.insertElementAt(string, 0);
            this.valueAddProp.insertElementAt(string2, 0);
        } else {
            this.keyAddProp.addElement(string);
            this.valueAddProp.addElement(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeIndexHtml() throws Exception {
        String string;
        String string2;
        int n;
        String string3 = this.getLabel();
        if (string3 == null || string3.length() == 0) {
            string3 = "XXX_" + System.currentTimeMillis() / 1000L;
        }
        if ((n = this.getOrder()) == -1) {
            n = Util.getMaxOrderByPath(this.getOutputPath());
        }
        if (this.moc == null) {
            try {
                this.loadMoc();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.prop == null) {
            this.loadProperties();
        }
        if ((string2 = this.prop.getProperty("hips_frame")) == null) {
            string2 = "galactic";
        }
        long l = CDSHealpix.pow2(n);
        long l2 = CDSHealpix.pow2(n + this.getTileOrder());
        double d = CDSHealpix.pixRes(l2) / 3600.0;
        int n2 = this.getTileSide();
        String string4 = this.getAvailableTileFormats();
        String string5 = string4.indexOf("png") >= 0 ? "png" : "jpg";
        String string6 = this.INDEX.replace("$LABEL", string3);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("   <LI> <B>Label:</B> " + string3 + "\n");
        stringBuilder.append("   <LI> <B>Type:</B> " + (this.depth > 1 ? "HiPS cube (" + this.depth + " frames)" : (this.isColor() ? "colored HiPS image" : "HiPS image")) + "\n");
        stringBuilder.append("   <LI> <B>Best pixel angular resolution:</B> " + Coord.getUnit(d) + "\n");
        stringBuilder.append("   <LI> <B>Max tile order:</B> " + n + " (NSIDE=" + l + ")\n");
        stringBuilder.append("   <LI> <B>Available encoding tiles:</B> " + string4 + "\n");
        stringBuilder.append("   <LI> <B>Tile size:</B> " + n2 + "x" + n2 + "\n");
        if (this.bitpix != 0 && this.bitpix != -1) {
            stringBuilder.append("   <LI> <B>FITS tile BITPIX:</B> " + this.bitpix + "\n");
        }
        stringBuilder.append("   <LI> <B>Processing date:</B> " + Context.getNow() + "\n");
        stringBuilder.append("   <LI> <B>HiPS builder:</B> Aladin/HipsGen v9.033a\n");
        stringBuilder.append("   <LI> <B>Coordinate frame:</B> " + string2 + "\n");
        if (this.moc != null) {
            double d2 = this.moc.getCoverage();
            double d3 = Math.toDegrees(1.0);
            double d4 = Math.PI * 4 * d3 * d3;
            stringBuilder.append("   <LI> <B>Sky area:</B> " + cds.tools.Util.round(d2 * 100.0, 3) + "% of sky => " + Coord.getUnit(d4 * d2, false, true) + "^2\n");
            stringBuilder.append("   <LI> <B>Associated coverage map:</B> <A HREF=\"Moc.fits\">MOC</A>\n");
        }
        if (new File(string = cds.tools.Util.concatDir(this.getHpxFinderPath(), "metadata.xml")).exists()) {
            stringBuilder.append("   <LI> <B>Original data access template:</B> <A HREF=\"HpxFinder/metadata.xml\">metadata.xml</A>\n");
        }
        string6 = string6.replace("$INFO", stringBuilder);
        string6 = string6.replace("$ORDER", n + "");
        string6 = string6.replace("$SYS", string2);
        string6 = string6.replace("$FMT", string5);
        String string7 = this.getOutputPath() + cds.tools.Util.FS + "index.html";
        File file = new File(string7);
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(string6.getBytes());
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    protected void writeMetadataFits() throws Exception {
        Context.writeMetadataFits(this.getOutputPath(), this.header);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeMetadataFits(String string, HeaderFits headerFits) throws Exception {
        if (headerFits == null) {
            return;
        }
        String string2 = string + cds.tools.Util.FS + "metadata.txt";
        File file = new File(string2);
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(headerFits.getOriginalHeaderFits().getBytes());
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    protected void writeMetaFile() throws Exception {
        this.writePropertiesFile(null);
        this.writeIndexHtml();
        this.writeMetadataFits();
    }

    protected void writePropertiesFile(OutputStream outputStream) throws Exception {
        double d;
        Object object;
        int n;
        if (this.hipsId == null) {
            this.setHipsId(null);
        }
        if ((n = this.getOrder()) == -1) {
            n = Util.getMaxOrderByPath(this.getOutputPath());
        }
        this.insertPropriete("creator_did", this.hipsId);
        if (this.creator != null) {
            this.setPropriete("hips_creator", this.creator);
        } else {
            this.setPropriete("#hips_creator", "HiPS creator (institute or person)");
        }
        this.setPropriete("#hips_copyright", "Copyright mention of the HiPS");
        if (this.addendum_id != null) {
            this.setPropriete("addendum_id", this.addendum_id);
        }
        this.setPropriete("obs_collection", this.getLabel());
        this.setPropriete("#obs_title", "Dataset text title");
        this.setPropriete("#obs_description", "Dataset text description");
        this.setPropriete("#obs_ack", "Acknowledgement mention");
        this.setPropriete("#prov_progenitor", "Provenance of the original data (free text)");
        this.setPropriete("#bib_reference", "Bibcode for bibliographic reference");
        this.setPropriete("#bib_reference_url", "URL to bibliographic reference");
        this.setPropriete("#obs_copyright", "Copyright mention of the original data");
        this.setPropriete("#obs_copyright_url", "URL to copyright page of the original data");
        this.setPropriete("#t_min", "Start time in MJD");
        this.setPropriete("#t_max", "Stop time in MJD");
        this.setPropriete("#obs_regime", "Waveband keyword (Radio Infrared Optical UV X-ray Gamma-ray)");
        this.setPropriete("#em_min", "Start in spectral coordinates in meters");
        this.setPropriete("#em_max", "Stop in spectral coordinates in meters");
        this.setPropriete("hips_builder", "Aladin/HipsGen v9.033a");
        this.setPropriete("hips_version", "1.31");
        this.setPropriete("hips_release_date", Context.getNow());
        this.setPropriete("hips_frame", this.getFrameName());
        this.setPropriete("hips_order", n + "");
        this.setPropriete("hips_tile_width", CDSHealpix.pow2(this.getTileOrder()) + "");
        this.setPropriete("#hips_master_url", "ex: http://yourHipsServer/" + this.label + "");
        this.setPropriete("hips_status", "public master clonableOnce");
        String string = "public";
        String string2 = "clonableOnce";
        if (this.status != null) {
            object = new Tok(this.status);
            while (((Tok)object).hasMoreTokens()) {
                String string3 = ((Tok)object).nextToken().toLowerCase();
                if (string3.equals("private")) {
                    string = "private";
                    continue;
                }
                if (string3.equals("unclonable")) {
                    string = "unclonable";
                    continue;
                }
                if (!string3.equals("clonable")) continue;
                string = "clonable";
            }
        }
        this.setPropriete("hips_status", string + " " + "master" + " " + string2);
        object = this.getAvailableTileFormats();
        if (((String)object).length() > 0) {
            this.setPropriete("hips_tile_format", (String)object);
        }
        if (((String)object).indexOf("fits") >= 0 && this.bitpix != -1) {
            this.setPropriete("hips_pixel_bitpix", this.bitpix + "");
        }
        if (this.cut != null) {
            if (this.cut[0] != 0.0 || this.cut[1] != 0.0) {
                this.setPropriete("hips_pixel_cut", cds.tools.Util.myRound(this.bscale * this.cut[0] + this.bzero) + " " + cds.tools.Util.myRound(this.bscale * this.cut[1] + this.bzero));
            }
            if (this.cut[2] != 0.0 || this.cut[3] != 0.0) {
                this.setPropriete("hips_data_range", cds.tools.Util.myRound(this.bscale * this.cut[2] + this.bzero) + " " + cds.tools.Util.myRound(this.bscale * this.cut[3] + this.bzero));
            }
        }
        if (this.target != null) {
            int n2 = this.target.indexOf(32);
            this.setPropriete("hips_initial_ra", this.target.substring(0, n2));
            this.setPropriete("hips_initial_dec", this.target.substring(n2 + 1));
        }
        if (this.targetRadius != null) {
            this.setPropriete("hips_initial_fov", this.targetRadius);
        }
        double d2 = CDSHealpix.pixRes(CDSHealpix.pow2(n + this.getTileOrder()));
        this.setPropriete("hips_pixel_scale", cds.tools.Util.myRound(d2 / 3600.0));
        if (this.resolution != null) {
            this.setPropriete("s_pixel_scale", this.resolution);
        }
        if (this.depth > 1) {
            this.setPropriete("dataproduct_type", "cube");
            this.setPropriete("hips_cube_depth", this.depth + "");
            this.setPropriete("hips_cube_firstframe", this.depth / 2 + "");
            if (this.isCubeCanal()) {
                this.setPropriete("data_cube_crpix3", this.crpix3 + "");
                this.setPropriete("data_cube_crval3", this.crval3 + "");
                this.setPropriete("data_cube_cdelt3", this.cdelt3 + "");
                this.setPropriete("data_cube_bunit3", this.bunit3 + "");
            }
        } else {
            this.setPropriete("dataproduct_type", "image");
        }
        this.setPropriete("dataproduct_subtype", this.live ? "live" : null);
        if (this.isColor()) {
            this.setPropriete("dataproduct_subtype", this.live ? "color live" : "color");
            if (this.redInfo != null) {
                this.setPropriete("hips_rgb_red", this.redInfo);
            }
            if (this.greenInfo != null) {
                this.setPropriete("hips_rgb_green", this.greenInfo);
            }
            if (this.blueInfo != null) {
                this.setPropriete("hips_rgb_blue", this.blueInfo);
            }
        }
        HealpixMoc healpixMoc = this.moc != null ? this.moc : this.mocIndex;
        double d3 = d = healpixMoc == null ? 0.0 : healpixMoc.getCoverage();
        if (d > 0.0) {
            this.setPropriete("moc_sky_fraction", cds.tools.Util.myRound(d));
            long l = (long)Math.abs(this.bitpix / 8) * CDSHealpix.pow2(this.getTileOrder()) * CDSHealpix.pow2(this.getTileOrder()) + 2048L;
            long l2 = 70000L;
            long l3 = 100000L;
            double d4 = healpixMoc.getCoverage();
            long l4 = CDSHealpix.pow2(n) * CDSHealpix.pow2(n) * 12L;
            long l5 = (long)((double)(l * l4) * 1.3 * d4) / 1024L;
            long l6 = (long)((double)(l2 * l4) * 1.3 * d4) / 1024L;
            long l7 = (long)((double)(l3 * l4) * 1.3 * d4) / 1024L;
            long l8 = (((String)object).indexOf("fits") >= 0 ? l5 : 0L) + (((String)object).indexOf("jpeg") >= 0 ? l6 : 0L) + (((String)object).indexOf("png") >= 0 ? l7 : 0L) + 8L;
            this.setPropriete("hips_estsize", l8 + "");
        }
        String[] stringArray = new String[this.keyAddProp == null ? 0 : this.keyAddProp.size()];
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.keyAddProp.get(i);
            stringArray2[i] = this.valueAddProp.get(i);
        }
        this.updateProperties(stringArray, stringArray2, true, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeHpxFinderProperties() throws Exception {
        if (this.hipsId == null) {
            this.setHipsId(null);
        }
        MyProperties myProperties = new MyProperties();
        String string = this.getLabel() + "-meta";
        String string2 = this.getHipsId() + "/meta";
        int n = string2.indexOf(47);
        if (n == -1) {
            myProperties.setProperty("obs_id", string2);
        } else {
            myProperties.setProperty("obs_id", string2.substring(n + 1));
            myProperties.setProperty("publisher_id", "ivo://" + string2.substring(0, n));
        }
        myProperties.setProperty("obs_collection", string);
        myProperties.setProperty("dataproduct_type", "meta");
        myProperties.setProperty("hips_frame", this.getFrameName());
        myProperties.setProperty("hips_order", this.getOrder() + "");
        if (this.minOrder > 3) {
            myProperties.setProperty("hips_order_min", this.minOrder + "");
        }
        myProperties.setProperty("hips_release_date", Context.getNow());
        myProperties.setProperty("hips_version", "1.31");
        myProperties.setProperty("hips_builder", "Aladin/HipsGen v9.033a");
        myProperties.add("#", "#____FOR_COMPATIBILITY_WITH_OLD_HIPS_CLIENTS____");
        myProperties.add("label", string);
        myProperties.add("coordsys", this.getFrameCode());
        myProperties.add("maxOrder", myProperties.getProperty("hips_order"));
        if (this.minOrder > 3) {
            myProperties.add("minOrder", this.minOrder + "");
        }
        myProperties.add("hips_tile_width", CDSHealpix.pow2(this.getTileOrder()) + "");
        String string3 = this.getHpxFinderPath() + cds.tools.Util.FS + "properties";
        File file = new File(string3);
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            myProperties.store(fileOutputStream, null);
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    protected String getAvailableTileFormats() {
        String string = BuilderAllsky.getFileName(this.getOutputPath(), 3, 0);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < Constante.TILE_EXTENSION.length; ++i) {
            File file = new File(string + Constante.TILE_EXTENSION[i]);
            if (!file.exists()) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(Constante.TILE_MODE[i]);
        }
        return stringBuffer.toString();
    }

    private void replaceKey(MyProperties myProperties, String string, String string2) {
        if (myProperties.getProperty(string2) == null) {
            myProperties.replaceKey(string, string2);
        }
    }

    private void replaceKeys(MyProperties myProperties) {
        String string;
        String string2;
        this.replaceKey(myProperties, "hips_publisher", "hips_creator");
        this.replaceKey(myProperties, "HiPSBuilder", "hips_builder");
        this.replaceKey(myProperties, "label", "obs_collection");
        this.replaceKey(myProperties, "description", "obs_title");
        this.replaceKey(myProperties, "verboseDescription", "obs_description");
        this.replaceKey(myProperties, "descriptionVerbose", "obs_description");
        this.replaceKey(myProperties, "acknowledgement", "obs_ack");
        this.replaceKey(myProperties, "copyright", "obs_copyright");
        this.replaceKey(myProperties, "copyrightUrl", "obs_copyright_url");
        this.replaceKey(myProperties, "cubeDepth", "hips_cube_depth");
        this.replaceKey(myProperties, "cubeFirstFrame", "hips_cube_firstframe");
        this.replaceKey(myProperties, "processingDate", "hips_release_date");
        this.replaceKey(myProperties, "pixelRange", "hips_data_range");
        this.replaceKey(myProperties, "pixelCut", "hips_pixel_cut");
        this.replaceKey(myProperties, "maxOrder", "hips_order");
        this.replaceKey(myProperties, "minOrder", "hips_order_min");
        this.replaceKey(myProperties, "format", "hips_tile_format");
        this.replaceKey(myProperties, "nside", "hips_tile_width");
        this.replaceKey(myProperties, "category", "client_category");
        this.replaceKey(myProperties, "red", "hips_rgb_red");
        this.replaceKey(myProperties, "green", "hips_rgb_green");
        this.replaceKey(myProperties, "blue", "hips_rgb_blue");
        if (myProperties.getProperty("creator_did") == null) {
            string2 = myProperties.getProperty("publisher_did");
            if (string2 != null) {
                myProperties.insert("creator_did", string2);
            } else {
                string2 = myProperties.getProperty("creator_id");
                if (string2 == null) {
                    string2 = myProperties.getProperty("publisher_id");
                }
                if (string2 == null) {
                    string2 = "ivo://UNK.AUT";
                }
                if ((string = myProperties.getProperty("obs_id")) != null) {
                    String string3 = string2 + "?" + string;
                    myProperties.insert("creator_did", string3);
                }
            }
        }
        myProperties.remove("publisher_did");
        myProperties.remove("publisher_id");
        string2 = myProperties.getProperty("firstProcessingDate");
        if (string2 != null && myProperties.getProperty("hips_creation_date") == null) {
            try {
                string = Constante.sdf.format(HipsGen.SDF.parse(string2)) + "Z";
                myProperties.replaceKey("firstProcessingDate", "hips_creation_date");
                myProperties.replaceValue("hips_creation_date", string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if ((string2 = myProperties.getProperty("processingDate")) != null && myProperties.getProperty("hips_release_date") == null) {
            try {
                string = Constante.sdf.format(HipsGen.SDF.parse(string2)) + "Z";
                myProperties.replaceKey("processingDate", "hips_release_date");
                myProperties.replaceValue("hips_release_date", string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if ((string2 = myProperties.getProperty("coordsys")) != null && myProperties.getProperty("hips_frame") == null) {
            string = Context.getCanonicalFrameName(string2);
            myProperties.setProperty("hips_frame", string);
        }
        if ((string2 = myProperties.getProperty("target")) != null) {
            int n = string2.indexOf(32);
            myProperties.setProperty("hips_initial_ra", string2.substring(0, n));
            myProperties.setProperty("hips_initial_dec", string2.substring(n + 1));
            myProperties.remove("target");
        }
        if ((string2 = myProperties.getProperty("targetRadius")) != null) {
            myProperties.replaceKey("targetRadius", "hips_initial_fov");
        }
        if ((string2 = myProperties.getProperty("isColored")) != null && string2.equals("true") && myProperties.getProperty("dataproduct_subtype") == null) {
            myProperties.setProperty("dataproduct_subtype", "color");
        }
        if ((string2 = myProperties.getProperty("isCatalog")) != null && string2.equals("true") && myProperties.getProperty("dataproduct_type") == null) {
            myProperties.setProperty("dataproduct_type", "catalog");
        }
        if ((string2 = myProperties.getProperty("isCube")) != null && string2.equals("true") && myProperties.getProperty("dataproduct_type") == null) {
            myProperties.setProperty("dataproduct_type", "cube");
        }
        myProperties.remove("aladinVersion");
    }

    protected void updateProperties(String[] stringArray, String[] stringArray2, boolean bl) throws Exception {
        this.updateProperties(stringArray, stringArray2, bl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateProperties(String[] stringArray, String[] stringArray2, boolean bl, OutputStream outputStream) throws Exception {
        block30: {
            this.waitingPropertieFile();
            try {
                File file;
                int n;
                Object object;
                String string = this.getOutputPath() + cds.tools.Util.FS + "properties";
                this.prop = new MyProperties();
                File file2 = new File(string);
                if (file2.exists()) {
                    if (!file2.canRead()) {
                        throw new Exception("Propertie file not available ! [" + string + "]");
                    }
                    object = new FileInputStream(string);
                    this.prop.load((InputStream)object);
                    ((FileInputStream)object).close();
                }
                this.replaceKeys(this.prop);
                for (n = 0; n < stringArray.length; ++n) {
                    if (stringArray[n].equals("hips_release_date") && this.prop.getProperty("hips_creation_date") == null && (object = this.prop.getProperty("hips_release_date")) != null) {
                        this.prop.setProperty("hips_creation_date", (String)object);
                    }
                    if (stringArray[n].charAt(0) == '#' && this.prop.getProperty(stringArray[n].substring(1)) != null) continue;
                    if (bl) {
                        if (stringArray2[n] == null) {
                            this.prop.remove(stringArray[n]);
                        } else if (stringArray2[n] != null) {
                            this.prop.setProperty(stringArray[n], stringArray2[n]);
                        }
                    } else {
                        object = this.prop.getProperty(stringArray[n]);
                        if (object == null && stringArray2[n] != null) {
                            this.prop.setProperty(stringArray[n], stringArray2[n]);
                        }
                    }
                    if (stringArray2[n] == null || stringArray[n].charAt(0) == '#' || this.prop.getProperty("#" + stringArray[n]) == null) continue;
                    this.prop.remove("#" + stringArray[n]);
                }
                if (this.scriptCommand != null) {
                    n = 0;
                    while (this.prop.getProperty("hipsgen_params" + (n == 0 ? "" : "_" + n)) != null) {
                        ++n;
                    }
                    this.prop.add("hipsgen_date" + (n == 0 ? "" : "_" + n), Context.getNow());
                    this.prop.add("hipsgen_params" + (n == 0 ? "" : "_" + n), this.scriptCommand);
                }
                this.prop.add("#", "#____FOR_COMPATIBILITY_WITH_OLD_HIPS_CLIENTS____");
                this.prop.add("label", this.getLabel());
                this.prop.add("coordsys", this.getFrameCode());
                this.prop.add("maxOrder", this.prop.getProperty("hips_order"));
                String string2 = this.getAvailableTileFormats();
                if (string2.length() > 0) {
                    this.prop.add("format", string2);
                }
                if (string2.indexOf("fits") >= 0 && this.cut != null) {
                    if (this.cut[0] != 0.0 || this.cut[1] != 0.0) {
                        this.prop.add("pixelCut", cds.tools.Util.myRound(this.bscale * this.cut[0] + this.bzero) + " " + cds.tools.Util.myRound(this.bscale * this.cut[1] + this.bzero));
                    }
                    if (this.cut[2] != 0.0 || this.cut[3] != 0.0) {
                        this.prop.add("pixelRange", cds.tools.Util.myRound(this.bscale * this.cut[2] + this.bzero) + " " + cds.tools.Util.myRound(this.bscale * this.cut[3] + this.bzero));
                    }
                }
                if (this.isColor()) {
                    this.prop.add("isColored", "true");
                }
                if (this.isCube()) {
                    this.prop.add("isCube", "true");
                    this.prop.add("cubeDepth", this.depth + "");
                }
                if (outputStream != null) {
                    this.prop.store(outputStream, null);
                    break block30;
                }
                String string3 = this.getOutputPath() + cds.tools.Util.FS + "properties" + ".tmp";
                File file3 = new File(string3);
                if (file3.exists()) {
                    file3.delete();
                }
                if (!(file = new File(this.getOutputPath())).exists() && !file.mkdir()) {
                    throw new Exception("Cannot create output directory");
                }
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(file3);
                    this.prop.store(fileOutputStream, null);
                }
                finally {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                if (file2.exists() && !file2.delete()) {
                    throw new Exception("Propertie file locked ! (cannot delete)");
                }
                if (!file3.renameTo(new File(string))) {
                    throw new Exception("Propertie file locked ! (cannot rename)");
                }
            }
            finally {
                this.releasePropertieFile();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadProperties() throws Exception {
        this.waitingPropertieFile();
        try {
            String string = this.getOutputPath() + cds.tools.Util.FS + "properties";
            this.prop = new MyProperties();
            File file = new File(string);
            if (file.exists()) {
                if (!file.canRead()) {
                    throw new Exception("Propertie file not available ! [" + string + "]");
                }
                FileInputStream fileInputStream = new FileInputStream(string);
                this.prop.load(fileInputStream);
                fileInputStream.close();
                this.replaceKeys(this.prop);
            }
        }
        finally {
            this.releasePropertieFile();
        }
    }

    private void waitingPropertieFile() {
        while (!this.getLock()) {
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void releasePropertieFile() {
        this.lock = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getLock() {
        Object object = this.lockObj;
        synchronized (object) {
            if (this.lock) {
                return false;
            }
            this.lock = true;
            return true;
        }
    }

    protected double[] gal2ICRSIfRequired(double d, double d2) {
        return this.gal2ICRSIfRequired(new double[]{d, d2});
    }

    protected double[] gal2ICRSIfRequired(double[] dArray) {
        if (this.getFrame() == 0) {
            return dArray;
        }
        Astrocoo astrocoo = (Astrocoo)COO_GAL.clone();
        astrocoo.set(dArray[0], dArray[1]);
        astrocoo.convertTo(AF_ICRS1);
        dArray[0] = astrocoo.getLon();
        dArray[1] = astrocoo.getLat();
        return dArray;
    }

    protected double[] ICRS2galIfRequired(double d, double d2) {
        return this.ICRS2galIfRequired(new double[]{d, d2});
    }

    protected double[] ICRS2galIfRequired(double[] dArray) {
        if (this.getFrame() == 0) {
            return dArray;
        }
        Astrocoo astrocoo = (Astrocoo)COO_EQU.clone();
        astrocoo.set(dArray[0], dArray[1]);
        astrocoo.convertTo(AF_GAL1);
        dArray[0] = astrocoo.getLon();
        dArray[1] = astrocoo.getLat();
        return dArray;
    }

    private void fillUp(int[] nArray, int n, int[] nArray2) {
        int n2;
        int n3 = n * n;
        int[][] nArray3 = new int[4][n3 / 4];
        int[] nArray4 = new int[4];
        for (n2 = 0; n2 < n3; ++n2) {
            int n4 = n2 % n < n / 2 ? 0 : 1;
            int n5 = n2 < n3 / 2 ? 1 : 0;
            int n6 = n4 << 1 | n5;
            int n7 = nArray2 == null ? n2 : nArray2[n2];
            nArray[n7] = nArray[n7] << 2 | n6;
            int n8 = n6;
            int n9 = nArray4[n8];
            nArray4[n8] = n9 + 1;
            nArray3[n6][n9] = n7;
        }
        if (n3 > 4) {
            for (n2 = 0; n2 < 4; ++n2) {
                this.fillUp(nArray, n / 2, nArray3[n2]);
            }
        }
    }

    public void createHealpixOrder(int n) {
        int n2 = (int)CDSHealpix.pow2(n);
        if (this.xy2hpx != null && this.xy2hpx.length == n2 * n2) {
            return;
        }
        this.xy2hpx = new int[n2 * n2];
        this.hpx2xy = new int[n2 * n2];
        this.fillUp(this.xy2hpx, n2, null);
        for (int i = 0; i < this.xy2hpx.length; ++i) {
            this.hpx2xy[this.xy2hpx[i]] = i;
        }
    }

    public final int xy2hpx(int n) {
        return this.xy2hpx[n];
    }

    public final int hpx2xy(int n) {
        return this.hpx2xy[n];
    }

    public long getMem() {
        return Runtime.getRuntime().maxMemory() - (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
    }

    protected void updateHeader(Fits fits, int n, long l) {
        if (fits.headerFits == null) {
            return;
        }
        if (this.creator != null) {
            fits.headerFits.setKeyValue("ORIGIN", this.creator);
        }
        fits.headerFits.setKeyValue("CPYRIGHT", "See HiPS properties file");
        fits.headerFits.setKeyValue("COMMENT", "HiPS FITS tile generated by Aladin/Hipsgen v9.033a");
        fits.headerFits.setKeyValue("ORDER", "" + n);
        fits.headerFits.setKeyValue("NPIX", "" + l);
    }

    static {
        DATEFORMAT = new SimpleDateFormat("dd/MM/yy HH:mm:ss");
        COO_GAL = new Astrocoo(new Galactic());
        COO_EQU = new Astrocoo(new ICRS());
        AF_GAL1 = new Galactic();
        AF_ICRS1 = new ICRS();
    }

    protected static enum JpegMethod {
        MEDIAN,
        MEAN,
        FIRST;

    }
}

