/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.PlanBG;
import cds.aladin.PlanImage;
import cds.aladin.TreeNodeAllsky;
import cds.allsky.Action;
import cds.allsky.BuilderAllsky;
import cds.allsky.Context;
import cds.allsky.MainPanel;
import cds.allsky.TransfertFct;
import cds.fits.CacheFits;
import cds.tools.pixtools.CDSHealpix;
import cds.tools.pixtools.Util;
import java.io.File;
import java.text.ParseException;
import javax.swing.JProgressBar;

public class ContextGui
extends Context {
    protected MainPanel mainPanel;
    private int lastShowAllSkyNorder3 = -1;
    private PreviewThread previewThread = null;

    public void setMainPanel(MainPanel mainPanel) {
        this.mainPanel = mainPanel;
    }

    @Override
    public int[] getBorderSize() {
        try {
            this.setBorderSize(this.mainPanel.tabDesc.getBorderSize().trim());
        }
        catch (ParseException parseException) {
            this.mainPanel.tabDesc.borderTextField.setText("Border error => assume 0");
            parseException.printStackTrace();
        }
        return this.borderSize;
    }

    @Override
    public void setOrder(int n) {
        this.mainPanel.tabBuild.setOrder(n);
    }

    @Override
    public int getOrder() {
        return this.mainPanel.tabBuild.getOrder();
    }

    @Override
    protected void showIndexStat(int n, int n2, int n3, long l, long l2, long l3, int n4, int n5, int n6, int n7, long l4) {
        this.mainPanel.tabBuild.buildProgressPanel.setSrcStat(n, n3, l, l3, n4, n6, n5, n7);
    }

    @Override
    protected void showTilesStat(int n, int n2, long l, int n3, int n4, int n5, long l2, long l3, long l4, long l5, long l6, long l7, long l8) {
        if (n3 == 0) {
            return;
        }
        int n6 = this.getTileSide();
        this.mainPanel.tabBuild.buildProgressPanel.setMemStat(n, n2, this.cacheFits);
        long l9 = this.getNbLowCells();
        this.mainPanel.tabBuild.buildProgressPanel.setLowTileStat(n3, n4, l9, n6 * n6 * this.getNpix(), l2, l3, l4);
        this.mainPanel.tabBuild.buildProgressPanel.setNodeTileStat(n5, n6 * n6 * this.getNpix(), l5);
        long l10 = this.getNbLowCells();
        long l11 = n3 + n4;
        long l12 = l11 == 0L ? 0L : (l10 == 0L ? 0L : l10 * (l / l11) - l);
        long l13 = l8 * 60000L / l7;
        this.mainPanel.tabBuild.buildProgressPanel.setTimeStat(l, l13, l12);
        this.setProgress(n3 + n4, l9);
    }

    @Override
    protected void showMapStat(long l, long l2, long l3, CacheFits cacheFits, String string) {
        double d = (double)l / (double)l2;
        long l4 = d == 0.0 ? 0L : (long)((double)l3 / d);
        long l5 = l4 == 0L ? 0L : l4 - l3;
        String string2 = cds.tools.Util.round(d * 100.0, 1) + "% in " + cds.tools.Util.getTemps(l3, true);
        if (l5 > 0L) {
            string2 = string2 + " ends n=" + cds.tools.Util.getTemps(l5, true);
        }
        this.mainPanel.tabBuild.buildProgressPanel.setTimeStat(string2);
        string2 = "Records: " + l + " / " + l2;
        this.mainPanel.tabBuild.buildProgressPanel.setLowTileStat(string2);
        this.mainPanel.tabBuild.buildProgressPanel.setMemStat(1, 1, cacheFits);
        this.mainPanel.tabBuild.buildProgressPanel.srcFileStat(string);
        this.setProgress(l, l2);
    }

    @Override
    protected void showJpgStat(int n, long l, int n2, int n3) {
        long l2 = this.getNbLowCells();
        long l3 = l2 == 0L ? 0L : (n == 0 ? 0L : l2 * (l / (long)n) - l);
        String string = n + " / " + l2 + " tiles";
        String string2 = cds.tools.Util.getTemps(l, true);
        if (l3 > 0L) {
            string2 = string2 + " - ends in " + cds.tools.Util.getTemps(l3, true);
        }
        this.mainPanel.tabJpg.setStat(string, string2);
        this.setProgress(n, l2);
    }

    @Override
    protected void showRGBStat(int n, long l, int n2, int n3) {
        long l2 = this.getNbLowCells();
        long l3 = l2 == 0L ? 0L : (n == 0 ? 0L : l2 * (l / (long)n) - l);
        String string = n + " / " + l2 + " tiles";
        String string2 = cds.tools.Util.getTemps(l, true);
        if (l3 > 0L) {
            string2 = string2 + " - ends in " + cds.tools.Util.getTemps(l3, true);
        }
        this.mainPanel.tabRgb.setStat(string, string2);
        this.setProgress(n, l2);
    }

    public void updateHipsPreview(boolean bl) {
        if (!bl) {
            if (this.previewThread != null) {
                return;
            }
            if (this.lastShowAllSkyNorder3 == this.lastNorder3) {
                return;
            }
        }
        this.lastShowAllSkyNorder3 = this.lastNorder3;
        if (this.previewThread != null) {
            this.previewThread.abort();
            this.previewThread = null;
        }
        this.previewThread = new PreviewThread(this);
        this.previewThread.start();
    }

    @Override
    public void progressStatus() {
        if (this.progressBar == null) {
            super.progressStatus();
            return;
        }
        if (this.progressMax <= 0.0) {
            this.progressBar.setIndeterminate(true);
            this.progressBar.setValue((int)this.progress);
        } else {
            this.progressBar.setIndeterminate(false);
            this.progressBar.setMaximum((int)this.progressMax);
            this.progressBar.setValue((int)this.progress);
        }
        if ((this.action == Action.TILES || this.action == Action.JPEG || this.action == Action.PNG || this.action == Action.RGB) && this.lastNorder3 >= 0) {
            this.updateHipsPreview(false);
        }
    }

    @Override
    public void endAction() throws Exception {
        if (this.progressBar != null) {
            this.progressBar.setIndeterminate(false);
            this.progressBar.setMaximum(100);
            this.progressBar.setValue(100);
            if (this.action == null) {
                this.progressBar.setString("Already done !");
            } else if (this.taskAborting) {
                this.progressBar.setString("Aborted !");
            } else {
                this.progressBar.setString("Done !");
            }
        }
        if ((this.action == Action.TILES || this.action == Action.MAPTILES || this.action == Action.JPEG || this.action == Action.PNG || this.action == Action.RGB) && this.lastNorder3 >= 0) {
            this.updateHipsPreview(true);
        }
        if (this.action == Action.INDEX) {
            this.mainPanel.tabBuild.resumeWidgets();
        }
        super.endAction();
    }

    @Override
    public void setTaskPause(boolean bl) {
        super.setTaskPause(bl);
        if (this.progressBar != null) {
            if (bl) {
                this.progressBar.setIndeterminate(true);
                this.progressBar.setString("pause");
            } else {
                this.progressBar.setIndeterminate(false);
                this.progressBar.setString(null);
            }
        }
    }

    @Override
    public void enableProgress(boolean bl) {
        if (this.progressBar == null) {
            super.enableProgress(bl);
        } else {
            this.progressBar.setEnabled(bl);
        }
    }

    @Override
    public void resumeWidgets() {
        this.mainPanel.resumeWidgets();
    }

    @Override
    public void setProgressBar(JProgressBar jProgressBar) {
        this.progressBar = jProgressBar;
        this.progressBar.setString(null);
    }

    public void setRgbOutput(String string) {
        this.outputRGB = string;
    }

    public void setRgbMethod(Context.JpegMethod jpegMethod) {
        this.methodRgb = jpegMethod;
    }

    @Override
    public String getRgbOutput() {
        return this.outputRGB;
    }

    @Override
    public Context.JpegMethod getRgbMethod() {
        return this.methodRgb;
    }

    public void setRgbFormat(int n) {
        this.targetColorMode = n;
    }

    @Override
    public String getInputPath() {
        return this.mainPanel.tabDesc.getInputField();
    }

    @Override
    public String getOutputPath() {
        return this.mainPanel.tabDesc.getOutputField();
    }

    @Override
    public void setOutputPath(String string) {
        this.mainPanel.tabDesc.setOutputField(string);
    }

    @Override
    public int getBitpixOrig() {
        return this.mainPanel.tabBuild.getOriginalBitpixField();
    }

    @Override
    public int getBitpix() {
        return this.mainPanel.tabBuild.getBitpixField();
    }

    @Override
    public double getBlankOrig() {
        double d = Double.NaN;
        this.hasAlternateBlank = false;
        String string = "";
        try {
            string = this.mainPanel.tabDesc.getBlank().trim();
            if (string.length() > 0) {
                d = Double.parseDouble(string);
                this.hasAlternateBlank = true;
            }
        }
        catch (Exception exception) {
            this.mainPanel.tabDesc.blankTextField.setText("Unknown value => [" + string + "]");
        }
        return d;
    }

    @Override
    public int[] getHDU() {
        String string = "";
        try {
            string = this.mainPanel.tabDesc.getHDU().trim();
            this.hdu = ContextGui.parseHDU(string);
        }
        catch (Exception exception) {
            this.mainPanel.tabDesc.blankTextField.setText("Syntax error => [" + string + "]");
        }
        return this.hdu;
    }

    @Override
    public void initParameters() throws Exception {
        this.setMocArea(this.mainPanel.tabDesc.getMocField().trim());
        this.setMode(this.mainPanel.tabDesc.getCoaddModeField());
        this.setSkyValName(this.mainPanel.tabDesc.getSkyvalField());
        super.initParameters();
    }

    @Override
    public String getSkyval() {
        this.skyvalName = this.mainPanel.tabDesc.getSkyvalField().toUpperCase();
        return this.skyvalName;
    }

    @Override
    public String getLabel() {
        return this.mainPanel.tabDesc.getLabelField();
    }

    @Override
    public TransfertFct getFct() throws Exception {
        if (this.mainPanel.tabJpg.isCutFromPlanBase()) {
            PlanImage planImage = (PlanImage)this.mainPanel.aladin.calque.getPlanBase();
            return TransfertFct.getFromCode(planImage.transfertFct);
        }
        return super.getFct();
    }

    @Override
    public double[] getPixelRangeCut() throws Exception {
        double[] dArray = new double[5];
        for (int i = 0; i < 4; ++i) {
            dArray[i] = Double.NaN;
        }
        if (this.mainPanel.tabJpg.isCutFromPlanBase()) {
            PlanImage planImage = (PlanImage)this.mainPanel.aladin.calque.getPlanBase();
            dArray[0] = planImage.getCutMin() * planImage.bScale + planImage.bZero;
            dArray[1] = planImage.getCutMax() * planImage.bScale + planImage.bZero;
        } else {
            String string = this.mainPanel.tabJpg.getCutMin();
            String string2 = this.mainPanel.tabJpg.getCutMax();
            try {
                dArray[0] = Double.parseDouble(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                dArray[1] = Double.parseDouble(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dArray;
    }

    @Override
    public void setCutOrig(double[] dArray) {
        super.setCutOrig(dArray);
        this.mainPanel.tabJpg.setCutMin(cds.tools.Util.myRound(dArray[0] * this.bScaleOrig + this.bZeroOrig));
        this.mainPanel.tabJpg.setCutMax(cds.tools.Util.myRound(dArray[1] * this.bScaleOrig + this.bZeroOrig));
    }

    @Override
    public void running(String string) {
        this.trace(3, "RUN   : " + string);
    }

    public void nldone(String string) {
        this.trace(3, "DONE  : " + string);
    }

    @Override
    public void done(String string) {
        this.trace(3, "DONE  : " + string);
    }

    @Override
    public void info(String string) {
        this.trace(3, "INFO  : " + string);
    }

    @Override
    public void warning(String string) {
        Aladin cfr_ignored_0 = this.mainPanel.aladin;
        Aladin.warning(this.mainPanel, string);
        this.trace(3, "WARN  : " + string);
    }

    @Override
    public void error(String string) {
        Aladin cfr_ignored_0 = this.mainPanel.aladin;
        Aladin.warning(this.mainPanel, string);
        this.trace(3, "ERROR : " + string);
    }

    @Override
    public void action(String string) {
        this.trace(3, "ACTION: " + string);
    }

    public void nlstat(String string) {
        this.trace(3, "STAT  : " + string);
    }

    @Override
    public void trace(int n, String string) {
        Aladin.trace(n, string);
    }

    class PreviewThread
    extends Thread {
        Context context;
        BuilderAllsky builder = null;

        PreviewThread(Context context) {
            this.context = context;
        }

        protected void abort() {
            this.builder.abort();
        }

        @Override
        public void run() {
            try {
                String string = ContextGui.this.getOutputPath() + cds.tools.Util.FS + "Norder3";
                if (!ContextGui.this.isExistingAllskyDir() || !new File(string).isDirectory()) {
                    throw new Exception("order3 tiles not found");
                }
                this.builder = new BuilderAllsky(this.context);
                this.builder.run();
                String string2 = ContextGui.this.getLabel();
                if (string2.trim().length() == 0) {
                    string2 = "MySky";
                }
                int n = ContextGui.this.lastShowAllSkyNorder3 >= 0 ? ContextGui.this.lastShowAllSkyNorder3 : 0;
                ContextGui.this.mainPanel.planPreview = (PlanBG)ContextGui.this.mainPanel.aladin.calque.getPlan(string2);
                if (ContextGui.this.mainPanel.planPreview == null || ContextGui.this.mainPanel.planPreview.isFree() || ContextGui.this.mainPanel.planPreview.hasError()) {
                    double[] dArray = CDSHealpix.pix2ang_nest(Util.nside(3), n);
                    double[] dArray2 = CDSHealpix.polarToRadec(new double[]{dArray[0], dArray[1]});
                    dArray2 = ContextGui.this.gal2ICRSIfRequired(dArray2);
                    TreeNodeAllsky treeNodeAllsky = new TreeNodeAllsky(ContextGui.this.mainPanel.aladin, ContextGui.this.getOutputPath());
                    int n2 = ContextGui.this.mainPanel.aladin.calque.newPlanBG(treeNodeAllsky, ContextGui.this.getOutputPath(), null, "=" + string2, Coord.getSexa(dArray2[0], dArray2[1]), "30");
                    Aladin.trace(4, "ContextGui.preview(): create " + string2);
                    ContextGui.this.mainPanel.planPreview = (PlanBG)ContextGui.this.mainPanel.aladin.calque.getPlan(n2);
                } else {
                    ContextGui.this.mainPanel.planPreview.forceReload();
                    ContextGui.this.mainPanel.aladin.calque.repaintAll();
                    Aladin.trace(4, "ContextGui.preview(): update " + string2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ContextGui.this.previewThread = null;
        }
    }
}

