/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.Aladin;
import cds.aladin.prop.PropPanel;
import cds.allsky.Context;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.RandomAccessFile;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FrameGlu
extends JFrame
implements KeyListener {
    private static final int REQUIRED = 0;
    private static final int LABEL = 1;
    private static final int FIELD = 2;
    private static final int KEY = 3;
    private static final int VALUE = 4;
    private static final int INFO = 5;
    private static String[][] GLUPARAM = new String[][]{{"*", "Survey ID", "Id", "", "", "One word survey identifier (ex: P/DSS/2)"}, {"*", "Name", "Description", "", "", "Survey name (ex: DSS blue"}, {"*", "Url access", "Url", "", "http://...", "Url for accessing the Healpix data (a Healpix FITS file map or a Healpix Aladin directory)"}, {"-", "Category", "Aladin.Tree", "client_category", "Test", "Aladin tree menu category - use / as separator (ex: Image/Test)"}, {"-", "Description", "Description", "obs_title", "", "Short description"}, {"-", "Full descript.", "VerboseDescr", "obs_description", "", "Full data description (can be a long paragraph)"}, {"-", "Web info", "Doc.User", "", "", "Web page describing the data"}, {"-", "Institute", "Institute", "", "", "Institute/origin of the data"}, {"-", "Copyright", "Copyright", "obs_copyright", "", "Copyright mention (ex: (c) Institute of ....)"}, {"-", "Web site", "Copyright.url", "obs_copyright_url", "", "Web link for copyright mention"}};
    private JTextField[] field;
    private Aladin aladin;
    Context context;
    private JButton test;
    private JButton save;

    public FrameGlu(Aladin aladin, Context context) {
        this.aladin = aladin;
        this.context = context;
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)this.getInfo(), "North");
        jPanel.add((Component)this.getForm(), "Center");
        jPanel.add((Component)this.getButton(), "South");
        this.getContentPane().add(jPanel);
        this.pack();
        this.setLocation(200, 200);
        this.setVisible(true);
    }

    private JPanel getInfo() {
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel("<html><center>Fill up these fields and test your survey description<br>in your Aladin session. Since is ok, send the generated parameter GLU file<br>to your collaborators, or even send it to the CDS team in order to offer<br>a full access to your data.</center></html>");
        jPanel.add(jLabel);
        return jPanel;
    }

    private JPanel getButton() {
        JButton jButton;
        JPanel jPanel = new JPanel();
        this.test = jButton = new JButton("Test it locally");
        jButton.setEnabled(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameGlu.this.test();
            }
        });
        this.add(jButton);
        jPanel.add(jButton);
        this.save = jButton = new JButton("Save it (for distributing)");
        jButton.setEnabled(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameGlu.this.save();
            }
        });
        this.add(jButton);
        jPanel.add(jButton);
        return jPanel;
    }

    private JPanel getForm() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.field = new JTextField[GLUPARAM.length];
        for (int i = 0; i < GLUPARAM.length; ++i) {
            JTextField jTextField;
            String[] stringArray = GLUPARAM[i];
            JLabel jLabel = new JLabel(stringArray[1]);
            if (stringArray[0].length() == 0) continue;
            if (stringArray[0].charAt(0) == '*') {
                jLabel.setFont(jLabel.getFont().deriveFont(1));
            }
            String string = stringArray[4];
            if (stringArray[2].equals("Description")) {
                string = this.context.getLabel();
            }
            this.field[i] = jTextField = new JTextField(string);
            jTextField.addKeyListener(this);
            jTextField.setMinimumSize(new Dimension(300, jTextField.getMinimumSize().height));
            jTextField.setPreferredSize(new Dimension(300, jTextField.getPreferredSize().height));
            PropPanel.addCouple(this, jPanel, jLabel, stringArray[5], jTextField, gridBagLayout, gridBagConstraints, 13);
        }
        return jPanel;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.activeButtonIfPossible();
    }

    private void activeButtonIfPossible() {
        boolean bl = this.isReady();
        this.test.setEnabled(bl);
        this.save.setEnabled(bl);
    }

    private boolean isReady() {
        return this.missingField() == -1;
    }

    private int missingField() {
        for (int i = 0; i < GLUPARAM.length; ++i) {
            if (!GLUPARAM[i][0].equals("*") || this.field[i].getText().trim().length() != 0) continue;
            return i;
        }
        return -1;
    }

    private void test() {
        try {
            String string = this.getGluRecord();
            File file = this.aladin.createTempFile("GluHealpix", ".dic");
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.writeBytes(string);
            randomAccessFile.close();
            this.aladin.execCommand("load " + file.getAbsolutePath());
            file.deleteOnExit();
            this.aladin.dialog.show("Allsky");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.updateProperties();
    }

    private void save() {
        String string = this.getGluRecord();
        if (!Aladin.confirmation(this, "Your data corresponds to this following registry description (GLU record) and can be saved on your disk as small text file for distributing to your collaborators.Simply by loading this file in Aladin, your collaborators will immediately see your data and will be able to access them.\n\nYou can also send this file to the CDS team (cds-question@unistra.fr) in order to expose your data to the whole astronomical community:\n \n" + string + "\n \nGenerate this file ?")) {
            return;
        }
        FileDialog fileDialog = new FileDialog((Frame)this.aladin.dialog, "GLU Data record", 1);
        fileDialog.setVisible(true);
        String string2 = fileDialog.getDirectory();
        String string3 = fileDialog.getFile();
        if (string3 == null) {
            return;
        }
        try {
            if (string3.trim().length() == 0) {
                return;
            }
            File file = new File(string2, string3);
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.writeBytes(string);
            randomAccessFile.close();
            Aladin.trace(3, "Glu record Allsky saved [" + file.getAbsolutePath() + "] !");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.updateProperties();
    }

    private void updateProperties() {
        try {
            this.context.writeMetaFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getGluRecord() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.field[0].getText().trim().replace('/', '_');
        stringBuffer.append(Util.align("%ActionName", 15) + " " + string + ".htx" + Util.CR);
        for (int i = 0; i < GLUPARAM.length; ++i) {
            String[] stringArray = GLUPARAM[i];
            String string2 = this.field[i].getText().trim();
            if (string2.length() == 0) continue;
            stringBuffer.append(Util.align("%" + stringArray[2], 15) + " " + string2 + Util.CR);
            if (stringArray[3].length() <= 0) continue;
            this.context.setPropriete(stringArray[3], string2);
        }
        stringBuffer.append(Util.align("%Aladin.XLabel", 15) + " " + this.field[1].getText().trim() + Util.CR);
        stringBuffer.append(Util.align("%Aladin.Profile", 15) + " >6.1" + Util.CR);
        stringBuffer.append(Util.align("%Aladin.HpxParam", 15) + " " + this.getHpxParam() + Util.CR);
        this.context.setPropriete("obs_collection", string);
        return stringBuffer.toString();
    }

    private String getHpxParam() {
        return this.context.getOrder() + " " + this.context.getAvailableTileFormats();
    }
}

