/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.MyInputStream;
import cds.aladin.MyProperties;
import cds.allsky.Action;
import cds.allsky.Context;
import cds.allsky.Mode;
import cds.allsky.Task;
import cds.moc.HealpixMoc;
import cds.tools.Util;
import java.io.File;
import java.io.FileInputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;

public class HipsGen {
    private File file;
    private boolean force = false;
    private boolean flagMode = false;
    private boolean flagConcat = false;
    private boolean flagMirror = false;
    private boolean flagUpdate = false;
    private boolean flagMethod = false;
    private boolean flagRGB = false;
    private boolean flagAbort = false;
    private boolean flagPause = false;
    private boolean flagResume = false;
    public Context context = new Context();
    public String launcher = "Aladin.jar -hipsgen";
    private Vector<Action> actions = new Vector();
    public static SimpleDateFormat SDF = new SimpleDateFormat("dd/MM/yy HH:mm:ss");

    private void parseConfig() throws Exception {
        MyProperties myProperties = new MyProperties();
        FileInputStream fileInputStream = new FileInputStream(this.file);
        myProperties.load(fileInputStream);
        Set<Object> set = myProperties.keySet();
        for (Object object : set) {
            String string = myProperties.getProperty((String)object);
            try {
                this.setContextFromOptions((String)object, string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                break;
            }
        }
        fileInputStream.close();
    }

    private String obsolete(String string) {
        if (string.equalsIgnoreCase("ivorn")) {
            return "id";
        }
        if (string.equalsIgnoreCase("input")) {
            return "in";
        }
        if (string.equalsIgnoreCase("output")) {
            return "out";
        }
        if (string.equalsIgnoreCase("pixel")) {
            return "mode";
        }
        if (string.equalsIgnoreCase("moc")) {
            return "region";
        }
        if (string.equalsIgnoreCase("blocking")) {
            return "partitioning";
        }
        if (string.equalsIgnoreCase("cutting")) {
            return "partitioning";
        }
        if (string.equalsIgnoreCase("polygon")) {
            return "fov";
        }
        if (string.equalsIgnoreCase("jpegMethod")) {
            return "method";
        }
        if (string.equalsIgnoreCase("dataCut")) {
            return "id";
        }
        if (string.equalsIgnoreCase("ivorn")) {
            return "pixelRange";
        }
        if (string.equalsIgnoreCase("histoPercent")) {
            return "skyval";
        }
        if (string.equalsIgnoreCase("publisher")) {
            return "creator";
        }
        return null;
    }

    private void setContextFromOptions(String string, String string2) throws Exception {
        string2 = string2.replace("'", "");
        string2 = string2.replace("\"", "");
        System.out.println("OPTION: " + string + "=" + string2);
        String string3 = this.obsolete(string);
        if (string3 != null) {
            this.context.warning("Obsoleted parameter, prefer \"" + string3 + "\"");
        }
        if (string.equalsIgnoreCase("h")) {
            HipsGen.usage(this.launcher);
        } else if (string.equalsIgnoreCase("verbose")) {
            Context.setVerbose(Integer.parseInt(string2));
        } else if (string.equalsIgnoreCase("blank")) {
            this.context.setBlankOrig(Double.parseDouble(string2));
        } else if (string.equalsIgnoreCase("order")) {
            this.context.setOrder(Integer.parseInt(string2));
        } else if (string.equalsIgnoreCase("minOrder")) {
            this.context.setMinOrder(Integer.parseInt(string2));
        } else if (string.equalsIgnoreCase("mocOrder")) {
            this.context.setMocOrder(Integer.parseInt(string2));
        } else if (string.equalsIgnoreCase("nside")) {
            this.context.setMapNside(Integer.parseInt(string2));
        } else if (string.equalsIgnoreCase("tileOrder")) {
            this.context.setTileOrder(Integer.parseInt(string2));
        } else if (string.equalsIgnoreCase("bitpix")) {
            this.context.setBitpix(Integer.parseInt(string2));
        } else if (string.equalsIgnoreCase("frame")) {
            this.context.setFrameName(string2);
        } else if (string.equalsIgnoreCase("maxThread")) {
            this.context.setMaxNbThread(Integer.parseInt(string2));
        } else if (string.equalsIgnoreCase("skyval")) {
            this.context.setSkyval(string2);
        } else if (string.equalsIgnoreCase("skyvalues")) {
            this.context.setSkyValues(string2);
        } else if (string.equalsIgnoreCase("exptime")) {
            this.context.setExpTime(string2);
        } else if (string.equalsIgnoreCase("fading")) {
            this.context.setFading(string2);
        } else if (string.equalsIgnoreCase("mixing")) {
            this.context.setMixing(string2);
        } else if (string.equalsIgnoreCase("color")) {
            this.context.setColor(string2);
        } else if (string.equalsIgnoreCase("inRed")) {
            this.context.setRgbInput(string2, 0);
            this.flagRGB = true;
        } else if (string.equalsIgnoreCase("inGreen")) {
            this.context.setRgbInput(string2, 1);
            this.flagRGB = true;
        } else if (string.equalsIgnoreCase("inBlue")) {
            this.context.setRgbInput(string2, 2);
            this.flagRGB = true;
        } else if (string.equalsIgnoreCase("cmRed")) {
            this.context.setRgbCmParam(string2, 0);
        } else if (string.equalsIgnoreCase("cmGreen")) {
            this.context.setRgbCmParam(string2, 1);
        } else if (string.equalsIgnoreCase("cmBlue")) {
            this.context.setRgbCmParam(string2, 2);
        } else if (string.equalsIgnoreCase("img")) {
            this.context.setImgEtalon(string2);
        } else if (string.equalsIgnoreCase("fitskeys")) {
            this.context.setIndexFitskey(string2);
        } else if (string.equalsIgnoreCase("status")) {
            this.context.setStatus(string2);
        } else if (string.equalsIgnoreCase("target")) {
            this.context.setTarget(string2);
        } else if (string.equalsIgnoreCase("targetRadius")) {
            this.context.setTargetRadius(string2);
        } else if (string.equalsIgnoreCase("label")) {
            this.context.setLabel(string2);
        } else if (string.equalsIgnoreCase("filter")) {
            this.context.setFilter(string2);
        } else if (string.equalsIgnoreCase("hdu")) {
            this.context.setHDU(string2);
        } else if (string.equalsIgnoreCase("publisher") || string.equalsIgnoreCase("creator")) {
            this.context.setCreator(string2);
        } else if (string.equalsIgnoreCase("ivorn") || string.equalsIgnoreCase("id")) {
            this.context.setHipsId(string2);
        } else if (string.equalsIgnoreCase("debug")) {
            if (Boolean.parseBoolean(string2)) {
                Context.setVerbose(4);
            }
        } else if (string.equalsIgnoreCase("in") || string.equalsIgnoreCase("input")) {
            this.context.setInputPath(string2);
        } else if (string.equalsIgnoreCase("out") || string.equalsIgnoreCase("output")) {
            this.context.setOutputPath(string2);
        } else if (string.equalsIgnoreCase("mode") || string.equalsIgnoreCase("pixel")) {
            this.context.setMode(Mode.valueOf(string2.toUpperCase()));
            this.flagMode = true;
        } else if (string.equalsIgnoreCase("region") || string.equalsIgnoreCase("moc")) {
            if (string2.endsWith("fits")) {
                HealpixMoc healpixMoc = new HealpixMoc();
                healpixMoc.read(string2);
                this.context.setMocArea(healpixMoc);
            } else {
                this.context.setMocArea(string2);
            }
        } else if (string.equalsIgnoreCase("blocking") || string.equalsIgnoreCase("cutting") || string.equalsIgnoreCase("partitioning")) {
            this.context.setPartitioning(string2);
        } else if (string.equalsIgnoreCase("tileTypes")) {
            this.context.setTileTypes(string2);
        } else if (string.equalsIgnoreCase("shape")) {
            this.context.setShape(string2);
        } else if (string.equalsIgnoreCase("maxRatio")) {
            try {
                this.context.setMaxRatio(string2);
            }
            catch (ParseException parseException) {
                throw new Exception(parseException.getMessage());
            }
        } else if (string.equalsIgnoreCase("circle") || string.equalsIgnoreCase("radius")) {
            try {
                this.context.setCircle(string2);
            }
            catch (ParseException parseException) {
                throw new Exception(parseException.getMessage());
            }
        } else if (string.equalsIgnoreCase("polygon") || string.equalsIgnoreCase("fov")) {
            try {
                this.context.setPolygon(string2);
            }
            catch (ParseException parseException) {
                throw new Exception(parseException.getMessage());
            }
        } else if (string.equalsIgnoreCase("border")) {
            try {
                this.context.setBorderSize(string2);
            }
            catch (ParseException parseException) {
                throw new Exception(parseException.getMessage());
            }
        } else if (string.equalsIgnoreCase("jpegMethod") || string.equalsIgnoreCase("method")) {
            this.flagMethod = true;
            this.context.setMethod(string2);
        } else if (string.equalsIgnoreCase("histoPercent")) {
            this.context.setHistoPercent(string2);
        } else if (string.equalsIgnoreCase("pixelGood")) {
            this.context.setPixelGood(string2);
        } else if (string.equalsIgnoreCase("pixelCut")) {
            this.context.setPixelCut(string2);
        } else if (string.equalsIgnoreCase("pixelRange") || string.equalsIgnoreCase("dataCut")) {
            this.context.setDataCut(string2);
        } else {
            throw new Exception("Option unknown [" + string + "]");
        }
    }

    public void execute(String[] stringArray) {
        Object object;
        int n = stringArray.length;
        boolean bl = true;
        if (n == 0) {
            HipsGen.usage(this.launcher);
            return;
        }
        String[] stringArray2 = stringArray;
        int n2 = stringArray2.length;
        for (int i = 0; i < n2; ++i) {
            Object object2;
            object = stringArray2[i];
            String string = "-param=";
            if (((String)object).startsWith(string)) {
                try {
                    this.setConfigFile(((String)object).substring(string.length()));
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
            }
            if (((String)object).equalsIgnoreCase("-skygen") || ((String)object).equalsIgnoreCase("-hipsgen")) continue;
            if (((String)object).equalsIgnoreCase("-h") || ((String)object).equalsIgnoreCase("-help")) {
                HipsGen.usage(this.launcher);
                return;
            }
            if (bl) {
                bl = false;
                this.context.info("Starting HipsGen " + SDF.format(new Date()) + " (based on Aladin " + "v9.033a" + ")...");
            }
            this.context.scriptCommand = this.context.scriptCommand == null ? object : this.context.scriptCommand + " " + (String)object;
            if (((String)object).equalsIgnoreCase("-debug") || ((String)object).equalsIgnoreCase("-d")) {
                Context.setVerbose(4);
                continue;
            }
            if (((String)object).equalsIgnoreCase("-fast")) {
                this.context.mixing = true;
                continue;
            }
            if (((String)object).equalsIgnoreCase("-force") || ((String)object).equalsIgnoreCase("-f")) {
                this.force = true;
                continue;
            }
            if (((String)object).equalsIgnoreCase("-nice")) {
                this.context.mirrorDelay = 500;
                continue;
            }
            if (((String)object).equalsIgnoreCase("-clone")) {
                this.context.testClonable = false;
                continue;
            }
            if (((String)object).equalsIgnoreCase("-live")) {
                this.context.setLive(true);
                continue;
            }
            if (((String)object).equalsIgnoreCase("-n")) {
                this.context.fake = true;
                continue;
            }
            if (((String)object).contains("=")) {
                object2 = ((String)object).split("=");
                try {
                    object2[0] = object2[0].substring(object2[0].indexOf(45) + 1);
                    this.setContextFromOptions(object2[0], object2[1]);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.context.error(exception.getMessage());
                    return;
                }
            }
            try {
                object2 = Action.valueOf(((String)object).toUpperCase());
                if (object2 == Action.FINDER) {
                    object2 = Action.INDEX;
                }
                if (object2 == Action.PROGEN) {
                    object2 = Action.DETAILS;
                }
                if (object2 == Action.MIRROR) {
                    this.flagMirror = true;
                }
                if (object2 == Action.UPDATE) {
                    this.flagUpdate = true;
                }
                if (object2 == Action.CONCAT) {
                    this.flagConcat = true;
                    if (!this.flagMode) {
                        this.context.setMode(Mode.AVERAGE);
                    }
                }
                if (object2 == Action.ABORT) {
                    this.flagAbort = true;
                }
                if (object2 == Action.PAUSE) {
                    this.flagPause = true;
                }
                if (object2 == Action.RESUME) {
                    this.flagResume = true;
                }
                this.actions.add((Action)((Object)object2));
                continue;
            }
            catch (Exception exception) {
                this.context.error("Unknown parameter [" + (String)object + "] !");
                return;
            }
        }
        if (this.flagAbort) {
            try {
                this.context.taskAbort();
            }
            catch (Exception exception) {
                this.context.error(exception.getMessage());
            }
            return;
        }
        if (this.flagPause) {
            try {
                this.context.setTaskPause(true);
            }
            catch (Exception exception) {
                this.context.error(exception.getMessage());
            }
            return;
        }
        if (this.flagResume) {
            try {
                this.context.setTaskPause(false);
            }
            catch (Exception exception) {
                this.context.error(exception.getMessage());
            }
            return;
        }
        boolean bl2 = false;
        if (this.actions.size() == 0) {
            bl2 = true;
            if (this.flagRGB) {
                this.actions.add(Action.RGB);
            } else {
                n2 = 0;
                File file = new File(this.context.getInputPath());
                if (!file.isDirectory() && file.exists()) {
                    try {
                        object = new MyInputStream(new FileInputStream(file));
                        object = ((MyInputStream)object).startRead();
                        n2 = (((MyInputStream)object).getType() & 0x100000000L) != 0L ? 1 : 0;
                        ((MyInputStream)object).close();
                        this.context.setMap(n2 != 0);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (n2 != 0) {
                    this.actions.add(Action.MAPTILES);
                } else {
                    this.actions.add(Action.INDEX);
                    this.actions.add(Action.TILES);
                }
                if (!this.context.isColor()) {
                    this.actions.add(Action.GZIP);
                    this.actions.add(Action.PNG);
                    if (n2 == 0) {
                        this.actions.add(Action.DETAILS);
                    }
                }
            }
        }
        if (this.flagRGB && !this.flagMode) {
            this.context.setMode(Mode.REPLACETILE);
        }
        if (this.context.isColor() && !this.flagMethod) {
            this.context.setJpegMethod(Context.JpegMethod.MEDIAN);
        }
        if (this.context.getMode() == Mode.ADD) {
            this.context.setFading(false);
            this.context.setPartitioning("false");
            this.context.setMixing("true");
            this.context.info("Pixel mode=ADD => fading, partitioning and no mixing parameter ignored");
        }
        if (this.force) {
            this.context.setIgnoreStamp(true);
            if (bl2) {
                this.actions.add(0, Action.CLEAN);
            } else {
                for (n2 = 0; n2 < this.actions.size(); ++n2) {
                    Action action = this.actions.get(n2);
                    if (action == Action.INDEX) {
                        this.actions.add(n2, Action.CLEANINDEX);
                        ++n2;
                        continue;
                    }
                    if (action == Action.MIRROR) {
                        this.actions.add(n2, Action.CLEAN);
                        ++n2;
                        continue;
                    }
                    if (action == Action.DETAILS) {
                        this.actions.add(n2, Action.CLEANDETAILS);
                        ++n2;
                        continue;
                    }
                    if (action == Action.TILES) {
                        this.actions.add(n2, Action.CLEANTILES);
                        ++n2;
                        continue;
                    }
                    if (action == Action.MAPTILES) {
                        this.actions.add(n2, Action.CLEANTILES);
                        ++n2;
                        continue;
                    }
                    if (action == Action.JPEG) {
                        this.actions.add(n2, Action.CLEANJPEG);
                        ++n2;
                        continue;
                    }
                    if (action == Action.PNG) {
                        this.actions.add(n2, Action.CLEANPNG);
                        ++n2;
                        continue;
                    }
                    if (action == Action.RGB) {
                        this.actions.add(n2, Action.CLEAN);
                        ++n2;
                        continue;
                    }
                    if (action != Action.CUBE) continue;
                    this.actions.add(n2, Action.CLEAN);
                    ++n2;
                }
            }
        }
        if (this.context.fake) {
            this.context.warning("NO RUN MODE (option -n), JUST PRINT INFORMATION !!!");
        }
        for (Action action : this.actions) {
            this.context.info("Action => " + (Object)((Object)action) + ": " + action.doc());
        }
        if (!this.flagRGB) {
            this.setDefaultFrame();
        }
        if (!(this.context.hipsId != null || this.flagConcat || this.flagMirror || this.flagUpdate)) {
            String string = this.context.checkHipsId(null, false);
            this.context.setHipsId(string);
        }
        try {
            long l = System.currentTimeMillis();
            new Task(this.context, this.actions, true);
            if (this.context.isTaskAborting()) {
                this.context.abort("======================= (aborted after " + Util.getTemps(System.currentTimeMillis() - l) + ") =======================");
            } else {
                if (!this.flagMirror) {
                    object = this.context.getHipsId();
                    if (object == null || ((String)object).startsWith("ivo://UNK.AUT")) {
                        this.context.warning("a valid HiPS IVOID identifier is strongly recommended => in the meantime, assuming " + this.context.getHipsId());
                    }
                    this.context.info("Tip: Edit the \"properties\" file for describing your HiPS (full description, copyright, ...)");
                }
                this.context.done("=================== THE END (done in " + Util.getTemps(System.currentTimeMillis() - l) + ") =======================");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.context.error(exception.getMessage());
            return;
        }
    }

    private void setDefaultFrame() {
        if (this.context.hasFrame()) {
            return;
        }
        String string = this.context.getOutputPath();
        String string2 = null;
        try {
            String string3 = string + Util.FS + "properties";
            MyProperties myProperties = new MyProperties();
            File file = new File(string3);
            if (file.exists()) {
                FileInputStream fileInputStream = new FileInputStream(string3);
                myProperties.load(fileInputStream);
                fileInputStream.close();
                String string4 = myProperties.getProperty("hips_frame");
                if (string4 == null) {
                    string4 = myProperties.getProperty("coordsys");
                }
                string2 = string4 != null && string4.length() > 0 ? string4 : "galactic";
            } else {
                string2 = this.context.isExistingAllskyDir() ? "galactic" : "equatorial";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.context.setFrameName(string2);
    }

    public void executeAsync(String[] stringArray) {
        new ExecuteAsyncThread(stringArray);
    }

    private static void usage(String string) {
        System.out.println("Usage: java -jar " + string + " in=file|dir [otherParams ... ACTIONs ...]");
        System.out.println("       java -jar " + string + " -param=configfile\n");
        System.out.println("The config file must contain these following options, or use them\ndirectly on the comand line :\n");
        System.out.println("Required parameter:\n   in=dir             Source image directory (FITS or JPEG|PNG +hhh or HiPS),\n                      unique image or HEALPix map file\n\nBasic optional parameters:\n   out=dir            HiPS target directory (default $PWD+\"HiPS\")\n   label=name         Label of the survey (by default, input directory name)\n   id=identifier      HiPS identifier (syntax: AUTHORITY-ID/internalID)\n   creator=name       Name of the person|institute who builds the HiPS\n   status=xx          HiPS status (private|public clonable|clonableOnce|unclonable)\n                      (default: public clonableOnce)   hdu=n1,n2-n3,...|all  List of HDU numbers (0 is the primary HDU - default is 0)\n   blank=nn           Specifical BLANK value\n   skyval=key|true|%info|%min %max   Fits key to use for removing a sky background, true auto detection \n                      or percents of pixel histogram kept (central ex 99, or min max ex 0.3 99.7)\n   color=jpeg|png     The source images are colored images (jpg or png) and the tiles will be \n                      produced in jpeg (resp. png)\n   shape=...          Shape of the observations (ellipse|rectangle)\n   border=...         Margins (in pixels) to ignore in the original observations (N W S E or \n                      constant)\n   fov=true|x1,y1..   Observed regions by files.fov or global polygon (in FITS convention).\n   verbose=n          Debug information from -1 (nothing) to 4 (a lot)\n   -live              incremental HiPS (keep weight associated to each HiPS pixel)\n   -f                 clear previous computations\n   -n                 Just print process information, but do not execute it.\n\nAdvanced optional parameters:\n   order=nn           Specifical HEALPix order - by default, adapted to the original resolution\n   bitpix=nn          Specifical target bitpix (-64|-32|8|16|32|64)\n   pixelCut=min max   Specifical pixel cut and/or transfert function for PNG/JPEG 8 bits\n                      conversion - ex: \"120 140 log\")\n   pixelRange=min max Specifical pixel value range (required for bitpix\n                      conversion, or for removing bad pixels - ex: \"-5 110\")\n   pixelGood=min [max] Range of pixel values kept\n   img=file           Specifical reference image for default initializations \n                      (BITPIX,BSCALE,BZERO,BLANK,order,pixelCut,pixelRange)\n   mode=xx            Coadd mode when restart: pixel level(OVERWRITE|KEEP|ADD|AVERAGE) \n                      or tile level (REPLACETILE|KEEPTILE) - (default OVERWRITE)\n                      Or LINK|COPY for CUBE action (default COPY)\n   fading=true|false  False to avoid fading effect on overlapping original images \n                      (default is true)\n   mixing=true|false  False to avoid mixing (and fading) effect on overlapping original images \n                      (default is true)\n   partitioning=true|false True for cutting large original images in blocks of 1024x1024 \n                      (default is true)\n   region=moc         Specifical HEALPix region to compute (ex: 3/34-38 50 53)\n                      or Moc.fits file (all sky by default)\n   maxRatio=nn        Max height/width pixel ratio tolerated for original obs \n                      (default 2, 0 for removing the test)\n   fitskeys=list      Fits key list (blank separator) designing metadata FITS keyword value \n                      to memorized in the HiPS index\n   minOrder=nn        Specifical HEALPix min order (only for DETAILS action)\n   method=m           Method (MEDIAN|MEAN|FIRST) (default MEDIAN) for aggregating colored \n                      compressed tiles (JPEG|PNG)\n   tileOrder=nn       Specifical tile order - default 9\n   mocOrder=nn        Specifical HEALPix MOC order (only for MOC action) - by default \n                      auto-adapted to the HiPS\n   nside=nn           HEALPix map NSIDE (only for MAP action) - by default 2048\n   exptime=key        Fits key to use for adjusting variation of exposition\n   inRed              HiPS red path component (RGB action)\n   inGreen            HiPS green path component (RGB action)\n   inBlue             HiPS blue path component (RGB action)\n   cmRed              Colormap parameters for HiPS red component (min [mid] max [fct])\n   cmGreen            Colormap parameters for HiPS green component (min [mid] max [fct])\n   cmBlue             Colormap parameters for HiPS blue component (min [mid] max [fct])\n   filter=gauss       Gaussian filter applied on the 3 input HiPS (RGB action)\n   tileTypes          List of tile format to copy (MIRROR action)\n   maxThread=nn       Max number of computing threads\n   target=ra +dec     Default HiPS target (ICRS deg)\n   targetRadius=rad   Default HiPS radius view (deg)\n   -nice              Slow download for avoiding to overload remote http server (dedicated \n                      to MIRROR action)\n");
        System.out.println("\nSpecifical actions (by default: \"INDEX TILES PNG GZIP DETAILS\"):\n   INDEX      " + Action.INDEX.doc() + "\n   TILES      " + Action.TILES.doc() + "\n   JPEG       " + Action.JPEG.doc() + "\n   PNG        " + Action.PNG.doc() + "\n   RGB        " + Action.RGB.doc() + "\n   MOC        " + Action.MOC.doc() + "\n   ALLSKY     " + Action.ALLSKY.doc() + "\n   TREE       " + Action.TREE.doc() + "\n   MAPTILES   " + Action.MAPTILES.doc() + "\n   APPEND     " + Action.APPEND.doc() + "\n   CONCAT     " + Action.CONCAT.doc() + "\n   CUBE       " + Action.CUBE.doc() + "\n   GZIP       " + Action.GZIP.doc() + "\n   CLEANFITS  " + Action.CLEANFITS.doc() + "\n   DETAILS    " + Action.DETAILS.doc() + "\n   MIRROR     " + Action.MIRROR.doc() + "\n   MAP        " + Action.MAP.doc() + "\n");
        System.out.println("\nEx: java -jar " + string + " in=/MyImages    => Do all the job.\n    java -jar " + string + " in=/MyImages bitpix=16 pixelCut=\"-1 100 log\" => Do all the job\n           The FITS tiles will be coded in short integers, the preview tiles\n           will map the physical values [-1..100] with a log function contrast in [0..255].\n    java -jar " + string + " in=/MyImages blank=0 border=\"100 50 100 50\" mode=REPLACETILE   \n           => recompute tiles. The original pixels in the border or null will be ignored.\n    java -jar " + string + " in=HiPS out=HiPStarget CONCAT => Concatenate HiPS to HiPStarget");
        System.out.println("\n(c) Unistra/CNRS 2016 - " + string + " based on Aladin " + "v9.033a" + " from CDS");
    }

    private void setConfigFile(String string) throws Exception {
        this.file = new File(string);
        this.parseConfig();
    }

    public static void main(String[] stringArray) {
        HipsGen hipsGen = new HipsGen();
        hipsGen.launcher = "HipsGen";
        hipsGen.execute(stringArray);
    }

    static {
        SDF.setTimeZone(TimeZone.getDefault());
    }

    class ExecuteAsyncThread
    extends Thread {
        String[] args;

        public ExecuteAsyncThread(String[] stringArray) {
            this.args = stringArray;
            this.start();
        }

        @Override
        public void run() {
            HipsGen.this.execute(this.args);
        }
    }
}

