/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.Aladin;
import cds.aladin.PlanBG;
import cds.allsky.BuilderIndex;
import cds.allsky.BuilderMapTiles;
import cds.allsky.BuilderTiles;
import cds.allsky.Constante;
import cds.allsky.ContextGui;
import cds.allsky.TabBuild;
import cds.allsky.TabDesc;
import cds.allsky.TabJpg;
import cds.allsky.TabPub;
import cds.allsky.TabRgb;
import cds.fits.Fits;
import cds.tools.pixtools.Util;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class MainPanel
extends JPanel
implements ActionListener {
    protected Aladin aladin;
    protected ContextGui context;
    private JTabbedPane pTab;
    protected TabDesc tabDesc;
    protected TabBuild tabBuild = null;
    protected TabJpg tabJpg;
    protected TabPub tabPub;
    protected TabRgb tabRgb;
    PlanBG planPreview;
    private String lastPath = null;

    public MainPanel(Aladin aladin, ContextGui contextGui) {
        this.aladin = aladin;
        this.context = contextGui;
        contextGui.setMainPanel(this);
        this.createPanel();
        BuilderTiles.DEBUG = Aladin.levelTrace > 0;
    }

    protected JProgressBar getProgressBarTile() {
        return this.tabBuild.buildProgressPanel.getProgressBarTile();
    }

    protected JProgressBar getProgressBarIndex() {
        return this.tabBuild.buildProgressPanel.getProgressBarIndex();
    }

    private void createPanel() {
        this.pTab = new JTabbedPane();
        this.tabBuild = new TabBuild(this);
        this.tabJpg = new TabJpg(this);
        this.tabPub = new TabPub(this.aladin, this);
        this.tabRgb = new TabRgb(this.aladin, this);
        this.tabDesc = new TabDesc(this.aladin.getDefaultDirectory(), this);
        this.tabDesc.inputField.addActionListener(this);
        this.pTab.addTab(this.getString("MDESC"), null, this.tabDesc, null);
        this.pTab.addTab(this.getString("MBUILD"), null, this.tabBuild, this.getString("MTIPBUILD"));
        this.pTab.addTab(this.getString("MDISPLAY"), null, this.tabJpg, null);
        this.pTab.addTab(this.getString("MPUBLISH"), null, this.tabPub, this.getString("MTIPPUBLISH"));
        this.pTab.addTab(this.getString("MRGBA"), null, this.tabRgb, this.getString("MTIPRGB"));
        this.pTab.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (MainPanel.this.pTab.getSelectedComponent() == MainPanel.this.tabRgb) {
                    MainPanel.this.tabRgb.init();
                }
            }
        });
        this.add((Component)this.pTab, "Center");
    }

    private String getString(String string) {
        MainPanel mainPanel = this;
        return mainPanel.aladin.getChaine().getString(string);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.tabDesc.inputField) {
            this.init();
        }
    }

    public void init() {
        boolean bl = false;
        int n = 3;
        int n2 = 16;
        String string = this.context.getInputPath();
        if (string.trim().length() == 0) {
            return;
        }
        if (this.lastPath == null || !this.lastPath.equals(string)) {
            this.lastPath = string;
            File file = new File(string);
            if (file.exists() && file.isFile()) {
                try {
                    BuilderMapTiles builderMapTiles = new BuilderMapTiles(this.context);
                    builderMapTiles.validateMap();
                    builderMapTiles.build(true);
                    bl = true;
                    n = builderMapTiles.maxOrder;
                    n2 = builderMapTiles.bitpixOrig;
                }
                catch (Exception exception) {
                    this.context.isInputFile = true;
                }
            }
            if (!file.isFile()) {
                this.context.isInputFile = false;
            }
            if (!bl) {
                boolean bl2 = this.context.findImgEtalon(string);
                if (!bl2) {
                    this.context.warning("There is no available images in source directory !\n" + string);
                    return;
                }
                String string2 = this.context.getImgEtalon();
                Fits fits = new Fits();
                try {
                    fits.loadHeaderFITS(string2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                n2 = fits.bitpix;
                long l = BuilderIndex.calculateNSide(fits.getCalib().GetResol()[0] * 3600.0);
                n = Util.order((int)l) - this.context.getTileOrder();
            }
            this.context.setMap(bl);
            this.tabBuild.setOriginalBitpixField(n2);
            this.tabBuild.setSelectedOrder(n);
        }
        this.newAllskyDir();
    }

    public void updateCurrentCM() {
        this.tabJpg.updateCurrentCM();
    }

    public void showDescTab() {
        this.pTab.setSelectedComponent(this.tabDesc);
    }

    public void showBuildTab() {
        this.pTab.setSelectedComponent(this.tabBuild);
    }

    public void showJpgTab() {
        this.pTab.setSelectedComponent(this.tabJpg);
    }

    public void showPubTab() {
        this.pTab.setSelectedComponent(this.tabPub);
    }

    public void showRgbTab() {
        this.pTab.setSelectedComponent(this.tabRgb);
    }

    protected void newAllskyDir() {
        this.tabPub.newAllskyDir(Constante.SURVEY);
        try {
            this.context.loadMocIndex();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.resumeWidgets();
    }

    protected void resumeWidgets() {
        this.tabDesc.resumeWidgets();
        this.tabBuild.resumeWidgets();
        this.tabJpg.resumeWidgets();
        this.tabRgb.resumeWidgets();
    }

    public void close() {
        this.aladin.frameAllsky.close();
    }

    protected void clearForms() {
        Constante.SURVEY = "HiPS";
        this.context.reset();
        this.tabDesc.clearForms();
        this.tabBuild.clearForms();
        this.tabJpg.clearForms();
        this.tabPub.clearForms();
    }

    protected void export(String string) {
        if (this.planPreview == null) {
            this.context.updateHipsPreview(true);
        }
        this.aladin.frameAllsky.export(this.planPreview, string);
    }

    public boolean hasJpg() {
        try {
            return cds.tools.Util.find(this.context.getOutputPath(), ".jpg");
        }
        catch (Exception exception) {
            return false;
        }
    }
}

