/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.Coord;
import cds.allsky.Context;
import cds.fits.Fits;
import cds.moc.Healpix;
import cds.moc.HealpixMoc;
import cds.tools.Util;
import cds.tools.pixtools.CDSHealpix;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;

public class MocGen {
    Healpix hpx = new Healpix();
    private String in = null;
    private String out = null;
    private String previous = null;
    private int order = 10;
    private double blank = Double.NaN;
    private int fmt = 0;
    public boolean verbose = false;
    public boolean debug = false;
    private boolean strict = false;
    private boolean recursive = false;
    private boolean multWrite = false;
    private int[] hdu = null;
    private HealpixMoc moc;
    private boolean ready;
    private boolean error;
    private String serror;
    private boolean abort;
    private String scanningDir = null;
    private int nbImg;
    private long tStart = 0L;
    private long t1 = 0L;
    private long t2 = 0L;
    private int dot = 0;
    private boolean needNL = false;

    public MocGen(String[] stringArray) {
        this.execute(stringArray);
    }

    public MocGen(String string, int n, boolean bl, boolean bl2, double d, int[] nArray) throws Exception {
        this.strict = bl2;
        this.blank = d;
        this.in = string;
        this.recursive = bl;
        this.order = n;
        this.hdu = nArray;
    }

    public boolean isReady() {
        return this.ready;
    }

    public boolean isError() {
        return this.error;
    }

    public String getError() {
        return this.serror;
    }

    public HealpixMoc getMoc() throws Exception {
        if (this.error) {
            throw new Exception("MOC error => " + this.serror);
        }
        if (!this.ready) {
            throw new Exception("MOC not yet ready");
        }
        return this.moc;
    }

    public void abort() {
        this.abort = true;
    }

    public String getScanningDir() {
        return this.scanningDir;
    }

    public int getNbImages() {
        return this.nbImg;
    }

    public void start() {
        new Thread(){

            @Override
            public void run() {
                try {
                    MocGen.this.serror = null;
                    MocGen.this.error = (MocGen.this.abort = (MocGen.this.ready = false));
                    MocGen.this.nbImg = 0;
                    MocGen.this.moc = new HealpixMoc();
                    MocGen.this.moc.setMocOrder(MocGen.this.order);
                    MocGen.this.moc.setCheckConsistencyFlag(false);
                    MocGen.this.scanAndDo(MocGen.this.moc, new File(MocGen.this.in), MocGen.this.order);
                    MocGen.this.moc.checkAndFix();
                    MocGen.this.ready = true;
                }
                catch (Exception exception) {
                    MocGen.this.moc = null;
                    MocGen.this.serror = exception.getMessage();
                    MocGen.this.error = true;
                    MocGen.this.ready = true;
                }
            }
        }.start();
    }

    private boolean addInMocPixel(HealpixMoc healpixMoc, File file, int n) throws Exception {
        boolean bl = false;
        String string = file.getPath();
        Fits fits = new Fits();
        boolean bl2 = this.hdu == null;
        boolean bl3 = this.hdu != null && this.hdu.length > 0 && this.hdu[0] == -1;
        int n2 = 2048;
        int n3 = 0;
        for (int i = 0; bl3 || bl2 || i < this.hdu.length; ++i) {
            block11: {
                int n4 = bl2 ? 0 : (bl3 ? i : this.hdu[i]);
                try {
                    int n5 = fits.loadHeaderFITS(string + (n4 == 0 ? "" : "[" + n4 + "]"));
                    if (bl3 && (n5 & 0x10) != 0 || fits.calib == null) continue;
                    if (n3 == 0) {
                        n3 = fits.depth;
                    } else if (fits.depth != n3) continue;
                    try {
                        int n6 = fits.width;
                        int n7 = fits.height;
                        int n8 = 0x40000000 / (fits.height * Math.abs(fits.bitpix));
                        if (n8 < 1) {
                            n8 = 1;
                        } else if (n8 > n7) {
                            n8 = n7;
                        }
                        for (int j = 0; j < n7; j += n8) {
                            fits.widthCell = n6;
                            fits.heightCell = j + n8 > n7 ? n7 - j : n8;
                            fits.depth = 1;
                            fits.depthCell = 1;
                            fits.xCell = 0;
                            fits.yCell = j;
                            fits.zCell = 0;
                            fits.ext = n4;
                            String string2 = fits.getCellSuffix();
                            bl |= this.addInMocPixel1(fits, healpixMoc, string, string2, n);
                            healpixMoc.checkAndFix();
                        }
                        break block11;
                    }
                    catch (Exception exception) {
                        if (Aladin.levelTrace < 3) break;
                        exception.printStackTrace();
                    }
                }
                catch (Exception exception) {
                    Aladin.trace(3, exception.getMessage() + " " + string);
                }
                break;
            }
            if (bl2) break;
        }
        return bl;
    }

    private boolean addInMocPixel1(Fits fits, HealpixMoc healpixMoc, String string, String string2, int n) throws Exception {
        boolean bl = false;
        int n2 = 0;
        Calib calib = fits.getCalib();
        if (calib == null) {
            if (this.debug) {
                System.out.println(string + string2 + " ignored (no calibration) => " + string);
            }
            return bl;
        }
        fits.loadFITS(string + string2);
        Coord coord = new Coord();
        double d = 1.0;
        try {
            double d2 = Math.min(calib.GetResol()[0], calib.GetResol()[1]);
            n2 = n;
            while (CDSHealpix.pixRes(CDSHealpix.pow2(n2)) / 3600.0 <= d2) {
                --n2;
            }
            if (d < 1.0) {
                d = 1.0;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.verbose) {
            System.out.println("Adding pixel coverage of " + string + string2 + "...");
        }
        if (!Double.isNaN(this.blank)) {
            fits.setBlank(this.blank);
        }
        int n3 = 0;
        int n4 = 0;
        long l = -1L;
        for (int i = fits.yCell; i < fits.yCell + fits.heightCell; ++i) {
            for (int j = fits.xCell; j < fits.xCell + fits.widthCell; ++j) {
                try {
                    double d3 = fits.getPixelDouble(j, i);
                    if (fits.isBlankPixel(d3)) continue;
                    coord.x = j;
                    coord.y = fits.height - i - 1;
                    calib.GetCoord(coord);
                    long l2 = 0L;
                    l2 = this.hpx.ang2pix(n2, coord.al, coord.del);
                    if (l2 == l) {
                        ++n4;
                        continue;
                    }
                    healpixMoc.add(n2, l2);
                    l = l2;
                    if (++n3 > 100000) {
                        n3 = 0;
                        healpixMoc.checkAndFix();
                        this.updateMoc(healpixMoc, this.out, this.fmt);
                    }
                    bl = true;
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return bl;
    }

    private boolean addInMocBox(Fits fits, HealpixMoc healpixMoc, int n) throws Exception {
        long[] lArray;
        boolean bl = true;
        Coord coord = new Coord();
        ArrayList<double[]> arrayList = new ArrayList<double[]>(10);
        Calib calib = fits.getCalib();
        Dimension dimension = calib.getImgSize();
        for (int i = 0; i < 4; ++i) {
            coord.x = i == 0 || i == 3 ? 0 : dimension.width;
            coord.y = i < 2 ? 0 : dimension.height;
            calib.GetCoord(coord);
            arrayList.add(new double[]{coord.al, coord.del});
        }
        for (long l : lArray = CDSHealpix.query_polygon(CDSHealpix.pow2(n), arrayList)) {
            healpixMoc.add(n, l);
        }
        return bl;
    }

    private boolean addInMocBox(HealpixMoc healpixMoc, File file, int n) throws Exception {
        boolean bl = false;
        boolean bl2 = this.hdu == null;
        boolean bl3 = this.hdu != null && this.hdu.length > 0 && this.hdu[0] == -1;
        for (int i = 0; bl3 || bl2 || i < this.hdu.length; ++i) {
            int n2 = bl2 ? 0 : (bl3 ? i : this.hdu[i]);
            Fits fits = new Fits();
            fits.setSkipHDU0(bl2);
            try {
                fits.loadHeaderFITS(file.getAbsolutePath() + "[" + n2 + "]");
            }
            catch (Exception exception) {
                return bl;
            }
            Calib calib = fits.getCalib();
            if (calib == null) continue;
            if (this.verbose) {
                System.out.println("Adding footprint of " + file.getName() + fits.getCellSuffix() + "...");
            }
            if (!Double.isNaN(this.blank)) {
                fits.setBlank(this.blank);
            }
            bl |= this.addInMocBox(fits, healpixMoc, n);
            if (bl2) break;
        }
        return bl;
    }

    private boolean addInMoc(HealpixMoc healpixMoc, File file, int n, boolean bl) throws Exception {
        if (!bl) {
            return this.addInMocBox(healpixMoc, file, n);
        }
        return this.addInMocPixel(healpixMoc, file, n);
    }

    private void scanAndDo(HealpixMoc healpixMoc, File file, int n) throws Exception {
        this.scanningDir = file.getCanonicalPath();
        File[] fileArray = file.isFile() ? new File[]{file} : file.listFiles();
        for (File file2 : fileArray) {
            if (this.debug) {
                System.out.println("Scanning " + file2);
            }
            if (this.abort) {
                throw new Exception("MOC aborted");
            }
            if (!file2.isFile()) continue;
            if (this.addInMoc(healpixMoc, file2, n, this.strict)) {
                ++this.nbImg;
            }
            if (this.nbImg <= 0 || this.nbImg % 100 != 0) continue;
            healpixMoc.checkAndFix();
            this.updateMoc(healpixMoc, this.out, this.fmt);
        }
        if (this.recursive) {
            for (File file2 : fileArray) {
                if (!file2.isDirectory()) continue;
                this.scanAndDo(healpixMoc, file2, n);
            }
        }
    }

    private boolean updateMoc(HealpixMoc healpixMoc, String string, int n) throws Exception {
        long l = System.currentTimeMillis();
        if (l - this.t1 < 6000L) {
            return false;
        }
        this.t1 = l;
        if (!this.verbose) {
            System.out.print(".");
            this.needNL = true;
            ++this.dot;
            if (this.dot > 10) {
                this.dot = 0;
                System.out.println();
                this.needNL = false;
            }
        }
        if (this.t2 > 0L && l - this.t2 > 60000L) {
            if (this.needNL) {
                System.out.println();
            }
            String string2 = this.nbImg + 1 > 1 ? "s" : "";
            System.out.println(this.nbImg + 1 + " image" + string2 + " in progress (MOC size=" + Util.getUnitDisk(healpixMoc.getMem()) + " in " + Util.getTemps(l - this.tStart) + ")...");
            this.needNL = false;
            this.t2 = l;
        }
        if (!this.multWrite || healpixMoc.getSize() == 0) {
            return false;
        }
        if (this.verbose) {
            System.out.println("Updating output MOC [" + string + "]...");
        }
        healpixMoc.write(string, n);
        return true;
    }

    private boolean scanArgs(String[] stringArray) {
        for (String string : stringArray) {
            int n = string.indexOf("=") + 1;
            if (string.startsWith("in=")) {
                this.in = string.substring(n);
                if (new File(this.in).exists()) continue;
                System.out.println("Unavailable directory or file [" + this.in + "]");
                return false;
            }
            if (string.startsWith("out=")) {
                this.out = string.substring(n);
                if (!new File(this.out).exists() || new File(this.out).canWrite()) continue;
                System.out.println("Unavailable output file [" + this.out + "]");
                return false;
            }
            if (string.startsWith("previous=")) {
                this.previous = string.substring(n);
                if (new File(this.previous).exists()) continue;
                System.out.println("Unavailable previous MOC file [" + this.previous + "]");
                return false;
            }
            if (string.startsWith("hdu=")) {
                try {
                    this.hdu = Context.parseHDU(string.substring(n));
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("Unavailable HDU numbers [" + string.substring(n) + "]");
                    return false;
                }
            }
            if (string.equals("-v") || string.equals("-verbose")) {
                this.verbose = true;
                continue;
            }
            if (string.equals("-d")) {
                this.verbose = true;
                this.debug = true;
                continue;
            }
            if (string.equals("-r")) {
                this.recursive = true;
                continue;
            }
            if (string.equals("-o")) {
                this.multWrite = true;
                continue;
            }
            if (string.equals("-strict")) {
                this.strict = true;
                continue;
            }
            if (string.equalsIgnoreCase("-pixfoot") || string.equalsIgnoreCase("-mocgen")) continue;
            if (string.startsWith("mocfmt=")) {
                String string2 = string.substring(n);
                if (string2.equalsIgnoreCase("fits")) {
                    this.fmt = 0;
                    continue;
                }
                if (string2.equalsIgnoreCase("json") || string2.equalsIgnoreCase("ascii")) {
                    this.fmt = 1;
                    continue;
                }
                System.out.println("Unkown MOC format [" + string2 + "]");
                return false;
            }
            if (string.startsWith("blank=")) {
                try {
                    this.blank = Double.parseDouble(string.substring(n));
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("Wrong blank value [" + string.substring(n) + "]");
                    return false;
                }
            }
            if (string.startsWith("order=")) {
                try {
                    this.order = Integer.parseInt(string.substring(n));
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("Wrong order value [" + string.substring(n) + "]");
                    return false;
                }
            }
            System.out.println("Unkown parameter [" + string + "]");
            return false;
        }
        if (this.out == null) {
            System.out.println("Missing parameters !");
            return false;
        }
        if (this.strict) {
            System.out.println("MOC generation based on *pixel* coverage:");
        } else {
            System.out.println("MOC generation based on *image* coverage:");
        }
        System.out.println(".in=" + (this.in == null ? "null => assuming stdin WCS headers stream (blank line separator)" : this.in));
        if (this.recursive && this.in != null && new File(this.in).isDirectory()) {
            System.out.println(".recursive directory scanning");
        }
        System.out.println(".out=" + this.out);
        if (this.previous != null) {
            System.out.println(".previous=" + this.previous);
        }
        System.out.println(".order=" + this.order);
        if (this.hdu != null) {
            System.out.print(".hdu=");
            if (this.hdu.length > 0 && this.hdu[0] == -1) {
                System.out.println("all");
            } else {
                for (int i = 0; i < this.hdu.length; ++i) {
                    System.out.print((i == 0 ? "" : ",") + this.hdu[i]);
                }
                System.out.println();
            }
        }
        System.out.println(".mocfmt=" + (this.fmt == 0 ? "fits" : "ascii"));
        if (this.strict) {
            System.out.println(".blank=NaN" + (Double.isNaN(this.blank) ? "" : "|" + this.blank));
        }
        return true;
    }

    private void usage() {
        System.out.println("Usage: java -jar Aladin.jar -mocgen ... in=inputDirOrFile out=MocFile\n-h                 : This help\n[-v]               : Verbose\n[-strict]          : Scan pixel values instead of using WCS image coverage\n[blank=value]      : Alternate BLANK value (-strict only)\n[order=nn]         : MOC resolution (default 10 => 3.345')\n[mocfmt=fits|json] : MOC output format (default Fits)\n[previous=moc.fits]: Previous MOC (if additions)\n[hdu=n1,n2-n3|all] : List of concerned Fits extensions\n[-r]               : Recursive directory scanning\n[-o]               : Output MOC updated continuously rather than generated at the end\nin=fileOrDir       : Directory of images/headers collection\n[out=outMoc.fits]  : Output MOC file\n[-d]               : Debug trace\n\nGenerate the MOC corresponding to a collection of images or WCS headers.\nA MOC is a a coverage map based on HEALPix sky tesselation.\n\nThe supported formats are : FITS files, MEF files, jpeg or png files\n(WCS header in the comment segment), .hhh file (FITS header files without pixels)\nand .txt simple ASCII file (FITS header as keyword = value basic ASCII lines).\n\nVersion: 1.5 - based on Aladin v9.033a - Oct 2015 - P.Fernique [CDS]");
    }

    private void execute(String[] stringArray) {
        if (stringArray.length > 0 && (stringArray[0].equals("-h") || stringArray[0].equals("-help")) || !this.scanArgs(stringArray)) {
            this.usage();
            return;
        }
        boolean bl = false;
        try {
            this.serror = null;
            this.ready = false;
            this.abort = false;
            this.error = false;
            this.nbImg = 0;
            this.moc = new HealpixMoc();
            if (this.previous != null) {
                this.moc.read(this.previous);
            }
            this.moc.setMocOrder(this.order);
            this.moc.setCheckConsistencyFlag(false);
            this.tStart = System.currentTimeMillis();
            this.scanAndDo(this.moc, new File(this.in), this.order);
            this.moc.checkAndFix();
            long l = System.currentTimeMillis() - this.tStart;
            if (this.needNL) {
                System.out.println();
            }
            if (this.verbose) {
                String string = this.nbImg > 1 ? "s" : "";
                System.out.println(this.nbImg + " image" + string + " added in the MOC in " + Util.getTemps(l));
            }
            this.moc.write(this.out, this.fmt);
            System.out.println("MOC achieved in " + Util.getTemps(l) + " => " + this.out);
            this.ready = true;
        }
        catch (Exception exception) {
            this.moc = null;
            this.serror = exception.getMessage();
            this.error = true;
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        new MocGen(stringArray);
    }
}

