/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.allsky.Action;
import cds.allsky.BuildProgressPanel;
import cds.allsky.BuildTable;
import cds.allsky.Context;
import cds.allsky.ContextGui;
import cds.allsky.MainPanel;
import cds.allsky.Task;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

public class TabBuild
extends JPanel
implements ActionListener {
    protected static final String BEST = "best";
    protected static final String FIRST = "first";
    protected JButton abort;
    protected JButton start;
    protected JButton pause;
    protected JButton previous;
    protected JButton next;
    protected JButton moc;
    private static BuildTable tab = null;
    private JLabel method_label = new JLabel();
    private ButtonGroup groupSampl = new ButtonGroup();
    private ButtonGroup groupOverlay = new ButtonGroup();
    private JRadioButton samplFast = new JRadioButton();
    private JRadioButton overlayFast = new JRadioButton();
    private JRadioButton samplBest = new JRadioButton();
    private JRadioButton overlayBest = new JRadioButton();
    private JCheckBox fading = new JCheckBox();
    private ActionListener methodsListener = new MethodSelectListener(new JRadioButton[]{this.samplFast, this.overlayFast, this.samplBest, this.overlayBest}, this.fading);
    private final String BIT8 = "short (8bits)";
    private final String BIT16 = "int (16bits)";
    private final String BIT32 = "long int (32bits)";
    private final String BIT_32 = "float real (32bits)";
    private final String BIT64 = "double real (64bits)";
    private ButtonGroup groupBitpix = new ButtonGroup();
    private JCheckBox keepBB = new JCheckBox();
    private ActionListener bitpixListener = new BitpixListener(this.keepBB);
    private JRadioButton bit8 = new JRadioButton("short (8bits)", false);
    private JRadioButton bit16 = new JRadioButton("int (16bits)", false);
    private JRadioButton bit32 = new JRadioButton("long int (32bits)", true);
    private JRadioButton bit_32 = new JRadioButton("float real (32bits)", false);
    private JRadioButton bit_64 = new JRadioButton("double real (64bits)", false);
    private int bitpixOrig = -1;
    private JLabel bitpixLabel = new JLabel();
    private JLabel resoLabel;
    private JLabel note;
    private String canceltip;
    MainPanel mainPanel;
    Context context;
    protected BuildProgressPanel buildProgressPanel;

    private String getString(String string) {
        MainPanel mainPanel = this.mainPanel;
        return mainPanel.aladin.getChaine().getString(string);
    }

    public TabBuild(MainPanel mainPanel) {
        super(new BorderLayout());
        this.mainPanel = mainPanel;
        this.context = this.mainPanel.context;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.init();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        ++gridBagConstraints.gridy;
        this.bitpixLabel.setText(this.getString("BITPIXALLSKY"));
        jPanel.add((Component)this.bitpixLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        ++gridBagConstraints.gridx;
        jPanel.add((Component)Util.getHelpButton(this, this.getString("HELPBITPIXALLSKY")), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.bit8, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.bit16, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.bit32, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)this.bit_32, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.bit_64, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.keepBB.setText(this.getString("KEEPORIGALLSKY"));
        jPanel.add((Component)this.keepBB, gridBagConstraints);
        gridBagConstraints.insets.top = 15;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        this.resoLabel.setText(this.getString("RESOALLSKY"));
        jPanel.add((Component)this.resoLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)Util.getHelpButton(this, this.getString("HELPRESOALLSKY")), gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridwidth = 0;
        tab.setPreferredScrollableViewportSize(new Dimension(500, 120));
        tab.setRowSelectionAllowed(false);
        JScrollPane jScrollPane = new JScrollPane(tab);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 13;
        JLabel jLabel = this.note = new JLabel("<html><i>(*) whole sky</i></html>");
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets.top = 15;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        this.buildProgressPanel = new BuildProgressPanel();
        jPanel.add((Component)this.buildProgressPanel, gridBagConstraints);
        this.buildProgressPanel.resetProgressBar();
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.initBtn();
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(Box.createHorizontalGlue());
        jPanel3.add(this.previous);
        jPanel3.add(this.moc);
        jPanel3.add(this.start);
        jPanel3.add(this.pause);
        jPanel3.add(this.abort);
        jPanel3.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel3.add(this.next);
        jPanel3.add(Box.createHorizontalGlue());
        jPanel2.add((Component)jPanel3, "Center");
        this.add((Component)jPanel, "Center");
        this.add((Component)jPanel2, "South");
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    public void init() {
        tab = new BuildTable(this.context, this);
        this.resoLabel = new JLabel();
        this.resoLabel.setFont(this.resoLabel.getFont().deriveFont(1));
        this.bitpixLabel.setFont(this.bitpixLabel.getFont().deriveFont(1));
        this.keepBB.setEnabled(false);
        this.initBitpix();
        this.method_label.setFont(this.resoLabel.getFont().deriveFont(1));
        this.samplBest.setSelected(true);
        this.fading.setSelected(true);
        this.overlayBest.setSelected(true);
        this.initMethods();
        this.initListenerBitpix();
        this.initBtn();
    }

    private void initBtn() {
        JButton jButton;
        this.previous = jButton = new JButton(this.getString("PREVIOUS"));
        jButton.addActionListener(this);
        this.moc = jButton = new JButton(this.getString("LOADMOC"));
        jButton.addActionListener(this);
        this.start = jButton = new JButton(this.getString("START"));
        jButton.addActionListener(this);
        this.pause = jButton = new JButton(this.getString("PAUSE"));
        jButton.addActionListener(this);
        this.abort = jButton = new JButton(this.getString("ABORT"));
        jButton.addActionListener(this);
        jButton.setToolTipText(this.canceltip);
        this.next = jButton = new JButton(this.getString("NEXT"));
        jButton.addActionListener(this);
    }

    private void loadMoc() {
        String string = this.mainPanel.context.getHpxFinderPath() + Util.FS + "Moc.fits";
        this.mainPanel.aladin.execAsyncCommand("load " + string);
    }

    private void initMethods() {
        this.groupSampl.add(this.samplBest);
        this.groupSampl.add(this.samplFast);
        this.groupOverlay.add(this.overlayBest);
        this.groupOverlay.add(this.overlayFast);
        this.samplBest.addActionListener(this.methodsListener);
        this.samplFast.addActionListener(this.methodsListener);
        this.overlayBest.addActionListener(this.methodsListener);
        this.overlayFast.addActionListener(this.methodsListener);
        this.samplBest.setActionCommand(BEST);
        this.samplFast.setActionCommand(FIRST);
        this.overlayBest.setActionCommand(BEST);
        this.overlayFast.setActionCommand(FIRST);
    }

    private void initListenerBitpix() {
        this.bit8.addActionListener(this.bitpixListener);
        this.bit16.addActionListener(this.bitpixListener);
        this.bit32.addActionListener(this.bitpixListener);
        this.bit_32.addActionListener(this.bitpixListener);
        this.bit_64.addActionListener(this.bitpixListener);
    }

    private void initBitpix() {
        this.bit8.setActionCommand("8");
        this.bit16.setActionCommand("16");
        this.bit32.setActionCommand("32");
        this.bit_32.setActionCommand("-32");
        this.bit_64.setActionCommand("-64");
        this.bit8.addActionListener(this);
        this.bit16.addActionListener(this);
        this.bit32.addActionListener(this);
        this.bit_32.addActionListener(this);
        this.bit_64.addActionListener(this);
        this.groupBitpix.add(this.bit8);
        this.groupBitpix.add(this.bit16);
        this.groupBitpix.add(this.bit32);
        this.groupBitpix.add(this.bit_32);
        this.groupBitpix.add(this.bit_64);
    }

    @Override
    public void show() {
        super.show();
        this.mainPanel.init();
        this.mainPanel.resumeWidgets();
    }

    private String getCoverageString() {
        double d = this.context.getIndexSkyArea();
        if (d == 1.0) {
            return "whole sky ";
        }
        double d2 = Math.toDegrees(1.0);
        double d3 = Math.PI * 4 * d2 * d2;
        return Util.round(d * 100.0, 3) + "% of sky => " + Coord.getUnit(d3 * d, false, true) + "^2 ";
    }

    protected void resumeWidgets() {
        try {
            boolean bl = this.context.isTaskRunning();
            boolean bl2 = this.context.isMap();
            boolean bl3 = this.context.isInputFile;
            boolean bl4 = (bl3 || bl2 || this.context.isExistingDir()) && this.mainPanel.tabDesc.outputField.getText().trim().length() > 0;
            boolean bl5 = this.context.getMocIndex() != null;
            this.moc.setEnabled(bl5);
            this.note.setText("<html><i>(*) " + this.getCoverageString() + "</i></html>");
            this.previous.setEnabled(bl4 && !bl);
            this.next.setEnabled(bl4 && !bl && this.context.isExistingAllskyDir());
            this.start.setEnabled(bl4 && !bl && !bl);
            this.pause.setEnabled(bl);
            this.abort.setEnabled(bl4 && bl);
            this.bit8.setEnabled(bl4 && !bl && this.bitpixOrig != 0);
            this.bit16.setEnabled(bl4 && !bl && this.bitpixOrig != 0);
            this.bit32.setEnabled(bl4 && !bl && this.bitpixOrig != 0);
            this.bit_32.setEnabled(bl4 && !bl && this.bitpixOrig != 0);
            this.bit_64.setEnabled(bl4 && !bl && this.bitpixOrig != 0);
            this.samplFast.setEnabled(bl4 && !bl && !bl2);
            this.overlayFast.setEnabled(bl4 && !bl && !bl2);
            this.samplBest.setEnabled(bl4 && !bl && !bl2);
            this.overlayBest.setEnabled(bl4 && !bl && !bl2);
            this.fading.setEnabled(bl4 && !bl && !bl2);
            tab.setBackground(bl4 && !bl ? Color.white : this.getBackground());
            this.setCursor(bl ? Cursor.getPredefinedCursor(3) : Cursor.getPredefinedCursor(0));
            tab.refresh();
            if (!bl) {
                if (bl2) {
                    JProgressBar jProgressBar = ((ContextGui)this.context).mainPanel.getProgressBarIndex();
                    jProgressBar.setValue(jProgressBar.getMaximum());
                    jProgressBar.setString("No indexation for map!");
                } else if (this.context.moc == null) {
                    JProgressBar jProgressBar = ((ContextGui)this.context).mainPanel.getProgressBarIndex();
                    jProgressBar.setValue(0);
                    jProgressBar.setString("");
                    jProgressBar = ((ContextGui)this.context).mainPanel.getProgressBarTile();
                    jProgressBar.setValue(0);
                    jProgressBar.setString("");
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void clearForms() {
        this.bitpixOrig = -1;
        this.bit8.setSelected(false);
        this.bit16.setSelected(false);
        this.bit32.setSelected(true);
        this.bit_32.setSelected(false);
        this.bit_64.setSelected(false);
        this.samplBest.setSelected(true);
        this.overlayBest.setSelected(true);
        this.fading.setSelected(true);
        tab.reset();
        this.resumeWidgets();
    }

    public int setSelectedOrder(int n) {
        int n2 = tab.setSelectedOrder(n);
        tab.setDefaultRow(n2);
        tab.repaint();
        return n2;
    }

    public int getOrder() {
        return tab.getOrder();
    }

    public void setOrder(int n) {
        this.setSelectedOrder(n);
    }

    public void setOriginalBitpixField(int n) {
        this.bitpixOrig = n;
        ((BitpixListener)this.bitpixListener).setDefault(n);
        switch (n) {
            case 0: {
                this.keepBB.doClick();
                break;
            }
            case 8: {
                this.bit8.doClick();
                break;
            }
            case 16: {
                this.bit16.doClick();
                break;
            }
            case 32: {
                this.bit32.doClick();
                break;
            }
            case -32: {
                this.bit_32.doClick();
                break;
            }
            case 64: {
                this.bit_64.doClick();
            }
        }
    }

    public int getOriginalBitpixField() {
        return this.bitpixOrig;
    }

    public int getBitpixField() {
        if (this.bitpixOrig == 0) {
            return 0;
        }
        ButtonModel buttonModel = this.groupBitpix.getSelection();
        int n = BuildTable.DEFAULT_BITPIX;
        try {
            n = Integer.parseInt(buttonModel.getActionCommand());
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        return n;
    }

    protected int getNpix() {
        return this.context.isColor() ? 4 : Math.abs(this.getBitpixField()) / 8;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        tab.setBitpix(this.getBitpixField());
        if (actionEvent.getSource() == this.start) {
            this.perform();
        } else if (actionEvent.getSource() == this.abort) {
            this.abort();
        } else if (actionEvent.getSource() == this.pause) {
            this.pause();
        } else if (actionEvent.getSource() == this.moc) {
            this.loadMoc();
        } else if (actionEvent.getSource() == this.next) {
            this.mainPanel.showJpgTab();
        } else if (actionEvent.getSource() == this.previous) {
            this.mainPanel.showDescTab();
        }
        this.mainPanel.resumeWidgets();
        this.resumeWidgets();
    }

    private void pause() {
        if (this.context.isTaskPause()) {
            this.context.setTaskPause(false);
            this.pause.setText(this.getString("PAUSE"));
        } else {
            this.context.setTaskPause(true);
            this.pause.setText(this.getString("RESUME"));
        }
    }

    private void abort() {
        if (!Aladin.confirmation(this.mainPanel, "Do you really want to abort the HEALPix survey computation ?")) {
            return;
        }
        this.context.taskAbort();
    }

    private void perform() {
        block9: {
            try {
                Vector<Action> vector = new Vector<Action>();
                boolean bl = this.context.isMap();
                if (!bl) {
                    if (this.mainPanel.tabDesc.isResetIndex()) {
                        vector.add(Action.CLEANINDEX);
                    }
                    vector.add(Action.INDEX);
                }
                if (this.mainPanel.tabDesc.isResetTiles()) {
                    vector.add(Action.CLEANTILES);
                }
                if (bl) {
                    vector.add(Action.MAPTILES);
                } else {
                    vector.add(Action.TILES);
                }
                if (!this.context.isColor()) {
                    vector.add(Action.GZIP);
                    if (!bl) {
                        vector.add(Action.DETAILS);
                    }
                }
                new Task(this.context, vector, false);
            }
            catch (Exception exception) {
                Aladin.warning(exception.getMessage());
                if (Aladin.levelTrace < 3) break block9;
                exception.printStackTrace();
            }
        }
    }

    class MethodSelectListener
    implements ActionListener {
        private JRadioButton samplFast = null;
        private JRadioButton overlayFast = null;
        private JRadioButton samplBest = null;
        private JRadioButton overlayBest = null;
        private JCheckBox fading = null;

        public MethodSelectListener(JRadioButton[] jRadioButtonArray, JCheckBox jCheckBox) {
            this.samplFast = jRadioButtonArray[0];
            this.overlayFast = jRadioButtonArray[1];
            this.samplBest = jRadioButtonArray[2];
            this.overlayBest = jRadioButtonArray[3];
            this.fading = jCheckBox;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.samplFast && !this.overlayFast.isSelected()) {
                this.overlayFast.doClick();
            }
            if (object == this.overlayFast && !this.samplFast.isSelected()) {
                this.samplFast.doClick();
            }
            if (object == this.samplBest && !this.overlayBest.isSelected()) {
                this.overlayBest.doClick();
            }
            if (object == this.overlayBest && !this.samplBest.isSelected()) {
                this.samplBest.doClick();
            }
            this.fading.setEnabled(this.samplBest.isSelected());
        }
    }

    class BitpixListener
    implements ActionListener {
        int defaultBitpix = BuildTable.DEFAULT_BITPIX;
        JCheckBox check = null;

        public BitpixListener(JCheckBox jCheckBox) {
            this.check = jCheckBox;
        }

        public void setDefault(int n) {
            this.defaultBitpix = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = Integer.parseInt(actionEvent.getActionCommand());
            if (n == this.defaultBitpix) {
                this.setKeepOn();
            } else {
                this.setKeepOff();
            }
        }

        private void setKeepOn() {
            this.check.setEnabled(true);
            this.check.setSelected(true);
        }

        private void setKeepOff() {
            this.check.setSelected(false);
            this.check.setEnabled(false);
        }
    }
}

