/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.Aladin;
import cds.allsky.Constante;
import cds.allsky.Context;
import cds.allsky.MainPanel;
import cds.allsky.Mode;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class TabDesc
extends JPanel
implements ActionListener {
    private String REP_SOURCE;
    private String REP_DEST;
    private String REP_DEST_RESET;
    private String INDEX_RESET;
    private JLabel infoLabel;
    private JLabel destLabel;
    private JLabel sourceLabel;
    private JLabel labelAllsky;
    private String LABELALLSKY;
    private String NEXT;
    private String SEE;
    private String INFOALLSKY;
    private String PARAMALLSKY;
    private String KEEPALLSKY;
    private String COADDALLSKY;
    private String OVERWRITEALLSKY;
    private String KEEPCELLALLSKY;
    private String SPECIFALLSKY;
    private String BLANKALLSKY;
    private String BORDERALLSKY;
    private String SKYVALALLSKY;
    private String HDUALLSKY;
    private JLabel paramLabel;
    private JRadioButton keepRadio;
    private JRadioButton coaddRadio;
    private JRadioButton overwriteRadio;
    private JRadioButton keepCellRadio;
    private JCheckBox specifCheckbox;
    private JCheckBox blankCheckbox;
    private JCheckBox hduCheckbox;
    private JCheckBox borderCheckbox;
    private JRadioButton skyvalCheckbox;
    private JCheckBox frameCheckbox;
    private JTextField specifTextField;
    protected JTextField blankTextField;
    protected JTextField hduTextField;
    protected JTextField borderTextField;
    private JTextField skyvalTextField;
    protected JTextField inputField = new JTextField(35);
    protected JTextField outputField = new JTextField(35);
    private JButton browseInput = new JButton();
    private JButton browseOutput = new JButton();
    private JCheckBox resetIndex = new JCheckBox();
    private JCheckBox resetTiles = new JCheckBox();
    private JTextField labelField = new JTextField(35);
    private String defaultDirectory;
    private String BROWSE;
    private JButton next;
    private JButton seeImg;
    private JButton reset;
    private String help;
    private String titlehelp;
    private MainPanel mainPanel;
    private Context context;

    public TabDesc(String string, final MainPanel mainPanel) {
        super(new BorderLayout());
        JComponent jComponent;
        this.mainPanel = mainPanel;
        this.context = mainPanel.context;
        this.createChaine();
        this.init();
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.defaultDirectory = string;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 3, 1, 3);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 4;
        jPanel.add((Component)this.infoLabel, gridBagConstraints);
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)this.sourceLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)Util.getHelpButton(this, this.getString("HELPDIRSRCALLSKY")), gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.inputField, gridBagConstraints);
        ++gridBagConstraints.gridx;
        if (Aladin.aladin.configuration.isLookAndFeelJava()) {
            jPanel.add((Component)this.browseInput, gridBagConstraints);
        }
        gridBagConstraints.insets.top = 1;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)this.destLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)Util.getHelpButton(this, this.getString("HELPDIRTRGALLSKY")), gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.outputField, gridBagConstraints);
        ++gridBagConstraints.gridx;
        if (Aladin.aladin.configuration.isLookAndFeelJava()) {
            jPanel.add((Component)this.browseOutput, gridBagConstraints);
        }
        gridBagConstraints.insets.bottom = 20;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)this.labelAllsky, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)Util.getHelpButton(this, this.getString("HELPLABELALLSKY")), gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.labelField, gridBagConstraints);
        gridBagConstraints.insets.bottom = 1;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.paramLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)Util.getHelpButton(this, this.getString("HELPPARAMALLSKY")), gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)this.resetIndex, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.resetTiles, gridBagConstraints);
        ++gridBagConstraints.gridy;
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        jPanel2.add(this.keepRadio);
        jPanel2.add(this.overwriteRadio);
        jPanel2.add(this.coaddRadio);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        if (Aladin.PROTO) {
            ++gridBagConstraints.gridy;
            jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
            jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
            jPanel2.add(this.keepCellRadio);
            jPanel.add((Component)jPanel2, gridBagConstraints);
        }
        gridBagConstraints.gridx = 2;
        ++gridBagConstraints.gridy;
        JPanel jPanel3 = new JPanel(new BorderLayout(0, 0));
        this.blankTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                TabDesc.this.blankCheckbox.setSelected(TabDesc.this.blankTextField.getText().trim().length() > 0);
            }
        });
        jPanel3.add((Component)this.blankCheckbox, "West");
        jPanel3.add((Component)this.blankTextField, "Center");
        jPanel.add((Component)jPanel3, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel3 = new JPanel(new BorderLayout(0, 0));
        this.hduTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                TabDesc.this.hduCheckbox.setSelected(TabDesc.this.hduTextField.getText().trim().length() > 0);
            }
        });
        jPanel3.add((Component)this.hduCheckbox, "West");
        jPanel3.add((Component)this.hduTextField, "Center");
        jPanel.add((Component)jPanel3, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel3 = new JPanel(new BorderLayout(0, 0));
        this.skyvalTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                TabDesc.this.skyvalCheckbox.setSelected(TabDesc.this.skyvalTextField.getText().trim().length() > 0);
            }
        });
        jPanel3.add((Component)this.skyvalCheckbox, "West");
        jPanel3.add((Component)this.skyvalTextField, "Center");
        jPanel.add((Component)jPanel3, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel3 = new JPanel(new BorderLayout(0, 0));
        this.borderTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                TabDesc.this.borderCheckbox.setSelected(TabDesc.this.borderTextField.getText().trim().length() > 0);
            }
        });
        jPanel3.add((Component)this.borderCheckbox, "West");
        jPanel3.add((Component)this.borderTextField, "Center");
        jPanel.add((Component)jPanel3, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel3 = new JPanel(new BorderLayout(0, 0));
        jPanel3.add((Component)this.specifCheckbox, "West");
        jPanel3.add((Component)this.specifTextField, "Center");
        this.specifTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                TabDesc.this.specifCheckbox.setSelected(TabDesc.this.specifTextField.getText().trim().length() > 0);
            }
        });
        jPanel.add((Component)jPanel3, gridBagConstraints);
        if (Aladin.PROTO) {
            ++gridBagConstraints.gridy;
            this.frameCheckbox = new JCheckBox("HEALPix in galactic (default is ICRS)", false);
            jComponent = this.frameCheckbox;
            ((AbstractButton)jComponent).addActionListener(new ActionListener((JCheckBox)jComponent){
                final /* synthetic */ JCheckBox val$cb1;
                {
                    this.val$cb1 = jCheckBox;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    mainPanel.context.setFrame(this.val$cb1.isSelected() ? 3 : 0);
                }
            });
            jPanel.add((Component)jComponent, gridBagConstraints);
        }
        jComponent = new JPanel(new BorderLayout());
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(Box.createHorizontalGlue());
        jPanel4.add(this.seeImg);
        jPanel4.add(this.reset);
        jPanel4.add(this.next);
        jPanel4.add(Box.createHorizontalGlue());
        jComponent.add((Component)jPanel4, "Center");
        this.add((Component)jPanel, "Center");
        this.add((Component)jComponent, "South");
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    private void createChaine() {
        this.REP_SOURCE = this.getString("REPSALLSKY");
        this.BROWSE = this.getString("FILEBROWSE");
        this.REP_DEST = this.getString("REPDALLSKY");
        this.REP_DEST_RESET = this.getString("REPRESALLSKY");
        this.INDEX_RESET = this.getString("INDEXRESETALLSKY");
        this.LABELALLSKY = this.getString("LABELALLSKY");
        this.SEE = this.getString("SEE");
        this.NEXT = this.getString("NEXT");
        this.titlehelp = this.getString("HHELP");
        this.INFOALLSKY = this.getString("INFOALLSKY");
        this.PARAMALLSKY = this.getString("PARAMALLSKY");
        this.COADDALLSKY = this.getString("COADDALLSKY");
        this.KEEPALLSKY = this.getString("KEEPALLSKY");
        this.KEEPCELLALLSKY = this.getString("KEEPCELLALLSKY");
        this.OVERWRITEALLSKY = this.getString("OVERWRITEALLSKY");
        this.SPECIFALLSKY = this.getString("SPECIFALLSKY");
        this.BLANKALLSKY = this.getString("BLANKALLSKY");
        this.HDUALLSKY = this.getString("HDUALLSKY");
        this.BORDERALLSKY = this.getString("BORDERALLSKY");
        this.SKYVALALLSKY = this.getString("SKYVALALLSKY");
    }

    private String getString(String string) {
        MainPanel mainPanel = this.mainPanel;
        return mainPanel.aladin.getChaine().getString(string);
    }

    public void init() {
        this.infoLabel = new JLabel(Util.fold(this.INFOALLSKY, 100, true));
        this.infoLabel.setFont(this.infoLabel.getFont().deriveFont(2));
        this.sourceLabel = new JLabel(this.REP_SOURCE);
        this.sourceLabel.setFont(this.sourceLabel.getFont().deriveFont(1));
        this.destLabel = new JLabel(this.REP_DEST);
        this.destLabel.setFont(this.destLabel.getFont().deriveFont(1));
        this.inputField.addActionListener(this);
        this.inputField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                super.keyTyped(keyEvent);
                if (!TabDesc.this.inputField.getText().equals("")) {
                    TabDesc.this.actionPerformed(new ActionEvent(TabDesc.this.inputField, -1, "dirBrowser Action"));
                }
            }
        });
        this.browseInput.setText(this.BROWSE);
        this.browseInput.addActionListener(this);
        this.outputField.addActionListener(this);
        this.outputField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                super.keyTyped(keyEvent);
                if (!TabDesc.this.outputField.getText().equals("")) {
                    TabDesc.this.actionPerformed(new ActionEvent(TabDesc.this.outputField, -1, "dirBrowser Action"));
                }
            }
        });
        this.browseOutput.setText(this.BROWSE);
        this.browseOutput.addActionListener(this);
        this.labelAllsky = new JLabel(this.LABELALLSKY);
        this.labelAllsky.setFont(this.labelAllsky.getFont().deriveFont(1));
        this.paramLabel = new JLabel(this.PARAMALLSKY);
        this.paramLabel.setFont(this.paramLabel.getFont().deriveFont(1));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.keepRadio = new JRadioButton(this.KEEPALLSKY);
        buttonGroup.add(this.keepRadio);
        this.overwriteRadio = new JRadioButton(this.OVERWRITEALLSKY);
        buttonGroup.add(this.overwriteRadio);
        this.coaddRadio = new JRadioButton(this.COADDALLSKY);
        buttonGroup.add(this.coaddRadio);
        this.keepCellRadio = new JRadioButton(this.KEEPCELLALLSKY);
        buttonGroup.add(this.keepCellRadio);
        this.keepRadio.setSelected(true);
        this.specifCheckbox = new JCheckBox(this.SPECIFALLSKY);
        this.specifCheckbox.setSelected(false);
        this.specifTextField = new JTextField();
        this.blankCheckbox = new JCheckBox(this.BLANKALLSKY);
        this.blankCheckbox.setSelected(false);
        this.blankTextField = new JTextField();
        this.hduCheckbox = new JCheckBox(this.HDUALLSKY);
        this.hduCheckbox.setSelected(false);
        this.hduTextField = new JTextField();
        this.borderCheckbox = new JCheckBox(this.BORDERALLSKY);
        this.borderCheckbox.setSelected(false);
        this.borderTextField = new JTextField();
        this.skyvalCheckbox = new JRadioButton(this.SKYVALALLSKY);
        this.skyvalCheckbox.setSelected(false);
        this.skyvalTextField = new JTextField();
        this.skyvalCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TabDesc.this.resumeWidgets();
            }
        });
        this.resetTiles.setText(this.REP_DEST_RESET);
        this.resetTiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TabDesc.this.resumeWidgets();
            }
        });
        this.resetIndex.setText(this.INDEX_RESET);
        this.resetIndex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TabDesc.this.resumeWidgets();
            }
        });
        this.seeImg = new JButton(this.SEE);
        this.seeImg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TabDesc.this.loadImgEtalon();
            }
        });
        this.reset = new JButton(this.getString("RESET"));
        this.reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TabDesc.this.mainPanel.clearForms();
            }
        });
        this.next = new JButton(this.NEXT);
        this.next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TabDesc.this.mainPanel.showBuildTab();
            }
        });
        this.resetTiles.setSelected(false);
        this.resetIndex.setSelected(true);
    }

    private void loadImgEtalon() {
        String string = this.context.getImgEtalon();
        if (string.endsWith(".hhh")) {
            string = string.substring(0, string.length() - 4) + ".jpg";
        }
        this.mainPanel.aladin.execAsyncCommand("load " + string);
    }

    @Override
    public void show() {
        super.show();
        this.resumeWidgets();
    }

    protected void resumeWidgets() {
        try {
            boolean bl = this.context.isColor();
            boolean bl2 = this.context.isExistingDir();
            boolean bl3 = this.context.isExistingAllskyDir();
            boolean bl4 = this.context.isExistingIndexDir();
            boolean bl5 = this.context.isTaskRunning();
            boolean bl6 = this.context.isMap();
            this.resetTiles.setEnabled(bl3 && !bl5);
            this.resetIndex.setEnabled(bl4 && !bl5);
            boolean bl7 = !this.resetTiles.isSelected() && this.resetTiles.isEnabled();
            this.keepRadio.setEnabled(bl7);
            this.keepCellRadio.setEnabled(bl7);
            this.overwriteRadio.setEnabled(bl7);
            this.coaddRadio.setEnabled(bl7);
            boolean bl8 = (bl2 || bl6) && this.outputField.getText().trim().length() > 0;
            this.seeImg.setEnabled(this.context.getImgEtalon() != null && !bl6);
            this.next.setEnabled(bl8);
            this.reset.setEnabled(this.getInputField().trim().length() > 0);
            this.blankCheckbox.setEnabled(bl8 && !bl5 && !bl);
            this.blankTextField.setEnabled(bl8 && !bl5 && !bl);
            this.hduCheckbox.setEnabled(bl8 && !bl5 && !bl && !bl6);
            this.hduTextField.setEnabled(bl8 && !bl5 && !bl && !bl6);
            this.borderCheckbox.setEnabled(bl8 && !bl5 && !bl6);
            this.borderTextField.setEnabled(bl8 && !bl5 && !bl6);
            this.skyvalCheckbox.setEnabled(bl8 && !bl5 && !bl && !bl6);
            this.skyvalTextField.setEnabled(bl8 && !bl5 && !bl && !bl6);
            this.specifCheckbox.setEnabled(bl8 && !bl5 && !bl6);
            this.specifTextField.setEnabled(bl8 && !bl5 && !bl6);
            if (this.frameCheckbox != null) {
                this.frameCheckbox.setEnabled(bl8 && !bl5 && !bl6);
            }
            this.inputField.setEnabled(!bl5);
            this.outputField.setEnabled(!bl5);
            this.labelField.setEnabled(!bl5);
            if (this.skyvalCheckbox.isSelected() && this.skyvalTextField.getText().trim().length() == 0) {
                this.skyvalTextField.setText("true");
            }
            this.setCursor(bl5 ? Cursor.getPredefinedCursor(3) : Cursor.getPredefinedCursor(0));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void clearForms() {
        this.inputField.setText("");
        this.outputField.setText("");
        if (this.mainPanel != null) {
            this.mainPanel.actionPerformed(new ActionEvent("", -1, "dirBrowser Action"));
        }
        this.labelField.setText("");
        this.resetTiles.setSelected(false);
        this.resetIndex.setSelected(true);
        this.resumeWidgets();
    }

    private void dirBrowser(JTextField jTextField) {
        String string = jTextField.getText().trim();
        String string2 = Util.dirBrowser("", string, jTextField, 1);
        if (string2 == null) {
            return;
        }
        this.mainPanel.actionPerformed(new ActionEvent(jTextField, -1, "dirBrowser Action"));
    }

    public String getInputField() {
        return this.inputField.getText();
    }

    public String getOutputField() {
        return this.outputField.getText();
    }

    public void setOutputField(String string) {
        this.outputField.setText(string);
    }

    public Mode getCoaddModeField() {
        return this.resetTiles.isSelected() ? Mode.REPLACETILE : (this.keepRadio.isSelected() ? Mode.KEEP : (this.keepCellRadio.isSelected() ? Mode.KEEPTILE : (this.overwriteRadio.isSelected() ? Mode.OVERWRITE : (this.coaddRadio.isSelected() ? Mode.AVERAGE : Mode.REPLACETILE))));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.inputField) {
            this.initTxt();
        } else if (actionEvent.getSource() == this.browseInput) {
            this.dirBrowser(this.inputField);
            this.initTxt();
        }
        if (actionEvent.getSource() == this.outputField) {
            this.newAllskyDir();
        } else if (actionEvent.getSource() == this.browseOutput) {
            this.dirBrowser(this.outputField);
            this.newAllskyDir();
        }
    }

    private void initTxt() {
        String string = this.inputField.getText();
        int n = string.lastIndexOf(Util.FS);
        if (n == -1) {
            return;
        }
        while (n + 1 == string.length()) {
            string = string.substring(0, n);
        }
        String string2 = string.substring(string.lastIndexOf(Util.FS) + 1);
        this.labelField.setText(string2);
        this.outputField.setText("");
        this.newAllskyDir();
    }

    public String getLabelField() {
        return this.labelField.getText();
    }

    public String getMocField() {
        if (!this.specifCheckbox.isSelected()) {
            return "";
        }
        return this.specifTextField.getText();
    }

    public String getBlank() {
        if (!this.blankCheckbox.isSelected()) {
            return "";
        }
        return this.blankTextField.getText();
    }

    public String getHDU() {
        if (!this.hduCheckbox.isSelected()) {
            return "";
        }
        return this.hduTextField.getText();
    }

    public String getBorderSize() {
        if (!this.borderCheckbox.isSelected()) {
            return "0";
        }
        return this.borderTextField.getText();
    }

    public String getSkyvalField() {
        if (!this.skyvalCheckbox.isSelected()) {
            return null;
        }
        String string = this.skyvalTextField.getText().toUpperCase().trim();
        if (string.length() == 0) {
            string = "true";
        }
        return string;
    }

    private void newAllskyDir() {
        String string = this.outputField.getText();
        while (string.endsWith(Util.FS)) {
            string = string.substring(0, string.lastIndexOf(Util.FS));
        }
        if (string.equals("")) {
            this.initOutputField();
            this.mainPanel.newAllskyDir();
            return;
        }
        Constante.SURVEY = string.substring(string.lastIndexOf(Util.FS) + 1);
        this.mainPanel.newAllskyDir();
        this.resumeWidgets();
    }

    private void initOutputField() {
        Constante.SURVEY = this.getLabelField() + "HiPS";
        String string = this.inputField.getText();
        while (string.endsWith(Util.FS)) {
            string = string.substring(0, string.lastIndexOf(Util.FS));
        }
        this.outputField.setText(string + "HiPS" + Util.FS);
    }

    public boolean isResetTiles() {
        return this.resetTiles.isSelected() && this.resetTiles.isEnabled();
    }

    public boolean isResetIndex() {
        return this.resetIndex.isSelected() && this.resetIndex.isEnabled();
    }

    public void help() {
        JOptionPane.showMessageDialog(this, this.help, this.titlehelp, 1);
    }
}

