/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.Aladin;
import cds.aladin.PlanBG;
import cds.aladin.PlanImage;
import cds.aladin.prop.PropPanel;
import cds.allsky.Action;
import cds.allsky.Context;
import cds.allsky.MainPanel;
import cds.allsky.Task;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ColorModel;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class TabJpg
extends JPanel
implements ActionListener {
    private String CUT_MAX = "Max";
    private String CUT_MIN = "Min";
    private JTextField tCutMin = new JTextField(10);
    private JTextField tCutMax = new JTextField(10);
    private JLabel label;
    private JRadioButton radioManual;
    private JRadioButton radioAllsky;
    private JLabel labelMethod;
    private JRadioButton radioMediane;
    private JRadioButton radioMoyenne;
    private JLabel labelFormat;
    private JRadioButton jpegFormat;
    private JRadioButton pngFormat;
    private JLabel currentCM;
    private JLabel warning;
    private JButton start;
    private JButton abort;
    private JButton pause;
    private JButton next;
    private JButton previous;
    private JButton moc;
    private JProgressBar progressJpg = new JProgressBar(0, 100);
    private final MainPanel mainPanel;
    private Context context;
    private JLabel tileStat;
    private JLabel timeStat;

    private String getString(String string) {
        MainPanel mainPanel = this.mainPanel;
        return mainPanel.aladin.getChaine().getString(string);
    }

    public TabJpg(MainPanel mainPanel) {
        super(new BorderLayout());
        JLabel jLabel;
        JRadioButton jRadioButton;
        JLabel jLabel2;
        this.mainPanel = mainPanel;
        this.context = mainPanel.context;
        ButtonGroup buttonGroup = new ButtonGroup();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 25, 5, 25));
        this.warning = new JLabel(" ");
        this.warning.setFont(this.warning.getFont().deriveFont(1));
        this.warning.setForeground(Color.red);
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets.bottom = 20;
        jPanel.add((Component)this.warning, gridBagConstraints);
        gridBagConstraints.insets.bottom = 5;
        ++gridBagConstraints.gridy;
        ++gridBagConstraints.gridy;
        this.label = jLabel2 = new JLabel(Util.fold(this.getString("JPEGINFOALLSKY"), 80, true));
        jLabel2.setFont(jLabel2.getFont().deriveFont(2));
        gridBagConstraints.gridheight = 5;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.insets.bottom = 0;
        ++gridBagConstraints.gridy;
        ++gridBagConstraints.gridy;
        ++gridBagConstraints.gridy;
        ++gridBagConstraints.gridy;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridheight = 1;
        this.currentCM = new JLabel();
        boolean bl = !this.updateCurrentCM();
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.radioManual = jRadioButton = new JRadioButton(this.getString("JPEGMCUTALLSKY"));
        jRadioButton.setSelected(bl);
        this.tCutMin.setEnabled(bl);
        this.tCutMax.setEnabled(bl);
        jRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = TabJpg.this.radioManual.isSelected();
                TabJpg.this.tCutMin.setEnabled(bl);
                TabJpg.this.tCutMax.setEnabled(bl);
            }
        });
        jRadioButton.setFont(jRadioButton.getFont().deriveFont(1));
        buttonGroup.add(jRadioButton);
        jPanel.add((Component)jRadioButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)Util.getHelpButton(this, this.getString("HELPJPEGMCUTALLSKY")), gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jLabel2 = new JLabel(this.CUT_MIN);
        jPanel2.add(jLabel2);
        jPanel2.add(this.tCutMin);
        jLabel2 = new JLabel(this.CUT_MAX);
        jPanel2.add(jLabel2);
        jPanel2.add(this.tCutMax);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        int n = gridBagConstraints.insets.top;
        gridBagConstraints.insets.top = 20;
        this.radioAllsky = jRadioButton = new JRadioButton(this.getString("JPEGCUTALLSKY"));
        jRadioButton.setSelected(!bl);
        jRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = TabJpg.this.radioManual.isSelected();
                TabJpg.this.tCutMin.setEnabled(bl);
                TabJpg.this.tCutMax.setEnabled(bl);
            }
        });
        jRadioButton.setFont(jRadioButton.getFont().deriveFont(1));
        jRadioButton.setSelected(true);
        buttonGroup.add(jRadioButton);
        jPanel.add((Component)jRadioButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)Util.getHelpButton(this, this.getString("HELPJPEGCUTALLSKY")), gridBagConstraints);
        gridBagConstraints.insets.top = n;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.currentCM, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        n = gridBagConstraints.insets.top;
        gridBagConstraints.insets.top = 20;
        JPanel jPanel3 = new JPanel();
        this.labelFormat = jLabel = new JLabel(this.getString("FORMATTILES"));
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jPanel3.add(jLabel);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.jpegFormat = jRadioButton = new JRadioButton("JPEG");
        buttonGroup2.add(jRadioButton);
        jPanel3.add(jRadioButton);
        this.pngFormat = jRadioButton = new JRadioButton("PNG");
        jRadioButton.setSelected(true);
        buttonGroup2.add(jRadioButton);
        jPanel3.add(jRadioButton);
        jPanel.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.insets.top = n;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jPanel3 = new JPanel();
        this.labelMethod = jLabel = new JLabel(this.getString("METHODJPG"));
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jPanel3.add(jLabel);
        buttonGroup2 = new ButtonGroup();
        this.radioMediane = jRadioButton = new JRadioButton(this.getString("MEDIANJPG"));
        jRadioButton.setSelected(true);
        buttonGroup2.add(jRadioButton);
        jPanel3.add(jRadioButton);
        this.radioMoyenne = jRadioButton = new JRadioButton(this.getString("AVERAGEJPG"));
        buttonGroup2.add(jRadioButton);
        jPanel3.add(jRadioButton);
        jPanel.add((Component)jPanel3, gridBagConstraints);
        this.progressJpg.setStringPainted(true);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setBorder(new EmptyBorder(0, 55, 15, 55));
        jPanel4.add((Component)this.progressJpg, "Center");
        jPanel4.add((Component)this.createStatPanel(), "South");
        JPanel jPanel5 = new JPanel(new BorderLayout());
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 0));
        jPanel6.add(Box.createHorizontalGlue());
        this.previous = new JButton(this.getString("PREVIOUS"));
        this.previous.addActionListener(this);
        this.previous.addActionListener(this);
        jPanel6.add(this.previous);
        this.moc = new JButton(this.getString("LOADMOCP"));
        this.moc.addActionListener(this);
        jPanel6.add(this.moc);
        this.start = new JButton(this.getString("JPEGBUILDALLSKY"));
        this.start.addActionListener(this);
        jPanel6.add(this.start);
        this.pause = new JButton(this.getString("PAUSE"));
        this.pause.addActionListener(this);
        jPanel6.add(this.pause);
        this.abort = new JButton(this.getString("ABORT"));
        this.abort.addActionListener(this);
        jPanel6.add(this.abort);
        jPanel6.add(Box.createRigidArea(new Dimension(10, 0)));
        this.next = new JButton(this.getString("NEXT"));
        this.next.addActionListener(this);
        this.next.addActionListener(this);
        jPanel6.add(this.next);
        jPanel6.add(Box.createHorizontalGlue());
        jPanel5.add((Component)jPanel4, "North");
        jPanel5.add((Component)jPanel6, "Center");
        this.add((Component)jPanel, "Center");
        this.add((Component)jPanel5, "South");
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.start) {
            Object object;
            if (!this.radioManual.isSelected()) {
                try {
                    object = (PlanBG)this.mainPanel.aladin.calque.getPlanBase();
                    if (!object.isTruePixels()) {
                        throw new Exception();
                    }
                }
                catch (Exception exception) {
                    Aladin cfr_ignored_0 = this.mainPanel.aladin;
                    Aladin.warning(this.mainPanel, "<html>There is no current view,<br>or the current view is not an all-sky view in true pixel mode");
                    return;
                }
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.context.setJpegMethod(this.getMethod());
            this.context.setProgressBar(this.progressJpg);
            object = this.getTileFormat() == 0 ? Action.PNG : Action.JPEG;
            this.context.setValidateCut(false);
            try {
                new Task(this.context, (Action)((Object)object), false);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (actionEvent.getSource() == this.abort) {
            this.abort();
        } else if (actionEvent.getSource() == this.pause) {
            this.pause();
        } else if (actionEvent.getSource() == this.next) {
            this.mainPanel.showPubTab();
        } else if (actionEvent.getSource() == this.previous) {
            this.mainPanel.showBuildTab();
        } else if (actionEvent.getSource() == this.moc) {
            this.loadMoc();
        }
        this.resumeWidgets();
    }

    private void pause() {
        if (this.context.isTaskPause()) {
            this.context.setTaskPause(false);
            this.pause.setText(this.getString("PAUSE"));
        } else {
            this.context.setTaskPause(true);
            this.pause.setText(this.getString("RESUME"));
        }
    }

    private void abort() {
        if (!Aladin.confirmation(this.mainPanel, "Do you really want to abort the compressed tile computation ?")) {
            return;
        }
        this.context.taskAbort();
    }

    private void loadMoc() {
        String string = this.context.getOutputPath() + Util.FS + "Moc.fits";
        this.mainPanel.aladin.execAsyncCommand("load " + string);
    }

    private JPanel createStatPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 10, 2, 2);
        JPanel jPanel = new JPanel(gridBagLayout);
        this.tileStat = new JLabel("--");
        PropPanel.addCouple(jPanel, ".Tiles: ", this.tileStat, gridBagLayout, gridBagConstraints);
        this.timeStat = new JLabel("--");
        PropPanel.addCouple(jPanel, ".Time: ", this.timeStat, gridBagLayout, gridBagConstraints);
        return jPanel;
    }

    protected void setStat(String string, String string2) {
        this.tileStat.setText(string);
        this.timeStat.setText(string2);
    }

    public void setCutMin(String string) {
        this.tCutMin.setText(string);
    }

    public void setCutMax(String string) {
        this.tCutMax.setText(string);
    }

    public String getCutMin() {
        return this.tCutMin.getText().trim();
    }

    public String getCutMax() {
        return this.tCutMax.getText().trim();
    }

    private boolean isExistingMoc() {
        String string = this.context.getOutputPath() + Util.FS + "Moc.fits";
        return string != null && new File(string).exists();
    }

    public boolean isCutFromPlanBase() {
        return !this.radioManual.isSelected();
    }

    public ColorModel getCM() {
        if (this.radioManual.isSelected()) {
            return null;
        }
        return ((PlanImage)this.mainPanel.aladin.calque.getPlanBase()).getCM();
    }

    public Context.JpegMethod getMethod() {
        if (this.radioMediane.isSelected()) {
            return Context.JpegMethod.MEDIAN;
        }
        return Context.JpegMethod.MEAN;
    }

    public int getTileFormat() {
        if (this.pngFormat.isSelected()) {
            return 0;
        }
        return 1;
    }

    protected void resumeWidgets() {
        block2: {
            try {
                boolean bl = this.context.isExistingDir() || this.context.isExistingAllskyDir();
                boolean bl2 = this.context.isTaskRunning();
                boolean bl3 = this.context.isColor();
                this.moc.setEnabled(this.isExistingMoc());
                this.previous.setEnabled(bl && !bl2);
                this.next.setEnabled(bl && !bl2);
                this.tCutMin.setEnabled(bl && !bl3);
                this.tCutMax.setEnabled(bl && !bl3);
                this.radioManual.setEnabled(bl && !bl3);
                this.labelMethod.setEnabled(bl && !bl3);
                this.radioAllsky.setEnabled(bl && !bl3);
                this.radioMediane.setEnabled(bl && !bl2 && !bl3);
                this.radioMoyenne.setEnabled(bl && !bl2 && !bl3);
                this.labelFormat.setEnabled(bl && !bl3);
                this.jpegFormat.setEnabled(bl && !bl3);
                this.pngFormat.setEnabled(bl && !bl3);
                this.progressJpg.setEnabled(bl && !bl2 && !bl3);
                this.start.setEnabled(bl && !bl2 && !bl3);
                this.pause.setEnabled(bl2);
                this.abort.setEnabled(bl2);
                this.setCursor(bl2 ? Cursor.getPredefinedCursor(3) : Cursor.getPredefinedCursor(0));
                this.warning.setText(bl3 ? Util.fold(this.getString("MNOPOST"), 60, true) : "");
                this.label.setEnabled(!bl3);
            }
            catch (Exception exception) {
                if (Aladin.levelTrace < 3) break block2;
                exception.printStackTrace();
            }
        }
    }

    public void clearForms() {
        this.tCutMin.setText("");
        this.tCutMax.setText("");
        this.radioManual.setSelected(true);
        this.radioMediane.setSelected(true);
        this.progressJpg.setValue(0);
        this.jpegFormat.setSelected(true);
    }

    public void setStartEnabled(boolean bl) {
        this.start.setEnabled(bl);
        this.next.setEnabled(bl);
    }

    @Override
    public void show() {
        this.updateCurrentCM();
        this.resumeWidgets();
        super.show();
    }

    public boolean updateCurrentCM() {
        String string;
        boolean bl = true;
        try {
            PlanImage planImage = (PlanImage)this.mainPanel.aladin.calque.getPlanBase();
            if (!planImage.hasAvailablePixels()) {
                throw new Exception();
            }
            string = "<html><i>Pixels:<b> " + planImage.getPixelMinInfo() + " .. " + planImage.getPixelMaxInfo() + "</b> from " + planImage.getDataMinInfo() + " .. " + planImage.getDataMaxInfo() + " - Transfert function: <b>" + planImage.getTransfertFctInfo() + "</b></i>";
        }
        catch (Exception exception) {
            string = "<html><i>No compatible image/survey presently displayed !</i>";
            bl = false;
        }
        this.currentCM.setText(string);
        return bl;
    }
}

