/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.Aladin;
import cds.allsky.Context;
import cds.allsky.FrameGlu;
import cds.allsky.MainPanel;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class TabPub
extends JPanel
implements ActionListener {
    private static String NEXT;
    private static String PUBLISH;
    private static String EXPORT;
    private static String OPEN;
    private static String LOCAL_FULL;
    private JTextField url = new JTextField(40);
    private JTextField pathLocal = new JTextField(40);
    private JButton bLocal = new JButton();
    private JButton bPublic = new JButton();
    private JButton bExport = new JButton();
    protected JButton bNext = new JButton();
    JProgressBar progressHpx = new JProgressBar(0, 100);
    private Aladin aladin;
    private MainPanel mainPanel;
    private Context context;
    private String mapfile;
    private boolean running = false;

    public TabPub(Aladin aladin, MainPanel mainPanel) {
        super(new BorderLayout());
        this.aladin = aladin;
        this.mainPanel = mainPanel;
        this.context = mainPanel.context;
        this.createChaine();
        Border border = BorderFactory.createEmptyBorder(20, 0, 0, 0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridy = 0;
        this.initBtn();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 20, 0, 20));
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        JLabel jLabel = new JLabel(this.getString("PUBFORYOUALLSKY"));
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jPanel.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)new JLabel(LOCAL_FULL), gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.pathLocal, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        JLabel jLabel2 = new JLabel(this.getString("PUBRESTALLSKY"));
        jLabel2.setFont(jLabel.getFont());
        jLabel2.setBorder(border);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)new JLabel(Util.fold(this.getString("PUBRESTINFOALLSKY"), 80, true)), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)this.url, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        JLabel jLabel3 = new JLabel(Util.fold(this.getString("PUBMAPALLSKY"), 80, true));
        jLabel3.setFont(jLabel3.getFont().deriveFont(1));
        jLabel3.setBorder(border);
        jPanel.add((Component)jLabel3, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)new JLabel(Util.fold(this.getString("PUBMAPINFOALLSKY"), 80, true)), gridBagConstraints);
        this.progressHpx.setStringPainted(true);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(5, 15, 5, 15));
        jPanel2.add(this.progressHpx);
        jPanel.add((Component)this.progressHpx, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.bExport, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        JLabel jLabel4 = new JLabel(this.getString("PUBLICALLSKY"));
        jLabel4.setFont(jLabel.getFont());
        jLabel4.setBorder(border);
        jPanel.add((Component)jLabel4, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)new JLabel(Util.fold(this.getString("PUBLICINFOALLSKY"), 80, true)), gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)this.bPublic, gridBagConstraints);
        this.add((Component)jPanel, "Center");
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    private void initBtn() {
        this.bNext = new JButton(NEXT);
        this.bNext.addActionListener(this);
        this.bExport.setText(EXPORT);
        this.bExport.addActionListener(this);
        this.bPublic.setText(PUBLISH);
        this.bPublic.addActionListener(this);
        this.bLocal.setText(OPEN);
        this.bLocal.addActionListener(this);
    }

    public void clearForms() {
        this.url.setText("");
    }

    private void createChaine() {
        LOCAL_FULL = this.getString("OPENALLSKY");
        OPEN = this.getString("MOPENLOAD");
        NEXT = this.getString("NEXT");
        PUBLISH = this.getString("PUBLISHALLSKY");
        EXPORT = this.getString("EXPORTALLSKY");
    }

    private String getString(String string) {
        TabPub tabPub = this;
        return tabPub.aladin.getChaine().getString(string);
    }

    public void newAllskyDir(String string) {
        this.url.setText("http://servername.org/" + string);
        this.url.repaint();
        this.pathLocal.setText(this.context.getOutputPath());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand() == PUBLISH) {
            new FrameGlu(this.aladin, this.context);
        } else if (actionEvent.getSource() == this.bExport) {
            this.mapfile = this.dirBrowserHPX();
            if (this.mapfile == null) {
                return;
            }
            this.bExport.setSelected(true);
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.mapfile = this.aladin.getFullFileName(this.mapfile);
            ExportThread exportThread = new ExportThread(this.mainPanel, this.mapfile);
            exportThread.start();
            new ThreadProgressBar(exportThread).start();
        } else if (actionEvent.getSource() == this.bNext) {
            this.mainPanel.showRgbTab();
        }
    }

    private String dirBrowserHPX() {
        FileDialog fileDialog = new FileDialog((Frame)this.aladin.frameAllsky, "Running directory selection", 1);
        fileDialog.setDirectory(this.context.getOutputPath());
        fileDialog.setVisible(true);
        if (fileDialog.getFile() == null) {
            return null;
        }
        return fileDialog.getDirectory() + fileDialog.getFile();
    }

    public void setStartEnabled(boolean bl) {
        this.resumeWidgets();
    }

    public void setProgress(int n) {
        this.progressHpx.setValue(n);
        if (n == 100) {
            Aladin.info(this, "Your HEALPix map has been successfully created\n" + this.mapfile);
        }
    }

    @Override
    public void show() {
        super.show();
        this.resumeWidgets();
    }

    protected void resumeWidgets() {
        try {
            boolean bl = this.context.isColor();
            boolean bl2 = this.context.isExistingAllskyDir();
            boolean bl3 = this.context.isTaskRunning() || this.running;
            this.bPublic.setEnabled(!bl3 && bl2);
            this.bExport.setEnabled(!bl3 && !bl && bl2);
            this.setCursor(bl3 ? Cursor.getPredefinedCursor(3) : Cursor.getPredefinedCursor(0));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    class ExportThread
    implements Runnable {
        String outfile;
        MainPanel allsky;
        int progress = 0;

        public ExportThread(MainPanel mainPanel, String string) {
            this.allsky = mainPanel;
            this.outfile = string;
        }

        public int getProgress() {
            File file = new File(this.outfile);
            if (!file.exists()) {
                return 0;
            }
            long l = file.length() / 1024L / 1024L;
            long l2 = 0xC000000 * TabPub.this.context.getNpix() / 1024 / 1024;
            return (int)(100L * l / l2);
        }

        public synchronized void start() {
            new Thread(this).start();
        }

        @Override
        public void run() {
            TabPub.this.running = true;
            File file = new File(this.outfile);
            file.delete();
            this.allsky.export(this.outfile);
            TabPub.this.running = false;
        }
    }

    class ThreadProgressBar
    implements Runnable {
        Object thread;

        public ThreadProgressBar(Object object) {
            this.thread = object;
        }

        public synchronized void start() {
            new Thread(this).start();
        }

        @Override
        public void run() {
            int n = 0;
            while (this.thread != null && n < 99) {
                n = ((ExportThread)this.thread).getProgress();
                TabPub.this.setProgress(n);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            TabPub.this.setProgress(100);
            TabPub.this.resumeWidgets();
        }
    }
}

