/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.Aladin;
import cds.aladin.Chaine;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.prop.PropPanel;
import cds.allsky.Action;
import cds.allsky.Context;
import cds.allsky.ContextGui;
import cds.allsky.MainPanel;
import cds.allsky.Task;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class TabRgb
extends JPanel
implements ActionListener {
    private static String B;
    private static String G;
    private static String R;
    private String REP_DEST;
    private String RGBALLSKY;
    private String BROWSE;
    private String HELP;
    private String CHOOSE = "-- select a plane --";
    private JLabel dirLabel = new JLabel();
    private JButton browse = new JButton();
    private JTextField outputField = new JTextField(30);
    private JRadioButton radioMediane;
    private JRadioButton formatJpeg;
    JProgressBar progressBar = new JProgressBar(0, 100);
    private JComboBox[] ch;
    private JButton start;
    private JButton abort;
    private JButton pause;
    private JButton help = new JButton();
    private final Aladin aladin;
    private MainPanel mainPanel;
    private ContextGui context;
    private String titlehelp;
    private JLabel tileStat;
    private JLabel timeStat;

    public TabRgb(Aladin aladin, MainPanel mainPanel) {
        super(new BorderLayout());
        JRadioButton jRadioButton;
        this.aladin = aladin;
        this.mainPanel = mainPanel;
        this.context = mainPanel.context;
        this.createChaine(Aladin.getChaine());
        this.help = Util.getHelpButton(this, this.HELP);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 55, 5, 55));
        JLabel jLabel = new JLabel(Util.fold(this.RGBALLSKY, 80, true));
        jLabel.setFont(jLabel.getFont().deriveFont(2));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.bottom = 20;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets.bottom = 2;
        int n = 3;
        this.ch = new JComboBox[n];
        for (int i = 0; i < n; ++i) {
            this.ch[i] = new JComboBox();
            this.ch[i].addActionListener(this);
            this.ch[i].setPreferredSize(new Dimension(200, 20));
            JLabel jLabel2 = new JLabel(this.getLabelSelector(i));
            jLabel2.setForeground(this.getColorLabel(i));
            gridBagConstraints.gridwidth = -1;
            gridBagConstraints.weightx = 0.0;
            jPanel.add((Component)jLabel2, gridBagConstraints);
            gridBagConstraints.gridwidth = 0;
            jPanel.add((Component)this.ch[i], gridBagConstraints);
            this.ch[i].addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    TabRgb.this.init();
                }
            });
        }
        this.init();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        this.dirLabel = new JLabel(this.REP_DEST);
        jPanel.add((Component)this.dirLabel, gridBagConstraints);
        this.browse.setText(this.BROWSE);
        this.browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TabRgb.this.dirBrowser(TabRgb.this.outputField);
            }
        });
        jPanel2.add(this.outputField);
        this.outputField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                TabRgb.this.resumeWidgets();
            }
        });
        if (Aladin.aladin.configuration.isLookAndFeelJava()) {
            jPanel2.add(this.browse);
        }
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        int n2 = gridBagConstraints.insets.top;
        gridBagConstraints.insets.top = 20;
        JPanel jPanel3 = new JPanel();
        JLabel jLabel3 = new JLabel(this.getString("METHODJPG"));
        jLabel3.setFont(jLabel3.getFont().deriveFont(1));
        jPanel3.add(jLabel3);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.radioMediane = jRadioButton = new JRadioButton(this.getString("MEDIANJPG"));
        jRadioButton.setSelected(true);
        buttonGroup.add(jRadioButton);
        jPanel3.add(jRadioButton);
        jRadioButton = new JRadioButton(this.getString("AVERAGEJPG"));
        buttonGroup.add(jRadioButton);
        jPanel3.add(jRadioButton);
        jPanel.add((Component)jPanel3, gridBagConstraints);
        n2 = gridBagConstraints.insets.top = n2;
        gridBagConstraints.insets.top = 0;
        jPanel3 = new JPanel();
        jLabel3 = new JLabel("Output tile format:");
        jLabel3.setFont(jLabel3.getFont().deriveFont(1));
        buttonGroup = new ButtonGroup();
        jPanel3.add(jLabel3);
        this.formatJpeg = jRadioButton = new JRadioButton("JPEG (faster)");
        buttonGroup.add(jRadioButton);
        jPanel3.add(jRadioButton);
        jRadioButton = new JRadioButton("PNG (better)");
        jRadioButton.setSelected(true);
        buttonGroup.add(jRadioButton);
        jPanel3.add(jRadioButton);
        jPanel.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.insets.top = n2;
        this.progressBar.setStringPainted(true);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setBorder(new EmptyBorder(50, 0, 15, 0));
        jPanel4.add((Component)this.progressBar, "Center");
        jPanel4.add((Component)this.createStatPanel(), "South");
        jPanel.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 0));
        jPanel6.add(Box.createHorizontalGlue());
        this.start = new JButton(this.getString("START"));
        this.start.addActionListener(this);
        jPanel6.add(this.start);
        this.pause = new JButton(this.getString("PAUSE"));
        this.pause.addActionListener(this);
        jPanel6.add(this.pause);
        this.abort = new JButton(this.getString("ABORT"));
        this.abort.addActionListener(this);
        jPanel6.add(this.abort);
        jPanel6.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel6.add(Box.createHorizontalGlue());
        jPanel5.add((Component)jPanel6, "Center");
        jPanel5.add((Component)this.help, "East");
        this.add((Component)jPanel, "Center");
        this.add((Component)jPanel5, "South");
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    protected String getLabelSelector(int n) {
        return n == 0 ? R : (n == 1 ? G : (n == 2 ? B : ""));
    }

    protected Color getColorLabel(int n) {
        return n == 0 ? Color.red : (n == 1 ? Color.green : (n == 2 ? Color.blue : Color.black));
    }

    private void createChaine(Chaine chaine) {
        this.BROWSE = this.getString("FILEBROWSE");
        this.REP_DEST = this.getString("REPDALLSKY");
        this.RGBALLSKY = this.getString("RGBALLSKY");
        this.HELP = this.getString("HELPRGBALLSKY");
        this.titlehelp = this.getString("HHELP");
        R = this.getString("RGBRED");
        G = this.getString("RGBGREEN");
        B = this.getString("RGBBLUE");
    }

    private String getString(String string) {
        MainPanel mainPanel = this.mainPanel;
        return mainPanel.aladin.getChaine().getString(string);
    }

    public Context.JpegMethod getMethod() {
        if (this.radioMediane.isSelected()) {
            return Context.JpegMethod.MEDIAN;
        }
        return Context.JpegMethod.MEAN;
    }

    public int getFormat() {
        if (this.formatJpeg.isSelected()) {
            return 1;
        }
        return 0;
    }

    protected PlanBG[] getPlan() {
        try {
            Vector<Plan> vector = this.aladin.calque.getPlanBG();
            if (vector == null) {
                return new PlanBG[0];
            }
            for (PlanBG planBG : vector) {
                if (!planBG.isColored()) continue;
                vector.remove(planBG);
            }
            Object[] objectArray = new PlanBG[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        catch (Exception exception) {
            return new PlanBG[0];
        }
    }

    private JPanel createStatPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 10, 2, 2);
        JPanel jPanel = new JPanel(gridBagLayout);
        this.tileStat = new JLabel("--");
        PropPanel.addCouple(jPanel, ".RGB tiles: ", this.tileStat, gridBagLayout, gridBagConstraints);
        this.timeStat = new JLabel("--");
        PropPanel.addCouple(jPanel, ".Time: ", this.timeStat, gridBagLayout, gridBagConstraints);
        return jPanel;
    }

    protected void setStat(String string, String string2) {
        this.tileStat.setText(string);
        this.timeStat.setText(string2);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.start) {
            for (int i = 0; i < 3; ++i) {
                Object object = this.ch[i].getSelectedItem();
                if (object == null || object instanceof String) continue;
                PlanBG planBG = (PlanBG)object;
                this.context.setRgbInput(planBG.getUrl(), i);
                String string = planBG.getPixelMin() + " " + planBG.getPixelMiddle() + " " + planBG.getPixelMax() + " " + planBG.getTransfertFctInfo();
                this.context.setRgbCmParam(string, i);
            }
            if ("".equals(this.outputField.getText()) || !new File(this.outputField.getText()).isDirectory()) {
                Aladin.warning("Choose an output directory");
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.context.setRgbOutput(this.outputField.getText());
            this.context.setRgbMethod(this.getMethod());
            this.context.setRgbFormat(this.getFormat());
            this.context.setProgressBar(this.progressBar);
            try {
                new Task((Context)this.context, Action.RGB, false);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (actionEvent.getSource() == this.abort) {
            this.abort();
        } else if (actionEvent.getSource() == this.pause) {
            this.pause();
        }
        this.resumeWidgets();
    }

    private void pause() {
        if (this.context.isTaskPause()) {
            this.context.setTaskPause(false);
            this.pause.setText(this.getString("PAUSE"));
        } else {
            this.context.setTaskPause(true);
            this.pause.setText(this.getString("RESUME"));
        }
    }

    private void abort() {
        if (!Aladin.confirmation(this.mainPanel, "Do you really want to abort the RGB computation ?")) {
            return;
        }
        this.context.taskAbort();
    }

    private void dirBrowser(JTextField jTextField) {
        String string = jTextField.getText().trim();
        String string2 = Util.dirBrowser("", string, jTextField, 0);
        if (string2 == null) {
            return;
        }
        this.actionPerformed(new ActionEvent(jTextField, -1, "dirBrowser Action"));
    }

    protected void init() {
        Object[] objectArray = new Object[]{this.ch[0].getSelectedItem(), this.ch[1].getSelectedItem(), this.ch[2].getSelectedItem()};
        PlanBG[] planBGArray = this.getPlan();
        for (int i = 0; i < 3; ++i) {
            this.ch[i].removeAllItems();
            this.ch[i].addItem(this.CHOOSE);
        }
        for (PlanBG planBG : planBGArray) {
            for (int i = 0; i < 3; ++i) {
                this.ch[i].addItem(planBG);
                if (objectArray[i] == null || planBG != objectArray[i]) continue;
                this.ch[i].setSelectedItem(planBG);
            }
        }
    }

    @Override
    public void show() {
        super.show();
        this.init();
    }

    public void help() {
        JOptionPane.showMessageDialog(this, this.HELP, this.titlehelp, 1);
    }

    private boolean hasPlanSelection() {
        int n = 0;
        for (int i = 0; i < this.ch.length; ++i) {
            Object object = this.ch[i].getSelectedItem();
            if (!(object instanceof PlanBG)) continue;
            ++n;
        }
        return n > 1;
    }

    protected void resumeWidgets() {
        try {
            boolean bl = this.hasPlanSelection() && this.outputField.getText().trim().length() > 0;
            boolean bl2 = this.context.isTaskRunning();
            this.start.setEnabled(bl && !bl2);
            this.pause.setEnabled(bl2);
            this.abort.setEnabled(bl2);
            this.setCursor(bl2 ? Cursor.getPredefinedCursor(3) : Cursor.getPredefinedCursor(0));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

