/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.Aladin;
import cds.allsky.Action;
import cds.allsky.Builder;
import cds.allsky.Context;
import cds.allsky.ContextGui;
import java.util.Vector;

public class Task
extends Thread {
    private Context context;
    private Vector<Action> actions;
    private Builder builder = null;

    public Task(Context context, Action action, boolean bl) throws Exception {
        this.context = context;
        this.actions = new Vector();
        this.actions.add(action);
        this.perform(bl);
    }

    public Task(Context context, Vector<Action> vector, boolean bl) throws Exception {
        this.context = context;
        this.actions = vector;
        this.perform(bl);
    }

    private void perform(boolean bl) throws Exception {
        if (this.context.isTaskRunning()) {
            throw new Exception("There is already a running task (" + (Object)((Object)this.context.getAction()) + ")");
        }
        if (bl) {
            this.run();
        } else {
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ThreadProgressBar threadProgressBar = null;
        threadProgressBar = new ThreadProgressBar(this.context);
        threadProgressBar.start();
        try {
            this.context.setTaskRunning(true);
            for (Action action : this.actions) {
                if (this.context.isTaskAborting()) break;
                this.context.running((Object)((Object)action) + "");
                this.builder = Builder.createBuilder(this.context, action);
                this.builder.validateContext();
                if (this.builder.isAlreadyDone()) {
                    this.context.endAction();
                    continue;
                }
                this.context.startAction(action);
                try {
                    if (!this.builder.isFake()) {
                        this.builder.run();
                        this.builder.showStatistics();
                    }
                }
                catch (Exception exception) {
                    this.context.taskAbort();
                    exception.printStackTrace();
                }
                this.context.endAction();
            }
            this.context.setTaskRunning(false);
        }
        catch (Exception exception) {
            if (Aladin.levelTrace >= 3) {
                exception.printStackTrace();
            }
            this.context.error(exception.getMessage());
            this.context.taskAbort();
        }
        finally {
            this.context.setTaskRunning(false);
            if (threadProgressBar != null) {
                threadProgressBar.end();
            }
        }
    }

    class ThreadProgressBar
    extends Thread {
        private Context context;
        boolean isRunning = true;
        long lastStat = -1L;
        long tempo;
        long lastGC = -1L;

        public ThreadProgressBar(Context context) {
            this.context = context;
            this.tempo = context instanceof ContextGui ? 1000L : 30000L;
        }

        @Override
        public void run() {
            while (this.isRunning) {
                try {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!this.isRunning || this.context.isTaskPause()) continue;
                    this.context.progressStatus();
                    long l = System.currentTimeMillis();
                    if (l - this.lastStat <= this.tempo || Task.this.builder == null) continue;
                    Task.this.builder.showStatistics();
                    this.lastStat = l;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.context.resumeWidgets();
        }

        public void end() {
            this.isRunning = false;
        }
    }
}

