/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.Coord;
import cds.allsky.BuilderTiles;
import cds.allsky.Context;
import cds.allsky.Mode;
import cds.fits.Fits;
import cds.tools.pixtools.CDSHealpix;
import cds.tools.pixtools.Util;
import healpix.essentials.HealpixBase;
import healpix.essentials.Pointing;
import java.awt.Polygon;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;

public final class ThreadBuilderTile {
    private Context context;
    private BuilderTiles builderTiles;
    private int bitpix;
    private Mode coaddMode;
    private double max;
    private boolean hasAlternateBlank;
    private double blankOrig;
    private double blank;
    private boolean flagColor;
    private double bScale;
    private double bZero;
    private boolean fading;
    private String hpxFinderPath = null;
    private double[] cutOrig;
    private double[] cut;
    private int[] borderSize;
    private int circle;
    private Polygon polygon;
    private ArrayList<SrcFile> downFiles;
    private boolean mixing;
    private int tileSide;
    protected static HashMap<File, Polygon> hashPolygon = null;
    private Object objRel = new Object();
    protected static int nbThreadRunning = 0;
    static long statOnePass = 0L;
    static long statMultiPass = 0L;
    static int statMaxOverlays = 0;
    private static double toRad = 57.29577951308232;
    private static double PI2 = 1.5707963267948966;
    private static final double OVERLAY_PROPORTION = 0.16666666666666666;
    int n = 0;

    public ThreadBuilderTile(Context context, BuilderTiles builderTiles) {
        this.context = context;
        this.builderTiles = builderTiles;
        this.bitpix = context.getBitpix();
        this.coaddMode = context.getMode();
        this.max = Fits.getMax(context.getBitpixOrig());
        this.flagColor = context.isColor();
        this.mixing = context.mixing;
        if (!this.flagColor) {
            this.bZero = context.getBZero();
            this.bScale = context.getBScale();
            try {
                this.cutOrig = context.getCutOrig();
                this.cut = context.getCut();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.blankOrig = context.getBlankOrig();
            this.hasAlternateBlank = context.hasAlternateBlank();
            this.blank = context.getBlank();
        } else {
            this.blank = 0.0;
        }
        this.fading = context.getFading();
        this.borderSize = context.getBorderSize();
        this.circle = context.circle;
        this.polygon = context.polygon;
        this.hpxFinderPath = context.getHpxFinderPath();
        this.tileSide = context.getTileSide();
        this.downFiles = new ArrayList(10);
    }

    public long getMem() {
        long l = 118L;
        for (SrcFile srcFile : this.downFiles) {
            l += srcFile.fitsfile.getMem();
        }
        return l;
    }

    private boolean needMem(long l) {
        return this.context.cacheFits.getFreeMem() < l;
    }

    private boolean requiredMem(long l) throws Exception {
        long l2 = 4L * l * 1024L * 1024L * (long)this.context.getNpixOrig();
        return this.needMem((long)nbThreadRunning * (l2 += (long)(2 * this.tileSide * this.tileSide * this.context.getNpix())));
    }

    private void checkMem(int n) throws Exception {
        long l = 4 * n * 1024 * 1024 * this.context.getNpixOrig();
        this.checkMem(n, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkMem(int n, long l) throws Exception {
        l += (long)(2 * this.tileSide * this.tileSide * this.context.getNpix());
        if (n > 10) {
            l += (long)(2 * this.tileSide * this.tileSide * 8);
        }
        if (!this.needMem(l)) {
            return;
        }
        Object object = this.objRel;
        synchronized (object) {
            if (!this.needMem(l)) {
                return;
            }
            long l2 = this.builderTiles.releaseBitmap();
            if (l2 > 0L) {
                System.gc();
                cds.tools.Util.pause(100);
                this.context.info("Need more RAM: output Fits bitmap release => " + cds.tools.Util.getUnitDisk(l2));
                if (!this.needMem(l)) {
                    return;
                }
            }
            if (this.isTheLastRunning()) {
                this.context.warning(Thread.currentThread().getName() + " needs " + cds.tools.Util.getUnitDisk(l) + " but can not stop (last thread running) !");
            }
            try {
                --nbThreadRunning;
                while (this.needMem(l)) {
                    try {
                        this.context.warning(Thread.currentThread().getName() + " is waiting more memory (need " + cds.tools.Util.getUnitDisk(l) + ")...");
                        cds.tools.Util.pause((int)(1000.0 * (1.0 + Math.random() * 5.0)));
                        this.context.cacheFits.forceClean();
                        nbThreadRunning = this.builderTiles.nbThreadRunning();
                        if (nbThreadRunning <= 1) {
                            this.context.warning(Thread.currentThread().getName() + " resumes (last thread runnning)");
                            break;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!this.context.isTaskAborting()) continue;
                    throw new Exception("Task abort !");
                }
            }
            finally {
                ++nbThreadRunning;
            }
        }
    }

    private boolean isTheLastRunning() {
        return nbThreadRunning <= 1;
    }

    protected long getReqMem(ArrayList<SrcFile> arrayList, int n, int n2) {
        long l = 0L;
        for (int i = 0; i < n2 && n < arrayList.size(); ++i, ++n) {
            SrcFile srcFile = arrayList.get(n);
            l += srcFile.cellMem;
        }
        return l;
    }

    Fits buildHealpix(BuilderTiles builderTiles, String string, int n, long l, int n2) throws Exception {
        ArrayList<SrcFile> arrayList = null;
        Fits fits = null;
        try {
            arrayList = new ArrayList<SrcFile>(20);
            if (!this.askLocalFinder(builderTiles, arrayList, this.hpxFinderPath, n, l, this.blank)) {
                return null;
            }
            int n3 = arrayList.size();
            if (n3 > statMaxOverlays) {
                statMaxOverlays = n3;
            }
            if (!(this.context.live || this.coaddMode != Mode.ADD && this.mixing && n3 >= 10 && this.requiredMem(this.mixing ? (long)n3 : 1L))) {
                ++statOnePass;
                long l2 = this.getReqMem(arrayList, 0, n3);
                this.checkMem(this.mixing ? n3 : 1, l2);
                fits = this.buildHealpix1(builderTiles, n, l, n2, arrayList, 0, n3, null);
            } else {
                int n4;
                ++statMultiPass;
                double[] dArray = null;
                double[] dArray2 = new double[this.tileSide * this.tileSide];
                for (int i = 0; i < n3; i += 10) {
                    n4 = i + 10;
                    if (n4 >= n3) {
                        n4 = n3;
                    }
                    long l3 = this.getReqMem(arrayList, i, n3);
                    this.checkMem(n3, l3);
                    Fits fits2 = this.buildHealpix1(builderTiles, n, l, n2, arrayList, i, n4, dArray2);
                    if (fits2 != null) {
                        if (fits == null) {
                            fits = fits2;
                            dArray = dArray2;
                            dArray2 = new double[this.tileSide * this.tileSide];
                        } else {
                            fits.coadd(fits2, dArray, dArray2);
                        }
                    }
                    for (int j = i; j < n4; ++j) {
                        SrcFile srcFile = arrayList.get(j);
                        srcFile.fitsfile.rmUser();
                        arrayList.set(j, null);
                    }
                }
                if (fits != null && this.bitpix != this.context.getBitpixOrig()) {
                    Fits fits3 = new Fits(fits.width, fits.height, this.bitpix);
                    fits3.setBlank(this.blank);
                    fits3.setBzero(this.bZero);
                    fits3.setBscale(this.bScale);
                    for (n4 = 0; n4 < fits.height; ++n4) {
                        for (int i = 0; i < fits.width; ++i) {
                            double d = fits.getPixelDouble(i, n4);
                            d = Double.isNaN(d) ? this.blank : (d <= this.cutOrig[2] ? this.cut[2] : (d >= this.cutOrig[3] ? this.cut[3] : (d - this.cutOrig[2]) * this.context.coef + this.cut[2]));
                            fits3.setPixelDouble(i, n4, d);
                        }
                    }
                    fits = fits3;
                    fits3 = null;
                }
                if (fits != null && this.context.live) {
                    String string2 = Util.getFilePath(string, n, l, n2);
                    ThreadBuilderTile.writeWeight(string2, dArray, this.tileSide);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            SrcFile srcFile = (SrcFile)arrayList.get(i);
            if (srcFile == null) continue;
            Fits fits4 = srcFile.fitsfile;
            fits4.rmUser();
        }
        if (this.context.isTaskAborting()) {
            throw new Exception("Task abort !");
        }
        return fits;
    }

    public static void writeWeight(String string, double[] dArray, int n) throws Exception {
        if (dArray == null) {
            return;
        }
        Fits fits = new Fits(n, n, -32);
        int n2 = 0;
        for (int i = 0; i < fits.height; ++i) {
            for (int j = 0; j < fits.width; ++j) {
                fits.setPixelDouble(j, i, dArray[n2++]);
            }
        }
        fits.writeFITS(string + "_w.fits");
    }

    public static double[] loadWeight(String string, int n, double d) throws Exception {
        double[] dArray = new double[n * n];
        String string2 = string + "_w.fits";
        if (!new File(string2).exists()) {
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = d;
            }
            return dArray;
        }
        Fits fits = new Fits();
        fits.loadFITS(string2);
        int n2 = 0;
        for (int i = 0; i < fits.height; ++i) {
            for (int j = 0; j < fits.width; ++j) {
                dArray[n2++] = fits.getPixelDouble(j, i);
            }
        }
        return dArray;
    }

    Fits buildHealpix1(BuilderTiles builderTiles, int n, long l, int n2, ArrayList<SrcFile> arrayList, int n3, int n4, double[] dArray) throws Exception {
        Fits fits;
        boolean bl;
        block55: {
            bl = true;
            double[] dArray2 = new double[2];
            Coord coord = new Coord();
            SrcFile srcFile = null;
            fits = null;
            int n5 = this.bitpix;
            double d = this.blank;
            double d2 = this.bScale;
            double d3 = this.bZero;
            int n6 = this.context.getTileSide();
            try {
                int n7;
                boolean bl2;
                long l2 = l * (long)n6 * (long)n6;
                boolean bl3 = bl2 = n5 != this.context.getBitpixOrig();
                if (bl2 && dArray != null) {
                    n5 = this.context.getBitpixOrig();
                    d = n5 < 0 ? Double.NaN : this.blankOrig;
                    bl2 = false;
                }
                fits = new Fits(n6, n6, n5);
                if (!this.flagColor) {
                    fits.setBlank(d);
                    fits.setBzero(d3);
                    fits.setBscale(d2);
                } else if (this.context.targetColorMode == 0) {
                    for (n7 = 0; n7 < fits.rgb.length; ++n7) {
                        fits.rgb[n7] = -16777216;
                    }
                }
                n7 = n4 - n3;
                double[] dArray3 = null;
                double[] dArray4 = null;
                double[] dArray5 = new double[n7];
                double[] dArray6 = new double[n7];
                if (this.flagColor) {
                    dArray3 = new double[n7];
                    dArray4 = new double[n7];
                }
                HealpixBase healpixBase = CDSHealpix.getHealpixBase(n + this.context.getTileOrder());
                boolean bl4 = this.context.getFrame() != 0;
                for (int i = 0; i < fits.height; ++i) {
                    for (int j = 0; j < fits.width; ++j) {
                        int n8;
                        long l3 = l2 + (long)this.context.xy2hpx(i * fits.width + j);
                        Pointing pointing = healpixBase.pix2ang(l3);
                        dArray2[1] = (PI2 - pointing.theta) * toRad;
                        dArray2[0] = pointing.phi * toRad;
                        if (bl4) {
                            dArray2 = this.context.gal2ICRSIfRequired(dArray2);
                        }
                        coord.al = dArray2[0];
                        coord.del = dArray2[1];
                        int n9 = 0;
                        double d4 = 0.0;
                        int n10 = 0;
                        for (n8 = n3; n8 < n4; ++n8) {
                            try {
                                srcFile = arrayList.get(n8);
                                if (srcFile.flagRemoved) continue;
                                try {
                                    srcFile.open(n2);
                                }
                                catch (Exception exception) {
                                    srcFile.flagRemoved = true;
                                    if (++n10 < n4 - n3) continue;
                                    return null;
                                }
                                srcFile.fitsfile.calib.GetXY(coord, false);
                                coord.y = (double)srcFile.fitsfile.height - coord.y - 1.0;
                                coord.x -= 1.0;
                                if (this.flagColor) {
                                    int n11 = this.getBilinearPixelRGB(srcFile, coord);
                                    if (n11 == 0) continue;
                                    dArray5[n9] = 0xFF & n11 >> 16;
                                    dArray3[n9] = 0xFF & n11 >> 8;
                                    dArray4[n9] = 0xFF & n11;
                                } else {
                                    double d5 = this.getBilinearPixel(srcFile, coord, n2, srcFile.blank);
                                    if (Double.isNaN(d5)) continue;
                                    dArray5[n9] = d5;
                                }
                                dArray6[n9] = this.getCoef(srcFile.fitsfile, coord);
                                d4 += dArray6[n9];
                                ++n9;
                                if (this.mixing) continue;
                                break;
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        if (this.flagColor) {
                            n8 = 0;
                            if (n9 != 0) {
                                int n12;
                                double d6;
                                double d7;
                                if (d4 == 0.0) {
                                    n8 = 0xFF000000 | ((int)dArray5[0] & 0xFF) << 16 | ((int)dArray3[0] & 0xFF) << 8 | (int)dArray4[0] & 0xFF;
                                } else if (this.coaddMode == Mode.ADD) {
                                    double d8 = 0.0;
                                    d7 = 0.0;
                                    d6 = 0.0;
                                    for (n12 = 0; n12 < n9; ++n12) {
                                        d8 += dArray5[n12];
                                        d7 += dArray3[n12];
                                        d6 += dArray4[n12];
                                    }
                                    if (d8 > 255.0) {
                                        d8 = 255.0;
                                    }
                                    if (d7 > 255.0) {
                                        d7 = 255.0;
                                    }
                                    if (d6 > 255.0) {
                                        d6 = 255.0;
                                    }
                                    n8 = 0xFF000000 | ((int)d8 & 0xFF) << 16 | ((int)d7 & 0xFF) << 8 | (int)d6 & 0xFF;
                                } else {
                                    double d9 = 0.0;
                                    d7 = 0.0;
                                    d6 = 0.0;
                                    for (n12 = 0; n12 < n9; ++n12) {
                                        d9 += dArray5[n12] * dArray6[n12] / d4;
                                        d7 += dArray3[n12] * dArray6[n12] / d4;
                                        d6 += dArray4[n12] * dArray6[n12] / d4;
                                    }
                                    if (d9 > 255.0) {
                                        d9 = 255.0;
                                    } else if (d9 < 0.0) {
                                        d9 = 0.0;
                                    }
                                    if (d7 > 255.0) {
                                        d7 = 255.0;
                                    } else if (d7 < 0.0) {
                                        d7 = 0.0;
                                    }
                                    if (d6 > 255.0) {
                                        d6 = 255.0;
                                    } else if (d6 < 0.0) {
                                        d6 = 0.0;
                                    }
                                    n8 = 0xFF000000 | ((int)d9 & 0xFF) << 16 | ((int)d7 & 0xFF) << 8 | (int)d6 & 0xFF;
                                }
                                bl = false;
                            }
                            fits.setPixelRGBJPG(j, i, n8);
                        } else {
                            int n13;
                            double d10 = 0.0;
                            if (n9 == 0) {
                                d10 = Double.NaN;
                            } else if (this.coaddMode == Mode.ADD) {
                                bl = false;
                                for (n13 = 0; n13 < n9; ++n13) {
                                    if (d10 / 2.0 + dArray5[n13] / 2.0 > this.max / 2.0) {
                                        d10 = this.max;
                                        break;
                                    }
                                    d10 += dArray5[n13];
                                }
                            } else if (d4 == 0.0) {
                                bl = false;
                                d10 = dArray5[0];
                            } else {
                                bl = false;
                                for (n13 = 0; n13 < n9; ++n13) {
                                    d10 += dArray5[n13] * dArray6[n13] / d4;
                                }
                            }
                            if (bl2) {
                                double d11 = Double.isNaN(d10) ? d : (d10 <= this.cutOrig[2] ? this.cut[2] : (d10 = d10 >= this.cutOrig[3] ? this.cut[3] : (d10 - this.cutOrig[2]) * this.context.coef + this.cut[2]));
                                if (n5 > 0 && (double)((long)d10) == d && d10 != d) {
                                    d10 += 0.5;
                                }
                            } else if (Double.isNaN(d10)) {
                                d10 = d;
                            }
                            fits.setPixelDouble(j, i, d10);
                        }
                        if (dArray == null) continue;
                        dArray[i * n6 + j] = d4;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                bl = true;
                if (dArray == null) break block55;
                for (int i = 0; i < dArray.length; ++i) {
                    dArray[i] = 0.0;
                }
            }
        }
        if (this.context.isTaskAborting()) {
            throw new Exception("Task abort !");
        }
        return !bl ? fits : null;
    }

    private boolean isIn(SrcFile srcFile, Coord coord) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        Fits fits = srcFile.fitsfile;
        if (this.circle > 0 && (d5 = (d4 = coord.x - (d3 = (double)(fits.width / 2))) * d4 + (d2 = coord.y - (d = (double)(fits.height / 2))) * d2) > (double)(this.circle * this.circle)) {
            return false;
        }
        if (coord.x < (double)this.borderSize[1] || coord.x > (double)(fits.width - this.borderSize[3])) {
            return false;
        }
        if (coord.y < (double)this.borderSize[0] || coord.y > (double)(fits.height - this.borderSize[2])) {
            return false;
        }
        if (this.polygon != null && !this.polygon.contains(coord.x, coord.y)) {
            return false;
        }
        return srcFile.polygon == null || srcFile.polygon.contains(coord.x, coord.y);
    }

    private double getCoef(Fits fits, Coord coord) {
        int n = (int)coord.x;
        int n2 = (int)coord.y;
        double d = 1.0;
        if (n > 0 && n < fits.width && (coord.x <= (double)fits.xCell || coord.x >= (double)(fits.xCell + fits.widthCell - 1))) {
            d *= 2.0;
        }
        if (n2 > 0 && n2 < fits.height && (coord.y <= (double)fits.yCell || coord.y >= (double)(fits.yCell + fits.heightCell - 1))) {
            d *= 2.0;
        }
        if (!this.fading) {
            return 1.0 / d;
        }
        double d2 = 0.0;
        try {
            if (this.circle > 0) {
                double d3 = fits.width / 2;
                double d4 = coord.x - d3;
                double d5 = fits.height / 2;
                double d6 = coord.y - d5;
                double d7 = Math.sqrt(d4 * d4 + d6 * d6);
                d2 = d7 < (double)this.circle - (double)this.circle * 0.16666666666666666 ? 1.0 : ((double)this.circle - d7) / (double)this.circle;
            } else {
                double d8 = fits.width - (this.borderSize[1] + this.borderSize[3]);
                double d9 = fits.height - (this.borderSize[0] + this.borderSize[2]);
                double d10 = d8 * 0.16666666666666666;
                double d11 = d9 * 0.16666666666666666;
                double d12 = coord.x - (double)this.borderSize[1];
                double d13 = coord.y - (double)this.borderSize[0];
                double d14 = 1.0;
                double d15 = 1.0;
                if (d12 < d10) {
                    d14 = d12 / d10;
                } else if (d12 > d8 - d10) {
                    d14 = (d8 - d12) / d10;
                }
                if (d13 < d11) {
                    d15 = d13 / d11;
                } else if (d13 > d9 - d11) {
                    d15 = (d9 - d13) / d11;
                }
                d2 = d14 * d15;
            }
        }
        catch (Exception exception) {
            d2 = 0.0;
        }
        return d2 / d;
    }

    private double getBilinearPixel(SrcFile srcFile, Coord coord, int n, double d) {
        boolean bl;
        Fits fits = srcFile.fitsfile;
        if (!this.isIn(srcFile, coord)) {
            return Double.NaN;
        }
        double d2 = coord.x;
        double d3 = coord.y;
        int n2 = (int)d2;
        int n3 = (int)d3;
        int n4 = n2 + 1;
        int n5 = n3 + 1;
        int n6 = n2;
        int n7 = n3;
        int n8 = n4;
        int n9 = n5;
        if (n4 < fits.xCell || n5 < fits.yCell || n2 >= fits.xCell + fits.widthCell || n3 >= fits.yCell + fits.heightCell || n < 0 || n >= fits.depth) {
            return Double.NaN;
        }
        if (n6 == fits.xCell - 1) {
            ++n6;
        }
        if (n7 == fits.yCell - 1) {
            ++n7;
        }
        if (n8 == fits.xCell + fits.widthCell) {
            --n8;
        }
        if (n9 == fits.yCell + fits.heightCell) {
            --n9;
        }
        double d4 = fits.getPixelDouble(n6, n7, n);
        double d5 = fits.getPixelDouble(n8, n7, n);
        double d6 = fits.getPixelDouble(n6, n9, n);
        double d7 = fits.getPixelDouble(n8, n9, n);
        boolean bl2 = Double.isNaN(d4) || d4 == d;
        boolean bl3 = Double.isNaN(d5) || d5 == d;
        boolean bl4 = Double.isNaN(d6) || d6 == d;
        boolean bl5 = bl = Double.isNaN(d7) || d7 == d;
        if (bl2 && bl3 && bl4 && bl) {
            return Double.NaN;
        }
        if (bl2 || bl3 || bl4 || bl) {
            double d8;
            double d9 = !bl2 ? d4 : (!bl3 ? d5 : (d8 = !bl4 ? d6 : d7));
            if (bl2) {
                d4 = d8;
            }
            if (bl3) {
                d5 = d8;
            }
            if (bl4) {
                d6 = d8;
            }
            if (bl) {
                d7 = d8;
            }
        }
        return this.bilineaire(n2, n3, n4, n5, d2, d3, d4, d5, d6, d7);
    }

    private int getBilinearPixelRGB(SrcFile srcFile, Coord coord) {
        int n;
        boolean bl;
        Fits fits = srcFile.fitsfile;
        if (!this.isIn(srcFile, coord)) {
            return 0;
        }
        double d = coord.x;
        double d2 = coord.y;
        int n2 = (int)d;
        int n3 = (int)d2;
        int n4 = n2 + 1;
        int n5 = n3 + 1;
        int n6 = n2;
        int n7 = n3;
        int n8 = n4;
        int n9 = n5;
        if (n4 < fits.xCell || n5 < fits.yCell || n2 >= fits.xCell + fits.widthCell || n3 >= fits.yCell + fits.heightCell) {
            return 0;
        }
        if (n6 == fits.xCell - 1) {
            ++n6;
        }
        if (n7 == fits.yCell - 1) {
            ++n7;
        }
        if (n8 == fits.xCell + fits.widthCell) {
            --n8;
        }
        if (n9 == fits.yCell + fits.heightCell) {
            --n9;
        }
        int n10 = fits.getPixelRGBJPG(n6, n7);
        int n11 = fits.getPixelRGBJPG(n8, n7);
        int n12 = fits.getPixelRGBJPG(n6, n9);
        int n13 = fits.getPixelRGBJPG(n8, n9);
        boolean bl2 = (n10 & 0xFF000000) == 0;
        boolean bl3 = (n11 & 0xFF000000) == 0;
        boolean bl4 = (n12 & 0xFF000000) == 0;
        boolean bl5 = bl = (n13 & 0xFF000000) == 0;
        if (bl2 && bl3 && bl4 && bl) {
            return 0;
        }
        if (bl2 || bl3 || bl4 || bl) {
            int n14 = !bl2 ? n10 : (!bl3 ? n11 : (n = !bl4 ? n12 : n13));
            if (bl2) {
                n10 = n;
            }
            if (bl3) {
                n11 = n;
            }
            if (bl4) {
                n12 = n;
            }
            if (bl) {
                n13 = n;
            }
        }
        n = 255;
        for (int i = 16; i >= 0; i -= 8) {
            double d3 = 0xFF & n10 >> i;
            double d4 = 0xFF & n11 >> i;
            double d5 = 0xFF & n12 >> i;
            double d6 = 0xFF & n13 >> i;
            int n15 = (int)(this.bilineaire(n2, n3, n4, n5, d, d2, d3, d4, d5, d6) + 0.5);
            if (n15 < 0) {
                n15 = 0;
            } else if (n15 > 255) {
                n15 = 255;
            }
            n = n << 8 | n15;
        }
        return n;
    }

    private double bilineaire(int n, int n2, int n3, int n4, double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        double d8;
        double d9;
        double d10;
        if (d == (double)n) {
            d10 = 1.0;
            d9 = 0.0;
        } else if (d == (double)n3) {
            d10 = 0.0;
            d9 = 1.0;
        } else {
            d10 = 1.0 / (d - (double)n);
            d9 = 1.0 / ((double)n3 - d);
        }
        if (d2 == (double)n2) {
            d8 = 1.0;
            d7 = 0.0;
        } else if (d2 == (double)n4) {
            d8 = 0.0;
            d7 = 1.0;
        } else {
            d8 = 1.0 / (d2 - (double)n2);
            d7 = 1.0 / ((double)n4 - d2);
        }
        double d11 = (d3 * d10 + d4 * d9) / (d10 + d9);
        double d12 = (d5 * d10 + d6 * d9) / (d10 + d9);
        return (d11 * d8 + d12 * d7) / (d8 + d7);
    }

    public void get(String string, String string2) throws IOException {
        try {
            String string3;
            URL uRL = new URL(string);
            InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream());
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            StringBuffer stringBuffer = new StringBuffer();
            while ((string3 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string3 + "\r\n");
            }
            ThreadBuilderTile.createAFile(string2, stringBuffer.toString());
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (IOException iOException) {
            throw iOException;
        }
    }

    private static void createAFile(String string, String string2) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
        dataOutputStream.writeBytes(string2);
        dataOutputStream.flush();
        dataOutputStream.close();
    }

    private String getPath(String string) throws Exception {
        if (string.charAt(0) != '{') {
            return string;
        }
        int n = string.indexOf("path");
        int n2 = string.indexOf(58, n);
        int n3 = string.indexOf(34, n2 + 1);
        int n4 = string.indexOf(34, n3 + 1);
        return string.substring(n3 + 1, n4);
    }

    private long getCellMem(String string) throws Exception {
        int n = string.indexOf("cellmem");
        if (string.charAt(0) == '{' && n > -1) {
            int n2 = string.indexOf(58, n);
            int n3 = string.indexOf(34, n2 + 1);
            int n4 = string.indexOf(34, n3 + 1);
            try {
                return Integer.parseInt(string.substring(n3 + 1, n4));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0x100000 * (this.context.bitpixOrig == 0 ? 32 : Math.abs(this.context.bitpixOrig) / 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean askLocalFinder(BuilderTiles builderTiles, ArrayList<SrcFile> arrayList, String string, int n, long l, double d) {
        String string2 = string + cds.tools.Util.FS + Util.getFilePath("", n, l);
        File file = new File(string2);
        String string3 = null;
        String string4 = null;
        if (file.exists()) {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(file));
                int n2 = 0;
                while ((string3 = bufferedReader.readLine()) != null) {
                    string4 = this.getPath(string3);
                    long l2 = this.getCellMem(string3);
                    try {
                        Fits fits = new Fits();
                        fits.setFilename(string4);
                        SrcFile srcFile = new SrcFile(string4, l2);
                        srcFile.fitsfile = fits;
                        arrayList.add(srcFile);
                    }
                    catch (Exception exception) {
                        System.err.println("Erreur de chargement de : " + string4);
                        exception.printStackTrace();
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                boolean bl = false;
                return bl;
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return true;
        }
        return false;
    }

    private Polygon getPolygon(Fits fits) {
        File file = new File(this.context.getInputPath()).getParentFile();
        File file2 = new File(fits.getFilename());
        Polygon polygon = null;
        while (polygon == null && !file2.equals(file)) {
            polygon = this.getPolygon(fits, file2);
            file2 = file2.getParentFile();
        }
        return polygon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Polygon getPolygon(Fits fits, File file) {
        if (hashPolygon.containsKey(file)) {
            return hashPolygon.get(file);
        }
        HashMap<File, Polygon> hashMap = hashPolygon;
        synchronized (hashMap) {
            Object object;
            String string;
            if (hashPolygon.containsKey(file)) {
                return hashPolygon.get(file);
            }
            Polygon polygon = null;
            if (file.isDirectory()) {
                string = file.getAbsoluteFile() + ".fov";
            } else {
                object = file.getName();
                int n = ((String)object).lastIndexOf(46);
                if (n > 0) {
                    object = ((String)object).substring(0, n);
                }
                string = file.getParent() + Util.FS + (String)object + ".fov";
            }
            object = new File(string);
            if (((File)object).isFile()) {
                FileInputStream fileInputStream = null;
                try {
                    String string2;
                    fileInputStream = new FileInputStream((File)object);
                    InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
                    BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                    StringBuilder stringBuilder = new StringBuilder();
                    while ((string2 = bufferedReader.readLine()) != null) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(' ');
                        }
                        stringBuilder.append(string2.trim());
                    }
                    bufferedReader.close();
                    inputStreamReader.close();
                    polygon = Context.createPolygon(stringBuilder.toString());
                    if (polygon != null) {
                        this.context.info("FoV detected: " + ((File)object).getName() + " => " + this.pol2String(polygon));
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                finally {
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            hashPolygon.put(file, polygon);
            return polygon;
        }
    }

    private String pol2String(Polygon polygon) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        for (n = 0; n < polygon.npoints && n < 5; ++n) {
            if (n > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(polygon.xpoints[n] + "," + polygon.ypoints[n]);
        }
        if (n < polygon.npoints) {
            stringBuilder.append("...");
        }
        return stringBuilder.toString();
    }

    class SrcFile {
        Fits fitsfile;
        long cellMem;
        int isOpened = -1;
        String name = null;
        double blank;
        Polygon polygon = null;
        boolean flagRemoved = false;

        SrcFile(String string, long l) {
            this.name = string;
            this.cellMem = l;
        }

        public String toString() {
            return this.fitsfile.getFilename();
        }

        protected void open(int n) throws Exception {
            int n2;
            if (this.isOpened == n) {
                return;
            }
            if (this.isOpened != -1) {
                this.fitsfile.rmUser();
            }
            int n3 = this.name.endsWith(".hhh") || this.name.indexOf(".hhh[") > 0 ? 4 : (this.name.endsWith(".jpg") || this.name.indexOf(".jpg[") > 0 ? 1 : (n2 = this.name.endsWith(".png") || this.name.indexOf(".png[") > 0 ? 2 : 0));
            if (n2 == 0 && ThreadBuilderTile.this.bitpix == 0) {
                this.fitsfile.loadFITS(this.name, true, true);
            } else {
                if (((ThreadBuilderTile)ThreadBuilderTile.this).context.depth > 1 || n > 0) {
                    this.name = this.addFrameToName(this.name, n);
                }
                this.fitsfile = ((ThreadBuilderTile)ThreadBuilderTile.this).context.cacheFits.getFits(this.name, n2, true, false);
            }
            if (((ThreadBuilderTile)ThreadBuilderTile.this).context.scanFov) {
                this.polygon = ThreadBuilderTile.this.getPolygon(this.fitsfile);
            }
            this.isOpened = n;
            this.fitsfile.addUser();
            this.blank = !ThreadBuilderTile.this.hasAlternateBlank ? this.fitsfile.blank : ThreadBuilderTile.this.blankOrig;
        }

        String addFrameToName(String string, int n) throws Exception {
            Fits fits = new Fits();
            fits.loadHeaderFITS(string);
            fits.zCell = n;
            fits.depthCell = 1;
            return fits.getFileNameExtended();
        }
    }
}

