/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.Coo;
import cds.astro.Coocube;
import cds.astro.Qbox;
import java.io.Serializable;

public abstract class AbstractRegion
implements Serializable {
    static boolean DEBUG = false;
    public static final int DISJOINT = 0;
    public static final int INTERSECTS = 1;
    public static final int INCLUDES = -1;
    public static final int IS_PARTOF = 3;
    public Coo centroid = null;
    public double minrad;
    public double maxrad;

    public abstract String toString();

    public abstract double area();

    public abstract boolean checkCoo(Coo var1);

    public abstract int checkCircle(Coo var1, double var2);

    public final int check1(Coo coo, double d) {
        double d2 = this.centroid.distance(coo);
        if (d2 >= d + this.maxrad) {
            return 0;
        }
        if (this.minrad >= d2 + d) {
            return -1;
        }
        if (d >= d2 + this.maxrad) {
            return 3;
        }
        return 1;
    }

    public int checkQbox(int n) {
        if (this.centroid == null) {
            return 0;
        }
        Qbox qbox = new Qbox();
        qbox.set(n);
        Coocube coocube = qbox.center();
        double d = qbox.radius();
        return this.checkCircle(coocube, d);
    }
}

