/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.Astroformat;
import cds.astro.Astroframe;
import cds.astro.Astrotime;
import cds.astro.Coo;
import cds.astro.Editing;
import cds.astro.FK4;
import cds.astro.FK5;
import cds.astro.Galactic;
import cds.astro.ICRS;
import cds.astro.Parsing;
import java.io.Serializable;
import java.text.ParseException;

public class Astrocoo
extends Coo
implements Serializable {
    public static boolean DEBUG = false;
    public Astroframe frame;
    public double epoch;
    protected byte dlon;
    protected byte dlat;
    protected byte precision;
    protected byte formRA;
    protected short editing;
    public static final byte NONE = 0;
    public static final byte DEG = 1;
    public static final byte ARCMIN = 3;
    public static final byte ARCSEC = 5;
    public static final byte MAS = 8;
    public static final short EDIT_FRAME = 256;
    public static final short EDIT_2NUMBERS = 512;
    public static final short EDIT_EPOCH = 1024;
    public static final short EDIT_MEAN_EPOCH = 2048;
    public static final short EDIT_FULL = 4096;
    public static final short EDIT_DEFAULT = 3328;
    private static final String[] explain_precision = new String[]{"unknown", "1degree", "0.1degree", "1arcmin", "0.1arcmin", "1arcsec", "0.1arcsec", "10mas", "1mas", "0.1mas", "10\u00b5as", "1\u00b5as", "0.1\u00b5as"};
    private static final String[] explain_edition = new String[]{"frame", "separate_components", "epoch", "meanEpoch", "full_precision"};
    static final char[] editing_options = new char[]{'s', 'd', ':', 'u', 'f', 'F', '2', 'E', 'M'};
    static final String string_options = new String(editing_options);
    static final short[] Editing_options = new short[]{3, 0, 5, 9, 256, 4096, 512, 1024, 2048};

    public static final String explain(int n) {
        String string = Astroformat.explain(n);
        int n2 = n >> 8;
        if (n2 == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n3 = 0;
        while (n2 != 0) {
            if ((n2 & 1) != 0) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(explain_edition[n3]);
            }
            ++n3;
            n2 >>= 1;
        }
        return stringBuffer.toString();
    }

    public Astrocoo() {
        this(new ICRS());
    }

    public Astrocoo(Astroframe astroframe) {
        this.frame = astroframe;
        this.epoch = Double.NaN;
        this.precision = 0;
        this.dlat = 0;
        this.dlon = 0;
        this.editing = (short)(astroframe.ed_lon | 0xD00);
    }

    public Astrocoo(Astroframe astroframe, double d, double d2) {
        this(astroframe, d, d2, Double.NaN);
    }

    public Astrocoo(Astroframe astroframe, double d, double d2, double d3) {
        this.frame = astroframe;
        this.editing = (short)(astroframe.ed_lon | 0x100 | 0x400);
        this.epoch = d3;
        this.precision = 0;
        this.dlat = 0;
        this.dlon = 0;
        super.set(d, d2);
    }

    public Astrocoo(Astroframe astroframe, String string) throws ParseException {
        this.frame = astroframe;
        this.set(string);
    }

    public Astrocoo(String string) throws ParseException {
        Parsing parsing = new Parsing(string);
        if (string.indexOf(32) < 0 && string.indexOf(58) < 0) {
            char c = parsing.currentChar();
            parsing.advance(1);
            if (Astroframe.isIAU(c)) {
                this.frame = Astroframe.create(c);
                while (parsing.pos < parsing.length) {
                    c = parsing.currentChar();
                    parsing.advance(1);
                    if (Character.isDigit(c) || c == '.') continue;
                }
                if (this.frame != null && Parsing.isSign(c)) {
                    this.setIAU(string);
                    return;
                }
            }
        }
        this.frame = Astroframe.parse(parsing);
        if (DEBUG) {
            System.out.println("#---Astrocoo(" + string + ") => frame=" + this.frame);
        }
        if (this.frame == null) {
            throw new ParseException("****Astrocoo: argument '" + string + "' (no frame)", parsing.pos);
        }
        this.set(parsing.toString());
    }

    public Object clone() {
        Astrocoo astrocoo = (Astrocoo)super.clone();
        return astrocoo;
    }

    public static double getEpoch(Parsing parsing) {
        Astrotime astrotime = new Astrotime();
        int n = parsing.pos;
        double d = Double.NaN;
        parsing.gobbleSpaces();
        boolean bl = parsing.match("(");
        if (bl) {
            parsing.gobbleSpaces();
        } else if (!Character.isLetter(parsing.currentChar())) {
            parsing.set(n);
            return Double.NaN;
        }
        boolean bl2 = astrotime.parsing(parsing);
        if (bl2) {
            d = astrotime.getJyr();
            if (bl) {
                bl2 = parsing.match(")");
            }
        }
        if (!bl2) {
            d = Double.NaN;
            parsing.set(n);
        }
        return d;
    }

    private boolean parse2(Parsing parsing, int n) {
        double d;
        double d2;
        boolean bl = this.frame.hms;
        this.dlat = 0;
        this.dlon = 0;
        this.precision = 0;
        int n2 = parsing.pos;
        this.set();
        this.epoch = Double.NaN;
        if (DEBUG) {
            System.out.print("#...parse2(" + parsing + "," + n);
        }
        if (n == 1 && bl) {
            d2 = parsing.parseIAU();
        } else {
            parsing.gobbleSpaces();
            d2 = parsing.parseSexa2();
        }
        this.dlon = (byte)(1 + parsing.decimals());
        if (parsing.inError() || this.dlon == 0) {
            parsing.set(n2);
            return false;
        }
        boolean bl2 = parsing.isSexa();
        this.formRA = (byte)parsing.format();
        if (n != 1) {
            if (parsing.isTime()) {
                bl = true;
            } else if (parsing.isAngle()) {
                bl = false;
            } else if (!bl2 && this.dlon > 0) {
                bl = false;
            }
        }
        if (bl) {
            d2 *= 15.0;
            if (this.dlon > 0) {
                this.dlon = (byte)(this.dlon - 1);
            }
        }
        if (n == 1 && bl) {
            d = parsing.parseIAU();
        } else {
            parsing.gobbleSpaces();
            d = parsing.parseSexa();
        }
        this.dlat = (byte)(1 + parsing.decimals());
        if (parsing.inError() || this.dlat == 0) {
            parsing.set(n2);
            return false;
        }
        bl2 |= parsing.isSexa();
        this.precision = this.dlon > this.dlat ? this.dlon : this.dlat;
        super.set(d2, d);
        if (DEBUG) {
            System.out.println(" (ok for lon/lat)");
        }
        if (n == 1) {
            return true;
        }
        int n3 = parsing.pos;
        parsing.gobbleSpaces();
        if (parsing.pos < parsing.length) {
            boolean bl3;
            Astrotime astrotime = new Astrotime();
            boolean bl4 = parsing.match("(");
            if (bl4) {
                parsing.gobbleSpaces();
            }
            if (bl3 = astrotime.parsing(parsing)) {
                this.epoch = astrotime.getJyr();
                if (bl4) {
                    bl3 = parsing.match(")");
                }
            }
            if (!bl3) {
                this.epoch = Double.NaN;
                parsing.set(n3);
            }
        }
        return true;
    }

    public boolean parsing(Parsing parsing) {
        return this.parse2(parsing, 0);
    }

    public boolean parseIAU(Parsing parsing) {
        boolean bl;
        int n = parsing.pos;
        char c = parsing.currentChar();
        if (Astroframe.isIAU(c)) {
            if (this.frame.equals(c)) {
                parsing.advance(1);
            } else {
                return false;
            }
        }
        if (!(bl = this.parse2(parsing, 1))) {
            parsing.set(n);
        }
        return bl;
    }

    public int parse(String string, int n) {
        Parsing parsing = new Parsing(string, n);
        if (this.parsing(parsing)) {
            return parsing.pos;
        }
        return n;
    }

    public void set(Astrocoo astrocoo) {
        super.set(astrocoo);
        this.frame = astrocoo.frame;
        this.epoch = astrocoo.epoch;
        this.dlon = astrocoo.dlon;
        this.dlat = astrocoo.dlat;
        this.precision = astrocoo.precision;
    }

    public void set(String string) throws ParseException {
        Parsing parsing = new Parsing(string);
        if (this.parse2(parsing, 0)) {
            parsing.gobbleSpaces();
        }
        if (parsing.pos != parsing.length) {
            throw new ParseException("****Astrocoo: argument '" + string + "'", parsing.pos);
        }
    }

    public void setIAU(String string) throws ParseException {
        Parsing parsing = new Parsing(string);
        char c = parsing.currentChar();
        if (Astroframe.isIAU(c)) {
            if (this.frame.equals(c)) {
                parsing.advance(1);
            } else {
                throw new ParseException("****Astrocoo: setIAU(" + c + "...) for " + this.frame, parsing.pos);
            }
        }
        if (DEBUG) {
            System.out.println("#...setIAU(" + string + ")");
        }
        if (this.parse2(parsing, 1)) {
            parsing.gobbleSpaces();
        } else if (this.parse2(parsing, 0)) {
            parsing.gobbleSpaces();
        }
        if (parsing.pos != parsing.length) {
            throw new ParseException("****Astrocoo: setIAU '" + string + "'", parsing.pos);
        }
    }

    public void set(Coo coo, double d) {
        this.epoch = d;
        super.set(coo);
    }

    public void setPrecision(int n) {
        this.precision = (byte)n;
    }

    public void setPrecision(int n, int n2) {
        this.dlon = (byte)n;
        this.dlat = (byte)n2;
        this.precision = this.dlon > this.dlat ? this.dlon : this.dlat;
    }

    public void setEditing(int n) {
        this.editing = (short)(n & 0xFFFF);
        if ((n & 0x1000) != 0) {
            this.setPrecision(12);
        }
    }

    public void setEditing(String string) {
        this.setEditing(Astrocoo.editingOptions(string));
    }

    public boolean setEpoch(double d) {
        this.epoch = d;
        return true;
    }

    public final Astroframe getFrame() {
        return this.frame;
    }

    public final int getPrecision() {
        return this.precision;
    }

    public byte getLonPrec() {
        return this.dlon;
    }

    public byte getLatPrec() {
        return this.dlat;
    }

    public final int getEditing() {
        return this.editing;
    }

    public void dump(String string) {
        StringBuffer stringBuffer = new StringBuffer(256);
        int n = string.length();
        while (--n >= 0) {
            stringBuffer.append(' ');
        }
        String string2 = stringBuffer.toString();
        stringBuffer.setLength(0);
        stringBuffer.append(string);
        stringBuffer.append("Astroframe=");
        stringBuffer.append(this.frame);
        stringBuffer.append(", def.Ep=J");
        stringBuffer.append(this.frame.base_epoch);
        stringBuffer.append('\n');
        stringBuffer.append(string2);
        stringBuffer.append("editing=0x");
        stringBuffer.append(Integer.toHexString(this.editing));
        stringBuffer.append('=');
        stringBuffer.append(Astrocoo.explain(this.editing));
        stringBuffer.append('\n');
        stringBuffer.append(string2);
        stringBuffer.append("precision=");
        stringBuffer.append(this.precision);
        stringBuffer.append(", dlon=");
        stringBuffer.append(this.dlon);
        stringBuffer.append(", dlat=");
        stringBuffer.append(this.dlat);
        stringBuffer.append(", formRA=0x");
        stringBuffer.append(Integer.toHexString(this.formRA));
        stringBuffer.append('(');
        stringBuffer.append(Astroformat.explain(this.formRA));
        stringBuffer.append(')');
        stringBuffer.append('\n');
        stringBuffer.append(string2);
        stringBuffer.append("  ");
        super.editCoo(stringBuffer, 12);
        stringBuffer.append("  Epoch=J");
        stringBuffer.append(this.epoch);
        System.out.println(stringBuffer.toString());
        super.dump(string2);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Astrocoo) {
            Astrocoo astrocoo = (Astrocoo)object;
            bl = this.frame.equals(astrocoo.frame) && super.equals(astrocoo);
        }
        return bl;
    }

    public int hashCode() {
        int n = this.frame.hashCode();
        n = n * 123 + super.hashCode();
        return n;
    }

    public static int editingOptions(String string) throws IllegalArgumentException {
        char[] cArray = string.toCharArray();
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            int n2;
            if (cArray[i] == '*') {
                n |= 0xD00;
                continue;
            }
            for (n2 = 0; n2 < editing_options.length && cArray[i] != editing_options[n2]; ++n2) {
            }
            if (n2 == editing_options.length) {
                throw new IllegalArgumentException("****Astrocoo: '" + string + "'; accepted=" + string_options);
            }
            if (Editing_options[n2] < 16) {
                n &= 0xFFFFFFF0;
            }
            n |= Editing_options[n2];
        }
        return n;
    }

    protected final StringBuffer editEpoch(StringBuffer stringBuffer, double d) {
        double d2 = this.epoch;
        if (Double.isNaN(d2)) {
            stringBuffer.append(' ');
        } else if (this.frame instanceof FK4) {
            stringBuffer.append('B');
            d2 = Astrotime.J2B(this.epoch);
        } else {
            stringBuffer.append('J');
        }
        ed.editDecimal(stringBuffer, d2, 4, -3, 32);
        return stringBuffer;
    }

    public final StringBuffer edit(StringBuffer stringBuffer, int n) {
        boolean bl = false;
        int n2 = this.precision & 0xF;
        if (n2 == 0) {
            n2 = this.frame.precision;
        } else if (n2 > this.frame.precision) {
            n2 = this.frame.precision;
        }
        int n3 = n & 0xFFFFEEFF;
        if (DEBUG) {
            System.out.println("....edit(opt=0x" + Integer.toHexString(n) + "), epoch=" + this.epoch + ", precision=" + n2 + ", dlon=" + this.dlon + ", dlat=" + this.dlat + ", lon=" + this.lon);
        }
        if ((n & 0x1000) != 0) {
            n2 = 12;
        }
        if ((n & 0x100) != 0) {
            stringBuffer.append(this.frame.toString());
            stringBuffer.append(' ');
        }
        double d = this.getLon();
        int n4 = 3;
        int n5 = n2;
        if (Astroformat.isSexa(n3)) {
            bl = this.frame.hms;
        }
        if (bl) {
            --n4;
            d /= 15.0;
            if (n5 > 0) {
                if (++n5 < 3) {
                    n5 = 3;
                }
            } else if (--n5 > -3) {
                n5 = -3;
            }
        }
        ed.editDecimal(stringBuffer, d, n4, n5 - 1, 0x20 | n3);
        if ((n & 0x200) != 0) {
            stringBuffer.append(' ');
        }
        if (Astroformat.isTime(n3)) {
            n3 = Astroformat.isSexa(n3) ? (n3 -= 2) : ++n3;
        }
        ed.editDecimal(stringBuffer, this.getLat(), 3, n2 - 1, 0x30 | n3);
        if ((n & 0x400) != 0 && !Double.isNaN(this.epoch)) {
            stringBuffer.append(" (");
            this.editEpoch(stringBuffer, this.epoch);
            stringBuffer.append(')');
        }
        return stringBuffer;
    }

    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(80);
        this.edit(stringBuffer, n);
        return stringBuffer.toString();
    }

    public String toString(String string) throws IllegalArgumentException {
        StringBuffer stringBuffer = new StringBuffer(80);
        this.edit(stringBuffer, Astrocoo.editingOptions(string));
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(80);
        this.edit(stringBuffer, this.editing);
        return stringBuffer.toString();
    }

    public String toIAU(String string) throws ParseException {
        Object object;
        Astrocoo astrocoo = this;
        Editing editing = new Editing();
        Object object2 = string.charAt(0);
        Astroframe astroframe = null;
        if (object2 == 74) {
            if (this.frame instanceof ICRS) {
                astroframe = this.frame;
            } else if (this.frame instanceof FK5) {
                object = (FK5)this.frame;
                if (((FK5)object).equinox == 2000.0) {
                    astroframe = this.frame;
                }
            }
            if (astroframe == null) {
                astroframe = new ICRS();
            }
        } else if (object2 == 66) {
            if (this.frame instanceof FK4) {
                object = (FK4)this.frame;
                if (((FK4)object).equinox == 1950.0) {
                    astroframe = this.frame;
                }
            }
            if (astroframe == null) {
                astroframe = new FK4();
            }
        } else if (object2 == 71) {
            if (this.frame instanceof Galactic) {
                astroframe = this.frame;
            }
            if (astroframe == null) {
                astroframe = new Galactic();
            }
        } else {
            throw new ParseException("****Astrocoo.toIAU: template does not start with J|B|G", 0);
        }
        if (astroframe != this.frame) {
            astrocoo = new Astrocoo(astroframe);
            Astrocoo.convert(this, astrocoo);
        }
        object = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((char)object2);
        double d = astrocoo.lon;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n5 = 96;
        int n6 = 1;
        while (n6 < ((Object)object).length && n < 2) {
            int n7;
            if (object[n6] == 43) {
                n5 |= 0x10;
                ++n6;
                ++n4;
                continue;
            }
            object2 = object[n6];
            int n8 = Character.toUpperCase(object2);
            if (n8 == 72 && n == 0) {
                bl = !astroframe.hms;
                d /= 15.0;
            } else if (n8 == 76) {
                bl = astroframe.hms || n != 0;
            } else if (n8 == 66) {
                bl = astroframe.hms || n == 0;
            } else if (n8 != 68) {
                bl = true;
            }
            if (bl) {
                throw new ParseException("***Astrocoo.toIAU: '" + object2 + "' invalid", n6);
            }
            bl2 = false;
            while (n6 < ((Object)object).length && object[n6] == object2) {
                ++n6;
                ++n4;
            }
            while (!(n6 >= ((Object)object).length || bl || object[n6] == 43 && n == 0)) {
                if (object[n6] == 46) {
                    bl2 = true;
                    ++n6;
                    continue;
                }
                n7 = Character.toUpperCase((char)object[n6]);
                if (n7 == n8 || object[n6] == 102) {
                    object2 = object[n6];
                    while (n6 < ((Object)object).length && object[n6] == object2) {
                        ++n6;
                        ++n3;
                    }
                    break;
                }
                if (n7 == 77 && (n8 == 68 || n8 == 72)) {
                    object2 = object[n6];
                    n8 = n7;
                    while (n6 < ((Object)object).length && object[n6] == object2) {
                        ++n6;
                        ++n3;
                    }
                    n2 = 2;
                    continue;
                }
                if (n7 == 83 && n8 == 77) {
                    object2 = object[n6];
                    n8 = n7;
                    while (n6 < ((Object)object).length && object[n6] == object2) {
                        ++n6;
                        ++n3;
                    }
                    n2 = 3;
                    continue;
                }
                bl = true;
            }
            if (bl) {
                throw new ParseException("***Astrocoo.toIAU: '" + (char)object[n6] + "' invalid", n6);
            }
            n7 = stringBuffer.length();
            if (DEBUG) {
                System.out.print("# Edition(nint=" + n4 + ",nd=" + n3 + ",opt=" + n5 + "): " + stringBuffer);
            }
            editing.editDecimal(stringBuffer, d, n4, n3, n5 | n2);
            if (n2 != 0 || !bl2) {
                while (n7 < stringBuffer.length()) {
                    object2 = stringBuffer.charAt(n7);
                    if (object2 == 32) {
                        stringBuffer.deleteCharAt(n7);
                        continue;
                    }
                    if (object2 == 46 && !bl2) {
                        stringBuffer.deleteCharAt(n7);
                        continue;
                    }
                    ++n7;
                }
            }
            if (DEBUG) {
                System.out.println(" => " + stringBuffer);
            }
            n2 = 0;
            n3 = 0;
            n4 = 0;
            bl = false;
            bl2 = false;
            n5 = 96;
            d = astrocoo.lat;
            ++n;
        }
        if (n6 < ((Object)object).length || n != 2) {
            throw new ParseException("***Astrocoo.toIAU: '" + (char)object[n6] + "' invalid", n6);
        }
        return stringBuffer.toString();
    }

    public void convertTo(Astroframe astroframe) {
        if (this.frame.equals(astroframe)) {
            if (DEBUG) {
                System.out.println("....Frame " + this.frame + "=" + astroframe);
            }
            return;
        }
        if (DEBUG) {
            System.out.println("....Astrocoo.convert: via ICRS:  " + this.frame + " => ICRS => " + astroframe);
        }
        this.frame.toICRS(this);
        if (DEBUG) {
            this.dump("#ICRS: ");
        }
        astroframe.fromICRS(this);
        if (DEBUG) {
            this.dump("#NewF: ");
        }
        this.frame = astroframe;
        this.lat = Double.NaN;
        this.lon = Double.NaN;
    }

    public static void convert(Astrocoo astrocoo, Astrocoo astrocoo2) {
        Astrocoo astrocoo3 = astrocoo2;
        astrocoo3.set((Coo)astrocoo);
        if (astrocoo2.frame.equals(astrocoo.frame)) {
            if (DEBUG) {
                System.out.println("....Astrocoo.convert: Frame " + astrocoo.frame + "=" + astrocoo2.frame);
            }
            return;
        }
        astrocoo.frame.toICRS(astrocoo3);
        if (DEBUG) {
            astrocoo2.dump("#ICRS: ");
        }
        astrocoo2.frame.fromICRS(astrocoo3);
        if (DEBUG) {
            astrocoo2.dump("#NewF: ");
        }
    }
}

