/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.Editing;
import cds.astro.Parsing;
import java.text.ParseException;

public class Astrotime {
    protected double mjd;
    protected byte unit;
    protected byte precision;
    public static Editing ed = new Editing("--");
    public static final double Byr = 365.242198781;
    public static final double Jyr = 365.25;
    public static final double JD_J2000 = 2451545.0;
    public static final double JD_B1900 = 2415020.31352;
    public static final double JD_1970 = 2440587.5;
    public static final double JD_MJD0 = 2400000.5;
    public static final String[] prefix = new String[]{"\"date\"", "MJD", "JD", "J", "B", "ms"};
    private static final double[] factor = new double[]{1.0, 1.0, 1.0, 0.0027378507871321013, 0.0027379092649685915, 8.64E7};
    private static final String[] is_now = new String[]{"now", "."};
    public static final double[] offset = new double[]{0.0, 0.0, 2400000.5, 1858.8788501026695, 1858.8771134054919, -3.5067168E12};
    private static final byte[] ilen = new byte[]{10, 5, 7, 4, 4, 12};
    private static final double[] C_teq = new double[]{24110.54841, 8640184.812866, 0.093104, -6.2E-6};

    public static final double J2JD(double d) {
        return 2451545.0 + (d - 2000.0) * 365.25;
    }

    public static final double B2JD(double d) {
        return 2415020.31352 + (d - 1900.0) * 365.242198781;
    }

    public static final double YMD2JD(int n, int n2, int n3) {
        int n4;
        int n5;
        if (n <= -4712) {
            n5 = 1 + (n + 4712) / 400;
            n4 = -n5 * 146097;
            n5 = n + 400 * n5;
        } else {
            n4 = 0;
            n5 = n;
        }
        if (n3 <= 0) {
            n3 = 1;
        }
        if (n2 < 0 || n2 > 11) {
            n2 = 0;
        }
        double d = n4 += 1461 * ((n5 -= (11 - n2) / 10) + 4712) / 4 + (306 * ((n2 + 10) % 12) + 5) / 10 - 3 * ((n5 + 4900) / 100) / 4 + n3 + 96;
        return d + 0.5;
    }

    public static final void JD2YMD(double d, int[] nArray) {
        int n = (int)(d + 0.5);
        int n2 = -4712;
        while (n <= 4480) {
            n += 146097;
            n2 -= 400;
        }
        int n3 = 4 * (n + (2 * ((4 * n - 17918) / 146097) * 3 / 4 + 1) / 2 - 37);
        int n4 = 10 * ((n3 - 237) % 1461 / 4) + 5;
        nArray[0] = n2 + n3 / 1461;
        if (nArray.length > 1) {
            nArray[1] = (n4 / 306 + 2) % 12;
            nArray[2] = n4 % 306 / 10 + 1;
        }
        if (nArray.length != 3) {
            n3 = (n + 32104) % 146097;
            if (n3 >= 36525) {
                n3 += (n3 - 366) / 36524;
            }
            if ((n3 %= 1461) >= 731) {
                n3 += (n3 - 366) / 365;
            }
            n = 1 + n3 % 366;
            if (nArray.length == 2) {
                nArray[1] = n;
            } else {
                nArray[3] = n;
            }
        }
    }

    public static final double ms2JD(long l) {
        return 2440587.5 + (double)l / 8.64E7;
    }

    public static final double MJD2JD(double d) {
        return 2400000.5 + d;
    }

    public static final double JD2J(double d) {
        return 2000.0 + (d - 2451545.0) / 365.25;
    }

    public static final double JD2B(double d) {
        return 1900.0 + (d - 2415020.31352) / 365.242198781;
    }

    public static final long JD2ms(double d) {
        return (long)((d - 2440587.5) * 8.64E7);
    }

    public static final double JD2MJD(double d) {
        return d - 2400000.5;
    }

    public static final double B2J(double d) {
        return Astrotime.JD2J(Astrotime.B2JD(d));
    }

    public static final double J2B(double d) {
        return Astrotime.JD2B(Astrotime.J2JD(d));
    }

    public Astrotime() {
        this.mjd = Double.NaN;
        this.unit = 0;
        this.precision = (byte)8;
    }

    public Astrotime(String string) throws ParseException {
        this.set(string);
    }

    public final void dump(String string) {
        System.out.println(string + " unit=" + this.unit + ", precision=" + this.precision + ", mjd=" + this.mjd);
    }

    public boolean parsing(Parsing parsing) {
        double d;
        int n = parsing.pos;
        parsing.gobbleSpaces();
        int n2 = 0;
        int n3 = parsing.lookup(prefix);
        int n4 = parsing.pos;
        if (parsing.pos == parsing.length || parsing.lookupIgnoreCase(is_now) >= 0) {
            this.set(System.currentTimeMillis());
            return true;
        }
        if (n3 <= 0) {
            int n5 = parsing.parseDate();
            boolean bl = false;
            d = 0.0;
            if (parsing.pos > n4) {
                n3 = 0;
                int n6 = parsing.pos;
                n2 = parsing.format() & 0xFFFFFF7E;
                n2 = n2 == 128 || n2 == 130 ? 0 : 1;
                if (n2 == 1) {
                    char c = parsing.currentChar();
                    if (c == '.') {
                        d = parsing.parseDecimal();
                        bl = parsing.match(':');
                        if (bl) {
                            parsing.set(n6);
                        } else {
                            n2 = 1 + parsing.decimals();
                        }
                    } else {
                        boolean bl2 = bl = c == 'T' || c == ':' || c == ' ';
                    }
                    if (bl) {
                        parsing.advance(1);
                        d = parsing.parseSexa();
                        if (parsing.pos - n6 > 1) {
                            d /= 24.0;
                            n2 = 2 + parsing.decimals();
                        } else {
                            parsing.set(n6);
                            d = 0.0;
                        }
                    }
                }
                d += (double)n5;
            }
        } else {
            d = parsing.parseDouble();
            n2 = 1 + parsing.decimals();
        }
        if (parsing.pos == n4) {
            parsing.set(n);
            return false;
        }
        this.precision = (byte)n2;
        if (n3 < 0) {
            n3 = parsing.lookup(prefix);
        }
        if (n3 < 0) {
            n3 = 3;
        }
        this.mjd = (d - offset[n3]) / factor[n3];
        return true;
    }

    public int parse(String string, int n) {
        Parsing parsing = new Parsing(string, n);
        return this.parsing(parsing) ? parsing.pos : n;
    }

    public void set(double d) {
        this.mjd = d;
        this.unit = 1;
        this.precision = (byte)8;
    }

    public void set(long l) {
        this.mjd = 40587.0 + (double)l / 8.64E7;
        this.unit = 0;
        this.precision = (byte)8;
    }

    public void set(String string) throws ParseException {
        Parsing parsing = new Parsing(string);
        if (this.parsing(parsing)) {
            parsing.gobbleSpaces();
        }
        if (parsing.pos != parsing.length) {
            throw new ParseException("****Astrotime: argument '" + string + "'", parsing.pos);
        }
    }

    public double getMJD() {
        return this.mjd;
    }

    public double getJyr() {
        return 2000.0 + (this.mjd + -51544.5) / 365.25;
    }

    public double getByr() {
        return 1900.0 + (this.mjd + -15019.81351999985) / 365.242198781;
    }

    public double getJD() {
        return this.mjd + 2400000.5;
    }

    public long getTime() {
        return (long)((this.mjd + -40587.0) * 8.64E7);
    }

    public double getLST() {
        double d = Math.floor(this.mjd);
        double d2 = (d - 51544.5) / 36525.0;
        double d3 = ((C_teq[3] * d2 + C_teq[2]) * d2 + C_teq[1]) * d2 + C_teq[0];
        d3 -= 86400.0 * Math.floor(d3 / 86400.0);
        if ((d3 += 86636.55536784 * (this.mjd - d)) >= 86400.0) {
            d3 -= 86400.0;
        }
        return d3;
    }

    public double getLST(double d) {
        double d2 = this.getLST() + d * 240.0;
        if (d2 < 0.0) {
            d2 += 86400.0;
        } else if (d2 > 86400.0) {
            d2 -= 86400.0;
        }
        return d2;
    }

    private final void edit(StringBuffer stringBuffer, int n, double d) {
        if (n > 0) {
            stringBuffer.append(prefix[n]);
        }
        if (Double.isNaN(d) || n > 0) {
            ed.editDecimal(stringBuffer, d, ilen[n], this.precision - 1, 0);
            return;
        }
        int n2 = (int)d;
        double d2 = d - (double)n2;
        if (d2 < -1.0E-11) {
            --n2;
            d2 += 1.0;
        } else if (d2 < 0.0) {
            d2 = 0.0;
        }
        ed.editDate(stringBuffer, n2);
        if (this.precision == 0) {
            stringBuffer.setLength(stringBuffer.length() - 3);
        }
        if (this.precision <= 1) {
            return;
        }
        stringBuffer.append('T');
        ed.editSexa(stringBuffer, d2 * 24.0, 2, this.precision - 2, 37);
    }

    public String toString(String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(32);
        for (n = 0; n < prefix.length && !string.equals(prefix[n]); ++n) {
        }
        if (n == prefix.length) {
            n = this.unit;
        }
        double d = this.mjd * factor[n] + offset[n];
        this.edit(stringBuffer, n, d);
        return stringBuffer.toString();
    }

    public String toString() {
        double d = this.mjd * factor[this.unit] + offset[this.unit];
        StringBuffer stringBuffer = new StringBuffer(32);
        this.edit(stringBuffer, this.unit, d);
        return stringBuffer.toString();
    }
}

