/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.Coo;
import cds.astro.Editing;

public class Coocube
extends Coo {
    public byte face;
    public double X;
    public double Y;
    private static final byte[] axis6 = new byte[]{0, 2, 6, 2, 6, 3, 3, 0, 0, 4, 4, 1, 5, 1, 5, 0, 0, 1, 2, 3, 4, 5, 6, 0};
    private static Editing edition = new Editing();

    public static final int face(double[] dArray) {
        int n;
        int[] nArray = new int[]{0, 1, 2};
        if (dArray[1] < dArray[0]) {
            nArray[0] = 1;
            nArray[1] = 0;
        }
        if (dArray[2] < dArray[nArray[0]]) {
            nArray[2] = nArray[0];
            nArray[0] = 2;
        }
        if (dArray[nArray[2]] < dArray[nArray[1]]) {
            n = nArray[2];
            nArray[2] = nArray[1];
            nArray[1] = n;
        }
        n = dArray[nArray[2]] > -dArray[nArray[0]] ? 3 ^ nArray[2] : 4 ^ nArray[0];
        if (dArray[nArray[0]] >= -0.577 && dArray[nArray[2]] <= 0.577) {
            n = 0;
        }
        return n;
    }

    public static final int setXY(double[] dArray, double[] dArray2) {
        double d;
        int n = Coocube.face(dArray);
        if (n == 0) {
            dArray2[1] = 0.0;
            dArray2[0] = 0.0;
            return n;
        }
        double d2 = d = (n & 4) == 0 ? dArray[3 ^ n] : -dArray[4 ^ n];
        if (d < 0.577) {
            dArray2[1] = 0.0;
            dArray2[0] = 0.0;
            return 0;
        }
        byte by = axis6[n];
        dArray2[0] = (by & 4) == 0 ? dArray[3 ^ by] : -dArray[4 ^ by];
        by = axis6[8 | n];
        dArray2[1] = (by & 4) == 0 ? dArray[3 ^ by] : -dArray[4 ^ by];
        dArray2[0] = dArray2[0] / d;
        dArray2[1] = dArray2[1] / d;
        return n;
    }

    public static final int setUvec(int n, double d, double d2, double[] dArray) {
        if (n < 1 || n > 6) {
            dArray[2] = 0.0;
            dArray[1] = 0.0;
            dArray[0] = 0.0;
            return 0;
        }
        double d3 = 1.0 / Math.sqrt(1.0 + d * d + d2 * d2);
        int n2 = n;
        if ((n2 & 4) == 0) {
            dArray[3 ^ n2] = d3;
        } else {
            dArray[4 ^ n2] = -d3;
        }
        n2 = axis6[n];
        if ((n2 & 4) == 0) {
            dArray[3 ^ n2] = d * d3;
        } else {
            dArray[4 ^ n2] = -d * d3;
        }
        n2 = axis6[8 | n];
        if ((n2 & 4) == 0) {
            dArray[3 ^ n2] = d2 * d3;
        } else {
            dArray[4 ^ n2] = -d2 * d3;
        }
        return n;
    }

    public final void set(double[] dArray) {
        double[] dArray2 = new double[2];
        super.set(dArray[0], dArray[1], dArray[2]);
        this.face = (byte)Coocube.setXY(dArray, dArray2);
        this.X = dArray2[0];
        this.Y = dArray2[1];
    }

    public final void set(Coo coo) {
        double[] dArray = new double[]{coo.x, coo.y, coo.z};
        this.set(dArray);
    }

    public final void set(int n, double d, double d2) {
        double[] dArray = new double[3];
        if (n < 1 || n > 6) {
            dArray[2] = 0.0;
            dArray[1] = 0.0;
            dArray[0] = 0.0;
        } else {
            Coocube.setUvec(n, d, d2, dArray);
        }
        this.set(dArray);
    }

    public Coocube() {
        this.face = 0;
        this.X = 0.0;
        this.Y = 0.0;
    }

    public Coocube(Coo coo) {
        this.set(coo);
    }

    public Coocube(int n, double d, double d2) {
        this.set(n, d, d2);
    }

    public StringBuffer edit(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.face);
        stringBuffer.append(":");
        if (this.face == 0) {
            return stringBuffer;
        }
        edition.editDecimal(stringBuffer, this.X, 2, n, 16);
        edition.editDecimal(stringBuffer, this.Y, 2, n, 16);
        return stringBuffer;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(20);
        this.edit(stringBuffer, 6);
        stringBuffer.append("(");
        super.edit(stringBuffer, 4);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

