/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.AstroMath;
import cds.astro.Astrotime;
import cds.astro.Coo;
import cds.astro.Equatorial;

public class FK4
extends Equatorial {
    private static boolean DEBUG = false;
    private static double[] ev50 = FK4.eterm(1950.0);
    protected double[][] toBaseEquinox;
    protected double[] ev_eq;
    protected static double[] A = new double[]{-1.62557E-6, -3.1919E-7, -1.3843E-7, 0.001244, -0.001579, -6.6E-4};
    protected static double[][] EM = new double[][]{{0.9999256782, -0.0111820611, -0.0048579477, 2.42395018E-6, -2.710663E-8, -1.177656E-8}, {0.011182061, 0.9999374784, -2.71765E-5, 2.710663E-8, 2.42397878E-6, -6.587E-11}, {0.0048579479, -2.71474E-5, 0.9999881997, 1.177656E-8, -6.582E-11, 2.42410173E-6}, {-5.51E-4, -0.238565, 0.435739, 0.99994704, -0.01118251, -0.00485767}, {0.238514, -0.002667, -0.008541, 0.01118251, 0.99995883, -2.718E-5}, {-0.435623, 0.012254, 0.002117, 0.00485767, -2.714E-5, 1.00000956}};
    private static double[][] EM50 = new double[][]{{0.9999256795356672, -0.011181482799697, -0.0048590039655699}, {0.0111814828233251, 0.9999374848650175, -2.71557959449E-5}, {0.0048590038843768, -2.71771046587E-5, 0.9999881945682256}};
    protected static double[][] EM1 = new double[][]{{0.9999256795, 0.0111814829, 0.0048590038, -2.4238984E-6, -2.710545E-8, -1.177742E-8}, {-0.0111814828, 0.9999374849, -2.71771E-5, 2.710545E-8, -2.42392702E-6, 6.585E-11}, {-0.004859004, -2.71558E-5, 0.9999881946, 1.177742E-8, 6.585E-11, -2.42404995E-6}, {-5.5E-4, 0.238509, -0.435613, 0.99990432, 0.01118145, 0.00485852}, {-0.238559, -0.002668, 0.012254, -0.01118145, 0.99991613, -2.717E-5}, {0.43573, -0.008541, 0.002116, -0.00485852, -2.716E-5, 0.99996684}};
    static double[][] EM2 = null;

    private void initialize(double d, double d2) {
        this.precision = (byte)6;
        this.base_epoch = Astrotime.B2J(1950.0);
        this.equinox = d;
        this.epoch = d2;
        this.name = "FK4(B" + d + ")";
        this.ed_lon = (byte)37;
        this.ed_lat = (byte)53;
        if (Math.abs(d - 1950.0) > 3.0E-4) {
            this.toBaseEquinox = FK4.precessionMatrix(d, 1950.0);
            this.ev_eq = FK4.eterm(d);
        } else {
            this.toBaseEquinox = Coo.Umatrix3;
            this.ev_eq = ev50;
        }
    }

    public FK4(double d, double d2) {
        this.initialize(d, Astrotime.B2J(d2));
    }

    public FK4(double d) {
        this.initialize(d, Astrotime.B2J(d));
    }

    public FK4() {
        this.initialize(1950.0, this.base_epoch);
    }

    public double[][] toICRSmatrix() {
        return null;
    }

    public static double[][] precessionMatrix(double d, double d2) {
        boolean bl = false;
        double d3 = d - 1900.0;
        double d4 = d2 - d;
        if (Math.abs(d3) > Math.abs(d3 + d4)) {
            bl = true;
            d3 += d4;
            d4 = -d4;
        }
        double d5 = (d4 /= 1000.0) * (23042.53 + (d3 /= 1000.0) * (139.73 + 0.06 * d3) + d4 * (30.23 + 18.0 * d4 - 0.27 * d3)) / 3600.0;
        double d6 = d5 + d4 * d4 * (79.27 + 0.66 * d3 + 0.32 * d4) / 3600.0;
        double d7 = d4 * (20046.85 - d3 * (85.33 + 0.37 * d3) - d4 * (42.67 + 0.37 * d3 + 41.8 * d4)) / 3600.0;
        if (bl) {
            return Coo.eulerMatrix(-d5, -d7, -d6);
        }
        return Coo.eulerMatrix(d6, d7, d5);
    }

    private static void pr6(double[] dArray, String string, String string2) {
        double[] dArray2 = new double[]{dArray[0], dArray[1], dArray[2]};
        System.out.println(string + Coo.toString(dArray2));
        dArray2[0] = dArray[3];
        dArray2[1] = dArray[4];
        dArray2[2] = dArray[5];
        System.out.println(string2 + Coo.toString(dArray2));
    }

    public static final double[] eterm(double d) {
        double[] dArray = new double[3];
        double d2 = (d - 1900.0) / 100.0;
        double d3 = 23.452 - 0.013 * d2;
        double d4 = 0.016751 - 4.2E-5 * d2;
        double d5 = 281.221 + 1.719 * d2;
        double d6 = AstroMath.cosd(d5);
        dArray[0] = (d4 *= 9.936741208021049E-5) * AstroMath.sind(d5);
        dArray[1] = -d4 * d6 * AstroMath.cosd(d3);
        dArray[2] = -d4 * d6 * AstroMath.sind(d3);
        if (DEBUG) {
            System.out.println(".... e-term(B" + d + "): " + Coo.toString(dArray));
        }
        return dArray;
    }

    public static void toFK5(Coo coo) {
        double[] dArray = new double[6];
        coo.copyUvector(dArray);
        FK4.estimateFK4motion(dArray);
        FK4.toFK5(dArray);
        coo.set(dArray[0], dArray[1], dArray[2]);
    }

    public static void toFK5(double[] dArray) {
        int n;
        double[] dArray2 = new double[6];
        if (dArray[0] == 0.0 && dArray[1] == 0.0 && dArray[2] == 0.0) {
            return;
        }
        dArray2[0] = dArray[0];
        dArray2[1] = dArray[1];
        dArray2[2] = dArray[2];
        dArray2[3] = dArray[3] * 2.0626480624709636E7;
        dArray2[4] = dArray[4] * 2.0626480624709636E7;
        dArray2[5] = dArray[5] * 2.0626480624709636E7;
        if (DEBUG) {
            FK4.pr6(dArray2, "        toFK5(1) ", "                 ");
        }
        double d = dArray2[0] * A[0] + dArray2[1] * A[1] + dArray2[2] * A[2];
        double d2 = dArray2[0] * A[3] + dArray2[1] * A[4] + dArray2[2] * A[5];
        dArray2[0] = dArray2[0] - (A[0] - d * dArray[0]);
        dArray2[1] = dArray2[1] - (A[1] - d * dArray[1]);
        dArray2[2] = dArray2[2] - (A[2] - d * dArray[2]);
        dArray2[3] = dArray2[3] - (A[3] - d2 * dArray[0]);
        dArray2[4] = dArray2[4] - (A[4] - d2 * dArray[1]);
        dArray2[5] = dArray2[5] - (A[5] - d2 * dArray[2]);
        for (n = 0; n < 6; ++n) {
            d = 0.0;
            for (int i = 0; i < 6; ++i) {
                d += EM[n][i] * dArray2[i];
            }
            dArray[n] = d;
        }
        if (DEBUG) {
            FK4.pr6(dArray, "        toFK5(2) ", "                 ");
        }
        dArray[3] = dArray[3] / 2.0626480624709636E7;
        dArray[4] = dArray[4] / 2.0626480624709636E7;
        dArray[5] = dArray[5] / 2.0626480624709636E7;
        d = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]);
        n = 0;
        while (n < 6) {
            int n2 = n++;
            dArray[n2] = dArray[n2] / d;
        }
    }

    public static void fromFK5(Coo coo) {
        double[] dArray = new double[]{coo.x, coo.y, coo.z};
        double d = EM1[0][0] * dArray[0] + EM1[0][1] * dArray[1] + EM1[0][2] * dArray[2];
        double d2 = EM1[1][0] * dArray[0] + EM1[1][1] * dArray[1] + EM1[1][2] * dArray[2];
        double d3 = EM1[2][0] * dArray[0] + EM1[2][1] * dArray[1] + EM1[2][2] * dArray[2];
        double d4 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        if (d4 == 0.0) {
            return;
        }
        d /= d4;
        d2 /= d4;
        d3 /= d4;
        d4 = d * A[0] + d2 * A[1] + d3 * A[2];
        d += A[0] - d4 * d;
        d2 += A[1] - d4 * d2;
        d3 += A[2] - d4 * d3;
        d4 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        coo.set(d /= d4, d2 /= d4, d3 /= d4);
    }

    public static void fromFK5(double[] dArray) {
        double d;
        int n;
        double[] dArray2 = new double[6];
        if (dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2] < 1.0E-10) {
            return;
        }
        dArray[3] = dArray[3] * 2.0626480624709636E7;
        dArray[4] = dArray[4] * 2.0626480624709636E7;
        dArray[5] = dArray[5] * 2.0626480624709636E7;
        if (DEBUG) {
            FK4.pr6(dArray, "        from5(1) ", "                 ");
        }
        for (n = 0; n < 6; ++n) {
            d = 0.0;
            for (int i = 0; i < 6; ++i) {
                d += EM1[n][i] * dArray[i];
            }
            dArray2[n] = d;
        }
        d = Math.sqrt(dArray2[0] * dArray2[0] + dArray2[1] * dArray2[1] + dArray2[2] * dArray2[2]);
        n = 0;
        while (n < 6) {
            int n2 = n++;
            dArray2[n2] = dArray2[n2] / d;
        }
        if (DEBUG) {
            FK4.pr6(dArray2, "        from5(+) ", "                 ");
        }
        d = dArray2[0] * A[0] + dArray2[1] * A[1] + dArray2[2] * A[2];
        double d2 = dArray2[0] * A[3] + dArray2[1] * A[4] + dArray2[2] * A[5];
        dArray[3] = dArray2[3] + A[3] - d2 * dArray2[0];
        dArray[4] = dArray2[4] + A[4] - d2 * dArray2[1];
        dArray[5] = dArray2[5] + A[5] - d2 * dArray2[2];
        dArray[0] = dArray2[0] + A[0] - d * dArray2[0];
        dArray[1] = dArray2[1] + A[1] - d * dArray2[1];
        dArray[2] = dArray2[2] + A[2] - d * dArray2[2];
        d = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]);
        n = 0;
        while (n < 6) {
            int n3 = n++;
            dArray[n3] = dArray[n3] / d;
        }
        if (DEBUG) {
            FK4.pr6(dArray, "        from5(2) ", "                 ");
        }
        dArray[3] = dArray[3] / 2.0626480624709636E7;
        dArray[4] = dArray[4] / 2.0626480624709636E7;
        dArray[5] = dArray[5] / 2.0626480624709636E7;
    }

    public static void estimateFK4motion(double[] dArray) {
        double d;
        int n;
        int n2;
        double[] dArray2 = new double[6];
        if (EM2 == null) {
            double[][] dArray3 = new double[6][6];
            for (n2 = 0; n2 < 6; ++n2) {
                for (n = 0; n < 6; ++n) {
                    d = 0.0;
                    for (int i = 0; i < 3; ++i) {
                        d += EM1[n2][i] * EM[i][n];
                    }
                    dArray3[n2][n] = d;
                }
            }
            EM2 = dArray3;
        }
        for (n2 = 0; n2 < 6; ++n2) {
            d = 0.0;
            for (n = 0; n < 3; ++n) {
                d += EM2[n2][n] * dArray[n];
            }
            dArray2[n2] = d;
        }
        d = dArray2[0] * A[3] + dArray2[1] * A[4] + dArray2[2] * A[5];
        for (n2 = 3; n2 < 6; ++n2) {
            int n3 = n2;
            dArray2[n3] = dArray2[n3] + (A[n2] - d * dArray2[n2 - 3]);
        }
        for (n2 = 3; n2 < 6; ++n2) {
            dArray[n2] = dArray2[n2] / 2.0626480624709636E7;
        }
    }

    public void toICRS(double[] dArray) {
        if (this.toBaseEquinox != Coo.Umatrix3) {
            double[] dArray2 = new double[3];
            Coo.sub(dArray, this.ev_eq);
            Coo.rotateVector(this.toBaseEquinox, dArray);
            Coo.add(dArray, ev50);
        }
        FK4.toFK5(dArray);
    }

    public void toICRS(Coo coo) {
        if (this.toBaseEquinox != Coo.Umatrix3) {
            double[] dArray = new double[3];
            coo.sub(this.ev_eq);
            coo.rotate(this.toBaseEquinox);
            coo.add(ev50);
        }
        FK4.toFK5(coo);
    }

    public void fromICRS(double[] dArray) {
        FK4.fromFK5(dArray);
        if (this.toBaseEquinox != Coo.Umatrix3) {
            double[] dArray2 = new double[3];
            Coo.sub(dArray, ev50);
            Coo.rotateVector_1(this.toBaseEquinox, dArray);
            Coo.add(dArray, this.ev_eq);
        }
    }

    public void fromICRS(Coo coo) {
        double[] dArray = new double[6];
        coo.copyUvector(dArray);
        dArray[5] = 0.0;
        dArray[4] = 0.0;
        dArray[3] = 0.0;
        FK4.fromFK5(dArray);
        if (DEBUG) {
            FK4.pr6(dArray, "FK4from ", "FK4from.");
        }
        coo.set(dArray[0], dArray[1], dArray[2]);
        if (this.toBaseEquinox != null) {
            double[] dArray2 = new double[3];
            coo.sub(ev50);
            coo.rotate_1(this.toBaseEquinox);
            coo.add(this.ev_eq);
        }
    }
}

