/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.AstroMath;
import cds.astro.Astroformat;
import cds.astro.Astrotime;
import java.text.ParseException;

public class Parsing
extends Astroformat {
    public char[] a;
    public int length;
    public int pos;
    private int flags;
    public String error_message;
    public static final int OK = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    public static final int DEBUG = 0;
    private static final char[] sexa_letter = new char[]{':', 'm', 's'};
    private static final char[] sexa_symbol = new char[]{'\u00b0', '\'', '\"'};
    private static final char[] sexa_symb1 = new char[]{':', 'd', 'o', '\u00b0', 'h', 'm', 's', '\'', '\"'};
    private static final byte[] sexa_unit1 = new byte[]{2, 4, 4, 20, 6, 7, 15, 21, 29};
    private static final char[] brackets = "()[]{}<>".toCharArray();
    private static final String[] error_symb = new String[]{"+/-", "+", "-", "\u00b1", "["};

    public Parsing(String string) {
        this(string, 0);
    }

    public Parsing(String string, int n) {
        this.length = string.length();
        this.a = string.toCharArray();
        this.pos = n;
    }

    public final void set(int n) {
        this.pos = n;
        if (this.pos > this.a.length) {
            this.pos = this.a.length;
        }
        if (this.pos < 0) {
            this.pos = 0;
        }
    }

    public final void set(String string) {
        this.a = string.toCharArray();
        this.length = string.length();
        this.pos = 0;
    }

    public final void advance(int n) {
        this.set(this.pos + n);
    }

    public final char currentChar() {
        if (this.pos >= this.length) {
            return '\u0000';
        }
        return this.a[this.pos];
    }

    public final void gobbleSpaces() {
        while (this.pos < this.length && Character.isWhitespace(this.a[this.pos])) {
            ++this.pos;
        }
    }

    public final int lookup(char[] cArray) {
        if (this.pos >= this.length) {
            return -1;
        }
        char c = this.a[this.pos];
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != c) continue;
            ++this.pos;
            return i;
        }
        return -1;
    }

    public final boolean match(char c) {
        int n = this.pos;
        this.gobbleSpaces();
        if (this.pos < this.length && this.a[this.pos++] == c) {
            return true;
        }
        this.pos = n;
        return false;
    }

    public final boolean match(String string) {
        int n;
        int n2 = this.pos;
        int n3 = string.length();
        boolean bl = n3 + this.pos <= this.length;
        for (n = 0; bl && n < n3; ++n) {
            bl = this.a[this.pos++] == string.charAt(n);
        }
        if (bl) {
            boolean bl2 = bl = n == n3;
        }
        if (!bl) {
            this.pos = n2;
        }
        return bl;
    }

    public final int lookup(String[] stringArray, int n) {
        if (this.flags > 0) {
            this.flags = 0;
        }
        if (this.pos + n <= this.length) {
            for (int i = 0; i < stringArray.length; ++i) {
                int n2;
                if (stringArray[i].length() != n) continue;
                for (n2 = 0; n2 < n && stringArray[i].charAt(n2) == this.a[this.pos + n2]; ++n2) {
                }
                if (n2 < n) continue;
                this.pos += n;
                return i;
            }
        }
        return -1;
    }

    public final int lookup(String[] stringArray) {
        int n = this.length - this.pos;
        int n2 = 0;
        if (this.flags > 0) {
            this.flags = 0;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            int n3;
            n2 = stringArray[i].length();
            if (n2 > n) continue;
            for (n3 = 0; n3 < n2 && stringArray[i].charAt(n3) == this.a[this.pos + n3]; ++n3) {
            }
            if (n3 < n2) continue;
            this.pos += n2;
            return i;
        }
        return -1;
    }

    public final int lookupIgnoreCase(String[] stringArray) {
        int n = this.length - this.pos;
        int n2 = 0;
        if (this.flags > 0) {
            this.flags = 0;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            int n3;
            n2 = stringArray[i].length();
            if (n2 > n) continue;
            for (n3 = 0; n3 < n2 && Character.toLowerCase(stringArray[i].charAt(n3)) == Character.toLowerCase(this.a[this.pos + n3]); ++n3) {
            }
            if (n3 < n2) continue;
            this.pos += n2;
            return i;
        }
        return -1;
    }

    public final int matchingBracket() {
        int n = this.pos;
        if (this.pos >= this.length) {
            return -1;
        }
        int n2 = this.lookup(brackets);
        if (n2 < 0) {
            return n2;
        }
        this.pos = n;
        char c = brackets[n2];
        char c2 = brackets[n2 ^ 1];
        int n3 = 1;
        int n4 = this.pos;
        if ((n2 & 1) == 0) {
            ++n4;
            while (n4 < this.length) {
                if (this.a[n4] == c) {
                    ++n3;
                } else if (this.a[n4] == c2) {
                    --n3;
                }
                if (n3 != 0) {
                    ++n4;
                    continue;
                }
                break;
            }
        } else {
            --n4;
            while (n4 >= 0) {
                if (this.a[n4] == c) {
                    ++n3;
                } else if (this.a[n4] == c2) {
                    --n3;
                }
                if (n3 != 0) {
                    --n4;
                    continue;
                }
                break;
            }
        }
        if (n4 >= this.length) {
            n4 = -1;
        }
        return n4;
    }

    public final int matchingQuote() {
        int n;
        for (n = this.pos + 1; n < this.length && this.a[n] != this.a[this.pos]; ++n) {
        }
        if (n >= this.length) {
            n = -1;
        }
        return n;
    }

    public static final boolean isMinus(char c) {
        return c == '-' || c >= '\u2010' && c <= '\u2015' || c == '\u2012' || c == '\u00ad';
    }

    public static final boolean isSign(char c) {
        return c == '+' || Parsing.isMinus(c);
    }

    public final int parseSign() {
        if (this.pos < this.length) {
            char c;
            if ((c = this.a[this.pos++]) == '+') {
                return 1;
            }
            if (Parsing.isMinus(c)) {
                return -1;
            }
            --this.pos;
        }
        return 0;
    }

    private final int parseNum() {
        int n;
        int n2 = 0;
        for (n = this.pos; n < this.length && Character.isDigit(this.a[n]); ++n) {
        }
        if (n > this.pos) {
            n2 = Integer.parseInt(new String(this.a, this.pos, n - this.pos));
        }
        if (this.flags == 0) {
            this.flags = n - this.pos << 8;
            if (this.flags > 256 && this.a[this.pos] == '0' && Character.isDigit(this.a[this.pos + 1])) {
                this.flags |= 0x200000;
            }
        }
        this.pos = n;
        return n2;
    }

    private final int parseNum(int n) {
        int n2;
        int n3 = 0;
        for (n2 = this.pos; n > 0 && n2 < this.length; --n, ++n2) {
            if (Character.isDigit(this.a[n2])) {
                n3 = n3 * 10 + (this.a[n2] & 0xF);
                continue;
            }
            if (n3 != 0 || !Character.isWhitespace(this.a[n2])) break;
        }
        if (this.flags == 0) {
            this.flags = n2 - this.pos << 8;
        }
        this.pos = n2;
        return n3;
    }

    private final long parseNum8() {
        int n;
        long l = 0L;
        for (n = this.pos; n < this.length && Character.isDigit(this.a[n]); ++n) {
        }
        if (n > this.pos) {
            l = Long.parseLong(new String(this.a, this.pos, n - this.pos));
        }
        if (this.flags == 0) {
            this.flags = n - this.pos << 8;
            if (this.flags > 256 && this.a[this.pos] == '0' && Character.isDigit(this.a[this.pos + 1])) {
                this.flags |= 0x200000;
            }
        }
        this.pos = n;
        return l;
    }

    public final boolean parseNaN() {
        int n = this.pos;
        this.gobbleSpaces();
        if (this.pos >= this.length) {
            this.pos = n;
            return false;
        }
        int n2 = this.pos;
        for (int i = 0; i < this.nulls.length; ++i) {
            if (this.nulls[i] == null) continue;
            this.pos = n2;
            if (!this.match(this.nulls[i])) continue;
            char c = this.a[this.pos - 1];
            while (this.pos < this.length && this.a[this.pos] == c) {
                ++this.pos;
            }
            if (this.pos >= this.length || Character.isLetterOrDigit(c = this.a[this.pos]) || c == '.') continue;
            return true;
        }
        this.pos = n;
        return false;
    }

    public final int parsePositiveInt() {
        int n = this.pos;
        int n2 = 0;
        if (this.flags > 0) {
            this.flags = 0;
        }
        while (this.pos < this.length && Character.isWhitespace(this.a[this.pos])) {
            ++this.pos;
        }
        if (this.pos >= this.length) {
            this.pos = n;
            return n2;
        }
        n2 = this.parseNum();
        if (this.flags == 0) {
            if (this.parseNaN()) {
                n2 = Integer.MIN_VALUE;
            } else {
                this.pos = n;
            }
        }
        return n2;
    }

    public final int parseInt() {
        int n = this.pos;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (this.flags > 0) {
            this.flags = 0;
        }
        this.gobbleSpaces();
        if (this.pos >= this.length) {
            this.pos = n;
            return n2;
        }
        n4 = this.parseSign();
        if (n4 > 0) {
            n3 = 16;
        }
        n2 = this.parseNum();
        if (n4 < 0) {
            n2 = -n2;
        }
        if (this.flags == 0) {
            if (this.parseNaN()) {
                n2 = Integer.MIN_VALUE;
            } else {
                this.pos = n;
            }
        } else {
            this.flags |= n3 << 16;
        }
        return n2;
    }

    public final long parseLong() {
        int n = this.pos;
        long l = 0L;
        int n2 = 0;
        int n3 = 0;
        if (this.flags > 0) {
            this.flags = 0;
        }
        this.gobbleSpaces();
        if (this.pos >= this.length) {
            this.pos = n;
            return l;
        }
        n3 = this.parseSign();
        if (n3 > 0) {
            n2 = 16;
        }
        l = this.parseNum8();
        if (n3 < 0) {
            l = -l;
        }
        if (this.flags == 0) {
            if (this.parseNaN()) {
                l = Long.MIN_VALUE;
            } else {
                this.pos = n;
            }
        } else {
            this.flags |= n2 << 16;
        }
        return l;
    }

    private final double parseValue(int n) {
        int n2;
        int n3;
        int n4;
        double d = 1.0;
        int n5 = this.pos;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        char c = '\u0000';
        int n9 = 0;
        if (this.flags > 0) {
            this.flags = 0;
        }
        if (this.pos >= this.length) {
            return d;
        }
        n9 = this.parseSign();
        if (n9 > 0) {
            n8 |= 0x10;
        }
        for (n4 = this.pos; n4 < this.length && this.a[n4] == '0'; ++n4) {
        }
        for (n3 = n4; n3 < this.length && Character.isDigit(this.a[n3]); ++n3) {
        }
        if (n4 - this.pos > 0 && n3 - this.pos > 1) {
            n8 |= 0x20;
        }
        if (n3 < this.length && this.a[n3] == '.') {
            if (n4 == n3) {
                ++n4;
                while (n4 < this.length && this.a[n4] == '0') {
                    ++n4;
                }
            } else {
                ++n4;
            }
            n2 = ++n3;
            while (n3 < this.length && Character.isDigit(this.a[n3])) {
                ++n3;
            }
            n2 = n3 - n2;
        } else {
            n2 = -1;
        }
        n4 = n3 - n4;
        if (n4 == 0) {
            n4 = 1;
        }
        if (n3 == this.pos) {
            this.pos = n5;
            if (this.parseNaN()) {
                d = Double.NaN;
            } else {
                this.pos = n5;
            }
            return d;
        }
        d = Double.valueOf(new String(this.a, this.pos, n3 - this.pos));
        if (n9 < 0) {
            d = -d;
        }
        this.pos = n3;
        if (this.flags == 0) {
            this.flags = n2 + 1 | n4 << 8 | n8 << 16;
        }
        if (n3 >= this.length - 1) {
            return d;
        }
        if (n == 0) {
            return d;
        }
        n5 = this.pos;
        c = '\u0000';
        if (this.a[n3] == 'e' || this.a[n3] == 'E') {
            n6 = 1;
            ++n3;
        } else if (n > 1) {
            if (n2 < 0) {
                n6 = 2;
            }
            if ((this.a[n3] == 'x' || this.a[n3] == '\u2715') && n3 <= this.length - 4) {
                if (this.a[++n3] == '1' && this.a[n3 + 1] == '0') {
                    n3 += 2;
                }
                n6 = 10;
            }
            if (this.a[n3] == '^') {
                c = '^';
                ++n3;
            } else if (!Parsing.isSign(this.a[n3]) && !Character.isDigit(this.a[n3])) {
                n6 = 0;
            }
        }
        if (n6 != 0) {
            this.pos = n3;
            this.flags |= Integer.MIN_VALUE;
            n7 = this.parseInt();
            this.flags &= Integer.MAX_VALUE;
            if (this.pos == n3) {
                n6 = 0;
            }
        }
        if (n6 == 0) {
            this.pos = n5;
        } else {
            if (n6 == 2) {
                n6 = (int)d;
                if (n6 < 0) {
                    n6 = -n6;
                    d = -1.0;
                } else {
                    d = 1.0;
                }
                while (n7 > 0) {
                    d *= (double)n6;
                    --n7;
                }
                while (n7 < 0) {
                    d /= (double)n6;
                    ++n7;
                }
                n6 = 0;
            } else {
                d *= AstroMath.dexp(n7);
            }
            this.flags |= n6 << 16;
            if (this.pos < this.length && this.a[this.pos] == c) {
                ++this.pos;
            }
        }
        return d;
    }

    public final double parseDecimal() {
        double d = this.parseValue(0);
        if ((this.flags & 0xFF00) == 0) {
            return Double.NaN;
        }
        return d;
    }

    public final double parseDouble() {
        double d = this.parseValue(1);
        if ((this.flags & 0xFF00) == 0) {
            return Double.NaN;
        }
        return d;
    }

    public final double parseFactor() {
        return this.parseValue(10);
    }

    private final double parse_sexa(int n) {
        char c;
        int n2;
        int n3;
        int n4;
        double d = 0.0;
        double d2 = 1.0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 2;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = this.pos;
        if (this.flags > 0) {
            this.flags = 0;
            this.error_message = null;
        }
        if (n > 0) {
            this.gobbleSpaces();
        }
        if (this.pos >= this.length) {
            this.pos = n11;
            return Double.NaN;
        }
        n5 = this.parseSign();
        if (n5 > 0) {
            n10 = 16;
        }
        if (n > 0) {
            while (this.pos < this.length && this.a[this.pos] == ' ') {
                ++this.pos;
            }
        }
        int n12 = n4 = n > 0 ? this.parseNum() : this.parseNum(2);
        if (this.flags == 0) {
            this.pos = n11;
            if (!this.parseNaN()) {
                this.pos = n11;
            }
            return Double.NaN;
        }
        this.flags |= n10 << 16;
        d = n4;
        int n13 = this.flags;
        if (this.pos < this.length && this.a[this.pos] == '.') {
            ++this.pos;
            n7 = 0;
            if (this.pos < this.length && Character.isDigit(this.a[this.pos])) {
                --this.pos;
                d += this.parseDecimal();
                n13 += this.flags;
            } else {
                n13 |= 1;
            }
        }
        if (n > 0 && this.pos < this.length) {
            for (n3 = 0; n3 < sexa_symb1.length; ++n3) {
                if (this.a[this.pos] != sexa_symb1[n3]) continue;
                n8 = sexa_unit1[n3];
                break;
            }
            if (n8 != 0) {
                if ((n8 & 9) != 0) {
                    d /= 60.0;
                    d2 /= 60.0;
                    ++n6;
                    if ((n8 & 8) != 0) {
                        d /= 60.0;
                        d2 /= 60.0;
                        ++n6;
                    }
                    n8 &= 0xFFFFFFF6;
                }
                ++this.pos;
            }
        }
        if (n > 1 && n6 == 0 && n7 > 0) {
            n3 = this.pos;
            while (n3 < this.length) {
                if (this.a[n3] == ':') {
                    ++n3;
                    continue;
                }
                if (this.a[n3] == ' ') {
                    ++n3;
                    continue;
                }
                if (Character.isDigit(this.a[n3]) || this.a[n3] == '.') {
                    ++n6;
                    while (n3 < this.length && Character.isDigit(this.a[n3])) {
                        ++n3;
                    }
                    if (n3 < this.length && this.a[n3] == '.') {
                        break;
                    }
                } else {
                    if (Parsing.isSign(this.a[n3]) || this.a[n3] == ',') break;
                    n2 = this.pos;
                    this.pos = n3;
                    c = this.lookup(sexa_symb1) >= 0 ? (char)'\u0001' : '\u0000';
                    this.pos = n2;
                    if (c == '\u0000') break;
                    ++n3;
                }
                if (n6 < 5) continue;
            }
            int n14 = n7 = n3 < this.length ? n6 : n6 / 2;
            if (n7 >= 3) {
                n7 = 2;
            }
            n6 = 0;
        }
        while (this.pos < this.length) {
            if (n > 0) {
                if (this.a[this.pos] == sexa_letter[n6]) {
                    ++this.pos;
                    continue;
                }
                if (this.a[this.pos] == sexa_symbol[n6]) {
                    ++this.pos;
                    n8 |= 0x10;
                    continue;
                }
                if (this.a[this.pos] == ':') {
                    ++this.pos;
                    continue;
                }
                if (this.a[this.pos] == ' ') {
                    ++this.pos;
                    continue;
                }
            }
            if (n6 >= n7 || !Character.isDigit(this.a[this.pos])) break;
            this.flags = 0;
            if (n == 0) {
                n4 = this.parseNum(2);
                n3 = this.flags & 0xFF00;
                if (n3 == 256) {
                    --this.pos;
                    break;
                }
            } else {
                n4 = this.parseNum();
                n3 = this.flags & 0xFF00;
                if (n3 == 256) {
                    n3 = 512;
                }
            }
            n13 += n3;
            if (n4 > 60) {
                n9 = 2;
                this.error_message = "component " + n4 + ">60";
            }
            ++n6;
            d += (d2 /= 60.0) * (double)n4;
        }
        if (n6 > 0 && n4 == 60 && n9 == 0) {
            n9 = 1;
            this.error_message = "";
        }
        n2 = 0;
        if (this.pos < this.length) {
            if (this.a[this.pos] == '.') {
                ++this.pos;
                n2 = 1;
            } else if (n == 0 && Character.isDigit(this.a[this.pos])) {
                n2 = 1;
                n13 |= 0x400000;
            }
        }
        if ((this.flags & 0xFF) == 0) {
            if (this.pos < this.length && n2 != 0 && Character.isDigit(this.a[this.pos])) {
                n3 = --this.pos;
                c = this.a[n3];
                this.a[n3] = 46;
                double d3 = this.parseDecimal();
                this.a[n3] = c;
                d += d2 * d3;
                if (n9 == 1 && d3 != 0.0) {
                    n9 = 2;
                    this.error_message = "component > 60" + d3;
                }
                n13 += this.flags;
            } else {
                n13 |= 1;
            }
        }
        if (n8 > 0 && this.pos < this.length) {
            if (this.a[this.pos] == sexa_letter[n6]) {
                ++this.pos;
            } else if (this.a[this.pos] == sexa_symbol[n6]) {
                ++this.pos;
            }
        }
        if (n6 == 0 && this.pos < this.length && n > 0 && Character.toLowerCase(this.a[this.pos]) == 'e') {
            ++this.pos;
            n3 = this.parseInt();
            if (this.digits() == 0) {
                --this.pos;
            } else {
                d *= AstroMath.dexp(n3);
                if ((n3 = (n13 & 0xFF) - n3) < 0) {
                    n3 = 0;
                }
                if (n3 >= 32) {
                    n3 = 31;
                }
                n13 = n13 & 0xFFFFFF00 | n3 | 0x10000;
            }
        }
        this.flags = n13;
        if (n5 < 0) {
            d = -d;
        }
        if (n9 > 0) {
            String string = n9 > 1 ? "****" : "++++";
            this.error_message = string + "parseSexa(" + String.valueOf(this.a, n11, this.pos - n11) + ")" + this.error_message;
        }
        if (n6 > 0) {
            n10 = n6 + 1 + n8;
            if ((n10 & 0x10) != 0) {
                n10 = (n10 & 0xF) + 8;
            }
            this.flags |= n10 << 16 | n9 << 24;
            if ((this.flags & 0xFF) == 0) {
                this.flags |= 1;
            }
            this.flags += n6 * 2;
        } else if (n8 > 0) {
            n10 = (n8 & 0x10) != 0 ? 13 : (n8 == 6 ? 12 : 11);
            this.flags |= n10 << 16;
        }
        return d;
    }

    public final double parseSexa() {
        return this.parse_sexa(1);
    }

    public final double parseSexa2() {
        return this.parse_sexa(2);
    }

    public final double parseIAU() {
        return this.parse_sexa(0);
    }

    public final int parseDate() {
        int n;
        int n2;
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        int n3 = 0;
        int n4 = this.pos;
        int n5 = 0;
        int n6 = 128;
        char c = '\u0000';
        int n7 = 3;
        if (this.flags > 0) {
            this.flags = 0;
        }
        this.gobbleSpaces();
        if (this.pos >= this.length) {
            this.pos = n4;
            return 0;
        }
        n5 = this.parseSign();
        if (n5 > 0) {
            n6 = 16;
        }
        for (n2 = 0; n2 < n7; ++n2) {
            if (n2 > 0) {
                char c2 = this.currentChar();
                if (c == '\u0000' && n2 == 1 && (c2 == '-' || c2 == '.' || c2 == '/')) {
                    c = c2;
                }
                if (c2 == c) {
                    ++this.pos;
                } else if (c != '\u0000') break;
            }
            this.gobbleSpaces();
            if (this.pos >= this.length) break;
            int n8 = this.pos;
            nArray[n2] = this.parseNum();
            if (n8 == this.pos) {
                if ((n3 & 2) != 0) break;
                nArray[n2] = this.lookupIgnoreCase(month_list);
                if (nArray[n2] < 0) break;
                n6 |= 0x81;
                int n9 = n2;
                nArray[n9] = nArray[n9] + 1;
                nArray2[n2] = 2;
                while (Character.isLetter(this.currentChar())) {
                    ++this.pos;
                }
            } else {
                if (n5 < 0 || this.pos - n8 >= 4) {
                    if ((n3 & 4) != 0) break;
                    nArray2[n2] = 4;
                } else if (this.pos - n8 >= 3) {
                    int n10 = nArray2[n2] = (n3 & 3) == 0 ? 1 : 4;
                    if (nArray2[n2] == 1) {
                        n7 = 2;
                    }
                }
                if (n5 < 0) {
                    nArray[n2] = -nArray[n2];
                    n5 = 0;
                }
            }
            n3 |= nArray2[n2];
        }
        if ((n = n2) < 2) {
            this.pos = n4;
            return 0;
        }
        if (n3 == 0) {
            nArray2[0] = 4;
            if (n == 2) {
                nArray2[1] = 1;
                n3 = 5;
            } else {
                nArray2[1] = 2;
                nArray2[2] = 1;
                n3 = 7;
            }
        }
        for (n2 = 0; n2 < n; ++n2) {
            if (nArray2[n2] != 0) continue;
            nArray2[n2] = (n3 & 4) == 0 ? 4 : ((n3 & 2) == 0 ? 2 : 1);
            n3 |= nArray2[n2];
        }
        n6 = n3 == 5 ? (n6 |= nArray2[0] == 4 ? 132 : 134) : (n3 == 6 ? (n6 |= nArray2[0] == 4 ? 128 : 130) : (nArray2[0] == 4 ? (n6 |= nArray2[1] == 2 ? 136 : 135) : (nArray2[0] == 1 ? (n6 |= nArray2[1] == 2 ? 138 : 133) : (n6 |= nArray2[1] == 4 ? 142 : 140))));
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            if (nArray2[n2] == 4) {
                n13 = nArray[n2];
            }
            if (nArray2[n2] == 2) {
                n12 = nArray[n2] - 1;
            }
            if (nArray2[n2] != 1) continue;
            n11 = nArray[n2];
        }
        if (n12 * 30 + n11 > 367) {
            this.pos = n4;
            return 0;
        }
        int n14 = (int)(Astrotime.YMD2JD(n13, n12, n11) - 2400000.5);
        this.flags |= n6 << 16;
        return n14;
    }

    public final double parseComplex(String string) throws ParseException {
        int n;
        int[] nArray = new int[6];
        int[] nArray2 = new int[6];
        char[] cArray = new char[6];
        boolean bl = false;
        char[] cArray2 = string.toCharArray();
        int n2 = 0;
        int n3 = string.length();
        int n4 = 0;
        double d = Double.NaN;
        int n5 = this.pos;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        char c = '\u0000';
        int n10 = 0;
        StringBuffer stringBuffer = null;
        if (this.flags > 0) {
            this.flags = 0;
            this.error_message = null;
        }
        nArray[5] = 0;
        nArray[4] = 0;
        nArray[3] = 0;
        nArray[2] = 0;
        nArray[1] = 0;
        nArray[0] = 0;
        nArray2[5] = 0;
        nArray2[4] = 0;
        nArray2[3] = 0;
        nArray2[2] = 0;
        nArray2[1] = 0;
        nArray2[0] = 0;
        cArray[5] = '\u0000';
        cArray[4] = '\u0000';
        cArray[3] = '\u0000';
        cArray[2] = '\u0000';
        cArray[1] = '\u0000';
        cArray[0] = '\u0000';
        if (cArray2[n2] == '\"') {
            ++n2;
        }
        if (this.pos < this.length && (n8 = this.parseSign()) > 0) {
            n9 = 16;
        }
        while (this.pos < this.length && n2 < n3) {
            if ((n6 = "YMDhmsymDdMS".indexOf(c = cArray2[n2++])) < 0) {
                if (c == this.a[this.pos]) {
                    ++this.pos;
                    continue;
                }
                if (c == ':') continue;
                if (c == '.' || c == 'f' || c == '\"') break;
                this.error_message = "****parseComplex((" + string + ")): what is '" + c + "'?";
                throw new ParseException(this.error_message, n2);
            }
            n6 %= 6;
            if (Character.isLetter(this.a[this.pos])) {
                n9 |= 0x81;
                n = this.lookupIgnoreCase(month_list);
                if (n6 == 4) {
                    n6 = 1;
                    n10 |= 1 << n6;
                }
                if (n6 != 1 || cArray[1] != '\u0000' || n < 0) {
                    this.error_message = "****parseComplex(" + string + "): month? " + this.toString();
                    throw new ParseException(this.error_message, n2);
                }
                nArray[1] = n;
                cArray[1] = 97;
            } else if (cArray[n6] != '\u0000') {
                n = 5 - n6;
                if (n6 > 0 && n > 0 && cArray[n] == '\u0000') {
                    nArray[n] = nArray[n6];
                    cArray[n] = cArray[n6];
                    nArray2[n] = nArray2[n6];
                    n6 = n;
                    n10 |= 1 << n6;
                }
                if (cArray[n6] != '\u0000') {
                    this.error_message = "****parseComplex((" + string + ")): " + "duplicated component '" + "YMDhmsymDdMS".charAt(n6) + "'";
                    throw new ParseException(this.error_message, n2);
                }
            }
            nArray2[n6] = n2;
            n4 = n6;
            n7 = 1;
            while (n2 < n3 && cArray2[n2] == c) {
                ++n7;
                ++n2;
            }
            if (cArray[n6] != '\u0000') continue;
            if (n7 == 1) {
                this.gobbleSpaces();
                if (this.a[this.pos] == ':') {
                    ++this.pos;
                }
                this.gobbleSpaces();
                nArray[n6] = this.parseNum();
                cArray[n6] = c;
                if (n6 != 0 || c != 'y') continue;
                bl = true;
                continue;
            }
            if (n6 == 0 && n7 == 2) {
                bl = true;
            }
            n = n7;
            while (n > 0 && this.pos < this.length) {
                if (this.a[this.pos] != ' ') {
                    if (Character.isDigit(this.a[this.pos])) {
                        nArray[n6] = nArray[n6] * 10 + Character.digit(this.a[this.pos], 10);
                    } else {
                        this.error_message = "****parseComplex(" + string + "): " + this.toString();
                        throw new ParseException(this.error_message, n2);
                    }
                }
                --n;
                ++this.pos;
            }
            cArray[n6] = c;
        }
        if (Character.toUpperCase(cArray[1]) == 'M' && cArray[4] == '\u0000' && cArray[0] == '\u0000') {
            cArray[4] = cArray[1];
            cArray[1] = '\u0000';
            nArray[4] = nArray[1];
            nArray[1] = 0;
            n10 |= 2;
        } else if (cArray[1] == '\u0000' && cArray[4] != '\u0000' && cArray[0] != '\u0000' && cArray[5] == '\u0000') {
            cArray[1] = cArray[4];
            cArray[4] = '\u0000';
            nArray[1] = nArray[4];
            nArray[4] = 0;
            n10 |= 0x10;
        }
        if (cArray[3] == '\u0000' && cArray[2] != '\u0000' && cArray[0] == '\u0000' && cArray[1] == '\u0000') {
            cArray[3] = cArray[2];
            cArray[2] = '\u0000';
            nArray[3] = nArray[2];
            nArray[2] = 0;
            n10 |= 4;
        } else if (cArray[2] == '\u0000' && cArray[0] != '\u0000') {
            cArray[2] = cArray[3];
            cArray[3] = '\u0000';
            nArray[2] = nArray[3];
            nArray[3] = 0;
            n10 |= 8;
        }
        if (n10 != 0) {
            String string2 = new String(string);
            char[] cArray3 = string2.toCharArray();
            n6 = 0;
            while (n10 != 0) {
                if (n10 & true) {
                    n = nArray2[n6] - 1;
                    char c2 = cArray3[n];
                    char c3 = Character.toUpperCase(c2);
                    if (c3 == c2) {
                        c3 = Character.toLowerCase(c2);
                    }
                    while (n < cArray3.length && cArray3[n] == c2) {
                        cArray3[n++] = c3;
                    }
                }
                n10 >>= 1;
                ++n6;
            }
            stringBuffer = new StringBuffer(100);
            stringBuffer.append("++++parseComplex(");
            stringBuffer.append(string);
            stringBuffer.append(") interpreted as (");
            stringBuffer.append(cArray3);
            stringBuffer.append(")");
        }
        if (cArray[1] != '\u0000' && cArray[1] != 'a' && nArray[1] > 0) {
            nArray[1] = nArray[1] - 1;
        }
        d = 0.0;
        double d2 = 1.0;
        double d3 = 1.0;
        if (cArray[0] != '\u0000') {
            n9 |= 0x80;
            if (cArray[2] != '\u0000') {
                n9 |= 0x84;
                if (cArray[1] != '\u0000') {
                    n9 |= 0x88;
                }
            }
            if (bl && nArray[0] < 200) {
                nArray[0] = nArray[0] + 1900;
                if (cArray[0] != 'Y' && nArray[0] < 1950) {
                    nArray[0] = nArray[0] + 100;
                }
                bl = false;
            }
            if (n8 < 0) {
                nArray[0] = -nArray[0];
                n8 = 0;
            }
            d = Astrotime.YMD2JD(nArray[0], nArray[1], nArray[2]) - 2400000.5;
            d3 = 24.0;
        } else if (cArray[2] != '\u0000') {
            if (cArray[1] != '\u0000') {
                this.error_message = "****parseComplex((" + string + ")): " + "month without year ? " + this.toString();
                throw new ParseException(this.error_message, n2);
            }
            n9 |= 0x85;
            d = nArray[2];
            d3 = 24.0;
        } else if (Character.toLowerCase(cArray[3]) == 'h') {
            n9 |= 9;
        }
        for (n = 3; n < 6; ++n) {
            if (cArray[n] != '\u0000') {
                d += (double)nArray[n] / d3;
                if (n == n4) {
                    d2 = d3;
                }
            }
            d3 *= 60.0;
        }
        if (this.pos >= this.length) {
            n2 = n3;
            c = '\u0000';
        } else if (n7 == 1 && this.a[this.pos] == '.') {
            d += this.parseValue(0) / d2;
        } else {
            while (c == 'f' && this.pos < this.length && Character.isDigit(this.a[this.pos])) {
                d += (double)Character.digit(this.a[this.pos], 10) / (d2 *= 10.0);
                c = n2 < n3 ? cArray2[n2++] : (char)'\u0000';
                ++this.pos;
            }
        }
        if (c != '\"' && c != '\u0000') {
            this.error_message = "****parseComplex(" + string + "): " + "mismatch from \"" + string.substring(n2 - 1) + "\": " + this.toString();
            throw new ParseException(this.error_message, n2);
        }
        if (stringBuffer != null) {
            this.error_message = stringBuffer.toString();
            this.flags |= 0x1000000;
        }
        this.flags |= n9 << 16;
        if (n8 < 0) {
            d = -d;
        }
        return d;
    }

    public final int decimals() {
        return (this.flags & 0xFF) - 1;
    }

    public final int digits() {
        return this.flags >> 8 & 0xFF;
    }

    public final int format() {
        return this.flags >> 16 & 0xFF;
    }

    public final String form() {
        return Astroformat.explain(this.flags >> 16 & 0xFF);
    }

    public final boolean isSexa() {
        return Parsing.isSexa(this.flags >> 16);
    }

    public final boolean isDate() {
        return Parsing.isDate(this.flags >> 16);
    }

    public final boolean isDays() {
        return Parsing.isDays(this.flags >> 16);
    }

    public final boolean isTime() {
        return Parsing.isTime(this.flags >> 16);
    }

    public final boolean isAngle() {
        return Parsing.isAngle(this.flags >> 16);
    }

    public final boolean inError() {
        return (this.flags & 0x2000000) != 0;
    }

    public final int status() {
        return this.flags >> 24;
    }

    public final String getMessage() {
        if ((this.flags & 0x3000000) == 0) {
            return null;
        }
        return this.error_message;
    }

    public int parseArray(double[] dArray, char c) {
        int n;
        for (n = 0; n < dArray.length; ++n) {
            dArray[n] = Double.NaN;
        }
        for (n = 0; n < dArray.length && this.pos < this.length; ++n) {
            int n2 = this.pos;
            this.gobbleSpaces();
            if (this.currentChar() == c) {
                if (n == 0) continue;
                this.advance(1);
                this.gobbleSpaces();
            }
            int n3 = this.pos;
            double d = this.parseDouble();
            if (this.pos == n3) {
                this.pos = n2;
                break;
            }
            dArray[n] = d;
        }
        return n;
    }

    public int parseArray(double[] dArray) {
        return this.parseArray(dArray, ' ');
    }

    public int parseWithError(double[] dArray) {
        int n;
        boolean bl = false;
        int n2 = 0;
        for (n = 0; n < dArray.length; ++n) {
            dArray[n] = Double.NaN;
        }
        int n3 = this.pos;
        this.gobbleSpaces();
        int n4 = this.pos;
        double d = this.parseDouble();
        if (this.pos == n4) {
            this.pos = n3;
            return 0;
        }
        dArray[0] = d;
        int n5 = n4;
        for (n = 1; n < dArray.length && n4 < this.length; ++n) {
            n3 = this.pos;
            n2 = this.lookup(error_symb);
            if (n2 < 0) break;
            bl |= n2 == 4;
            n4 = this.pos;
            d = this.parseDouble();
            if (this.pos == n4) {
                this.pos = n3;
                break;
            }
            if (n2 == 1 || n2 == 2) {
                dArray[n2] = d;
                continue;
            }
            dArray[n] = d;
        }
        if (bl) {
            this.gobbleSpaces();
            if (!this.match("]")) {
                n4 = n5;
                for (n = 1; n < dArray.length; ++n) {
                    dArray[n] = Double.NaN;
                }
                n = 1;
            }
        }
        return n;
    }

    public final String toString() {
        return new String(this.a, this.pos, this.length - this.pos);
    }

    public final String toString(int n) {
        if (n + this.pos > this.length) {
            n = this.length - this.pos;
        }
        return new String(this.a, this.pos, n);
    }
}

