/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.AstroMath;
import cds.astro.Astroframe;
import cds.astro.Coo;
import cds.astro.Qbox;
import cds.astro.Region;

public class ZonalRegion
extends Region {
    Astroframe frame;
    double lon0;
    double lon1;
    double dlon;
    double lat0;
    double lat1;
    double[][] R;
    double zmin;
    double zmax;
    double smax;
    double xmin;
    double ymax;
    double tmax;

    private void set_zone(double d, double d2, double d3, double d4) {
        int n;
        if (DEBUG) {
            System.out.println("#...new Zone(" + d + ".." + d2 + ", " + d3 + ".." + d4 + ")[" + this.frame + "]");
        }
        this.lon0 = d;
        this.lon1 = d2;
        if (d3 > d4) {
            this.lat0 = d4;
            this.lat1 = d3;
        } else {
            this.lat0 = d3;
            this.lat1 = d4;
        }
        double d5 = 0.5 * (d3 + d4);
        double d6 = 0.5 * (d + d2);
        if (d > d2) {
            d6 += 180.0;
        }
        this.centroid = new Coo(d6, d5);
        Coo[] cooArray = new Coo[4];
        this.minrad = 180.0;
        this.maxrad = 0.0;
        cooArray[0] = new Coo(d, d3);
        cooArray[1] = new Coo(d, d4);
        cooArray[2] = new Coo(d6, d3);
        cooArray[3] = new Coo(d6, d4);
        double d7 = this.centroid.distc(cooArray[0], cooArray[1]);
        if (d7 < this.minrad) {
            this.minrad = d7;
        }
        if (d7 > this.maxrad) {
            this.maxrad = d7;
        }
        for (n = 0; n < 4; ++n) {
            d7 = this.centroid.distance(cooArray[n]);
            if (d7 < this.minrad) {
                this.minrad = d7;
            }
            if (!(d7 > this.maxrad)) continue;
            this.maxrad = d7;
        }
        if (DEBUG) {
            System.out.println("#   min/max radius = " + this.minrad + "/" + this.maxrad);
        }
        cooArray[0] = new Coo(d6, 0.0);
        cooArray[1] = new Coo(d6 + 90.0, 0.0);
        cooArray[2] = new Coo(0.0, 90.0);
        if (this.frame != null) {
            for (n = 0; n < 3; ++n) {
                this.frame.toICRS(cooArray[n]);
            }
            this.frame.toICRS(this.centroid);
        }
        this.R = new double[3][3];
        for (n = 0; n < 3; ++n) {
            this.R[n][0] = cooArray[n].x;
            this.R[n][1] = cooArray[n].y;
            this.R[n][2] = cooArray[n].z;
        }
        this.dlon = d2 - d;
        if (this.dlon < 0.0) {
            this.dlon += 360.0;
        }
        if (this.dlon > 360.0) {
            System.err.println("#+++Zone(lon=" + d + "," + d2 + ") lon.range reduced to +/-180deg");
            this.dlon = 360.0;
        }
        this.dlon /= 2.0;
        this.xmin = AstroMath.cosd(this.dlon);
        this.ymax = AstroMath.sind(this.dlon);
        this.tmax = AstroMath.tand(this.dlon / 2.0);
        this.zmin = AstroMath.sind(d3);
        this.zmax = AstroMath.sind(d4);
        this.smax = Math.abs(this.zmin);
        double d8 = Math.abs(this.zmax);
        if (d8 > this.smax) {
            this.smax = d8;
        }
        this.smax = 1.0 / Math.sqrt(1.0 - this.smax * this.smax);
        if (DEBUG) {
            System.out.println(Coo.toString("Rotation matrix ", this.R));
            System.out.println("    xmin=" + this.xmin + ", ymax=" + this.ymax + ", tmax=" + this.tmax + "\n    smax=" + this.smax);
        }
    }

    ZonalRegion(Astroframe astroframe, double d, double d2, double d3, double d4) {
        this.frame = astroframe;
        this.set_zone(d, d2, d3, d4);
    }

    ZonalRegion(double d, double d2, double d3, double d4) {
        this.frame = null;
        this.set_zone(d, d2, d3, d4);
    }

    ZonalRegion(Astroframe astroframe, Coo coo, double d, double d2) {
        if (d > 360.0 || d2 > 180.0) {
            System.err.println("#+++Zone(" + coo + ", dim=" + d + "/" + d2 + "): too large width/height!");
            if (d > 360.0) {
                d = 360.0;
            }
            if (d2 > 180.0) {
                d2 = 180.0;
            }
        }
        this.frame = astroframe;
        double d3 = d / 2.0;
        double d4 = d2 / 2.0;
        double d5 = coo.getLon();
        double d6 = coo.getLat();
        this.set_zone(d5 - d3, d5 + d3, d6 - d4, d6 + d4);
    }

    ZonalRegion(Coo coo, double d, double d2) {
        this(null, coo, d, d2);
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.R == null) {
            stringBuffer.append("*INVALID*");
        }
        stringBuffer.append("Zone");
        if (this.frame != null) {
            stringBuffer.append("[" + this.frame + "]");
        }
        stringBuffer.append("(" + this.centroid + ", " + 2.0 * this.dlon + "x" + (this.lat1 - this.lat0) + ")");
        return stringBuffer.toString();
    }

    public final double area() {
        if (this.centroid == null) {
            return Double.NaN;
        }
        return 57.29577951308232 * (this.zmax - this.zmin) * 2.0 * this.dlon;
    }

    public boolean checkCoo(Coo coo) {
        if (this.R == null) {
            return false;
        }
        if (DEBUG) {
            System.out.println("#...Zone.checkCoo(" + coo + ")");
        }
        double[] dArray = new double[]{coo.x, coo.y, coo.z};
        Coo.rotateVector(this.R, dArray);
        if (dArray[2] >= this.zmin && dArray[2] <= this.zmax) {
            if (dArray[0] >= this.xmin) {
                return true;
            }
            double d = dArray[0] * dArray[0] + dArray[1] * dArray[1];
            if (this.xmin > 0.707) {
                return dArray[1] * dArray[1] <= this.ymax * this.ymax * d;
            }
            return dArray[0] >= this.xmin * Math.sqrt(d);
        }
        return false;
    }

    private boolean intersects(double[] dArray, double[] dArray2) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        int n;
        double d7 = Coo.dotprod(dArray, dArray2);
        double[] dArray3 = new double[3];
        Coo.vecprod(dArray, dArray2, dArray3);
        for (n = 0; n < 2; ++n) {
            Object object;
            d6 = n == 0 ? this.zmin : this.zmax;
            d5 = Math.sqrt(1.0 - d6 * d6);
            d4 = d5 * dArray3[0];
            d3 = d5 * dArray3[1];
            double d8 = d6 * dArray3[2];
            double d9 = d4 * d4 + d3 * d3 - d8 * d8;
            if (DEBUG) {
                object = new Coo(dArray[0], dArray[1], dArray[2]);
                Coo coo = new Coo(dArray2[0], dArray2[1], dArray2[2]);
                System.out.println("#...inter(z=" + d6 + ") " + object + "->" + coo + " : " + (d9 >= 0.0));
            }
            if (d9 < 0.0) continue;
            if (this.dlon >= 180.0) {
                return true;
            }
            object = new double[2];
            int n2 = 1;
            double d10 = d8 - d4;
            if (d10 == 0.0) {
                object[0] = d4 / d3;
            } else {
                d9 = Math.sqrt(d9);
                object[0] = (-d3 - d9) / d10;
                object[1] = (-d3 + d9) / d10;
                n2 = 2;
            }
            if (DEBUG) {
                System.out.println("#      tmax=" + this.tmax + ": " + n2 + "solutions: " + object[0] + "," + object[1]);
            }
            while (--n2 >= 0) {
                if (Math.abs(object[n2]) > this.tmax || !((d2 = d5 * (1.0 - object[n2] * object[n2]) / (d10 = 1.0 + object[n2] * object[n2])) * dArray[0] + (d = d5 * (2.0 * object[n2]) / d10) * dArray[1] + d6 * dArray[2] >= d7) || !(d2 * dArray2[0] + d * dArray2[1] + d6 * dArray2[2] >= d7)) continue;
                return true;
            }
        }
        if (this.dlon >= 180.0) {
            return false;
        }
        d4 = -this.xmin * dArray3[0] / dArray3[2];
        d3 = -this.ymax * dArray3[1] / dArray3[2];
        if (DEBUG) {
            Coo coo = new Coo(dArray[0], dArray[1], dArray[2]);
            Coo coo2 = new Coo(dArray2[0], dArray2[1], dArray2[2]);
            System.out.println("#...solutions(lon) in " + coo + " -> " + coo2 + " tanb=" + (d4 + d3) + "," + (d4 - d3));
        }
        for (n = 0; n < 2; ++n) {
            double d11 = n == 0 ? d4 + d3 : d4 - d3;
            d6 = d11 * (d5 = 1.0 / Math.sqrt(1.0 + d11 * d11));
            if (!(d6 >= this.zmin) || !(d6 <= this.zmax)) continue;
            d2 = d5 * this.xmin;
            d = d5 * this.ymax;
            if (n > 0) {
                d = -d;
            }
            if (!(d2 * dArray[0] + d * dArray[1] + d6 * dArray[2] >= d7) || !(d2 * dArray2[0] + d * dArray2[1] + d6 * dArray2[2] >= d7)) continue;
            return true;
        }
        return false;
    }

    int iCircle(Coo coo, double d, boolean bl) {
        if (this.R == null) {
            return 0;
        }
        Coo coo2 = new Coo(coo);
        if (DEBUG) {
            String string = bl ? "[deep]" : "[light]";
            System.out.println("#...Zone.checkCircle(" + coo2 + ", r=" + d + ")" + string);
        }
        coo2.rotate(this.R);
        double d2 = coo2.getLat();
        if (d2 - d > this.lat1) {
            return 0;
        }
        if (d2 + d < this.lat0) {
            return 0;
        }
        if (this.dlon >= 180.0) {
            return d2 + d <= this.lat1 && d2 - d >= this.lat0 ? -1 : 1;
        }
        double d3 = coo2.getLon();
        if (d3 > 180.0) {
            d3 -= 360.0;
        }
        if ((d3 = Math.abs(d3)) > this.dlon + d * this.smax) {
            return 0;
        }
        if (!bl) {
            return 1;
        }
        int n = 0;
        Coo coo3 = new Coo();
        double d4 = 2.0 * AstroMath.sind(d / 2.0);
        d4 *= d4;
        coo3.set(this.lat0, -d3);
        if (coo2.dist2(coo3) <= d4) {
            ++n;
        }
        coo3.set(coo3.x, -coo3.y, coo3.z);
        if (coo2.dist2(coo3) <= d4) {
            ++n;
        }
        coo3.set(this.lat1, -d3);
        if (coo2.dist2(coo3) <= d4) {
            ++n;
        }
        coo3.set(coo3.x, -coo3.y, coo3.z);
        if (coo2.dist2(coo3) <= d4) {
            ++n;
        }
        if (DEBUG) {
            System.out.println("#...circle(" + coo2 + ") nin=" + n);
        }
        if (n == 4) {
            return 3;
        }
        if (n != 0) {
            return 1;
        }
        double d5 = 1.0 - d4 / 2.0;
        double d6 = coo2.z / d5;
        if (Math.abs(d6) >= 1.0) {
            return 1;
        }
        double d7 = d5 * Math.sqrt((1.0 - d6 * d6) / (coo2.x * coo2.x + coo2.y * coo2.y));
        double d8 = 90.0 - AstroMath.asind(d7);
        if (d3 > this.dlon + d8) {
            return 0;
        }
        return coo2.z <= this.zmax && coo2.z >= this.zmin && d3 < this.dlon ? -1 : 1;
    }

    public int checkCircle(Coo coo, double d) {
        return this.iCircle(coo, d, true);
    }

    public int checkQbox(int n) {
        Coo coo;
        if (this.centroid == null) {
            return 0;
        }
        Qbox qbox = new Qbox();
        qbox.set(n);
        int n2 = this.iCircle(qbox.center(), Qbox.maxRadius(n), false);
        if (DEBUG) {
            System.out.println("#...................=" + n2);
        }
        if (n2 < 1) {
            return n2;
        }
        double[][] dArray = new double[5][3];
        Qbox.ucorners(qbox.qbox, dArray);
        int n3 = 0;
        for (n2 = 0; n2 < 4; ++n2) {
            Coo.rotateVector(this.R, dArray[n2]);
            if (DEBUG) {
                coo = new Coo(dArray[n2][0], dArray[n2][1], dArray[n2][2]);
                System.out.print("#   Corner#" + n2 + " = " + coo);
                coo.rotate_1(this.R);
                System.out.println(" (" + coo + ")");
            }
            if (!(dArray[n2][2] >= this.zmin) || !(dArray[n2][2] <= this.zmax)) continue;
            if (dArray[n2][0] >= this.xmin) {
                ++n3;
                continue;
            }
            double d = Math.sqrt(dArray[n2][0] * dArray[n2][0] + dArray[n2][1] * dArray[n2][1]);
            if (!(dArray[n2][0] >= this.xmin * d)) continue;
            ++n3;
        }
        if (DEBUG) {
            System.out.println("#..." + qbox + qbox.center() + " (xmin=" + this.xmin + "): inside=" + n3);
        }
        if (n3 > 0 && n3 < 4) {
            return 1;
        }
        dArray[4][0] = dArray[0][0];
        dArray[4][1] = dArray[0][1];
        dArray[4][2] = dArray[0][2];
        for (n2 = 0; n2 < 4; ++n2) {
            if (DEBUG) {
                coo = new Coo(dArray[n2][0], dArray[n2][1], dArray[n2][2]);
                Coo coo2 = new Coo(dArray[n2 + 1][0], dArray[n2 + 1][1], dArray[n2 + 1][2]);
                System.out.println("#...intersection " + coo + " -> " + coo2 + " = " + this.intersects(dArray[n2], dArray[n2 + 1]));
            }
            if (!this.intersects(dArray[n2], dArray[n2 + 1])) continue;
            return 1;
        }
        if (n3 == 4) {
            return -1;
        }
        if (DEBUG) {
            System.out.println("#...DISJOINT/IS_PARTOF: " + (qbox.inside(this.centroid) ? 3 : 0));
        }
        return qbox.inside(this.centroid) ? 3 : 0;
    }
}

