/*
 * Decompiled with CFR 0.152.
 */
package cds.fits;

import cds.aladin.Aladin;
import cds.allsky.Context;
import cds.fits.Fits;
import cds.tools.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;

public class CacheFits {
    private static final long DEFAULT_MAXMEM = 0x20000000L;
    private long maxMem;
    private int nextId;
    private boolean cacheOutOfMem;
    protected Hashtable<String, FitsFile> map;
    Context context;
    private Hashtable<String, double[]> cutCache = new Hashtable();
    private Hashtable<String, double[]> shapeCache = new Hashtable();
    protected int statNbOpen;
    protected int statNbFind;
    protected int statNbFree;
    protected static final Object lockObj = new Object();
    public static final int FITS = 0;
    public static final int JPEG = 1;
    public static final int PNG = 2;
    public static final int HHH = 4;
    private boolean firstChangeOrig = true;
    private static final int WIDTHAUTOCUT = 1024;
    private boolean first = true;
    static double obscale = -1.0;
    static long lastTimeMem = 0L;
    static long lastMem = 0L;

    public CacheFits() {
        this(0x20000000L);
    }

    public CacheFits(long l) {
        this.maxMem = l;
        this.cacheOutOfMem = l == 0L;
        this.nextId = 0;
        this.statNbFind = 0;
        this.statNbOpen = 0;
        this.statNbFree = 0;
        this.map = new Hashtable(20000);
    }

    public Fits getFits(String string) throws Exception {
        return this.getFits(string, 0, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Fits getFits(String string, int n, boolean bl, boolean bl2) throws Exception {
        if (this.cacheOutOfMem) {
            return this.open((String)string, (int)n, (boolean)bl, (boolean)bl2).fits;
        }
        Object object = lockObj;
        synchronized (object) {
            FitsFile fitsFile = this.find(string);
            if (fitsFile != null) {
                fitsFile.update();
                ++this.statNbFind;
            } else {
                if (this.isOver()) {
                    this.clean();
                }
                try {
                    fitsFile = this.add(string, n, bl, bl2);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    System.err.println("CacheFits.getFits(" + string + ") out of memory... clean and try again...");
                    this.maxMem = this.maxMem < 0L ? (this.maxMem *= 2L) : (this.maxMem /= 2L);
                    try {
                        this.clean();
                        fitsFile = this.add(string, n, bl, bl2);
                    }
                    catch (OutOfMemoryError outOfMemoryError2) {
                        System.err.println("CacheFits.getFits(" + string + ") out of memory... double error... removing the cache...");
                        outOfMemoryError2.printStackTrace();
                        this.reset();
                        this.cacheOutOfMem = true;
                        return this.open((String)string, (int)n, (boolean)bl, (boolean)bl2).fits;
                    }
                }
                ++this.statNbOpen;
            }
            return fitsFile.fits;
        }
    }

    protected FitsFile find(String string) {
        return this.map.get(string);
    }

    private FitsFile add(String string, int n, boolean bl, boolean bl2) throws Exception {
        FitsFile fitsFile = this.open(string, n, bl, bl2);
        this.map.put(string, fitsFile);
        return fitsFile;
    }

    protected void remove(String string) throws Exception {
        this.map.remove(string);
    }

    private FitsFile open(String string, int n, boolean bl, boolean bl2) throws Exception {
        int n2;
        boolean bl3 = false;
        String string2 = string;
        int n3 = string2.length() - 1;
        if (string2.charAt(n3) == ']' && (n2 = string2.lastIndexOf(91, n3)) > 0) {
            string2 = string2.substring(0, n2);
        }
        if (!new File(string2).exists()) {
            throw new FileNotFoundException();
        }
        FitsFile fitsFile = new FitsFile();
        fitsFile.fits = new Fits();
        if (this.context != null && this.context.skyvalName != null) {
            bl = true;
            fitsFile.fits.setReleasable(false);
        }
        if ((n & 4) != 0) {
            fitsFile.fits.loadHeaderFITS(string);
            String string3 = string.replaceAll("\\.hhh", ".png");
            String string4 = string.replaceAll("\\.hhh", ".jpg");
            if ((n & 3) == 0) {
                String string5 = string4;
                String string6 = string3;
                int n4 = string4.indexOf(".jpg[");
                if (n4 > 0) {
                    string5 = string4.substring(0, n4 + 4);
                }
                if ((n4 = string3.indexOf(".png[")) > 0) {
                    string6 = string3.substring(0, n4 + 4);
                }
                if (new File(string5).exists()) {
                    n |= 1;
                } else if (new File(string6).exists()) {
                    n |= 2;
                }
            }
            if ((n & 2) != 0) {
                string = string3;
            } else if ((n & 1) != 0) {
                string = string4;
            } else {
                throw new Exception(".hhh file without associated .jpg or .png file");
            }
        }
        if ((n & 3) != 0) {
            int n5 = (n & 2) != 0 ? 2 : ((n & 1) != 0 ? 1 : 0);
            fitsFile.fits.loadPreview(string, true, (n & 4) == 0, n5);
        } else {
            fitsFile.fits.loadFITS(string, false, bl);
            if (this.context != null) {
                boolean bl4 = bl3 = fitsFile.fits.bzero != this.context.bZeroOrig || fitsFile.fits.bscale != this.context.bScaleOrig;
                if (bl3 && this.firstChangeOrig) {
                    this.context.warning("All original data sets do no used the same BZERO & BSCALE factors => rescaling will be applied => " + string);
                    this.firstChangeOrig = false;
                }
                if (this.context.isCube()) {
                    int n6 = 1;
                    try {
                        n6 = fitsFile.fits.headerFits.getIntFromHeader("NAXIS3");
                        if (n6 != this.context.depth) {
                            throw new Exception();
                        }
                    }
                    catch (Exception exception) {
                        throw new Exception("Uncompatible cube depth (" + n6 + ") => file ignored [" + fitsFile.fits.getFilename() + "]");
                    }
                    if (this.context.isCubeCanal()) {
                        try {
                            double d = fitsFile.fits.headerFits.getDoubleFromHeader("CRPIX3");
                            double d2 = fitsFile.fits.headerFits.getDoubleFromHeader("CRVAL3");
                            double d3 = fitsFile.fits.headerFits.getDoubleFromHeader("CDELT3");
                            if (this.context.crpix3 != d || this.context.crval3 != d2 || this.context.cdelt3 != d3) {
                                throw new Exception();
                            }
                        }
                        catch (Exception exception) {
                            this.context.warning("All original data sets do no used the same CRPIX3,CRVAL3 & CDELT3 factors => factors ignored");
                            this.context.cdelt3 = 0.0;
                            this.context.crval3 = 0.0;
                            this.context.crpix3 = 0.0;
                            this.context.bunit3 = null;
                        }
                    }
                }
            }
        }
        if (this.context != null && (this.context.skyvalName != null || this.context.expTimeName != null || this.context.pixelGood != null || bl3 || this.context.dataArea != 0)) {
            this.delSkyval(fitsFile.fits, bl3);
        }
        if (!bl2) {
            fitsFile.fits.freeHeader();
        }
        return fitsFile;
    }

    protected boolean isOver() {
        if (this.maxMem < 0L) {
            return this.getFreeMem() < -this.maxMem;
        }
        return this.getMem() > this.maxMem;
    }

    public long getMem() {
        long l = 0L;
        if (this.map == null) {
            return l;
        }
        Enumeration<String> enumeration = this.map.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            FitsFile fitsFile = this.map.get(string);
            l += fitsFile.fits.getMem();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceClean() {
        Object object = lockObj;
        synchronized (object) {
            this.clean();
        }
    }

    protected void clean() {
        Object object;
        int n;
        long l = this.getMem();
        long l2 = 0L;
        long l3 = 0L;
        int n2 = 0;
        long l4 = this.getFreeMem();
        boolean bl = true;
        long l5 = System.currentTimeMillis();
        long l6 = 5000L;
        block2: for (n = 0; n < 3 && bl; ++n) {
            Enumeration<String> enumeration = this.map.keys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                object = this.map.get(string);
                if (((FitsFile)object).fits.hasUsers() || n == 0 && l5 - ((FitsFile)object).timeAccess < l6) continue;
                l3 = ((FitsFile)object).getMem();
                l2 += l3;
                ++n2;
                ++this.statNbFree;
                try {
                    this.remove(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (l2 <= l / 2L || this.map.size() >= 10000) continue;
                bl = false;
                continue block2;
            }
        }
        this.gc();
        long l7 = System.currentTimeMillis() - l5;
        object = n > 1 ? "s" : "";
        long l8 = this.getFreeMem();
        if (this.context != null) {
            this.context.stat("Cache: freeRAM=" + Util.getUnitDisk(l4) + " => " + n2 + " files removed (" + Util.getUnitDisk(l2) + ") in " + n + " step" + (String)object + " in " + Util.getTemps(l7) + " => freeRAM=" + Util.getUnitDisk(l8));
        }
    }

    public void reset() {
        this.statNbFree += this.map.size();
        Enumeration<String> enumeration = this.map.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            try {
                this.remove(string);
            }
            catch (Exception exception) {}
        }
        this.gc();
    }

    public void close() {
        this.reset();
    }

    public void setContext(Context context) {
        this.context = context;
    }

    private double[] findAutocutRange(Fits fits, double d, double d2) throws Exception {
        String string = fits.getFilename() + fits.getMefSuffix();
        double[] dArray = this.cutCache.get(string);
        if (dArray != null) {
            return dArray;
        }
        Object[] objectArray = new Cut[5];
        Fits fits2 = new Fits();
        fits2.loadHeaderFITS(string);
        int n = fits2.width;
        int n2 = fits2.height;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        try {
            int n9 = fits2.width > 1024 ? 1024 : fits2.width;
            int n10 = fits2.height > 1024 ? 1024 : fits2.height;
            int n11 = fits2.depth > 10 ? 10 : fits2.depth;
            int n12 = fits.width / 2 - n9 / 2;
            int n13 = fits.height / 2 - n10 / 2;
            int n14 = fits.depth / 3 - n11 / 3;
            n8 = n12;
            n7 = n13;
            n6 = n14;
            n5 = n9;
            n4 = n10;
            n3 = n11;
            fits2.loadFITS(fits.getFilename(), fits.ext, n12, n13, n14, n9, n10, n11);
            if (this.context.hasAlternateBlank()) {
                fits2.setBlank(this.context.getBlankOrig());
            }
            dArray = fits2.findAutocutRange(d, d2);
            if (n > 3072 && n2 > 3072) {
                int n15;
                int n16 = (n - 2048) / 3;
                int n17 = (n2 - 2048) / 3;
                for (n15 = 0; n15 < 4; ++n15) {
                    n12 = n15 == 0 || n15 == 2 ? n16 : n - 1024 - n16;
                    n13 = n15 < 2 ? n17 : n2 - 1024 - n17;
                    fits2.loadFITS(fits.getFilename(), fits.ext, n12, n13, n14, n9, n10, n11);
                    objectArray[n15] = new Cut();
                    ((Cut)objectArray[n15]).cut = fits2.findAutocutRange(d, d2);
                }
                objectArray[4] = new Cut();
                objectArray[4].cut = new double[dArray.length];
                for (n15 = 0; n15 < dArray.length; ++n15) {
                    ((Cut)objectArray[4]).cut[n15] = dArray[n15];
                }
                Arrays.sort(objectArray);
                for (n15 = 0; n15 < dArray.length; ++n15) {
                    dArray[n15] = ((Cut)objectArray[2]).cut[n15];
                }
            }
        }
        catch (Exception exception) {
            System.err.println("findAutocutRange exception: on " + string + " width=" + n + " height=" + n2 + " box=" + n8 + "," + n7 + "," + n6 + " " + n5 + "x" + n4 + "x" + n3);
            exception.printStackTrace();
            throw exception;
        }
        this.cutCache.put(string, dArray);
        return dArray;
    }

    private String ip(double d, double d2, double d3) {
        return Util.myRound(d) + (d2 != 0.0 || d3 != 1.0 ? "/" + Util.myRound(d * d3 + d2) : "");
    }

    private double[] findDataArea(Fits fits) throws Exception {
        String string = fits.getFilename() + fits.getMefSuffix();
        double[] dArray = this.shapeCache.get(string);
        if (dArray != null) {
            return dArray;
        }
        Fits fits2 = new Fits();
        fits2.loadFITS(string);
        if (this.context.hasAlternateBlank()) {
            fits2.setBlank(this.context.getBlankOrig());
        }
        dArray = fits2.findData();
        this.shapeCache.put(string, dArray);
        return dArray;
    }

    private void delSkyval(Fits fits, boolean bl) {
        double d = 0.0;
        double d2 = 1.0;
        boolean bl2 = false;
        boolean bl3 = false;
        double[] dArray = null;
        double d3 = 0.0;
        boolean bl4 = true;
        double d4 = this.context.pourcentMin;
        double d5 = this.context.pourcentMax;
        if (this.context.skyvalName != null) {
            try {
                block31: {
                    double[] dArray2;
                    double[] dArray3;
                    if (this.context.skyvalName.equalsIgnoreCase("true")) {
                        dArray3 = this.findAutocutRange(fits, d4, d5);
                        dArray2 = this.context.getCutOrig();
                        d = dArray3[0] - dArray2[0];
                    } else {
                        try {
                            d = fits.headerFits.getDoubleFromHeader(this.context.skyvalName);
                            d = (d - this.context.bZeroOrig) / this.context.bScaleOrig;
                            dArray3 = this.context.getCutOrig();
                            d -= dArray3[0];
                            bl4 = false;
                        }
                        catch (Exception exception) {
                            dArray2 = this.findAutocutRange(fits, d4, d5);
                            double[] dArray4 = this.context.getCutOrig();
                            d = dArray2[0] - dArray4[0];
                            if (!this.first) break block31;
                            this.context.warning("\nSKYVAL=" + this.context.skyvalName + " not found is some images => use an estimation for these images");
                            this.first = false;
                        }
                    }
                }
                bl2 = d != 0.0;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.context.dataArea != 0) {
            try {
                dArray = this.findDataArea(fits);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.context.expTimeName != null) {
            try {
                d2 = fits.headerFits.getDoubleFromHeader(this.context.expTimeName);
                bl3 = d2 != 1.0;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (!(bl2 || bl3 || bl || this.context.pixelGood != null || dArray != null)) {
            return;
        }
        Aladin.trace(4, "SkyVal=" + d + (bl4 ? "( estimation)" : "( from header)") + " => " + fits.getFileNameExtended());
        double d6 = this.context.hasAlternateBlank() ? this.context.getBlankOrig() : fits.blank;
        double d7 = 0.0;
        double d8 = 0.0;
        if (dArray != null) {
            if (this.context.dataArea == 1) {
                d7 = dArray[2] - (double)this.context.borderSize[0] - (double)this.context.borderSize[2];
                d7 *= d7;
                d8 = dArray[3] - (double)this.context.borderSize[1] - (double)this.context.borderSize[3];
                d8 *= d8;
            } else {
                d7 = (dArray[2] - (double)this.context.borderSize[0] - (double)this.context.borderSize[2]) / 2.0;
                d8 = (dArray[3] - (double)this.context.borderSize[1] - (double)this.context.borderSize[3]) / 2.0;
            }
        }
        for (int i = 0; i < fits.depthCell; ++i) {
            for (int j = 0; j < fits.heightCell; ++j) {
                for (int k = 0; k < fits.widthCell; ++k) {
                    double d9 = fits.getPixelDouble(k + fits.xCell, j + fits.yCell, i + fits.zCell);
                    if (Double.isNaN(d9)) continue;
                    if (this.context.good != null && (d9 < this.context.good[0] || this.context.good[1] < d9)) {
                        if (fits.bitpix < 0) {
                            fits.setPixelDouble(k + fits.xCell, j + fits.yCell, i + fits.zCell, d6);
                            continue;
                        }
                        fits.setPixelInt(k + fits.xCell, j + fits.yCell, i + fits.zCell, (int)d6);
                        continue;
                    }
                    if (dArray != null) {
                        boolean bl5;
                        double d10 = (double)(k + fits.xCell) - dArray[0];
                        double d11 = (double)(j + fits.yCell) - dArray[1];
                        if (this.context.dataArea == 1) {
                            bl5 = d10 * d10 / d7 + d11 * d11 / d8 >= 1.0;
                        } else {
                            boolean bl6 = bl5 = Math.abs(d10) >= d7 || Math.abs(d11) >= d8;
                        }
                        if (bl5) {
                            if (fits.bitpix < 0) {
                                fits.setPixelDouble(k + fits.xCell, j + fits.yCell, i + fits.zCell, d6);
                                continue;
                            }
                            fits.setPixelInt(k + fits.xCell, j + fits.yCell, i + fits.zCell, (int)d6);
                            continue;
                        }
                    }
                    if (!this.context.hasAlternateBlank() ? fits.isBlankPixel(d9) : d9 == this.context.getBlankOrig()) continue;
                    if (bl2) {
                        d9 -= d;
                    }
                    if (bl3) {
                        d9 /= d2;
                    }
                    if (bl) {
                        d9 = d9 * fits.bscale + fits.bzero;
                        d9 = (d9 - this.context.bZeroOrig) / this.context.bScaleOrig;
                    }
                    if (fits.bitpix < 0) {
                        fits.setPixelDouble(k + fits.xCell, j + fits.yCell, i + fits.zCell, d9);
                        continue;
                    }
                    fits.setPixelInt(k + fits.xCell, j + fits.yCell, i + fits.zCell, (int)(d9 + 0.5));
                }
            }
        }
    }

    public int getStatNbOpen() {
        return this.statNbOpen;
    }

    public int getStatNbFind() {
        return this.statNbFind;
    }

    public int getStatNbFree() {
        return this.statNbFree;
    }

    public String toString() {
        int n = this.map.size();
        String string = n > 1 ? "s" : "";
        return "Cache: " + n + " cell" + string + " using " + Util.getUnitDisk(this.getMem()) + (this.maxMem > 0L ? "/" + Util.getUnitDisk(this.maxMem) : "[" + Util.getUnitDisk(this.maxMem) + "]") + " freeRAM=" + Util.getUnitDisk(this.getFreeMem()) + " (open=" + this.statNbOpen + " find=" + this.statNbFind + " remove=" + this.statNbFree + ")";
    }

    public long getFreeMem() {
        lastMem = Runtime.getRuntime().maxMemory() - (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
        return lastMem;
    }

    public void gc() {
        System.gc();
        Util.pause(100);
    }

    class ValueComparator
    implements Comparator {
        Map base;

        public ValueComparator(Map map) {
            this.base = map;
        }

        public int compare(Object object, Object object2) {
            FitsFile fitsFile = (FitsFile)this.base.get(object);
            FitsFile fitsFile2 = (FitsFile)this.base.get(object2);
            if (fitsFile == null) {
                return 1;
            }
            if (fitsFile2 == null) {
                return -1;
            }
            int n = (int)(fitsFile2.timeAccess + (long)fitsFile2.id - fitsFile.timeAccess);
            if (n == 0) {
                return fitsFile2.id - fitsFile.id;
            }
            return n;
        }
    }

    protected class FitsFile {
        public Fits fits;
        long timeAccess = System.currentTimeMillis();
        private int id;

        public FitsFile() {
            this.id = CacheFits.this.nextId++;
        }

        public long getMem() {
            if (this.fits == null) {
                return 0L;
            }
            return this.fits.getMem();
        }

        void update() {
            this.timeAccess = System.currentTimeMillis();
        }

        public String toString() {
            long l = System.currentTimeMillis();
            return "[" + this.id + "] age=" + (l - this.timeAccess) + " => " + this.fits.getFileNameExtended();
        }
    }

    class Cut
    implements Comparable<Cut> {
        double[] cut;

        Cut() {
        }

        @Override
        public int compareTo(Cut cut) {
            return cut.cut[0] < this.cut[0] ? -1 : (cut.cut[0] > this.cut[0] ? 1 : 0);
        }
    }
}

