/*
 * Decompiled with CFR 0.152.
 */
package cds.fits;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.Coord;
import cds.aladin.MyInputStream;
import cds.fits.HeaderFits;
import cds.image.Hdecomp;
import cds.tools.Util;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.ImageConsumer;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.GZIPOutputStream;
import javax.imageio.IIOImage;
import javax.imageio.IIOParam;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public final class Fits {
    public static final int PREVIEW_UNKOWN = 0;
    public static final int PREVIEW_JPEG = 1;
    public static final int PREVIEW_PNG = 2;
    public static final int PIX_ARGB = 0;
    public static final int PIX_RGB = 1;
    public static final int PIX_TRUE = 2;
    public static final int PIX_256 = 3;
    public static final int PIX_255 = 4;
    protected int pixMode;
    public static final double DEFAULT_BLANK = Double.NaN;
    public static final double DEFAULT_BSCALE = 1.0;
    public static final double DEFAULT_BZERO = 0.0;
    public HeaderFits headerFits;
    public HeaderFits headerFits0;
    public byte[] pixels;
    public int bitpix;
    public int width;
    public int height;
    public int depth = 1;
    public double bzero = 0.0;
    public double bscale = 1.0;
    public double blank = Double.NaN;
    public long bitmapOffset = -1L;
    public int xCell;
    public int yCell;
    public int zCell;
    public int widthCell;
    public int heightCell;
    public int depthCell;
    public int ext;
    public int[] rgb;
    public Calib calib;
    public static String FS = System.getProperty("file.separator");
    private boolean skipHDU0 = true;
    public static final int GZIP = 1;
    public static final int HHH = 2;
    public static final int COLOR = 4;
    public static final int XFITS = 8;
    public static final int HDU0SKIP = 16;
    private Vector extHeader = null;
    private Vector extPixels = null;
    private static Toolkit kit = null;
    private static Object lockKit = new Object();
    public static final boolean JPEGORDERCALIB = false;
    public static final boolean JPEGFROMTOP = false;
    public static final boolean RGBASFITS = true;
    private RandomAccessFile fDirectAccess = null;
    private static final double POURCENT_MIN = 0.003;
    private static final double POURCENT_MAX = 0.9995;
    private int users = 0;
    private boolean bitmapReleaseDone = false;
    private boolean releasable = true;
    private static int FINDMINMAXSIZE = 1500;
    private static int FINDMINMAXDEPTH = 100;
    private Coord cTmp = new Coord();
    public String filename;

    public long getMem() {
        long l = 80L;
        if (this.calib != null) {
            l += this.calib.getMem();
        }
        if (this.headerFits != null) {
            l += this.headerFits.getMem();
        }
        if (this.headerFits0 != null) {
            l += this.headerFits0.getMem();
        }
        if (this.pixels != null) {
            l += (long)this.pixels.length;
        }
        if (this.rgb != null) {
            l += (long)(4 * this.rgb.length);
        }
        return l;
    }

    public Fits() {
    }

    public Fits(int n, int n2, int n3) {
        this(n, n2, 1, n3);
    }

    public Fits(int n, int n2, int n3, int n4) {
        this.width = this.widthCell = n;
        this.height = this.heightCell = n2;
        this.depth = this.depthCell = n3;
        this.bitpix = n4;
        this.zCell = 0;
        this.yCell = 0;
        this.xCell = 0;
        this.ext = 0;
        if (n4 == 0) {
            this.pixMode = 0;
            this.rgb = new int[n * n2 * n3];
        } else {
            this.pixMode = 2;
            this.pixels = new byte[n * n2 * n3 * Math.abs(n4) / 8];
            this.headerFits = new HeaderFits();
            this.headerFits.setKeyValue("SIMPLE", "T");
            this.headerFits.setKeyValue("BITPIX", n4 + "");
            this.headerFits.setKeyValue("NAXIS", n3 > 1 ? "3" : "2");
            this.headerFits.setKeyValue("NAXIS1", n + "");
            this.headerFits.setKeyValue("NAXIS2", n2 + "");
            if (n3 > 1) {
                this.headerFits.setKeyValue("NAXIS3", n3 + "");
            }
        }
    }

    public void setCalib(Calib calib) {
        this.calib = calib;
    }

    public Calib getCalib() {
        return this.calib;
    }

    public void loadPreview(MyInputStream myInputStream) throws Exception {
        this.loadPreview(myInputStream, false);
    }

    public void loadPreview(String string, int n, int n2, int n3, int n4) throws Exception {
        this.loadPreview(string + "[" + n + "," + n2 + "-" + n3 + "x" + n4 + "]");
    }

    public void loadPreview(String string) throws Exception {
        this.loadPreview(string, false, true, 0);
    }

    private void bidouilleJPEGPNG(HeaderFits headerFits, String string) {
        try {
            headerFits.getIntFromHeader("NAXIS1");
        }
        catch (Exception exception) {
            try {
                Fits fits = new Fits();
                MyInputStream myInputStream = new MyInputStream(new FileInputStream(string));
                fits.loadPreview(myInputStream);
                headerFits.setKeyValue("NAXIS", "2");
                headerFits.setKeyValue("NAXIS1", fits.width + "");
                headerFits.setKeyValue("NAXIS2", fits.height + "");
                headerFits.setKeyValue("NAXIS3", null);
                fits.free();
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    private Dimension getSizeJPEGPNG(String string) {
        Dimension dimension = null;
        try {
            Fits fits = new Fits();
            MyInputStream myInputStream = new MyInputStream(new FileInputStream(string));
            fits.loadPreview(myInputStream);
            dimension = new Dimension(fits.width, fits.height);
            fits.free();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPreview(String string, boolean bl, boolean bl2, int n) throws Exception {
        string = this.parseCell(string);
        MyInputStream myInputStream = null;
        try {
            myInputStream = new MyInputStream(new FileInputStream(string));
            if (bl2) {
                myInputStream.getType();
                if (myInputStream.hasCommentCalib()) {
                    Dimension dimension = new Dimension(0, 0);
                    if (myInputStream.hasCommentAVM()) {
                        dimension = this.getSizeJPEGPNG(string);
                    }
                    this.headerFits = myInputStream.createHeaderFitsFromCommentCalib(dimension.width, dimension.height);
                    this.bidouilleJPEGPNG(this.headerFits, string);
                    try {
                        this.setCalib(new Calib(this.headerFits));
                    }
                    catch (Exception exception) {
                        System.err.println("loadJpeg(" + string + ") : no calib found !");
                        this.calib = null;
                    }
                }
            }
            this.loadPreview(myInputStream, this.xCell, this.yCell, this.widthCell, this.heightCell, bl, n);
        }
        finally {
            if (myInputStream != null) {
                myInputStream.close();
            }
        }
        this.setFilename(string);
    }

    public void loadPreview(MyInputStream myInputStream, boolean bl) throws Exception {
        this.loadPreview(myInputStream, 0, 0, -1, -1, bl, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPreview(MyInputStream myInputStream, int n, int n2, int n3, int n4, boolean bl, int n5) throws Exception {
        int n6 = this.bitpix = bl ? 0 : 8;
        if ((long)this.width * (long)this.height > Integer.MAX_VALUE) {
            throw new Exception("Too large image for JAVA API");
        }
        if (n5 == 0) {
            int n7 = n5 = myInputStream.getType() == 65536L ? 2 : 1;
        }
        if (n3 == -1 && bl) {
            this.widthCell = n3;
            this.heightCell = n4;
            this.xCell = n;
            this.yCell = n2;
            this.pixMode = n5 == 2 ? 0 : 1;
            Image image = Toolkit.getDefaultToolkit().createImage(myInputStream.readFully());
            MyImageLoader myImageLoader = new MyImageLoader();
            image.getSource().startProduction(myImageLoader);
            while (!myImageLoader.ready()) {
                Util.pause(5);
            }
            if (this.width == -1) {
                throw new Exception("MyLoader error");
            }
        } else {
            BufferedImage bufferedImage;
            Object object;
            String string = n5 == 2 ? "png" : "jpeg";
            Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(string);
            ImageReader imageReader = iterator.next();
            ImageInputStream imageInputStream = null;
            try {
                imageInputStream = ImageIO.createImageInputStream(myInputStream);
                imageReader.setInput(imageInputStream, true);
                this.width = imageReader.getWidth(0);
                this.height = imageReader.getHeight(0);
                if (n3 == -1) {
                    n3 = this.width;
                    n4 = this.height;
                    n = 0;
                    n2 = 0;
                }
                if (n < 0 || n2 < 0 || n + n3 > this.width || n2 + n4 > this.height) {
                    throw new Exception("Mosaic cell outside the image (" + this.width + "x" + this.height + ") cell=[" + n + "," + n2 + " " + n3 + "x" + n4 + "]");
                }
                this.widthCell = n3;
                this.heightCell = n4;
                this.xCell = n;
                this.yCell = n2;
                object = imageReader.getDefaultReadParam();
                if (this.widthCell != this.width || this.heightCell != this.height) {
                    int n8 = this.height - this.yCell - this.heightCell;
                    Rectangle rectangle = new Rectangle(this.xCell, n8, this.widthCell, this.heightCell);
                    ((IIOParam)object).setSourceRegion(rectangle);
                }
                bufferedImage = imageReader.read(0, (ImageReadParam)object);
                imageReader.dispose();
            }
            finally {
                if (imageInputStream != null) {
                    imageInputStream.close();
                }
            }
            if (bl) {
                this.pixMode = n5 == 2 ? 0 : 1;
                object = bufferedImage.getRGB(0, 0, this.widthCell, this.heightCell, null, 0, this.widthCell);
                Fits.invImageLine(this.widthCell, this.heightCell, (int[])object);
                this.rgb = (int[])object;
                object = null;
            } else {
                this.pixMode = n5 == 2 ? 4 : 3;
                this.pixels = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                Fits.invImageLine(this.widthCell, this.heightCell, this.pixels);
            }
            try {
                myInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            bufferedImage.flush();
            bufferedImage = null;
        }
    }

    protected static void invImageLine(int n, int n2, byte[] byArray) {
        byte[] byArray2 = new byte[n];
        for (int i = n2 / 2 - 1; i >= 0; --i) {
            int n3 = i * n;
            int n4 = (n2 - i - 1) * n;
            System.arraycopy(byArray, n3, byArray2, 0, n);
            System.arraycopy(byArray, n4, byArray, n3, n);
            System.arraycopy(byArray2, 0, byArray, n4, n);
        }
        byArray2 = null;
    }

    protected static void invImageLine(int n, int n2, int[] nArray) {
        int[] nArray2 = new int[n];
        for (int i = n2 / 2 - 1; i >= 0; --i) {
            int n3 = i * n;
            int n4 = (n2 - i - 1) * n;
            System.arraycopy(nArray, n3, nArray2, 0, n);
            System.arraycopy(nArray, n4, nArray, n3, n);
            System.arraycopy(nArray2, 0, nArray, n4, n);
        }
        nArray2 = null;
    }

    public String parseCell(String string) throws Exception {
        this.yCell = 0;
        this.yCell = 0;
        this.xCell = 0;
        this.ext = 0;
        this.heightCell = -1;
        this.heightCell = -1;
        this.widthCell = -1;
        int n = string.lastIndexOf(91);
        if (n == -1) {
            return string;
        }
        int n2 = string.indexOf(93, n);
        if (n2 == -1) {
            return string;
        }
        int n3 = string.indexOf(44, n);
        boolean bl = n3 > 0;
        boolean bl2 = string.indexOf(44, n3 + 1) > 0;
        boolean bl3 = !bl || string.indexOf(58, n) > 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n + 1, n2), ":,-x");
        try {
            if (bl3) {
                this.ext = Integer.parseInt(stringTokenizer.nextToken());
            }
            if (bl) {
                this.xCell = Integer.parseInt(stringTokenizer.nextToken());
                this.yCell = Integer.parseInt(stringTokenizer.nextToken());
                this.zCell = bl2 ? Integer.parseInt(stringTokenizer.nextToken()) : 0;
                this.widthCell = Integer.parseInt(stringTokenizer.nextToken());
                this.heightCell = Integer.parseInt(stringTokenizer.nextToken());
                this.depthCell = bl2 ? Integer.parseInt(stringTokenizer.nextToken()) : 1;
            }
        }
        catch (Exception exception) {
            throw new Exception("Bad cell mosaic FITS definition => " + string);
        }
        return string.substring(0, n);
    }

    public void loadFITS(String string, int n, int n2, int n3, int n4, int n5) throws Exception {
        this.loadFITS(string + "[" + n + ":" + n2 + "," + n3 + "-" + n4 + "x" + n5 + "]");
    }

    public void loadFITS(String string, int n, int n2, int n3, int n4, int n5, int n6, int n7) throws Exception {
        this.loadFITS(string + "[" + n + ":" + n2 + "," + n3 + "," + n4 + "-" + n5 + "x" + n6 + "x" + n7 + "]");
    }

    public void loadFITS(String string) throws Exception {
        this.loadFITS(string, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFITS(String string, boolean bl, boolean bl2) throws Exception {
        string = this.parseCell(string);
        MyInputStream myInputStream = null;
        try {
            myInputStream = new MyInputStream(new FileInputStream(string));
            myInputStream = myInputStream.startRead();
            if (bl) {
                if (this.widthCell < 0) {
                    throw new Exception("Mosaic mode not supported yet for FITS color file");
                }
                this.loadFITSColor(myInputStream);
            } else {
                this.loadFITS(myInputStream, this.ext, this.xCell, this.yCell, this.zCell, this.widthCell, this.heightCell, this.depthCell, bl2);
            }
        }
        finally {
            if (myInputStream != null) {
                myInputStream.close();
            }
        }
        this.setFilename(string);
    }

    public void loadFITS(MyInputStream myInputStream) throws Exception {
        this.loadFITS(myInputStream, 0, 0, 0, 0, -1, -1, -1);
    }

    public void loadFITS(MyInputStream myInputStream, int n, int n2, int n3, int n4, int n5, int n6, int n7) throws Exception {
        this.loadFITS(myInputStream, n, n2, n3, n4, n5, n6, n7, true);
    }

    private void moveOnHUD(MyInputStream myInputStream, int n) throws Exception {
        boolean bl = true;
        while (n > 0) {
            HeaderFits headerFits = new HeaderFits(myInputStream);
            if (bl) {
                this.headerFits0 = headerFits;
                bl = false;
            }
            int n2 = headerFits.getIntFromHeader("BITPIX");
            int n3 = headerFits.getIntFromHeader("NAXIS");
            if (n3 != 0) {
                int n4 = 1;
                try {
                    n4 = headerFits.getIntFromHeader("GCOUNT");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int n5 = 0;
                try {
                    n5 = headerFits.getIntFromHeader("PCOUNT");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                long l = 1L;
                for (int i = 1; i <= n3; ++i) {
                    int n6 = headerFits.getIntFromHeader("NAXIS" + i);
                    l *= (long)n6;
                }
                l += (long)n5;
                myInputStream.skip(l *= (long)(n4 * Math.abs(n2) / 8));
                myInputStream.skipOnNext2880();
            }
            --n;
        }
    }

    public void setSkipHDU0(boolean bl) {
        this.skipHDU0 = bl;
    }

    public void loadFITS(MyInputStream myInputStream, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) throws Exception {
        boolean bl2 = (myInputStream = myInputStream.startRead()).isHCOMP();
        if (bl2 || myInputStream.isGZ()) {
            this.releasable = false;
            bl = true;
        }
        this.moveOnHUD(myInputStream, n);
        this.pixMode = 2;
        this.headerFits = new HeaderFits(myInputStream);
        if (n == 0 && this.headerFits.getIntFromHeader("NAXIS") == 0) {
            if (!this.skipHDU0) {
                return;
            }
            this.headerFits = new HeaderFits(myInputStream);
        }
        this.bitpix = this.headerFits.getIntFromHeader("BITPIX");
        this.width = this.headerFits.getIntFromHeader("NAXIS1");
        this.height = this.headerFits.getIntFromHeader("NAXIS2");
        try {
            this.depth = this.headerFits.getIntFromHeader("NAXIS3");
        }
        catch (Exception exception) {
            this.depth = 1;
        }
        if (this.headerFits.getStringFromHeader("ZBITPIX") != null) {
            throw new Exception("RICE image not supported");
        }
        if (n5 == -1) {
            this.widthCell = this.width;
            this.heightCell = this.height;
            this.depthCell = this.depth;
            this.zCell = 0;
            this.yCell = 0;
            this.xCell = 0;
        } else {
            if (n2 < 0 || n3 < 0 || n2 + n5 > this.width || n3 + n6 > this.height || n4 < 0 || n4 + n7 > this.depth) {
                throw new Exception("Mosaic cell outside the image (" + this.width + "x" + this.height + ") cell=[" + n2 + "," + n3 + "," + n4 + " " + n5 + "x" + n6 + "x" + n7 + "]");
            }
            this.widthCell = n5;
            this.heightCell = n6;
            this.depthCell = n7;
            this.xCell = n2;
            this.yCell = n3;
            this.zCell = n4;
        }
        try {
            this.blank = this.headerFits.getDoubleFromHeader("BLANK");
        }
        catch (Exception exception) {
            this.blank = Double.NaN;
        }
        int n8 = Math.abs(this.bitpix) / 8;
        this.bitmapOffset = myInputStream.getPos();
        int n9 = this.widthCell * this.heightCell * this.depthCell * n8;
        if (bl2) {
            byte[] byArray = Hdecomp.decomp(myInputStream);
            if (n5 == -1) {
                this.pixels = byArray;
            } else {
                this.pixels = new byte[n9];
                for (int i = 0; i < this.depthCell; ++i) {
                    for (int j = 0; j < this.heightCell; ++j) {
                        System.arraycopy(byArray, ((this.zCell + i) * this.width * this.height + (this.yCell + j) * this.width + this.xCell) * n8, this.pixels, (i * this.widthCell * this.heightCell + j * this.widthCell) * n8, this.widthCell * n8);
                    }
                }
            }
        } else if (bl || this.bitpix == 8) {
            this.pixels = new byte[n9];
            if (n5 == -1) {
                myInputStream.readFully(this.pixels);
            } else if (n5 == this.width && this.depth == 1) {
                myInputStream.skip((long)this.yCell * (long)this.width * (long)n8);
                myInputStream.readFully(this.pixels);
            } else {
                myInputStream.skip((long)this.zCell * (long)this.width * (long)this.height * (long)n8);
                for (int i = 0; i < this.depthCell; ++i) {
                    myInputStream.skip((long)this.yCell * (long)this.width * (long)n8);
                    byte[] byArray = new byte[this.width * n8];
                    for (int j = 0; j < this.heightCell; ++j) {
                        myInputStream.readFully(byArray);
                        System.arraycopy(byArray, this.xCell * n8, this.pixels, i * this.widthCell * this.heightCell + j * this.widthCell * n8, this.widthCell * n8);
                    }
                    myInputStream.skip((long)((this.height - (this.yCell + this.heightCell)) * this.width) * (long)n8);
                }
                myInputStream.skip((long)((this.depth - (this.zCell + this.depthCell)) * this.width * this.height) * (long)n8);
            }
        } else {
            this.bitmapReleaseDone = true;
        }
        try {
            this.bscale = this.headerFits.getDoubleFromHeader("BSCALE");
        }
        catch (Exception exception) {
            this.bscale = 1.0;
        }
        try {
            this.bzero = this.headerFits.getDoubleFromHeader("BZERO");
        }
        catch (Exception exception) {
            this.bzero = 0.0;
        }
        try {
            this.setCalib(new Calib(this.headerFits));
        }
        catch (Exception exception) {
            this.calib = null;
        }
    }

    public void loadFITSARGB(MyInputStream myInputStream) throws Exception {
        this.headerFits = new HeaderFits(myInputStream);
        this.width = this.widthCell = this.headerFits.getIntFromHeader("NAXIS1");
        this.height = this.heightCell = this.headerFits.getIntFromHeader("NAXIS2");
        this.yCell = 0;
        this.xCell = 0;
        this.pixMode = 0;
        this.pixels = new byte[this.widthCell * this.heightCell * 32];
        myInputStream.readFully(this.pixels);
        this.setARGB();
        try {
            this.setCalib(new Calib(this.headerFits));
        }
        catch (Exception exception) {
            this.calib = null;
        }
    }

    public void loadFITSColor(MyInputStream myInputStream) throws Exception {
        this.headerFits = new HeaderFits(myInputStream);
        this.bitpix = this.headerFits.getIntFromHeader("BITPIX");
        this.width = this.widthCell = this.headerFits.getIntFromHeader("NAXIS1");
        this.height = this.heightCell = this.headerFits.getIntFromHeader("NAXIS2");
        this.depthCell = 1;
        this.depth = 1;
        this.zCell = 0;
        this.yCell = 0;
        this.xCell = 0;
        this.pixMode = 1;
        this.pixels = new byte[this.widthCell * this.heightCell];
        myInputStream.readFully(this.pixels);
        byte[] byArray = new byte[this.widthCell * this.heightCell];
        myInputStream.readFully(byArray);
        byte[] byArray2 = new byte[this.widthCell * this.heightCell];
        myInputStream.readFully(byArray2);
        this.rgb = new int[this.widthCell * this.heightCell];
        for (int i = 0; i < this.heightCell * this.widthCell; ++i) {
            int n = 0;
            this.rgb[i] = n = 0 | (this.pixels[i] & 0xFF) << 16 | (byArray[i] & 0xFF) << 8 | byArray2[i] & 0xFF;
        }
        try {
            this.bscale = this.headerFits.getIntFromHeader("BSCALE");
        }
        catch (Exception exception) {
            this.bscale = 1.0;
        }
        try {
            this.bzero = this.headerFits.getIntFromHeader("BZERO");
        }
        catch (Exception exception) {
            this.bzero = 0.0;
        }
        try {
            this.setCalib(new Calib(this.headerFits));
        }
        catch (Exception exception) {
            this.calib = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadHeaderFITS(String string) throws Exception {
        string = this.parseCell(string);
        int n = 0;
        MyInputStream myInputStream = null;
        try {
            Object object;
            long l;
            myInputStream = new MyInputStream(new FileInputStream(string));
            if (myInputStream.isGZ()) {
                n |= 1;
                myInputStream = myInputStream.startRead();
            }
            if (((l = myInputStream.getType(10000)) & 0x10002L) != 0L && !myInputStream.hasCommentCalib()) {
                myInputStream.fastExploreCommentOrAvmCalib(string);
            }
            if (string.endsWith(".hhh")) {
                object = myInputStream.readFully();
                this.headerFits = new HeaderFits();
                this.headerFits.readFreeHeader(new String((byte[])object), true, null);
                n |= 2;
            } else if (myInputStream.hasCommentCalib()) {
                object = new Dimension(0, 0);
                if (myInputStream.hasCommentAVM()) {
                    object = this.getSizeJPEGPNG(string);
                }
                this.headerFits = myInputStream.createHeaderFitsFromCommentCalib(object.width, object.height);
                this.bidouilleJPEGPNG(this.headerFits, string);
            } else {
                this.moveOnHUD(myInputStream, this.ext);
                this.headerFits = new HeaderFits(myInputStream);
                if (this.ext == 0 && this.headerFits.getIntFromHeader("NAXIS") == 0) {
                    if (!this.skipHDU0) {
                        int n2 = 0;
                        return n2;
                    }
                    this.headerFits0 = this.headerFits;
                    this.headerFits = new HeaderFits(myInputStream);
                }
                if (this.headerFits.getStringFromHeader("ZBITPIX") != null) {
                    this.headerFits.setKeyword("BITPIX", this.headerFits.getStringFromHeader("ZBITPIX"));
                    this.headerFits.setKeyword("NAXIS1", this.headerFits.getStringFromHeader("ZNAXIS1"));
                    this.headerFits.setKeyword("NAXIS2", this.headerFits.getStringFromHeader("ZNAXIS2"));
                    this.headerFits.setKeyword("NAXIS", "2");
                }
                this.bitmapOffset = myInputStream.getPos();
                try {
                    this.bitpix = this.headerFits.getIntFromHeader("BITPIX");
                }
                catch (Exception exception) {
                    this.bitpix = 0;
                }
            }
            if (this.bitpix == 0) {
                n |= 4;
            }
            try {
                this.width = this.headerFits.getIntFromHeader("NAXIS1");
                this.height = this.headerFits.getIntFromHeader("NAXIS2");
                try {
                    this.depth = this.headerFits.getIntFromHeader("NAXIS3");
                }
                catch (Exception exception) {
                    this.depth = 1;
                }
                if (!this.hasCell()) {
                    this.zCell = 0;
                    this.yCell = 0;
                    this.xCell = 0;
                    this.widthCell = this.width;
                    this.heightCell = this.height;
                    this.depthCell = this.depth;
                }
                try {
                    this.blank = this.headerFits.getDoubleFromHeader("BLANK");
                }
                catch (Exception exception) {
                    this.blank = Double.NaN;
                }
                try {
                    this.bscale = this.headerFits.getDoubleFromHeader("BSCALE");
                }
                catch (Exception exception) {
                    this.bscale = 1.0;
                }
                try {
                    this.bzero = this.headerFits.getDoubleFromHeader("BZERO");
                }
                catch (Exception exception) {
                    this.bzero = 0.0;
                }
                try {
                    this.setCalib(new Calib(this.headerFits));
                }
                catch (Exception exception) {
                    this.calib = null;
                }
            }
            catch (Exception exception) {
                if (Aladin.levelTrace >= 3) {
                    exception.printStackTrace();
                }
                this.calib = null;
            }
            this.setFilename(string);
        }
        finally {
            if (myInputStream != null) {
                myInputStream.close();
            }
        }
        return n;
    }

    public double getBscale() {
        return this.bscale;
    }

    public double getBzero() {
        return this.bzero;
    }

    public double getBlank() {
        return this.blank;
    }

    public void setBscale(double d) {
        this.bscale = d;
        if (this.headerFits != null) {
            this.headerFits.setKeyValue("BSCALE", d == 1.0 ? (String)null : d + "");
        }
    }

    public void setBzero(double d) {
        this.bzero = d;
        if (this.headerFits != null) {
            this.headerFits.setKeyValue("BZERO", d == 0.0 ? (String)null : d + "");
        }
    }

    public void setBlank(double d) {
        this.blank = d;
        if (this.headerFits != null) {
            this.headerFits.setKeyValue("BLANK", Double.isNaN(d) ? (String)null : (this.bitpix > 0 ? (double)((int)d) : d) + "");
        }
    }

    public void setARGB() {
        this.setARGB(true);
    }

    public void setARGB(boolean bl) {
        this.pixMode = 0;
        this.bitpix = 0;
        if (this.headerFits != null) {
            this.headerFits.setKeyValue("COLORMOD", "ARGB");
        }
        this.rgb = new int[this.widthCell * this.heightCell];
        for (int i = 0; i < this.heightCell; ++i) {
            for (int j = 0; j < this.widthCell; ++j) {
                int n = i * this.widthCell + j;
                int n2 = bl ? (this.heightCell - i - 1) * this.widthCell + j : n;
                this.rgb[n2] = (this.pixels[n * 4] & 0xFF) << 24 | (this.pixels[n * 4 + 1] & 0xFF) << 16 | (this.pixels[n * 4 + 2] & 0xFF) << 8 | this.pixels[n * 4 + 3] & 0xFF;
            }
        }
    }

    private void createDir(String string) throws Exception {
        Util.createPath(string);
    }

    public static byte[] getBourrage(int n) {
        int n2 = n % 2880;
        int n3 = n2 == 0 ? 0 : 2880 - n2;
        byte[] byArray = new byte[n3];
        return byArray;
    }

    public void writeFITS(OutputStream outputStream) throws Exception {
        int n;
        int n2 = this.headerFits.writeHeader(outputStream);
        this.bitmapOffset = n2;
        if (this.pixMode == 0 || this.pixMode == 1) {
            byte[] byArray = new byte[this.rgb.length * 4];
            for (n = 0; n < this.rgb.length; ++n) {
                int n3 = this.rgb[n];
                byArray[n * 4] = (byte)(this.pixMode == 0 ? n3 >> 24 & 0xFF : 255);
                byArray[n * 4 + 1] = (byte)(n3 >> 16 & 0xFF);
                byArray[n * 4 + 2] = (byte)(n3 >> 8 & 0xFF);
                byArray[n * 4 + 3] = (byte)(n3 & 0xFF);
            }
            outputStream.write(byArray);
            n2 += byArray.length;
            byArray = null;
        } else {
            outputStream.write(this.pixels);
            n2 += this.pixels.length;
        }
        if (this.extHeader == null) {
            return;
        }
        int n4 = this.extHeader.size();
        for (n = 0; n < n4; ++n) {
            byte[] byArray = Fits.getBourrage(n2);
            n2 += byArray.length;
            outputStream.write(byArray);
            HeaderFits headerFits = (HeaderFits)this.extHeader.elementAt(n);
            headerFits.writeHeader(outputStream);
            byte[] byArray2 = (byte[])this.extPixels.elementAt(n);
            outputStream.write(byArray2);
            n2 += byArray2.length;
        }
    }

    public void writeFITS(String string) throws Exception {
        this.writeFITS(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFITS(String string, boolean bl) throws Exception {
        this.createDir(string);
        OutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(string);
            if (bl) {
                outputStream = new GZIPOutputStream(outputStream);
            }
            this.writeFITS(outputStream);
        }
        finally {
            outputStream.close();
        }
        this.setFilename(string);
    }

    public void addFitsExtension(HeaderFits headerFits, byte[] byArray) {
        if (this.extHeader == null) {
            this.extHeader = new Vector();
            this.extPixels = new Vector();
        }
        this.headerFits.setKeyValue("EXTEND", "T");
        this.extHeader.addElement(headerFits);
        this.extPixels.addElement(byArray);
    }

    public void clearExtensions() {
        this.extPixels = null;
        this.extHeader = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCompressed(String string, double d, double d2, byte[] byArray, String string2) throws Exception {
        this.createDir(string);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(new File(string));
            this.writePreview(fileOutputStream, d, d2, byArray, string2);
            this.setReleasable(false);
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        this.setFilename(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setToolKit() {
        if (kit == null) {
            Object object = lockKit;
            synchronized (object) {
                try {
                    ImageIO.setUseCache(false);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (kit == null) {
                    kit = Toolkit.getDefaultToolkit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePreview(OutputStream outputStream, double d, double d2, byte[] byArray, String string) throws Exception {
        BufferedImage bufferedImage;
        Image image;
        int[] nArray = this.rgb;
        int n = string.equals("png") ? 2 : 1;
        Fits.setToolKit();
        if (this.bitpix == 0 || this.pixMode == 1 || this.pixMode == 0) {
            nArray = new int[this.rgb.length];
            System.arraycopy(this.rgb, 0, nArray, 0, nArray.length);
            Fits.invImageLine(this.widthCell, this.heightCell, nArray);
            image = kit.createImage(new MemoryImageSource(this.widthCell, this.heightCell, nArray, 0, this.widthCell));
            bufferedImage = new BufferedImage(this.width, this.height, n);
        } else {
            int n2 = string.equals("png") ? 4 : 3;
            byte[] byArray2 = this.toPix8(d, d2, byArray, n2);
            image = kit.createImage(new MemoryImageSource(this.widthCell, this.heightCell, this.getCM(n2), byArray2, 0, this.widthCell));
            bufferedImage = new BufferedImage(this.width, this.height, n);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        int n3 = this.height - this.yCell - this.heightCell;
        graphics2D.drawImage(image, this.xCell, n3, null);
        graphics2D.dispose();
        ImageWriter imageWriter = ImageIO.getImageWritersByFormatName(string).next();
        ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
        if (string.equals("jpeg")) {
            imageWriteParam.setCompressionMode(2);
            imageWriteParam.setCompressionQuality(0.95f);
        }
        ImageOutputStream imageOutputStream = null;
        try {
            imageOutputStream = ImageIO.createImageOutputStream(outputStream);
            imageWriter.setOutput(imageOutputStream);
            imageWriter.write(null, new IIOImage(bufferedImage, null, null), imageWriteParam);
            imageWriter.dispose();
        }
        finally {
            if (imageOutputStream != null) {
                imageOutputStream.close();
            }
        }
    }

    protected boolean isTransparent() {
        return Fits.isTransparent(this.pixMode);
    }

    public static boolean isTransparent(int n) {
        return n == 4 || n == 2 || n == 0;
    }

    private ColorModel getCM(int n) {
        byte[] byArray = new byte[256];
        boolean bl = Fits.isTransparent(n);
        int n2 = bl ? 1 : 0;
        for (int i = 1; i < byArray.length; ++i) {
            byArray[i] = (byte)(i - n2);
        }
        return bl ? new IndexColorModel(8, 256, byArray, byArray, byArray, 0) : new IndexColorModel(8, 256, byArray, byArray, byArray);
    }

    public int getPixelRGB(int n, int n2) {
        return this.rgb[(n2 - this.yCell) * this.widthCell + (n - this.xCell)];
    }

    public int getPixelRGBJPG(int n, int n2) {
        return this.rgb[(n2 - this.yCell) * this.widthCell + (n - this.xCell)];
    }

    public String getCellSuffix() {
        if (!this.hasCell()) {
            return this.ext == 0 ? "" : "[" + this.ext + "]";
        }
        return "[" + (this.ext == 0 ? "" : this.ext + ":") + this.xCell + "," + this.yCell + (this.depth > 1 ? "," + this.zCell : "") + "-" + this.widthCell + "x" + this.heightCell + (this.depth > 1 ? "x" + this.depthCell : "") + "]";
    }

    public String getMefSuffix() {
        if (this.ext == 0) {
            return "";
        }
        return "[" + this.ext + "]";
    }

    public boolean hasCell() {
        return this.widthCell != -1 && this.heightCell != -1 && this.depthCell != -1 && (this.widthCell != this.width || this.heightCell != this.height || this.depthCell != this.depth);
    }

    public boolean isInCell(int n, int n2, int n3) {
        return n >= this.xCell && n < this.xCell + this.widthCell && n2 >= this.yCell && n2 < this.yCell + this.heightCell && n3 >= this.zCell && n3 < this.zCell + this.depthCell;
    }

    public double getPixelDirectAccess(int n, int n2) throws Exception {
        return this.getPixelDirectAccess(n, n2, 0);
    }

    public double getPixelDirectAccess(int n, int n2, int n3) throws Exception {
        if (this.filename == null || this.bitmapOffset == -1L) {
            throw new Exception("FITS stream not compatible (not a true file [" + this.filename + "])");
        }
        if (this.fDirectAccess == null) {
            this.fDirectAccess = new RandomAccessFile(this.filename, "r");
        }
        int n4 = Math.abs(this.bitpix) / 8;
        byte[] byArray = new byte[n4];
        long l = this.bitmapOffset + ((long)n3 * (long)this.width * (long)this.height + (long)n2 * (long)this.width + (long)n) * (long)n4;
        this.fDirectAccess.seek(l);
        this.fDirectAccess.readFully(byArray);
        return this.getPixValDouble(byArray, this.bitpix, 0);
    }

    public double getPixelFull(int n, int n2) {
        double d = this.getPixValDouble(this.pixels, this.bitpix, (n2 - this.yCell) * this.widthCell + (n - this.xCell));
        if (this.isBlankPixel(d)) {
            return d;
        }
        return this.bscale * d + this.bzero;
    }

    public double getPixelFull(int n, int n2, int n3) {
        double d = this.getPixValDouble(this.pixels, this.bitpix, (n3 - this.zCell) * this.widthCell * this.heightCell + (n2 - this.yCell) * this.widthCell + (n - this.xCell));
        if (this.isBlankPixel(d)) {
            return d;
        }
        return this.bscale * d + this.bzero;
    }

    public double getPixelDouble(int n, int n2) {
        return this.getPixValDouble(this.pixels, this.bitpix, (n2 - this.yCell) * this.widthCell + (n - this.xCell));
    }

    public double getPixelDouble(int n, int n2, int n3) {
        return this.getPixValDouble(this.pixels, this.bitpix, (n3 - this.zCell) * this.widthCell * this.heightCell + (n2 - this.yCell) * this.widthCell + (n - this.xCell));
    }

    public int getPixelInt(int n, int n2) {
        return this.getPixValInt(this.pixels, this.bitpix, (n2 - this.yCell) * this.widthCell + (n - this.xCell));
    }

    public int getPixelInt(int n, int n2, int n3) {
        return this.getPixValInt(this.pixels, this.bitpix, (n3 - this.zCell) * this.widthCell * this.heightCell + (n2 - this.yCell) * this.widthCell + (n - this.xCell));
    }

    public void setPixelRGB(int n, int n2, int n3) {
        this.rgb[(n2 - this.yCell) * this.widthCell + (n - this.xCell)] = n3;
    }

    public void setPixelRGBJPG(int n, int n2, int n3) {
        this.rgb[(n2 - this.yCell) * this.widthCell + (n - this.xCell)] = n3;
    }

    public void setPixelDouble(int n, int n2, double d) {
        Fits.setPixValDouble(this.pixels, this.bitpix, (n2 - this.yCell) * this.widthCell + (n - this.xCell), d);
    }

    public void setPixelDouble(int n, int n2, int n3, double d) {
        Fits.setPixValDouble(this.pixels, this.bitpix, n3 * this.widthCell * this.heightCell + (n2 - this.yCell) * this.widthCell + (n - this.xCell), d);
    }

    public void setPixelInt(int n, int n2, int n3) {
        this.setPixValInt(this.pixels, this.bitpix, (n2 - this.yCell) * this.widthCell + (n - this.xCell), n3);
    }

    public void setPixelInt(int n, int n2, int n3, int n4) {
        this.setPixValInt(this.pixels, this.bitpix, (n3 - this.zCell) * this.widthCell * this.heightCell + (n2 - this.yCell) * this.widthCell + (n - this.xCell), n4);
    }

    protected double[] getRaDec(double[] dArray, double d, double d2) throws Exception {
        if (dArray == null) {
            dArray = new double[2];
        }
        this.cTmp.x = d;
        this.cTmp.y = d2;
        this.calib.GetCoord(this.cTmp);
        dArray[0] = this.cTmp.al;
        dArray[1] = this.cTmp.del;
        return dArray;
    }

    protected double[] getXY(double[] dArray, double d, double d2) throws Exception {
        if (dArray == null) {
            dArray = new double[2];
        }
        this.cTmp.al = d;
        this.cTmp.del = d2;
        this.calib.GetXY(this.cTmp);
        dArray[0] = this.cTmp.x;
        dArray[1] = this.cTmp.y;
        return dArray;
    }

    public byte[] toPix8(double d, double d2, byte[] byArray, int n) {
        int n2 = 256;
        int n3 = 0;
        if (Fits.isTransparent(n)) {
            n2 = 254;
            n3 = 2;
        }
        byte[] byArray2 = new byte[this.widthCell * this.heightCell];
        double d3 = (double)n2 / (d2 - d);
        --n2;
        for (int i = 0; i < this.heightCell; ++i) {
            for (int j = 0; j < this.widthCell; ++j) {
                byte by;
                double d4 = this.getPixelDouble(j + this.xCell, i + this.yCell);
                if (this.isBlankPixel(d4)) {
                    by = 0;
                } else {
                    int n4 = n3 + (d4 <= d ? 0 : (d4 >= d2 ? n2 : (int)((d4 - d) * d3))) & 0xFF;
                    by = byArray == null ? (byte)n4 : byArray[n4];
                }
                this.setPixValInt(byArray2, 8, (this.height - i - 1) * this.widthCell + (j + this.xCell), by);
            }
        }
        return byArray2;
    }

    public byte[] toPix8Int(double d, double d2, int n) {
        int n2 = 256;
        int n3 = 0;
        if (Fits.isTransparent(n)) {
            n3 = 2;
            n2 -= n3;
        }
        byte[] byArray = new byte[this.widthCell * this.heightCell * 4];
        double d3 = (double)n2 / (d2 - d);
        --n2;
        for (int i = 0; i < this.heightCell; ++i) {
            for (int j = 0; j < this.widthCell; ++j) {
                double d4 = this.getPixelDouble(j + this.xCell, i + this.yCell);
                int n4 = this.isBlankPixel(d4) ? 0 : n3 + (d4 <= d ? 0 : (d4 > 2.147483647E9 ? Integer.MAX_VALUE : (int)((d4 - d) * d3)));
                this.setPixValInt(byArray, 32, (this.height - i - 1) * this.widthCell + (j + this.xCell), n4);
            }
        }
        return byArray;
    }

    public byte[] toPix4(double d, double d2, byte[] byArray) {
        int n = 15;
        int n2 = 1;
        byte[] byArray2 = new byte[this.widthCell * this.heightCell];
        double d3 = (double)n / (d2 - d);
        --n;
        for (int i = 0; i < this.heightCell; ++i) {
            for (int j = 0; j < this.widthCell; ++j) {
                byte by;
                double d4 = this.getPixelDouble(j + this.xCell, i + this.yCell);
                if (this.isBlankPixel(d4)) {
                    by = 0;
                } else {
                    int n3 = n2 + (d4 <= d ? 0 : (d4 >= d2 ? n : (int)((d4 - d) * d3))) & 0xFF;
                    by = byArray == null ? (byte)n3 : byArray[n3];
                }
                this.setPixValInt(byArray2, 8, (this.height - i - 1) * this.widthCell + (j + this.xCell), by);
            }
        }
        return byArray2;
    }

    public double[] findData() throws Exception {
        double[] dArray = new double[4];
        try {
            double d;
            int n;
            int n2;
            if (this.isReleased()) {
                this.reloadBitmap();
            }
            double d2 = this.getPixValDouble(this.pixels, this.bitpix, 0);
            int n3 = -1;
            int n4 = -1;
            int n5 = -1;
            int n6 = -1;
            block2: for (n2 = 0; n2 < this.height; ++n2) {
                for (n = 0; n < this.width; ++n) {
                    d = this.getPixValDouble(this.pixels, this.bitpix, n2 * this.width + n);
                    if (d == d2) continue;
                    n6 = n2;
                    break block2;
                }
            }
            block4: for (n2 = this.height - 1; n2 >= 0; --n2) {
                for (n = 0; n < this.width; ++n) {
                    d = this.getPixValDouble(this.pixels, this.bitpix, n2 * this.width + n);
                    if (d == d2) continue;
                    n5 = n2;
                    break block4;
                }
            }
            block6: for (n2 = 0; n2 < this.width; ++n2) {
                for (n = 0; n < this.height; ++n) {
                    d = this.getPixValDouble(this.pixels, this.bitpix, n * this.width + n2);
                    if (d == d2) continue;
                    n3 = n2;
                    break block6;
                }
            }
            block8: for (n2 = this.height - 1; n2 >= 0; --n2) {
                for (n = 0; n < this.height; ++n) {
                    d = this.getPixValDouble(this.pixels, this.bitpix, n * this.width + n2);
                    if (d == d2) continue;
                    n4 = n2;
                    break block8;
                }
            }
            dArray[0] = (n4 + n3) / 2;
            dArray[1] = (n6 + n5) / 2;
            dArray[2] = (n4 - n3) / 2;
            dArray[3] = (n5 - n6) / 2;
            if (n4 == -1 || n3 == -1) {
                dArray[0] = this.width / 2;
                dArray[2] = this.width / 2;
            }
            if (n6 == -1 || n5 == -1) {
                dArray[1] = this.height / 2;
                dArray[3] = this.height / 2;
            }
        }
        catch (Exception exception) {
            dArray = null;
        }
        return dArray;
    }

    public double[] findAutocutRange() throws Exception {
        return this.findAutocutRange(0.0, 0.0, -1.0, -1.0, false);
    }

    public double[] findAutocutRange(double d, double d2) throws Exception {
        return this.findAutocutRange(0.0, 0.0, d, d2, false);
    }

    public double[] findAutocutRange(double d, double d2, boolean bl) throws Exception {
        return this.findAutocutRange(d, d2, -1.0, -1.0, bl);
    }

    public double[] findAutocutRange(double d, double d2, double d3, double d4, boolean bl) throws Exception {
        double[] dArray = new double[5];
        if (d3 == -1.0) {
            d3 = 0.003;
        }
        if (d4 == -1.0) {
            d4 = 0.9995;
        }
        try {
            if (this.isReleased()) {
                this.reloadBitmap();
            }
            this.findMinMax(dArray, this.pixels, this.bitpix, this.widthCell, this.heightCell, this.depthCell, d, d2, d3, d4, true, bl, 0);
        }
        catch (Exception exception) {
            dArray[0] = dArray[2] = d;
            dArray[1] = dArray[3] = d2;
            dArray[4] = 0.0;
        }
        return dArray;
    }

    public boolean isBlankPixel(double d) {
        return Double.isNaN(d) || d == this.blank;
    }

    public boolean hasUsers() {
        return this.users > 0;
    }

    public synchronized void addUser() {
        ++this.users;
    }

    public synchronized void rmUser() {
        --this.users;
    }

    public boolean isReleased() {
        return this.bitmapReleaseDone;
    }

    public void setReleasable(boolean bl) {
        this.releasable = bl;
    }

    public boolean isReleasable() {
        return this.releasable;
    }

    public synchronized long releaseBitmap() throws Exception {
        if (this.bitpix == 0) {
            return 0L;
        }
        if (this.hasUsers()) {
            return 0L;
        }
        if (this.filename == null) {
            return 0L;
        }
        this.testBitmapReleaseFeature();
        long l = this.pixels.length;
        this.pixels = null;
        this.bitmapReleaseDone = true;
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reloadBitmap() throws Exception {
        if (this.bitpix == 0) {
            return;
        }
        if (this.pixels != null) {
            return;
        }
        if (this.filename == null) {
            return;
        }
        if (!this.bitmapReleaseDone) {
            throw new Exception("no releaseBitmap done before");
        }
        this.testBitmapReleaseFeature();
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(this.filename, "r");
            int n = Math.abs(this.bitpix) / 8;
            this.pixels = new byte[this.widthCell * this.heightCell * this.depth * n];
            if (!this.hasCell()) {
                randomAccessFile.seek(this.bitmapOffset);
                randomAccessFile.readFully(this.pixels);
            } else {
                for (int i = 0; i < this.depth; ++i) {
                    long l = this.bitmapOffset + (long)i * (long)this.width * (long)this.height + (long)this.yCell * (long)this.width * (long)n;
                    randomAccessFile.seek(l);
                    byte[] byArray = new byte[this.width * n];
                    for (int j = 0; j < this.heightCell; ++j) {
                        randomAccessFile.readFully(byArray);
                        System.arraycopy(byArray, this.xCell * n, this.pixels, i * this.widthCell * this.heightCell + j * this.widthCell * n, this.widthCell * n);
                    }
                }
            }
        }
        finally {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
        this.bitmapReleaseDone = false;
    }

    private void testBitmapReleaseFeature() throws Exception {
        if (this.filename == null || this.bitmapOffset == -1L) {
            throw new Exception("FITS stream not compatible (not a true file [" + this.filename + "])");
        }
        if (!this.releasable) {
            throw new Exception("FITS not compatible (compressed or reserved by user)");
        }
        if (!new File(this.filename).canRead()) {
            throw new Exception("FITS does not exist on disk [" + this.filename + "]");
        }
    }

    public void finalize() throws Throwable {
        this.free();
    }

    public void free() {
        this.pixels = null;
        this.rgb = null;
        this.calib = null;
        this.headerFits0 = null;
        this.headerFits = null;
        this.bitpix = 0;
        this.height = 0;
        this.width = 0;
        this.depth = 0;
        this.ext = 0;
        this.zCell = 0;
        this.yCell = 0;
        this.xCell = 0;
        this.depthCell = 0;
        this.heightCell = 0;
        this.widthCell = 0;
        if (this.fDirectAccess != null) {
            try {
                this.fDirectAccess.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.fDirectAccess = null;
        }
    }

    public void freeHeader() {
        this.headerFits0 = null;
        this.headerFits = null;
    }

    public String toString() {
        if (this.depth > 1) {
            return "Fits file: " + this.width + "x" + this.height + "x" + this.depth + " bitpix=" + this.bitpix + " [" + this.xCell + "," + this.yCell + "," + this.zCell + " " + this.widthCell + "x" + this.heightCell + "x" + this.depthCell + "]";
        }
        return "Fits file: " + this.width + "x" + this.height + " bitpix=" + this.bitpix + " [" + this.xCell + "," + this.yCell + " " + this.widthCell + "x" + this.heightCell + "]";
    }

    private void findMinMax(double[] dArray, byte[] byArray, int n, int n2, int n3, int n4, double d, double d2, double d3, double d4, boolean bl, boolean bl2, int n5) throws Exception {
        double d5;
        int n6;
        int n7;
        int n8;
        boolean bl3 = n5 > 0 || d != 0.0 && d2 != 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        if (!bl2) {
            n9 = (int)((double)n2 * 0.05);
            n10 = (int)((double)n3 * 0.05);
            n11 = (int)((double)n4 * 0.05);
            if (n2 - 2 * n9 > FINDMINMAXSIZE) {
                n9 = (n2 - FINDMINMAXSIZE) / 2;
            }
            if (n3 - 2 * n10 > FINDMINMAXSIZE) {
                n10 = (n3 - FINDMINMAXSIZE) / 2;
            }
            if (n4 - 2 * n11 > FINDMINMAXDEPTH) {
                n11 = (n4 - FINDMINMAXDEPTH) / 2;
            }
            if (n4 - 2 * n11 < 1) {
                n11 = 0;
            }
        }
        if (!(bl || d == 0.0 && d2 == 0.0)) {
            dArray[2] = d8 = d;
            dArray[3] = d6 = d2;
        } else {
            n8 = 0;
            boolean bl4 = true;
            long l = 0L;
            long l2 = 0L;
            for (n7 = n10; n7 < n3 - n10; ++n7) {
                for (n6 = n9; n6 < n2 - n9; ++n6) {
                    for (int i = n11; i < n4 - n11; ++i) {
                        d5 = this.getPixValDouble(byArray, n, i * n3 * n2 + n7 * n2 + n6);
                        if (this.isBlankPixel(d5)) {
                            ++n8;
                            continue;
                        }
                        if (bl3 && (d5 < d || d5 > d2)) continue;
                        if (bl4) {
                            d8 = d9 = d5;
                            d7 = d9;
                            d6 = d9;
                            bl4 = false;
                        }
                        if (d8 > d5) {
                            d8 = d5;
                            l = 1L;
                        } else if (d6 < d5) {
                            d6 = d5;
                            l2 = 1L;
                        } else {
                            if (d5 == d8) {
                                ++l;
                            }
                            if (d5 == d6) {
                                ++l2;
                            }
                        }
                        if (d5 < d9 && d5 > d8 || d9 == d8 && d5 < d7) {
                            d9 = d5;
                            continue;
                        }
                        if (!(d5 > d7 && d5 < d6) && (d7 != d6 || !(d5 > d9))) continue;
                        d7 = d5;
                    }
                }
            }
            if (bl && d6 - d8 > 256.0) {
                if (d9 - d8 > d7 - d9 && d9 != Double.MAX_VALUE && d9 != d6) {
                    d8 = d9;
                }
                if (d6 - d7 > d7 - d9 && d7 != Double.MIN_VALUE && d7 != d8) {
                    d6 = d7;
                }
            }
            dArray[2] = d8;
            dArray[3] = d6;
            try {
                dArray[4] = (double)n8 / (double)((n3 - 2 * n10) * (n2 - 2 * n9));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (bl) {
            n8 = 10000;
            double d10 = (d6 - d8) / (double)n8;
            int[] nArray = new int[n8];
            for (n7 = n10; n7 < n3 - n10; ++n7) {
                for (int i = n9; i < n2 - n9; ++i) {
                    d5 = this.getPixValDouble(byArray, n, n7 * n2 + i);
                    if (this.isBlankPixel(d5)) continue;
                    n6 = (int)((d5 - d8) / d10);
                    if (n6 == nArray.length) {
                        --n6;
                    }
                    if (n6 >= nArray.length || n6 < 0) continue;
                    int n12 = n6;
                    nArray[n12] = nArray[n12] + 1;
                }
            }
            int[] nArray2 = this.getMinMaxBean(nArray, d3, d4);
            if (nArray2[0] == -1 || nArray2[1] == -1) {
                throw new Exception("beaning error");
            }
            d9 = d8;
            d7 = (double)nArray2[1] * d10 + d9;
            d9 += (double)nArray2[0] * d10;
            if (nArray2[0] != -1 && nArray2[0] > nArray2[1] - 5 && n5 < 3) {
                if (d9 > d8) {
                    d8 = d9;
                }
                if (d7 < d6) {
                    d6 = d7;
                }
                this.findMinMax(dArray, byArray, n, n2, n3, n4, d8, d6, d3, d4, bl, bl2, n5 + 1);
                return;
            }
            d8 = d9;
            d6 = d7;
        }
        dArray[0] = d8;
        dArray[1] = d6;
    }

    private int[] getMinMaxBean(int[] nArray, double d, double d2) {
        int n;
        int[] nArray2 = new int[2];
        int n2 = 0;
        for (n = 0; n < nArray.length; ++n) {
            n2 += nArray[n];
        }
        nArray2[1] = -1;
        nArray2[0] = -1;
        int n3 = 0;
        for (n = 0; n < nArray.length; ++n) {
            double d3 = (double)(n3 += nArray[n]) / (double)n2;
            if (nArray2[0] == -1) {
                if (!(d3 > d)) continue;
                nArray2[0] = n;
                continue;
            }
            if (!(d3 > d2)) continue;
            nArray2[1] = n;
            break;
        }
        return nArray2;
    }

    private void setPixValInt(byte[] byArray, int n, int n2, int n3) {
        switch (n) {
            case 8: {
                byArray[n2] = (byte)(0xFF & n3);
                break;
            }
            case 16: {
                int n4 = n3;
                byArray[n2 *= 2] = (byte)(0xFF & n4 >> 8);
                byArray[n2 + 1] = (byte)(0xFF & n4);
                break;
            }
            case 32: {
                Fits.setInt(byArray, n2 *= 4, n3);
                break;
            }
            case -32: {
                int n5 = Float.floatToIntBits(n3);
                Fits.setInt(byArray, n2 *= 4, n5);
                break;
            }
            case -64: {
                long l = Double.doubleToLongBits(n3);
                int n6 = (int)(0xFFFFFFFFL & l >>> 32);
                Fits.setInt(byArray, n2 *= 8, n6);
                n6 = (int)(0xFFFFFFFFL & l);
                Fits.setInt(byArray, n2 + 4, n6);
            }
        }
    }

    public static void setPixValDouble(byte[] byArray, int n, int n2, double d) {
        switch (n) {
            case -32: {
                Fits.setInt(byArray, n2 << 2, Float.floatToIntBits((float)d));
                break;
            }
            case 16: {
                int n3 = (int)d;
                byArray[n2 *= 2] = (byte)(0xFF & n3 >> 8);
                byArray[n2 + 1] = (byte)(0xFF & n3);
                break;
            }
            case 32: {
                Fits.setInt(byArray, n2 *= 4, (int)d);
                break;
            }
            case 8: {
                byArray[n2] = (byte)(0xFF & (int)d);
                break;
            }
            case -64: {
                long l = Double.doubleToLongBits(d);
                int n4 = (int)(0xFFFFFFFFL & l >>> 32);
                Fits.setInt(byArray, n2 *= 8, n4);
                n4 = (int)(0xFFFFFFFFL & l);
                Fits.setInt(byArray, n2 + 4, n4);
            }
        }
    }

    public int getPixValInt(byte[] byArray, int n, int n2) {
        try {
            switch (n) {
                case 8: {
                    return byArray[n2] & 0xFF;
                }
                case 16: {
                    return byArray[n2 *= 2] << 8 | byArray[n2 + 1] & 0xFF;
                }
                case 32: {
                    return this.getInt(byArray, n2 * 4);
                }
                case -32: {
                    return (int)Float.intBitsToFloat(this.getInt(byArray, n2 * 4));
                }
                case -64: {
                    long l = (long)this.getInt(byArray, n2 *= 8) << 32 | (long)this.getInt(byArray, n2 + 4) & 0xFFFFFFFFL;
                    return (int)Double.longBitsToDouble(l);
                }
            }
            return 0;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public double getPixValDouble(byte[] byArray, int n, int n2) {
        try {
            switch (n) {
                case -32: {
                    return Float.intBitsToFloat(this.getInt(byArray, n2 << 2));
                }
                case 16: {
                    return byArray[n2 *= 2] << 8 | byArray[n2 + 1] & 0xFF;
                }
                case 32: {
                    return this.getInt(byArray, n2 * 4);
                }
                case 8: {
                    return byArray[n2] & 0xFF;
                }
                case -64: {
                    long l = (long)this.getInt(byArray, n2 *= 8) << 32 | (long)this.getInt(byArray, n2 + 4) & 0xFFFFFFFFL;
                    return Double.longBitsToDouble(l);
                }
            }
            return 0.0;
        }
        catch (Exception exception) {
            return Double.NaN;
        }
    }

    private static void setInt(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(0xFF & n2 >>> 24);
        byArray[n + 1] = (byte)(0xFF & n2 >>> 16);
        byArray[n + 2] = (byte)(0xFF & n2 >>> 8);
        byArray[n + 3] = (byte)(0xFF & n2);
    }

    private int getInt(byte[] byArray, int n) {
        return byArray[n] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    public static double getMax(int n) {
        return n == -64 ? Double.MAX_VALUE : (n == -32 ? 3.4028234663852886E38 : (n == 64 ? 9.223372036854776E18 : (n == 32 ? 2.147483647E9 : (n == 16 ? 32767.0 : 255.0))));
    }

    public void coadd(Fits fits, boolean bl) throws Exception {
        int n;
        int n2 = this.widthCell * this.heightCell * this.depthCell;
        if (fits.pixels != null && this.pixels != null) {
            double d = Fits.getMax(this.bitpix);
            for (n = 0; n < n2; ++n) {
                double d2 = this.getPixValDouble(this.pixels, this.bitpix, n);
                double d3 = fits.getPixValDouble(fits.pixels, fits.bitpix, n);
                double d4 = bl ? (this.isBlankPixel(d2) ? d3 : (fits.isBlankPixel(d3) ? d2 : (d2 + d3) / 2.0)) : (this.isBlankPixel(d2) ? d3 : (fits.isBlankPixel(d3) ? d2 : (d2 / 2.0 + d3 / 2.0 > d / 2.0 ? d : d2 + d3)));
                Fits.setPixValDouble(this.pixels, this.bitpix, n, d4);
            }
        }
        if (fits.rgb != null && this.rgb != null) {
            for (int i = 0; i < n2; ++i) {
                int n3;
                int n4;
                if ((fits.rgb[i] & 0xFF000000) == 0) continue;
                if ((this.rgb[i] & 0xFF000000) == 0) {
                    this.rgb[i] = fits.rgb[i];
                    continue;
                }
                if (bl) {
                    n4 = ((this.rgb[i] >> 16 & 0xFF) + (fits.rgb[i] >> 16 & 0xFF)) / 2 << 16;
                    n = ((this.rgb[i] >> 8 & 0xFF) + (fits.rgb[i] >> 8 & 0xFF)) / 2 << 8;
                    n3 = ((this.rgb[i] & 0xFF) + (fits.rgb[i] & 0xFF)) / 2;
                } else {
                    n4 = (this.rgb[i] >> 16 & 0xFF) + (fits.rgb[i] >> 16 & 0xFF);
                    n = (this.rgb[i] >> 8 & 0xFF) + (fits.rgb[i] >> 8 & 0xFF);
                    n3 = (this.rgb[i] & 0xFF) + (fits.rgb[i] & 0xFF);
                    if (n4 > 255) {
                        n4 = 255;
                    }
                    if (n > 255) {
                        n = 255;
                    }
                    if (n3 > 255) {
                        n3 = 255;
                    }
                    n4 <<= 16;
                    n <<= 8;
                }
                this.rgb[i] = 0xFF000000 | n4 | n | n3;
            }
        }
    }

    public void coadd(Fits fits, double[] dArray, double[] dArray2) throws Exception {
        double d;
        double d2;
        int n;
        int n2 = this.widthCell * this.heightCell * this.depthCell;
        if (fits.pixels != null && this.pixels != null) {
            for (n = 0; n < n2; ++n) {
                d2 = this.getPixValDouble(this.pixels, this.bitpix, n);
                d = fits.getPixValDouble(fits.pixels, fits.bitpix, n);
                double d3 = dArray[n] / (dArray[n] + dArray2[n]);
                double d4 = dArray2[n] / (dArray[n] + dArray2[n]);
                int n3 = n;
                dArray[n3] = dArray[n3] + dArray2[n];
                dArray2[n] = 0.0;
                double d5 = this.isBlankPixel(d2) ? d : (fits.isBlankPixel(d) ? d2 : d2 * d3 + d * d4);
                Fits.setPixValDouble(this.pixels, this.bitpix, n, d5);
            }
        }
        if (fits.rgb != null && this.rgb != null) {
            for (n = 0; n < n2; ++n) {
                d2 = dArray[n] / (dArray[n] + dArray2[n]);
                d = dArray2[n] / (dArray[n] + dArray2[n]);
                int n4 = n;
                dArray[n4] = dArray[n4] + dArray2[n];
                dArray2[n] = 0.0;
                if ((fits.rgb[n] & 0xFF000000) == 0) continue;
                if ((this.rgb[n] & 0xFF000000) == 0) {
                    this.rgb[n] = fits.rgb[n];
                    continue;
                }
                int n5 = (int)((double)(this.rgb[n] >> 16 & 0xFF) * d2 + (double)(fits.rgb[n] >> 16 & 0xFF) * d) << 16;
                int n6 = (int)((double)(this.rgb[n] >> 8 & 0xFF) * d2 + (double)(fits.rgb[n] >> 8 & 0xFF) * d) << 8;
                int n7 = (int)((double)(this.rgb[n] & 0xFF) * d2 + (double)(fits.rgb[n] & 0xFF) * d);
                this.rgb[n] = 0xFF000000 | n5 | n6 | n7;
            }
        }
    }

    public void mergeOnNaN(Fits fits, double[] dArray, double[] dArray2) throws Exception {
        int n;
        int n2 = this.widthCell * this.heightCell;
        if (fits.pixels != null && this.pixels != null) {
            for (n = 0; n < n2; ++n) {
                double d = this.getPixValDouble(this.pixels, this.bitpix, n);
                boolean bl = this.isBlankPixel(d);
                double d2 = fits.getPixValDouble(fits.pixels, fits.bitpix, n);
                boolean bl2 = fits.isBlankPixel(d2);
                if (!bl || bl2) continue;
                Fits.setPixValDouble(this.pixels, this.bitpix, n, d2);
                dArray[n] = dArray2[n];
            }
        }
        if (fits.rgb != null && this.rgb != null) {
            for (n = 0; n < n2; ++n) {
                if ((this.rgb[n] & 0xFF000000) != 0 || (fits.rgb[n] & 0xFF000000) == 0) continue;
                this.rgb[n] = fits.rgb[n];
                dArray[n] = dArray2[n];
            }
        }
    }

    public void mergeOnNaN(Fits fits) throws Exception {
        int n;
        int n2 = this.widthCell * this.heightCell;
        if (fits.pixels != null && this.pixels != null) {
            for (n = 0; n < n2; ++n) {
                double d = this.getPixValDouble(this.pixels, this.bitpix, n);
                boolean bl = this.isBlankPixel(d);
                double d2 = fits.getPixValDouble(fits.pixels, fits.bitpix, n);
                boolean bl2 = fits.isBlankPixel(d2);
                if (!bl || bl2) continue;
                Fits.setPixValDouble(this.pixels, this.bitpix, n, d2);
            }
        }
        if (fits.rgb != null && this.rgb != null) {
            for (n = 0; n < n2; ++n) {
                if ((this.rgb[n] & 0xFF000000) != 0 || (fits.rgb[n] & 0xFF000000) == 0) continue;
                this.rgb[n] = fits.rgb[n];
            }
        }
    }

    public void setFilename(String string) {
        if (string == null) {
            this.filename = null;
            return;
        }
        int n = string.lastIndexOf(91);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        this.filename = string;
    }

    public String getFileNameExtended() {
        return this.getFilename() + this.getCellSuffix();
    }

    public String getFilename() {
        return this.filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String string, double d, double d2, byte[] byArray, String string2) throws Exception {
        this.createDir(string);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(new File(string));
            this.write(fileOutputStream, d, d2, byArray, string2);
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        this.setFilename(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream outputStream, double d, double d2, byte[] byArray, String string) throws Exception {
        byte[] byArray2 = new byte[16];
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = (byte)(i * 16);
        }
        IndexColorModel indexColorModel = new IndexColorModel(4, 16, byArray2, byArray2, byArray2);
        byte[] byArray3 = this.toPix4(d, d2, null);
        WritableRaster writableRaster = Raster.createPackedRaster(0, this.width, this.height, 1, 4, null);
        writableRaster.setDataElements(0, 0, this.width, this.height, byArray3);
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 13, indexColorModel);
        bufferedImage.setData(writableRaster);
        ImageWriter imageWriter = ImageIO.getImageWritersByFormatName(string).next();
        ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
        if (string.equals("jpeg")) {
            imageWriteParam.setCompressionMode(2);
            imageWriteParam.setCompressionQuality(0.95f);
        }
        ImageOutputStream imageOutputStream = null;
        try {
            imageOutputStream = ImageIO.createImageOutputStream(outputStream);
            imageWriter.setOutput(imageOutputStream);
            imageWriter.write(null, new IIOImage(bufferedImage, null, null), imageWriteParam);
            imageWriter.dispose();
        }
        finally {
            if (imageOutputStream != null) {
                imageOutputStream.close();
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            Fits fits = new Fits();
            fits.loadFITS("C:\\Users\\Pierre\\Desktop\\Data\\Herschell\\hspire1342239942browse_18217979027709026.fits[2]");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    final class MyImageLoader
    implements ImageConsumer {
        boolean ready = false;
        boolean hasAlpha = true;

        MyImageLoader() {
        }

        @Override
        public void setDimensions(int n, int n2) {
            Fits.this.width = n;
            Fits.this.height = n2;
            if (Fits.this.widthCell == -1) {
                Fits.this.widthCell = n;
                Fits.this.heightCell = n2;
                Fits.this.depthCell = 1;
                Fits.this.zCell = 0;
                Fits.this.yCell = 0;
                Fits.this.xCell = 0;
            }
            Fits.this.rgb = new int[Fits.this.widthCell * Fits.this.heightCell];
        }

        @Override
        public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
            if ((n2 = Fits.this.height - n2 - 1) + n4 < Fits.this.yCell || n2 >= Fits.this.yCell + Fits.this.heightCell) {
                return;
            }
            for (int i = 0; i < n4; ++i) {
                int n7;
                int n8 = i + n2;
                int n9 = n8 - Fits.this.yCell;
                if (n9 < 0 || n9 >= Fits.this.heightCell) continue;
                if (this.hasAlpha && n3 >= Fits.this.widthCell) {
                    n7 = n9 * Fits.this.widthCell + n - Fits.this.xCell;
                    System.arraycopy(nArray, n5 + n6 * i, Fits.this.rgb, n7, Fits.this.widthCell);
                    continue;
                }
                for (n7 = 0; n7 < n3; ++n7) {
                    int n10 = n7 + n;
                    int n11 = n10 - Fits.this.xCell;
                    if (n11 < 0 || n11 >= Fits.this.widthCell) continue;
                    int n12 = nArray[n5 + n6 * i + n7];
                    if (!this.hasAlpha) {
                        n12 |= 0xFF000000;
                    }
                    Fits.this.rgb[n9 * Fits.this.widthCell + n11] = n12;
                }
            }
        }

        @Override
        public void imageComplete(int n) {
            this.ready = true;
        }

        public boolean ready() {
            return this.ready;
        }

        @Override
        public void setProperties(Hashtable<?, ?> hashtable) {
        }

        @Override
        public void setColorModel(ColorModel colorModel) {
            this.hasAlpha = colorModel.hasAlpha();
        }

        @Override
        public void setHints(int n) {
        }

        @Override
        public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
            if ((n2 = Fits.this.height - n2 - 1) + n4 < Fits.this.yCell || n2 >= Fits.this.yCell + Fits.this.heightCell) {
                return;
            }
            for (int i = 0; i < n4; ++i) {
                int n7 = i + n2;
                int n8 = n7 - Fits.this.yCell;
                if (n8 < 0 || n8 >= Fits.this.heightCell) continue;
                for (int j = 0; j < n3; ++j) {
                    int n9 = j + n;
                    int n10 = n9 - Fits.this.xCell;
                    if (n10 < 0 || n10 >= Fits.this.widthCell) continue;
                    int n11 = 0xFF & byArray[n5 + n6 * i + j];
                    n11 = n11 << 16 | n11 << 8 | n11;
                    if (!this.hasAlpha) {
                        n11 |= 0xFF000000;
                    }
                    Fits.this.rgb[n8 * Fits.this.widthCell + n10] = n11;
                }
            }
        }
    }
}

