/*
 * Decompiled with CFR 0.152.
 */
package cds.fits;

import cds.aladin.Aladin;
import cds.aladin.FrameHeaderFits;
import cds.aladin.MyInputStream;
import cds.aladin.Save;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class HeaderFits {
    private StringBuffer memoHeaderFits = null;
    protected Hashtable header;
    protected Vector<String> keysOrder;
    private int sizeHeader = 0;

    public HeaderFits() {
        this.alloc();
    }

    public HeaderFits(MyInputStream myInputStream) throws Exception {
        this.readHeader(myInputStream);
    }

    public HeaderFits(String string) throws Exception {
        this.readFreeHeader(string);
    }

    public HeaderFits(String string, FrameHeaderFits frameHeaderFits) throws Exception {
        this.readFreeHeader(string, false, frameHeaderFits);
    }

    public HeaderFits(MyInputStream myInputStream, FrameHeaderFits frameHeaderFits) throws Exception {
        this.readHeader(myInputStream, frameHeaderFits);
    }

    public String getOriginalHeaderFits() {
        return this.memoHeaderFits.toString();
    }

    public void setOriginalHeaderFits(String string) {
        this.memoHeaderFits = new StringBuffer(string);
    }

    public void appendMHF(String string) {
        if (this.memoHeaderFits == null) {
            this.memoHeaderFits = new StringBuffer();
        }
        this.memoHeaderFits.append(string.trim() + "\n");
    }

    public int getSizeHeader() {
        return this.sizeHeader;
    }

    public Hashtable getHashHeader() {
        return this.header;
    }

    public static String getValue(String string) {
        int n;
        byte[] byArray = new byte[80];
        for (n = 0; n < string.length(); ++n) {
            byArray[n] = (byte)string.charAt(n);
        }
        while (n < 80) {
            byArray[n++] = 32;
        }
        return HeaderFits.getValue(byArray);
    }

    public static String getValue(byte[] byArray) {
        int n;
        int n2;
        boolean bl = false;
        boolean bl2 = true;
        for (n2 = n = 9; n2 < 80 && !(bl ? byArray[n2] == 39 : byArray[n2] == 47); ++n2) {
            if (!bl2) continue;
            if (byArray[n2] != 32) {
                bl2 = false;
            }
            if (byArray[n2] != 39) continue;
            bl = true;
            n = n2 + 1;
        }
        return new String(byArray, 0, n, n2 - n).trim();
    }

    public static String getKey(byte[] byArray) {
        return new String(byArray, 0, 0, 8).trim();
    }

    public static String getKey(String string) {
        if (string.length() < 8) {
            return string;
        }
        return string.substring(0, 8).trim();
    }

    public boolean readHeaderPDS(MyInputStream myInputStream, FrameHeaderFits frameHeaderFits) throws Exception {
        int n = 0;
        this.alloc();
        try {
            while (true) {
                int n2;
                String string = myInputStream.readLine();
                ++n;
                if (string.length() == 0) continue;
                if (string.trim().equals("END")) {
                    return true;
                }
                if (frameHeaderFits != null) {
                    frameHeaderFits.appendMHF(string);
                }
                if ((n2 = string.indexOf(61)) < 0) continue;
                String string2 = string.substring(0, n2 - 1).trim();
                String string3 = string.substring(n2 + 1).trim();
                this.header.put(string2, string3);
                this.keysOrder.addElement(string2);
            }
        }
        catch (Exception exception) {
            Aladin.error = "PDS header error (line " + (n + 1) + ")";
            if (Aladin.levelTrace >= 3) {
                exception.printStackTrace();
            }
            throw new Exception();
        }
    }

    public boolean readHeader(MyInputStream myInputStream) throws Exception {
        return this.readHeader(myInputStream, null);
    }

    public boolean readHeader(MyInputStream myInputStream, FrameHeaderFits frameHeaderFits) throws Exception {
        int n = 2880;
        int n2 = 80;
        int n3 = 0;
        this.sizeHeader = 0;
        boolean bl = true;
        byte[] byArray = new byte[n2];
        this.alloc();
        try {
            while (true) {
                myInputStream.readFully(byArray);
                String string = HeaderFits.getKey(byArray);
                if (n3 == 0 && !string.equals("SIMPLE") && !string.equals("XTENSION")) {
                    throw new Exception("probably not a FITS file");
                }
                this.sizeHeader += n2;
                ++n3;
                if (string.equals("END")) break;
                this.appendMHF(new String(byArray, 0));
                if (byArray[8] != 61) continue;
                String string2 = HeaderFits.getValue(byArray);
                this.header.put(string, string2);
                this.keysOrder.addElement(string);
            }
            if (myInputStream.isHCOMP()) {
                return true;
            }
            int n4 = n - this.sizeHeader % n;
            if (n4 != n) {
                byte[] byArray2 = new byte[n4];
                myInputStream.readFully(byArray2);
                this.sizeHeader += n4;
            }
        }
        catch (Exception exception) {
            Aladin.error = n3 == 0 ? "Remote server message:\n" + new String(byArray, 0) : "Fits header error (line " + (n3 + 1) + ")";
            throw exception;
        }
        return true;
    }

    private int getPos(char[] cArray, int n, int n2, char c) {
        int n3 = cArray.length;
        boolean bl = n + 2 < cArray.length && cArray[n + 2] == '\'' && c == '/';
        int n4 = n;
        while (n < n3 && n < n2 && (cArray[n] != c || cArray[n] == c && bl) && cArray[n] != '\n') {
            if (n > n4 + 2 && cArray[n] == '\'' && cArray[n - 1] != '\'') {
                bl = false;
            }
            ++n;
        }
        return n;
    }

    public boolean readFreeHeader(String string) {
        return this.readFreeHeader(string, false, null);
    }

    public boolean readFreeHeader(String string, boolean bl, FrameHeaderFits frameHeaderFits) {
        this.alloc();
        int n = 79;
        char[] cArray = string.toCharArray();
        int n2 = 0;
        while (n2 < cArray.length) {
            String string2;
            int n3;
            int n4 = this.getPos(cArray, n2, n2 + n, '\n');
            if (new String(cArray, n2, n4 - n2).trim().length() == 0) {
                this.appendMHF("");
            } else if (cArray.length > n2 + 7 && new String(cArray, n2, 7).equals("COMMENT")) {
                n3 = n2 + 7;
                n4 = this.getPos(cArray, n3, n2 + n, '\n');
                string2 = n4 - n3 > 0 ? new String(cArray, n3 + 1, n4 - n3 - 1).trim() : "";
                this.appendMHF(new String(Save.getFitsLineComment(string2)).trim());
            } else if (cArray.length > n2 + 7 && new String(cArray, n2, 7).equals("HISTORY")) {
                n3 = n2 + 7;
                n4 = this.getPos(cArray, n3, n2 + n, '\n');
                string2 = n4 - n3 > 0 ? new String(cArray, n3 + 1, n4 - n3 - 1).trim() : "";
                this.appendMHF(new String(Save.getFitsLineHistory(string2)).trim());
            } else {
                n3 = this.getPos(cArray, n2, n2 + n, '=');
                int n5 = this.getPos(cArray, n3, n2 + n, '/');
                n4 = this.getPos(cArray, n5, n2 + n, '\n');
                if (n2 != n3 || n2 != n5 || n2 != n4) {
                    String string3 = new String(cArray, n2, n3 - n2).trim();
                    String string4 = n5 - n3 > 0 ? new String(cArray, n3 + 1, n5 - n3 - 1).trim() : "";
                    String string5 = string2 = n4 - n5 > 0 ? new String(cArray, n5 + 1, n4 - n5 - 1).trim() : "";
                    if (string3.equals("END")) {
                        string2 = null;
                        string4 = null;
                        break;
                    }
                    this.header.put(string3, string4);
                    this.keysOrder.addElement(string3);
                    this.appendMHF(new String(Save.getFitsLine(string3, string4, string2)).trim());
                }
            }
            n2 = n4 + 1;
        }
        return true;
    }

    public boolean hasKey(String string) {
        return this.header.get(string.trim()) != null;
    }

    public int getIntFromHeader(String string) throws NumberFormatException, NullPointerException {
        String string2 = (String)this.header.get(string.trim());
        int n = (int)Double.parseDouble(string2.trim());
        return n;
    }

    private String trimDouble(String string) {
        int n;
        char c;
        int n2;
        char[] cArray = string.toCharArray();
        for (n2 = 0; n2 < cArray.length && (c = cArray[n2]) != '+' && c != '-' && c != '.' && (c < '0' || c > '9'); ++n2) {
        }
        for (n = cArray.length - 1; n >= n2; --n) {
            c = cArray[n];
            if ((c < '0' || c > '9') && c != '.') continue;
            ++n;
            break;
        }
        return new String(cArray, n2, n - n2);
    }

    public void setKeyword(String string, String string2) {
        this.header.put(string, string2);
    }

    public double getDoubleFromHeader(String string) throws NumberFormatException, NullPointerException {
        String string2 = (String)this.header.get(string.trim());
        double d = Double.valueOf(this.trimDouble(string2));
        return d;
    }

    public String getStringFromHeader(String string) throws NullPointerException {
        String string2 = (String)this.header.get(string.trim());
        if (string2 == null || string2.length() == 0) {
            return string2;
        }
        if (string2.charAt(0) == '\'') {
            return string2.substring(1, string2.length() - 1).trim();
        }
        return string2;
    }

    public void setToHeader(String string, String string2) {
        if (string2 == null) {
            this.header.remove(string);
        } else {
            this.header.put(string.trim(), string2);
        }
    }

    public void setKeyValue(String string, String string2) {
        if (string2 == null) {
            if (!this.hasKey(string)) {
                return;
            }
            this.header.remove(string);
            this.keysOrder.remove(string);
            return;
        }
        if (!this.hasKey(string)) {
            this.keysOrder.addElement(string);
        }
        this.header.put(string, string2);
    }

    public int writeHeader(OutputStream outputStream) throws Exception {
        int n = this.keysOrder.size() * 80;
        byte[] byArray = HeaderFits.getEndBourrage(n);
        byte[] byArray2 = new byte[n + byArray.length];
        int n2 = 0;
        Enumeration<String> enumeration = this.keysOrder.elements();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            String string2 = (String)this.header.get(string);
            if (string2 == null) continue;
            System.arraycopy(HeaderFits.getFitsLine(string, string2), 0, byArray2, n2, 80);
            n2 += 80;
        }
        System.arraycopy(byArray, 0, byArray2, n2, byArray.length);
        outputStream.write(byArray2);
        return n += byArray.length;
    }

    public static byte[] getEndBourrage(int n) {
        int n2 = 2880 - n % 2880;
        if (n2 < 3) {
            n2 += 2880;
        }
        byte[] byArray = new byte[n2];
        byArray[0] = 69;
        byArray[1] = 78;
        byArray[2] = 68;
        for (int i = 3; i < byArray.length; ++i) {
            byArray[i] = 32;
        }
        return byArray;
    }

    public static byte[] getFitsLine(String string, String string2) {
        return HeaderFits.getFitsLine(string, string2, null);
    }

    public static byte[] getFitsLine(String string, String string2, String string3) {
        int n;
        byte[] byArray = new byte[80];
        char[] cArray = string.toCharArray();
        int n2 = 0;
        for (n = 0; n < 8; ++n) {
            byArray[n] = (byte)(n2 < cArray.length ? cArray[n2] : 32);
            ++n2;
        }
        if (string2 != null) {
            byArray[n++] = 61;
            byArray[n++] = 32;
            cArray = string2.toCharArray();
            if (!HeaderFits.isFitsString(string2)) {
                for (n2 = 0; n2 < 20 - cArray.length; ++n2) {
                    byArray[n++] = 32;
                }
                for (n2 = 0; n < 80 && n2 < cArray.length; ++n2, ++n) {
                    byArray[n] = (byte)cArray[n2];
                }
            } else {
                cArray = HeaderFits.formatFitsString(cArray);
                for (n2 = 0; n < 80 && n2 < cArray.length; ++n2, ++n) {
                    byArray[n] = (byte)cArray[n2];
                }
                while (n < 30) {
                    byArray[n++] = 32;
                }
            }
        }
        if (string3 != null && string3.length() > 0) {
            if (string2 != null) {
                byArray[n++] = 32;
                byArray[n++] = 47;
                byArray[n++] = 32;
            }
            cArray = string3.toCharArray();
            for (n2 = 0; n < 80 && n2 < cArray.length; ++n2, ++n) {
                byArray[n] = (byte)cArray[n2];
            }
        }
        while (n < 80) {
            byArray[n++] = 32;
        }
        return byArray;
    }

    private static boolean isFitsString(String string) {
        if (string.length() == 0) {
            return true;
        }
        char c = string.charAt(0);
        if (string.length() == 1 && (c == 'T' || c == 'F')) {
            return false;
        }
        if (!Character.isDigit(c) && c != '.' && c != '-' && c != '+') {
            return true;
        }
        try {
            Double.valueOf(string);
            return false;
        }
        catch (Exception exception) {
            return true;
        }
    }

    private static char[] formatFitsString(char[] cArray) {
        int n;
        if (cArray.length == 0) {
            return cArray;
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = cArray[0] == '\'';
        stringBuffer.append('\'');
        for (n = bl ? 1 : 0; n < cArray.length - (bl ? 1 : 0); ++n) {
            if (!bl && cArray[n] == '\'') {
                stringBuffer.append('\'');
            }
            stringBuffer.append(cArray[n]);
        }
        while (n < (bl ? 9 : 8)) {
            stringBuffer.append(' ');
            ++n;
        }
        stringBuffer.append('\'');
        return stringBuffer.toString().toCharArray();
    }

    protected void alloc() {
        this.header = new Hashtable(200);
        this.keysOrder = new Vector(200);
    }

    public long getMem() {
        return 16 + (this.keysOrder == null ? 0 : this.keysOrder.size() * 50);
    }
}

