/*
 * Decompiled with CFR 0.152.
 */
package cds.image;

import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.DataOutputStream;
import java.io.OutputStream;

public final class BMPWriter {
    public static void write(Image image, OutputStream outputStream) throws Exception {
        int[] nArray = null;
        int n = 0;
        int n2 = 0;
        try {
            n = image.getWidth(null);
            n2 = image.getHeight(null);
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, true);
            pixelGrabber.grabPixels();
            nArray = (int[])pixelGrabber.getPixels();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        BMPWriter.write24BitBMP(nArray, n, n2, outputStream);
    }

    static void printStatus(int n) {
        String string = "";
        if ((n & 0x80) != 0) {
            string = string + " ABORT";
        }
        if ((n & 0x20) != 0) {
            string = string + " ALLBITS";
        }
        if ((n & 0x40) != 0) {
            string = string + " ERROR";
        }
        if ((n & 8) != 0) {
            string = string + " SOMEBITS";
        }
        if ((n & 0x10) != 0) {
            string = string + " FRAMEBITS";
        }
        System.out.println("Status: " + string);
    }

    public static void write24BitBMP(int[] nArray, int n, int n2, OutputStream outputStream) throws Exception {
        int n3 = (4 - n * 3 % 4) % 4;
        int n4 = (n * 3 + n3) * n2;
        byte[] byArray = new byte[n4];
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            int n6;
            for (n6 = 0; n6 < n; ++n6) {
                int n7 = nArray[(n2 - 1 - i) * n + n6];
                byArray[n5++] = (byte)(n7 & 0xFF);
                byArray[n5++] = (byte)(n7 >> 8 & 0xFF);
                byArray[n5++] = (byte)(n7 >> 16 & 0xFF);
            }
            for (n6 = 0; n6 < n3; ++n6) {
                byArray[n5++] = 0;
            }
        }
        BMPWriter.writeBMPFile(outputStream, n4, n, n2, 24, byArray);
    }

    protected static void writeBMPFile(OutputStream outputStream, int n, int n2, int n3, int n4, byte[] byArray) throws Exception {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        BMPWriter.writeShort(dataOutputStream, 19778);
        BMPWriter.writeInt(dataOutputStream, n + 54);
        BMPWriter.writeShort(dataOutputStream, 0);
        BMPWriter.writeShort(dataOutputStream, 0);
        BMPWriter.writeInt(dataOutputStream, 54);
        BMPWriter.writeInt(dataOutputStream, 40);
        BMPWriter.writeInt(dataOutputStream, n2);
        BMPWriter.writeInt(dataOutputStream, n3);
        BMPWriter.writeShort(dataOutputStream, 1);
        BMPWriter.writeShort(dataOutputStream, n4);
        BMPWriter.writeInt(dataOutputStream, 0);
        BMPWriter.writeInt(dataOutputStream, n);
        BMPWriter.writeInt(dataOutputStream, 2835);
        BMPWriter.writeInt(dataOutputStream, 2835);
        BMPWriter.writeInt(dataOutputStream, 0);
        BMPWriter.writeInt(dataOutputStream, 0);
        dataOutputStream.write(byArray, 0, n);
        dataOutputStream.close();
    }

    private static void writeInt(DataOutputStream dataOutputStream, int n) throws Exception {
        dataOutputStream.writeByte(n & 0xFF);
        dataOutputStream.writeByte(n >> 8 & 0xFF);
        dataOutputStream.writeByte(n >> 16 & 0xFF);
        dataOutputStream.writeByte(n >> 24 & 0xFF);
    }

    private static void writeShort(DataOutputStream dataOutputStream, int n) throws Exception {
        dataOutputStream.writeByte(n & 0xFF);
        dataOutputStream.writeByte(n >> 8 & 0xFF);
    }
}

