/*
 * Decompiled with CFR 0.152.
 */
package cds.image;

import java.io.IOException;
import java.io.InputStream;

public class Bzip2
extends InputStream {
    static int BASEBLOCKSIZE = 100000;
    static int MAX_ALPHA_SIZE = 258;
    static int MAX_CODE_LEN = 23;
    static int RUNA = 0;
    static int RUNB = 1;
    static int N_GROUPS = 6;
    static int G_SIZE = 50;
    static int N_ITERS = 4;
    static int MAX_SELECTORS = 2 + 900000 / G_SIZE;
    static int NUM_OVERSHOOT_BYTES = 20;
    private long bytesRead = 0L;
    private int last;
    private int origPtr;
    private int blockSize100k;
    private boolean blockRandomised;
    private int bsBuff;
    private int bsLive;
    private final CRC crc = new CRC();
    private int nInUse;
    private InputStream in;
    private final boolean decompressConcatenated;
    private static final int EOF = 0;
    private static final int START_BLOCK_STATE = 1;
    private static final int RAND_PART_A_STATE = 2;
    private static final int RAND_PART_B_STATE = 3;
    private static final int RAND_PART_C_STATE = 4;
    private static final int NO_RAND_PART_A_STATE = 5;
    private static final int NO_RAND_PART_B_STATE = 6;
    private static final int NO_RAND_PART_C_STATE = 7;
    private int currentState = 1;
    private int storedBlockCRC;
    private int storedCombinedCRC;
    private int computedBlockCRC;
    private int computedCombinedCRC;
    private int su_count;
    private int su_ch2;
    private int su_chPrev;
    private int su_i2;
    private int su_j2;
    private int su_rNToGo;
    private int su_rTPos;
    private int su_tPos;
    private char su_z;
    private Data data;
    private static final int[] crc32Table = new int[]{0, 79764919, 159529838, 222504665, 319059676, 398814059, 445009330, 507990021, 638119352, 583659535, 797628118, 726387553, 890018660, 835552979, 1015980042, 944750013, 1276238704, 1221641927, 1167319070, 1095957929, 1595256236, 1540665371, 1452775106, 1381403509, 1780037320, 1859660671, 1671105958, 1733955601, 2031960084, 2111593891, 1889500026, 1952343757, -1742489888, -1662866601, -1851683442, -1788833735, -1960329156, -1880695413, -2103051438, -2040207643, -1104454824, -1159051537, -1213636554, -1284997759, -1389417084, -1444007885, -1532160278, -1603531939, -734892656, -789352409, -575645954, -646886583, -952755380, -1007220997, -827056094, -898286187, -231047128, -151282273, -71779514, -8804623, -515967244, -436212925, -390279782, -327299027, 881225847, 809987520, 1023691545, 969234094, 662832811, 591600412, 771767749, 717299826, 311336399, 374308984, 453813921, 533576470, 25881363, 88864420, 134795389, 214552010, 2023205639, 2086057648, 1897238633, 1976864222, 1804852699, 1867694188, 1645340341, 1724971778, 1587496639, 1516133128, 1461550545, 1406951526, 1302016099, 1230646740, 1142491917, 1087903418, -1398421865, -1469785312, -1524105735, -1578704818, -1079922613, -1151291908, -1239184603, -1293773166, -1968362705, -1905510760, -2094067647, -2014441994, -1716953613, -1654112188, -1876203875, -1796572374, -525066777, -462094256, -382327159, -302564546, -206542021, -143559028, -97365931, -17609246, -960696225, -1031934488, -817968335, -872425850, -709327229, -780559564, -600130067, -654598054, 1762451694, 1842216281, 1619975040, 1682949687, 2047383090, 2127137669, 1938468188, 2001449195, 1325665622, 1271206113, 1183200824, 1111960463, 1543535498, 1489069629, 1434599652, 1363369299, 622672798, 568075817, 748617968, 677256519, 907627842, 853037301, 1067152940, 995781531, 51762726, 131386257, 177728840, 240578815, 269590778, 349224269, 429104020, 491947555, -248556018, -168932423, -122852000, -60002089, -500490030, -420856475, -341238852, -278395381, -685261898, -739858943, -559578920, -630940305, -1004286614, -1058877219, -845023740, -916395085, -1119974018, -1174433591, -1262701040, -1333941337, -1371866206, -1426332139, -1481064244, -1552294533, -1690935098, -1611170447, -1833673816, -1770699233, -2009983462, -1930228819, -2119160460, -2056179517, 1569362073, 1498123566, 1409854455, 1355396672, 1317987909, 1246755826, 1192025387, 1137557660, 2072149281, 2135122070, 1912620623, 1992383480, 1753615357, 1816598090, 1627664531, 1707420964, 295390185, 358241886, 404320391, 483945776, 43990325, 106832002, 186451547, 266083308, 932423249, 861060070, 1041341759, 986742920, 613929101, 542559546, 756411363, 701822548, -978770311, -1050133554, -869589737, -924188512, -693284699, -764654318, -550540341, -605129092, -475935807, -413084042, -366743377, -287118056, -257573603, -194731862, -114850189, -35218492, -1984365303, -1921392450, -2143631769, -2063868976, -1698919467, -1635936670, -1824608069, -1744851700, -1347415887, -1418654458, -1506661409, -1561119128, -1129027987, -1200260134, -1254728445, -1309196108};
    private static final int[] RNUMS = new int[]{619, 720, 127, 481, 931, 816, 813, 233, 566, 247, 985, 724, 205, 454, 863, 491, 741, 242, 949, 214, 733, 859, 335, 708, 621, 574, 73, 654, 730, 472, 419, 436, 278, 496, 867, 210, 399, 680, 480, 51, 878, 465, 811, 169, 869, 675, 611, 697, 867, 561, 862, 687, 507, 283, 482, 129, 807, 591, 733, 623, 150, 238, 59, 379, 684, 877, 625, 169, 643, 105, 170, 607, 520, 932, 727, 476, 693, 425, 174, 647, 73, 122, 335, 530, 442, 853, 695, 249, 445, 515, 909, 545, 703, 919, 874, 474, 882, 500, 594, 612, 641, 801, 220, 162, 819, 984, 589, 513, 495, 799, 161, 604, 958, 533, 221, 400, 386, 867, 600, 782, 382, 596, 414, 171, 516, 375, 682, 485, 911, 276, 98, 553, 163, 354, 666, 933, 424, 341, 533, 870, 227, 730, 475, 186, 263, 647, 537, 686, 600, 224, 469, 68, 770, 919, 190, 373, 294, 822, 808, 206, 184, 943, 795, 384, 383, 461, 404, 758, 839, 887, 715, 67, 618, 276, 204, 918, 873, 777, 604, 560, 951, 160, 578, 722, 79, 804, 96, 409, 713, 940, 652, 934, 970, 447, 318, 353, 859, 672, 112, 785, 645, 863, 803, 350, 139, 93, 354, 99, 820, 908, 609, 772, 154, 274, 580, 184, 79, 626, 630, 742, 653, 282, 762, 623, 680, 81, 927, 626, 789, 125, 411, 521, 938, 300, 821, 78, 343, 175, 128, 250, 170, 774, 972, 275, 999, 639, 495, 78, 352, 126, 857, 956, 358, 619, 580, 124, 737, 594, 701, 612, 669, 112, 134, 694, 363, 992, 809, 743, 168, 974, 944, 375, 748, 52, 600, 747, 642, 182, 862, 81, 344, 805, 988, 739, 511, 655, 814, 334, 249, 515, 897, 955, 664, 981, 649, 113, 974, 459, 893, 228, 433, 837, 553, 268, 926, 240, 102, 654, 459, 51, 686, 754, 806, 760, 493, 403, 415, 394, 687, 700, 946, 670, 656, 610, 738, 392, 760, 799, 887, 653, 978, 321, 576, 617, 626, 502, 894, 679, 243, 440, 680, 879, 194, 572, 640, 724, 926, 56, 204, 700, 707, 151, 457, 449, 797, 195, 791, 558, 945, 679, 297, 59, 87, 824, 713, 663, 412, 693, 342, 606, 134, 108, 571, 364, 631, 212, 174, 643, 304, 329, 343, 97, 430, 751, 497, 314, 983, 374, 822, 928, 140, 206, 73, 263, 980, 736, 876, 478, 430, 305, 170, 514, 364, 692, 829, 82, 855, 953, 676, 246, 369, 970, 294, 750, 807, 827, 150, 790, 288, 923, 804, 378, 215, 828, 592, 281, 565, 555, 710, 82, 896, 831, 547, 261, 524, 462, 293, 465, 502, 56, 661, 821, 976, 991, 658, 869, 905, 758, 745, 193, 768, 550, 608, 933, 378, 286, 215, 979, 792, 961, 61, 688, 793, 644, 986, 403, 106, 366, 905, 644, 372, 567, 466, 434, 645, 210, 389, 550, 919, 135, 780, 773, 635, 389, 707, 100, 626, 958, 165, 504, 920, 176, 193, 713, 857, 265, 203, 50, 668, 108, 645, 990, 626, 197, 510, 357, 358, 850, 858, 364, 936, 638};

    public Bzip2(InputStream inputStream) throws IOException {
        this(inputStream, false);
    }

    public Bzip2(InputStream inputStream, boolean bl) throws IOException {
        this.in = inputStream;
        this.decompressConcatenated = bl;
        this.init(true);
        this.initBlock();
    }

    @Override
    public int read() throws IOException {
        if (this.in != null) {
            int n = this.read0();
            this.count(n < 0 ? -1 : 1);
            return n;
        }
        throw new IOException("stream closed");
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (n < 0) {
            throw new IndexOutOfBoundsException("offs(" + n + ") < 0.");
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("len(" + n2 + ") < 0.");
        }
        if (n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException("offs(" + n + ") + len(" + n2 + ") > dest.length(" + byArray.length + ").");
        }
        if (this.in == null) {
            throw new IOException("stream closed");
        }
        int n4 = n + n2;
        int n5 = n;
        while (n5 < n4 && (n3 = this.read0()) >= 0) {
            byArray[n5++] = (byte)n3;
            this.count(1);
        }
        int n6 = n5 == n ? -1 : n5 - n;
        return n6;
    }

    private void makeMaps() {
        boolean[] blArray = this.data.inUse;
        byte[] byArray = this.data.seqToUnseq;
        int n = 0;
        for (int i = 0; i < 256; ++i) {
            if (!blArray[i]) continue;
            byArray[n++] = (byte)i;
        }
        this.nInUse = n;
    }

    private int read0() throws IOException {
        switch (this.currentState) {
            case 0: {
                return -1;
            }
            case 1: {
                return this.setupBlock();
            }
            case 2: {
                throw new IllegalStateException();
            }
            case 3: {
                return this.setupRandPartB();
            }
            case 4: {
                return this.setupRandPartC();
            }
            case 5: {
                throw new IllegalStateException();
            }
            case 6: {
                return this.setupNoRandPartB();
            }
            case 7: {
                return this.setupNoRandPartC();
            }
        }
        throw new IllegalStateException();
    }

    private boolean init(boolean bl) throws IOException {
        if (null == this.in) {
            throw new IOException("No InputStream");
        }
        int n = this.in.read();
        if (n == -1 && !bl) {
            return false;
        }
        int n2 = this.in.read();
        int n3 = this.in.read();
        if (n != 66 || n2 != 90 || n3 != 104) {
            throw new IOException(bl ? "Stream is not in the BZip2 format" : "Garbage after a valid BZip2 stream");
        }
        int n4 = this.in.read();
        if (n4 < 49 || n4 > 57) {
            throw new IOException("BZip2 block size is invalid");
        }
        this.blockSize100k = n4 - 48;
        this.bsLive = 0;
        this.computedCombinedCRC = 0;
        return true;
    }

    private void initBlock() throws IOException {
        char c;
        char c2;
        char c3;
        char c4;
        char c5;
        char c6;
        block3: {
            do {
                c6 = this.bsGetUByte();
                c5 = this.bsGetUByte();
                c4 = this.bsGetUByte();
                c3 = this.bsGetUByte();
                c2 = this.bsGetUByte();
                c = this.bsGetUByte();
                if (c6 != '\u0017' || c5 != 'r' || c4 != 'E' || c3 != '8' || c2 != 'P' || c != '\u0090') break block3;
            } while (!this.complete());
            return;
        }
        if (c6 != '1' || c5 != 'A' || c4 != 'Y' || c3 != '&' || c2 != 'S' || c != 'Y') {
            this.currentState = 0;
            throw new IOException("bad block header");
        }
        this.storedBlockCRC = this.bsGetInt();
        boolean bl = this.blockRandomised = this.bsR(1) == 1;
        if (this.data == null) {
            this.data = new Data(this.blockSize100k);
        }
        this.getAndMoveToFrontDecode();
        this.crc.initialiseCRC();
        this.currentState = 1;
    }

    private void endBlock() throws IOException {
        this.computedBlockCRC = this.crc.getFinalCRC();
        if (this.storedBlockCRC != this.computedBlockCRC) {
            this.computedCombinedCRC = this.storedCombinedCRC << 1 | this.storedCombinedCRC >>> 31;
            this.computedCombinedCRC ^= this.storedBlockCRC;
            throw new IOException("BZip2 CRC error");
        }
        this.computedCombinedCRC = this.computedCombinedCRC << 1 | this.computedCombinedCRC >>> 31;
        this.computedCombinedCRC ^= this.computedBlockCRC;
    }

    private boolean complete() throws IOException {
        this.storedCombinedCRC = this.bsGetInt();
        this.currentState = 0;
        this.data = null;
        if (this.storedCombinedCRC != this.computedCombinedCRC) {
            throw new IOException("BZip2 CRC error");
        }
        return !this.decompressConcatenated || !this.init(false);
    }

    @Override
    public void close() throws IOException {
        InputStream inputStream = this.in;
        if (inputStream != null) {
            try {
                if (inputStream != System.in) {
                    inputStream.close();
                }
            }
            finally {
                this.data = null;
                this.in = null;
            }
        }
    }

    private int bsR(int n) throws IOException {
        int n2 = this.bsLive;
        int n3 = this.bsBuff;
        if (n2 < n) {
            InputStream inputStream = this.in;
            do {
                int n4;
                if ((n4 = inputStream.read()) < 0) {
                    throw new IOException("unexpected end of stream");
                }
                n3 = n3 << 8 | n4;
            } while ((n2 += 8) < n);
            this.bsBuff = n3;
        }
        this.bsLive = n2 - n;
        return n3 >> n2 - n & (1 << n) - 1;
    }

    private boolean bsGetBit() throws IOException {
        int n = this.bsLive;
        int n2 = this.bsBuff;
        if (n < 1) {
            int n3 = this.in.read();
            if (n3 < 0) {
                throw new IOException("unexpected end of stream");
            }
            n2 = n2 << 8 | n3;
            n += 8;
            this.bsBuff = n2;
        }
        this.bsLive = n - 1;
        return (n2 >> n - 1 & 1) != 0;
    }

    private char bsGetUByte() throws IOException {
        return (char)this.bsR(8);
    }

    private int bsGetInt() throws IOException {
        return ((this.bsR(8) << 8 | this.bsR(8)) << 8 | this.bsR(8)) << 8 | this.bsR(8);
    }

    private static void hbCreateDecodeTables(int[] nArray, int[] nArray2, int[] nArray3, char[] cArray, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = 0;
        for (n5 = n; n5 <= n2; ++n5) {
            for (n4 = 0; n4 < n3; ++n4) {
                if (cArray[n4] != n5) continue;
                nArray3[n6++] = n4;
            }
        }
        n5 = MAX_CODE_LEN;
        while (--n5 > 0) {
            nArray2[n5] = 0;
            nArray[n5] = 0;
        }
        for (n5 = 0; n5 < n3; ++n5) {
            int n7 = cArray[n5] + '\u0001';
            nArray2[n7] = nArray2[n7] + 1;
        }
        n6 = nArray2[0];
        for (n5 = 1; n5 < MAX_CODE_LEN; ++n5) {
            nArray2[n5] = n6 += nArray2[n5];
        }
        n6 = 0;
        n4 = nArray2[n5];
        for (n5 = n; n5 <= n2; ++n5) {
            int n8 = nArray2[n5 + 1];
            n4 = n8;
            nArray[n5] = (n6 += n8 - n4) - 1;
            n6 <<= 1;
        }
        for (n5 = n + 1; n5 <= n2; ++n5) {
            nArray2[n5] = (nArray[n5 - 1] + 1 << 1) - nArray2[n5];
        }
    }

    private void recvDecodingTables() throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Data data = this.data;
        boolean[] blArray = data.inUse;
        byte[] byArray = data.recvDecodingTables_pos;
        byte[] byArray2 = data.selector;
        byte[] byArray3 = data.selectorMtf;
        int n7 = 0;
        for (n6 = 0; n6 < 16; ++n6) {
            if (!this.bsGetBit()) continue;
            n7 |= 1 << n6;
        }
        n6 = 256;
        while (--n6 >= 0) {
            blArray[n6] = false;
        }
        for (n6 = 0; n6 < 16; ++n6) {
            if ((n7 & 1 << n6) == 0) continue;
            n5 = n6 << 4;
            for (n4 = 0; n4 < 16; ++n4) {
                if (!this.bsGetBit()) continue;
                blArray[n5 + n4] = true;
            }
        }
        this.makeMaps();
        n6 = this.nInUse + 2;
        n5 = this.bsR(3);
        n4 = this.bsR(15);
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = 0;
            while (this.bsGetBit()) {
                ++n2;
            }
            byArray3[n3] = (byte)n2;
        }
        n3 = n5;
        while (--n3 >= 0) {
            byArray[n3] = (byte)n3;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            n = byArray[n2];
            for (n2 = byArray3[n3] & 0xFF; n2 > 0; --n2) {
                byArray[n2] = byArray[n2 - 1];
            }
            byArray[0] = n;
            byArray2[n3] = n;
        }
        char[][] cArray = data.temp_charArray2d;
        for (n2 = 0; n2 < n5; ++n2) {
            n = this.bsR(5);
            char[] cArray2 = cArray[n2];
            for (int i = 0; i < n6; ++i) {
                while (this.bsGetBit()) {
                    n += this.bsGetBit() ? -1 : 1;
                }
                cArray2[i] = (char)n;
            }
        }
        this.createHuffmanDecodingTables(n6, n5);
    }

    private void createHuffmanDecodingTables(int n, int n2) {
        Data data = this.data;
        char[][] cArray = data.temp_charArray2d;
        int[] nArray = data.minLens;
        int[][] nArray2 = data.limit;
        int[][] nArray3 = data.base;
        int[][] nArray4 = data.perm;
        for (int i = 0; i < n2; ++i) {
            int n3 = 32;
            int n4 = 0;
            char[] cArray2 = cArray[i];
            int n5 = n;
            while (--n5 >= 0) {
                int n6 = cArray2[n5];
                if (n6 > n4) {
                    n4 = n6;
                }
                if (n6 >= n3) continue;
                n3 = n6;
            }
            Bzip2.hbCreateDecodeTables(nArray2[i], nArray3[i], nArray4[i], cArray[i], n3, n4, n);
            nArray[i] = n3;
        }
    }

    private void getAndMoveToFrontDecode() throws IOException {
        this.origPtr = this.bsR(24);
        this.recvDecodingTables();
        InputStream inputStream = this.in;
        Data data = this.data;
        byte[] byArray = data.ll8;
        int[] nArray = data.unzftab;
        byte[] byArray2 = data.selector;
        byte[] byArray3 = data.seqToUnseq;
        char[] cArray = data.getAndMoveToFrontDecode_yy;
        int[] nArray2 = data.minLens;
        int[][] nArray3 = data.limit;
        int[][] nArray4 = data.base;
        int[][] nArray5 = data.perm;
        int n = this.blockSize100k * 100000;
        int n2 = 256;
        while (--n2 >= 0) {
            cArray[n2] = (char)n2;
            nArray[n2] = 0;
        }
        n2 = 0;
        int n3 = G_SIZE - 1;
        int n4 = this.nInUse + 1;
        int n5 = this.getAndMoveToFrontDecode0(0);
        int n6 = this.bsBuff;
        int n7 = this.bsLive;
        int n8 = -1;
        int n9 = byArray2[n2] & 0xFF;
        int[] nArray6 = nArray4[n9];
        int[] nArray7 = nArray3[n9];
        int[] nArray8 = nArray5[n9];
        int n10 = nArray2[n9];
        while (n5 != n4) {
            int n11;
            int n12;
            int n13;
            int n14;
            if (n5 == RUNA || n5 == RUNB) {
                n14 = -1;
                n13 = 1;
                while (true) {
                    if (n5 == RUNA) {
                        n14 += n13;
                    } else {
                        if (n5 != RUNB) break;
                        n14 += n13 << 1;
                    }
                    if (n3 == 0) {
                        n3 = G_SIZE - 1;
                        n9 = byArray2[++n2] & 0xFF;
                        nArray6 = nArray4[n9];
                        nArray7 = nArray3[n9];
                        nArray8 = nArray5[n9];
                        n10 = nArray2[n9];
                    } else {
                        --n3;
                    }
                    n12 = n10;
                    while (n7 < n12) {
                        n11 = inputStream.read();
                        if (n11 >= 0) {
                            n6 = n6 << 8 | n11;
                            n7 += 8;
                            continue;
                        }
                        throw new IOException("unexpected end of stream");
                    }
                    n11 = n6 >> n7 - n12 & (1 << n12) - 1;
                    n7 -= n12;
                    while (n11 > nArray7[n12]) {
                        ++n12;
                        while (n7 < 1) {
                            int n15 = inputStream.read();
                            if (n15 >= 0) {
                                n6 = n6 << 8 | n15;
                                n7 += 8;
                                continue;
                            }
                            throw new IOException("unexpected end of stream");
                        }
                        n11 = n11 << 1 | n6 >> --n7 & 1;
                    }
                    n5 = nArray8[n11 - nArray6[n12]];
                    n13 <<= 1;
                }
                n13 = byArray3[cArray[0]];
                int n16 = n13 & 0xFF;
                nArray[n16] = nArray[n16] + (n14 + 1);
                while (n14-- >= 0) {
                    byArray[++n8] = n13;
                }
                if (n8 < n) continue;
                throw new IOException("block overrun");
            }
            if (++n8 >= n) {
                throw new IOException("block overrun");
            }
            n14 = cArray[n5 - 1];
            int n17 = byArray3[n14] & 0xFF;
            nArray[n17] = nArray[n17] + 1;
            byArray[n8] = byArray3[n14];
            if (n5 <= 16) {
                n13 = n5 - 1;
                while (n13 > 0) {
                    cArray[n13--] = cArray[n13];
                }
            } else {
                System.arraycopy(cArray, 0, cArray, 1, n5 - 1);
            }
            cArray[0] = n14;
            if (n3 == 0) {
                n3 = G_SIZE - 1;
                n9 = byArray2[++n2] & 0xFF;
                nArray6 = nArray4[n9];
                nArray7 = nArray3[n9];
                nArray8 = nArray5[n9];
                n10 = nArray2[n9];
            } else {
                --n3;
            }
            n13 = n10;
            while (n7 < n13) {
                n12 = inputStream.read();
                if (n12 >= 0) {
                    n6 = n6 << 8 | n12;
                    n7 += 8;
                    continue;
                }
                throw new IOException("unexpected end of stream");
            }
            n12 = n6 >> n7 - n13 & (1 << n13) - 1;
            n7 -= n13;
            while (n12 > nArray7[n13]) {
                ++n13;
                while (n7 < 1) {
                    n11 = inputStream.read();
                    if (n11 >= 0) {
                        n6 = n6 << 8 | n11;
                        n7 += 8;
                        continue;
                    }
                    throw new IOException("unexpected end of stream");
                }
                n12 = n12 << 1 | n6 >> --n7 & 1;
            }
            n5 = nArray8[n12 - nArray6[n13]];
        }
        this.last = n8;
        this.bsLive = n7;
        this.bsBuff = n6;
    }

    private int getAndMoveToFrontDecode0(int n) throws IOException {
        InputStream inputStream = this.in;
        Data data = this.data;
        int n2 = data.selector[n] & 0xFF;
        int[] nArray = data.limit[n2];
        int n3 = data.minLens[n2];
        int n4 = this.bsR(n3);
        int n5 = this.bsLive;
        int n6 = this.bsBuff;
        while (n4 > nArray[n3]) {
            ++n3;
            while (n5 < 1) {
                int n7 = inputStream.read();
                if (n7 >= 0) {
                    n6 = n6 << 8 | n7;
                    n5 += 8;
                    continue;
                }
                throw new IOException("unexpected end of stream");
            }
            n4 = n4 << 1 | n6 >> --n5 & 1;
        }
        this.bsLive = n5;
        this.bsBuff = n6;
        return data.perm[n2][n4 - data.base[n2][n3]];
    }

    private int setupBlock() throws IOException {
        int n;
        if (this.currentState == 0 || this.data == null) {
            return -1;
        }
        int[] nArray = this.data.cftab;
        int[] nArray2 = this.data.initTT(this.last + 1);
        byte[] byArray = this.data.ll8;
        nArray[0] = 0;
        System.arraycopy(this.data.unzftab, 0, nArray, 1, 256);
        int n2 = nArray[0];
        for (n = 1; n <= 256; ++n) {
            nArray[n] = n2 += nArray[n];
        }
        n = 0;
        n2 = this.last;
        while (n <= n2) {
            int n3 = byArray[n] & 0xFF;
            int n4 = nArray[n3];
            nArray[n3] = n4 + 1;
            nArray2[n4] = n++;
        }
        if (this.origPtr < 0 || this.origPtr >= nArray2.length) {
            throw new IOException("stream corrupted");
        }
        this.su_tPos = nArray2[this.origPtr];
        this.su_count = 0;
        this.su_i2 = 0;
        this.su_ch2 = 256;
        if (this.blockRandomised) {
            this.su_rNToGo = 0;
            this.su_rTPos = 0;
            return this.setupRandPartA();
        }
        return this.setupNoRandPartA();
    }

    private int setupRandPartA() throws IOException {
        if (this.su_i2 <= this.last) {
            this.su_chPrev = this.su_ch2;
            int n = this.data.ll8[this.su_tPos] & 0xFF;
            this.su_tPos = this.data.tt[this.su_tPos];
            if (this.su_rNToGo == 0) {
                this.su_rNToGo = RNUMS[this.su_rTPos] - 1;
                if (++this.su_rTPos == 512) {
                    this.su_rTPos = 0;
                }
            } else {
                --this.su_rNToGo;
            }
            this.su_ch2 = n ^= this.su_rNToGo == 1 ? 1 : 0;
            ++this.su_i2;
            this.currentState = 3;
            this.crc.updateCRC(n);
            return n;
        }
        this.endBlock();
        this.initBlock();
        return this.setupBlock();
    }

    private int setupNoRandPartA() throws IOException {
        if (this.su_i2 <= this.last) {
            int n;
            this.su_chPrev = this.su_ch2;
            this.su_ch2 = n = this.data.ll8[this.su_tPos] & 0xFF;
            this.su_tPos = this.data.tt[this.su_tPos];
            ++this.su_i2;
            this.currentState = 6;
            this.crc.updateCRC(n);
            return n;
        }
        this.currentState = 5;
        this.endBlock();
        this.initBlock();
        return this.setupBlock();
    }

    private int setupRandPartB() throws IOException {
        if (this.su_ch2 != this.su_chPrev) {
            this.currentState = 2;
            this.su_count = 1;
            return this.setupRandPartA();
        }
        if (++this.su_count >= 4) {
            this.su_z = (char)(this.data.ll8[this.su_tPos] & 0xFF);
            this.su_tPos = this.data.tt[this.su_tPos];
            if (this.su_rNToGo == 0) {
                this.su_rNToGo = RNUMS[this.su_rTPos] - 1;
                if (++this.su_rTPos == 512) {
                    this.su_rTPos = 0;
                }
            } else {
                --this.su_rNToGo;
            }
            this.su_j2 = 0;
            this.currentState = 4;
            if (this.su_rNToGo == 1) {
                this.su_z = (char)(this.su_z ^ '\u0001');
            }
            return this.setupRandPartC();
        }
        this.currentState = 2;
        return this.setupRandPartA();
    }

    private int setupRandPartC() throws IOException {
        if (this.su_j2 < this.su_z) {
            this.crc.updateCRC(this.su_ch2);
            ++this.su_j2;
            return this.su_ch2;
        }
        this.currentState = 2;
        ++this.su_i2;
        this.su_count = 0;
        return this.setupRandPartA();
    }

    private int setupNoRandPartB() throws IOException {
        if (this.su_ch2 != this.su_chPrev) {
            this.su_count = 1;
            return this.setupNoRandPartA();
        }
        if (++this.su_count >= 4) {
            this.su_z = (char)(this.data.ll8[this.su_tPos] & 0xFF);
            this.su_tPos = this.data.tt[this.su_tPos];
            this.su_j2 = 0;
            return this.setupNoRandPartC();
        }
        return this.setupNoRandPartA();
    }

    private int setupNoRandPartC() throws IOException {
        if (this.su_j2 < this.su_z) {
            int n = this.su_ch2;
            this.crc.updateCRC(n);
            ++this.su_j2;
            this.currentState = 7;
            return n;
        }
        ++this.su_i2;
        this.su_count = 0;
        return this.setupNoRandPartA();
    }

    public static boolean matches(byte[] byArray, int n) {
        if (n < 3) {
            return false;
        }
        if (byArray[0] != 66) {
            return false;
        }
        if (byArray[1] != 90) {
            return false;
        }
        return byArray[2] == 104;
    }

    protected void count(int n) {
        this.count((long)n);
    }

    protected void count(long l) {
        if (l != -1L) {
            this.bytesRead += l;
        }
    }

    protected void pushedBackBytes(long l) {
        this.bytesRead -= l;
    }

    @Deprecated
    public int getCount() {
        return (int)this.bytesRead;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    class CRC {
        private int globalCrc;

        CRC() {
            this.initialiseCRC();
        }

        void initialiseCRC() {
            this.globalCrc = -1;
        }

        int getFinalCRC() {
            return ~this.globalCrc;
        }

        int getGlobalCRC() {
            return this.globalCrc;
        }

        void setGlobalCRC(int n) {
            this.globalCrc = n;
        }

        void updateCRC(int n) {
            int n2 = this.globalCrc >> 24 ^ n;
            if (n2 < 0) {
                n2 = 256 + n2;
            }
            this.globalCrc = this.globalCrc << 8 ^ crc32Table[n2];
        }

        void updateCRC(int n, int n2) {
            int n3 = this.globalCrc;
            while (n2-- > 0) {
                int n4 = n3 >> 24 ^ n;
                n3 = n3 << 8 ^ crc32Table[n4 >= 0 ? n4 : n4 + 256];
            }
            this.globalCrc = n3;
        }
    }

    private static final class Data {
        final boolean[] inUse = new boolean[256];
        final byte[] seqToUnseq = new byte[256];
        final byte[] selector = new byte[MAX_SELECTORS];
        final byte[] selectorMtf = new byte[MAX_SELECTORS];
        final int[] unzftab = new int[256];
        final int[][] limit = new int[N_GROUPS][MAX_ALPHA_SIZE];
        final int[][] base = new int[N_GROUPS][MAX_ALPHA_SIZE];
        final int[][] perm = new int[N_GROUPS][MAX_ALPHA_SIZE];
        final int[] minLens = new int[N_GROUPS];
        final int[] cftab = new int[257];
        final char[] getAndMoveToFrontDecode_yy = new char[256];
        final char[][] temp_charArray2d = new char[N_GROUPS][MAX_ALPHA_SIZE];
        final byte[] recvDecodingTables_pos = new byte[N_GROUPS];
        int[] tt;
        byte[] ll8;

        Data(int n) {
            this.ll8 = new byte[n * BASEBLOCKSIZE];
        }

        int[] initTT(int n) {
            int[] nArray = this.tt;
            if (nArray == null || nArray.length < n) {
                this.tt = nArray = new int[n];
            }
            return nArray;
        }
    }
}

