/*
 * Decompiled with CFR 0.152.
 */
package cds.image;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.io.PrintStream;
import java.text.AttributedCharacterIterator;
import java.text.SimpleDateFormat;
import java.util.Date;

public class EPSGraphics
extends Graphics {
    private PrintStream out;
    private Image preview;
    private String title;
    private int xmin;
    private int ymin;
    private int xmax;
    private int ymax;
    private int height;
    private int mode = 0;
    private int size;
    static final int STROKE = 0;
    static final int FILL = 1;
    static final int CLIP = 2;
    private Font font = new Font("Helvetica", 0, 10);
    private Color color = Color.black;
    private String HEX = "0123456789abcdef";

    public EPSGraphics(PrintStream printStream, String string, Image image, int n, int n2, int n3, int n4) {
        this.out = printStream;
        this.title = string;
        this.xmin = n;
        this.ymin = n2;
        this.xmax = n3;
        this.ymax = n4;
        this.height = n4 - n2;
        this.preview = image;
        this.head();
    }

    public void end() {
        this.tail();
        this.out.flush();
    }

    private void flushIfRequired(int n) {
        this.size += n;
        if (this.size > 10000) {
            this.out.flush();
            this.size = 0;
        }
    }

    private void print(String string) {
        this.out.print(string);
        this.flushIfRequired(string.length());
    }

    private void print(char c) {
        this.out.print(c);
        this.flushIfRequired(1);
    }

    private void head() {
        String string = new SimpleDateFormat("dd/MM/yyyy HH:mm").format(new Date(System.currentTimeMillis()));
        this.print("%!PS-Adobe-3.0 EPSF-3.0\n%%BoundingBox: " + this.xmin + " " + this.ymin + " " + this.xmax + " " + this.ymax + "\n%%Creator: Aladin [CDS]\n%%Title: " + this.title + "\n%%CreationDate: " + string + "\n%%LanguageLevel: 2\n%%EndComments\n");
        if (this.preview != null) {
            this.preview(this.preview);
        }
        this.print("0.5 setlinewidth\n0 setlinejoin\n/Helvetica findfont 10 scalefont setfont\n/l { newpath moveto lineto stroke } def\n/t { newpath moveto show } def\n");
        this.clipRect(this.xmin, this.ymin, this.xmax - this.xmin + 1, this.ymax - this.ymin + 1);
    }

    private void preview(Image image) {
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        int n3 = 8;
        int n4 = n2 * (n / 36 + (n % 36 != 0 ? 1 : 0));
        this.print("%%BeginPreview: " + n + " " + n2 + " " + n3 + " " + n4 + "\n");
        try {
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, true);
            pixelGrabber.grabPixels();
            int[] nArray = (int[])pixelGrabber.getPixels();
            for (int i = n2 - 1; i >= 0; --i) {
                this.writePixelsPreviewHexStr(nArray, i * n, n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.print("%%EndPreview\n");
    }

    private void tail() {
        this.print("0 0 0 setrgbcolor\nnewpath\n" + this.xmin + " " + this.ymin + " moveto\n" + this.xmin + " " + this.ymax + " lineto\n" + this.xmax + " " + this.ymax + " lineto\n" + this.xmax + " " + this.ymin + " lineto\nclosepath\n1 setlinewidth\nstroke\nshowpage\n%%EOF\n");
    }

    @Override
    public void clearRect(int n, int n2, int n3, int n4) {
        this.setColor(Color.white);
        this.fillRect(n, n2, n3, n4);
        this.setColor(this.color);
    }

    @Override
    public void clipRect(int n, int n2, int n3, int n4) {
        this.mode = 2;
        this.drawRect(n, n2, n3, n4);
        this.mode = 0;
    }

    @Override
    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    @Override
    public Graphics create() {
        return null;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.drawArc1((double)n + (double)n3 / 2.0, (double)n2 + (double)n4 / 2.0, n3, n4, n5, n6, 0.0);
    }

    public void drawEllipse(double d, double d2, double d3, double d4, double d5) {
        this.drawArc1(d, d2, d3 * 2.0, d4 * 2.0, 0.0, 360.0, d5);
    }

    private void drawArc1(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = d3 / 2.0;
        double d9 = d4 / d3;
        d5 += 180.0;
        d7 = 180.0 - d7;
        d2 = (double)this.height - d2;
        this.print("gsave\n" + d + " " + d2 + " translate\n");
        if (d7 != 0.0) {
            this.print(d7 + " rotate\n");
        }
        if (!Double.isNaN(d9) && d9 != 1.0) {
            this.print("1 " + d9 + " scale\n");
        }
        this.print("newpath\n0 0 " + d8 + " " + d5 + " " + (d6 + d5) + " arc " + (this.mode == 1 ? "fill" : "stroke") + "\ngrestore\n");
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        try {
            int n3 = image.getWidth(imageObserver);
            int n4 = image.getHeight(imageObserver);
            int n5 = this.xmax - this.xmin + 1;
            int n6 = this.ymax - this.ymin + 1;
            if (n3 > n5) {
                n3 = n5;
            }
            if (n4 > n6) {
                n4 = n6;
            }
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n3, n4, true);
            pixelGrabber.grabPixels();
            int[] nArray = (int[])pixelGrabber.getPixels();
            this.print("gsave\n" + n3 + " " + n4 + " scale\n" + n + " " + n2 + " translate\n" + n3 + " " + n4 + " 8 [" + n3 + " 0 0 " + n4 + " 0 0]\n{ currentfile " + 3 * n3 + " string readhexstring pop } bind\nfalse 3 colorimage\n");
            for (int i = n4 - 1; i >= 0; --i) {
                this.writePixelsHexStr(nArray, i * n3, n3);
            }
            this.print("grestore\n");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return false;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return false;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        return false;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return false;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        return false;
    }

    private void writePixelsHexStr(int[] nArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            if (i > 0 && i % 24 == 0) {
                this.out.println();
            }
            int n3 = nArray[n + i] >> 16 & 0xFF;
            int n4 = nArray[n + i] >> 8 & 0xFF;
            int n5 = nArray[n + i] & 0xFF;
            this.print(this.HEX.charAt(n3 / 16));
            this.print(this.HEX.charAt(n3 % 16));
            this.print(this.HEX.charAt(n4 / 16));
            this.print(this.HEX.charAt(n4 % 16));
            this.print(this.HEX.charAt(n5 / 16));
            this.print(this.HEX.charAt(n5 % 16));
        }
        if (n2 % 72 != 0) {
            this.out.println();
        }
    }

    private void writePixelsPreviewHexStr(int[] nArray, int n, int n2) {
        this.print('%');
        for (int i = 0; i < n2; ++i) {
            if (i > 0 && i % 36 == 0 && i != n2 - 1) {
                this.print("\n%");
            }
            int n3 = nArray[n + i] >> 16 & 0xFF;
            int n4 = nArray[n + i] >> 8 & 0xFF;
            int n5 = nArray[n + i] & 0xFF;
            n3 = (n3 + n4 + n5) / 3;
            this.print(this.HEX.charAt(n3 / 16));
            this.print(this.HEX.charAt(n3 % 16));
        }
        this.out.println();
    }

    @Override
    public void drawLine(int n, int n2, int n3, int n4) {
        this.print(n + " " + (this.height - n2 - 1) + " " + n3 + " " + (this.height - n4 - 1) + " l\n");
    }

    @Override
    public void drawOval(int n, int n2, int n3, int n4) {
        this.drawArc(n, n2, n3, n4, 0, 360);
    }

    @Override
    public void drawPolygon(Polygon polygon) {
        this.drawPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    @Override
    public void fillPolygon(Polygon polygon) {
        this.fillPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    @Override
    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        this.drawPolygon(nArray, nArray2, n, false);
    }

    @Override
    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.drawPolygon(nArray, nArray2, n, true);
    }

    private void drawPolygon(int[] nArray, int[] nArray2, int n, boolean bl) {
        this.print("newpath\n");
        for (int i = 0; i < n; ++i) {
            if (i == 0) {
                this.print(nArray[i] + " " + (this.height - nArray2[i] - 1) + " moveto\n");
                continue;
            }
            this.print(nArray[i] + " " + (this.height - nArray2[i] - 1) + " lineto\n");
        }
        if (n > 0 && bl) {
            this.print(nArray[0] + " " + (this.height - nArray2[0] - 1) + " lineto\n");
        }
        this.print("closepath\n" + (this.mode == 0 ? "stroke" : (this.mode == 2 ? "clip" : "fill")) + "\n");
    }

    @Override
    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.drawRect(n, n2, n3, n4);
    }

    @Override
    public void drawString(String string, int n, int n2) {
        if (string.indexOf(40) >= 0 || string.indexOf(41) >= 0) {
            char[] cArray = string.toCharArray();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < cArray.length; ++i) {
                char c = cArray[i];
                if (c == '(' || c == ')') {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(c);
            }
            string = stringBuffer.toString();
        }
        this.print("(" + string + ") " + n + " " + (this.height - n2 - 1) + "  t\n");
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
    }

    @Override
    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.mode = 1;
        this.drawArc(n, n2, n3, n4, n5, n6);
        this.mode = 0;
    }

    @Override
    public void fillOval(int n, int n2, int n3, int n4) {
        this.mode = 1;
        this.drawOval(n, n2, n3, n4);
        this.mode = 0;
    }

    @Override
    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.mode = 1;
        this.drawPolygon(nArray, nArray2, n);
        this.mode = 0;
    }

    @Override
    public void drawRect(int n, int n2, int n3, int n4) {
        n2 = this.height - n2 - 1;
        int n5 = n + n3 - 1;
        int n6 = n2 - n4 + 1;
        this.print("newpath\n" + n + " " + n2 + " moveto\n" + n + " " + n6 + " lineto\n" + n5 + " " + n6 + " lineto\n" + n5 + " " + n2 + " lineto\nclosepath\n" + (this.mode == 0 ? "stroke" : (this.mode == 2 ? "clip" : "fill")) + "\n");
    }

    @Override
    public void fillRect(int n, int n2, int n3, int n4) {
        this.mode = 1;
        this.drawRect(n, n2, n3, n4);
        this.mode = 0;
    }

    @Override
    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    @Override
    public Shape getClip() {
        return null;
    }

    @Override
    public Rectangle getClipBounds() {
        return null;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    @Override
    public void setClip(Shape shape) {
    }

    @Override
    public void setClip(int n, int n2, int n3, int n4) {
    }

    @Override
    public void setColor(Color color) {
        if (color == null || color == this.color) {
            return;
        }
        double d = (double)color.getRed() / 256.0;
        double d2 = (double)color.getGreen() / 256.0;
        double d3 = (double)color.getBlue() / 256.0;
        this.print(d + " " + d2 + " " + d3 + " setrgbcolor\n");
        this.color = color;
    }

    @Override
    public void setFont(Font font) {
        int n;
        this.font = font;
        String string = "Italic";
        String string2 = font.getName();
        if (string2.equals("Serif")) {
            string2 = "Times-Roman";
        } else if (string2.equals("Monospaced")) {
            string2 = "Courrier";
        } else if (string2.equals("SansSerif")) {
            string2 = "Helvetica";
        }
        if (string2.indexOf("Courier") >= 0 || string2.indexOf("Helvetica") >= 0) {
            string = "Oblique";
        }
        if (((n = font.getStyle()) & 1) == 1) {
            string2 = string2 + "-Bold";
        }
        if ((n & 2) == 2) {
            string2 = string2 + "-" + string;
        }
        this.print("/" + string2 + " findfont " + font.getSize() + " scalefont setfont\n");
    }

    @Override
    public void setPaintMode() {
    }

    @Override
    public void setXORMode(Color color) {
    }

    @Override
    public void translate(int n, int n2) {
        this.print(n + " " + n2 + " translate\n");
    }
}

