/*
 * Decompiled with CFR 0.152.
 */
package cds.image;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public final class Hdecomp {
    private static int SIZEBUF = 8192;
    private static byte[] buf = new byte[SIZEBUF];
    private static int ptBuf = 0;
    private static int maxBuf = 0;
    private static InputStream dis;
    private static double log2;
    private static int[] code_magic;
    private static int nx;
    private static int ny;
    private static int nel;
    private static int scale;
    private static int[] a;
    private static int buffer;
    private static int bits_to_go;
    private static int[] nbitplanes;

    public static byte[] decomp(InputStream inputStream) throws Exception {
        dis = inputStream;
        Hdecomp.decode();
        Hdecomp.undigitize();
        Hdecomp.hinv();
        return Hdecomp.getPixels();
    }

    private static byte[] getPixels() {
        byte[] byArray = new byte[nel * 2];
        int n = 0;
        for (int i = 0; i < byArray.length; i += 2) {
            byArray[i] = (byte)(a[n] >> 8 & 0xFF);
            byArray[i + 1] = (byte)(a[n++] & 0xFF);
        }
        return byArray;
    }

    private static int getc() throws Exception {
        while (ptBuf == maxBuf) {
            ptBuf = 0;
            maxBuf = dis.read(buf, 0, buf.length);
            if (maxBuf != -1) continue;
            throw new EOFException();
        }
        return buf[ptBuf++] & 0xFF;
    }

    private static int getint() throws Exception {
        return Hdecomp.getc() << 24 | Hdecomp.getc() << 16 | Hdecomp.getc() << 8 | Hdecomp.getc();
    }

    private static void start_inputing_bits() {
        bits_to_go = 0;
    }

    private static int input_bit() throws Exception {
        if (bits_to_go == 0) {
            buffer = Hdecomp.getc();
            bits_to_go = 8;
        }
        return buffer >> --bits_to_go & 1;
    }

    private static int input_nbits(int n) throws Exception {
        if (bits_to_go < n) {
            buffer <<= 8;
            buffer |= Hdecomp.getc();
            bits_to_go += 8;
        }
        return buffer >> (bits_to_go -= n) & (1 << n) - 1;
    }

    private static int input_huffman() throws Exception {
        int n = Hdecomp.input_nbits(3);
        if (n < 4) {
            return 1 << n;
        }
        n = Hdecomp.input_bit() | n << 1;
        if (n < 13) {
            switch (n) {
                case 8: {
                    return 3;
                }
                case 9: {
                    return 5;
                }
                case 10: {
                    return 10;
                }
                case 11: {
                    return 12;
                }
                case 12: {
                    return 15;
                }
            }
        }
        if ((n = Hdecomp.input_bit() | n << 1) < 31) {
            switch (n) {
                case 26: {
                    return 6;
                }
                case 27: {
                    return 7;
                }
                case 28: {
                    return 9;
                }
                case 29: {
                    return 11;
                }
                case 30: {
                    return 13;
                }
            }
        }
        if ((n = Hdecomp.input_bit() | n << 1) == 62) {
            return 0;
        }
        return 14;
    }

    private static void qtree_bitins(byte[] byArray, int n, int n2, int n3, int n4, int n5) {
        byte by;
        int n6;
        int n7;
        int n8;
        int n9 = n - 1;
        int n10 = n2 - 1;
        int n11 = 0;
        for (n8 = 0; n8 < n9; n8 += 2) {
            n7 = n3 + n4 * n8;
            int n12 = n7 + n4;
            for (n6 = 0; n6 < n10; n6 += 2) {
                by = byArray[n11];
                int n13 = n12 + 1;
                a[n13] = a[n13] | (by & 1) << n5;
                int n14 = n12;
                a[n14] = a[n14] | (by >> 1 & 1) << n5;
                int n15 = n7 + 1;
                a[n15] = a[n15] | (by >> 2 & 1) << n5;
                int n16 = n7;
                a[n16] = a[n16] | (by >> 3 & 1) << n5;
                n7 += 2;
                n12 += 2;
                ++n11;
            }
            if (n6 >= n2) continue;
            by = byArray[n11];
            int n17 = n12;
            a[n17] = a[n17] | (by >> 1 & 1) << n5;
            int n18 = n7;
            a[n18] = a[n18] | (by >> 3 & 1) << n5;
            ++n11;
        }
        if (n8 < n) {
            n7 = n3 + n4 * n8;
            for (n6 = 0; n6 < n10; n6 += 2) {
                by = byArray[n11];
                int n19 = n7 + 1;
                a[n19] = a[n19] | (by >> 2 & 1) << n5;
                int n20 = n7;
                a[n20] = a[n20] | (by >> 3 & 1) << n5;
                n7 += 2;
                ++n11;
            }
            if (n6 < n2) {
                int n21 = n7;
                a[n21] = a[n21] | (byArray[n11] >> 3 & 1) << n5;
                ++n11;
            }
        }
    }

    private static void read_bdirect(int n, int n2, int n3, int n4, byte[] byArray, int n5) throws Exception {
        int n6 = (n3 + 1) / 2 * ((n4 + 1) / 2);
        for (int i = 0; i < n6; ++i) {
            byArray[i] = (byte)Hdecomp.input_nbits(4);
        }
        Hdecomp.qtree_bitins(byArray, n3, n4, n, n2, n5);
    }

    private static void qtree_copy(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        byte by;
        int n4;
        int n5;
        int n6;
        int n7 = n - 1;
        int n8 = n2 - 1;
        int n9 = (n + 1) / 2;
        int n10 = (n2 + 1) / 2;
        int n11 = n10 * (n9 - 1) + n10 - 1;
        for (n6 = n9 - 1; n6 >= 0; --n6) {
            n5 = n3 * n6 + n10 - 1 << 1;
            for (n4 = n10 - 1; n4 >= 0; --n4) {
                byArray2[n5] = byArray[n11--];
                n5 -= 2;
            }
        }
        for (n6 = 0; n6 < n7; n6 += 2) {
            n5 = n3 * n6;
            int n12 = n5 + n3;
            for (n4 = 0; n4 < n8; n4 += 2) {
                by = byArray2[n5];
                byArray2[n12 + 1] = (byte)(by & 1);
                byArray2[n12] = (byte)(by >> 1 & 1);
                byArray2[n5 + 1] = (byte)(by >> 2 & 1);
                byArray2[n5] = (byte)(by >> 3 & 1);
                n5 += 2;
                n12 += 2;
            }
            if (n4 >= n2) continue;
            by = byArray2[n5];
            byArray2[n12] = (byte)(by >> 1 & 1);
            byArray2[n5] = (byte)(by >> 3 & 1);
        }
        if (n6 < n) {
            n5 = n3 * n6;
            for (n4 = 0; n4 < n8; n4 += 2) {
                by = byArray2[n5];
                byArray2[n5 + 1] = (byte)(by >> 2 & 1);
                byArray2[n5] = (byte)(by >> 3 & 1);
                n5 += 2;
            }
            if (n4 < n2) {
                byArray2[n5] = (byte)(byArray2[n5] >> 3 & 1);
            }
        }
    }

    private static void qtree_expand(byte[] byArray, int n, int n2, byte[] byArray2) throws Exception {
        Hdecomp.qtree_copy(byArray, n, n2, byArray2, n2);
        for (int i = n * n2 - 1; i >= 0; --i) {
            if (byArray2[i] == 0) continue;
            byArray2[i] = (byte)Hdecomp.input_huffman();
        }
    }

    private static void qtree_decode(int n, int n2, int n3, int n4, int n5) throws Exception {
        int n6;
        int n7 = n3 > n4 ? n3 : n4;
        if (n7 > 1 << (n6 = (int)(Math.log(n7) / log2 + 0.5))) {
            ++n6;
        }
        int n8 = (n3 + 1) / 2;
        int n9 = (n4 + 1) / 2;
        byte[] byArray = new byte[n8 * n9];
        for (int i = n5 - 1; i >= 0; --i) {
            int n10 = Hdecomp.input_nbits(4);
            if (n10 == 0) {
                Hdecomp.read_bdirect(n, n2, n3, n4, byArray, i);
                continue;
            }
            if (n10 != 15) {
                throw new Exception("qtree_decode: bad format code " + n10);
            }
            byArray[0] = (byte)Hdecomp.input_huffman();
            int n11 = 1;
            int n12 = 1;
            int n13 = n3;
            int n14 = n4;
            int n15 = 1 << n6;
            for (int j = 1; j < n6; ++j) {
                n11 <<= 1;
                n12 <<= 1;
                if (n13 <= (n15 >>= 1)) {
                    --n11;
                } else {
                    n13 -= n15;
                }
                if (n14 <= n15) {
                    --n12;
                } else {
                    n14 -= n15;
                }
                Hdecomp.qtree_expand(byArray, n11, n12, byArray);
            }
            Hdecomp.qtree_bitins(byArray, n3, n4, n, n2, i);
        }
        byArray = null;
    }

    private static void dodecode() throws Exception {
        int n = (nx + 1) / 2;
        int n2 = (ny + 1) / 2;
        Hdecomp.start_inputing_bits();
        Hdecomp.qtree_decode(0, ny, n, n2, nbitplanes[0]);
        Hdecomp.qtree_decode(n2, ny, n, ny / 2, nbitplanes[1]);
        Hdecomp.qtree_decode(ny * n, ny, nx / 2, n2, nbitplanes[1]);
        Hdecomp.qtree_decode(ny * n + n2, ny, nx / 2, ny / 2, nbitplanes[2]);
        if (Hdecomp.input_nbits(4) != 0) {
            throw new IOException("dodecode: bad bit plane values\n");
        }
        Hdecomp.start_inputing_bits();
        for (int i = 0; i < nel; ++i) {
            int n3 = a[i];
            if (n3 == 0 || Hdecomp.input_bit() == 0) continue;
            Hdecomp.a[i] = -n3;
        }
    }

    private static void decode() throws Exception {
        int n = 0;
        int n2 = 0;
        maxBuf = 0;
        ptBuf = 0;
        n = Hdecomp.getc();
        if (n != code_magic[0] || (n2 = Hdecomp.getc()) != code_magic[1]) {
            throw new Exception("Bad magic number");
        }
        nx = Hdecomp.getint();
        ny = Hdecomp.getint();
        nel = nx * ny;
        scale = Hdecomp.getint();
        a = new int[nel];
        int n3 = Hdecomp.getint();
        Hdecomp.nbitplanes[0] = Hdecomp.getc();
        Hdecomp.nbitplanes[1] = Hdecomp.getc();
        Hdecomp.nbitplanes[2] = Hdecomp.getc();
        Hdecomp.dodecode();
        Hdecomp.a[0] = n3;
    }

    private static void undigitize() {
        if (scale <= 1) {
            return;
        }
        int n = nel - 1;
        while (n >= 0) {
            int n2 = n--;
            a[n2] = a[n2] * scale;
        }
    }

    private static void unshuffle(int n, int n2, int n3, int[] nArray) {
        int n4;
        int n5 = n3 << 1;
        int n6 = n2 + 1 >> 1;
        int n7 = 0;
        int n8 = n + n3 * n6;
        for (n4 = n6; n4 < n2; ++n4) {
            nArray[n7++] = a[n8];
            n8 += n3;
        }
        int n9 = n + n3 * (n6 - 1);
        n8 = n + (n3 * (n6 - 1) << 1);
        for (n4 = n6 - 1; n4 >= 0; --n4) {
            Hdecomp.a[n8] = a[n9];
            n9 -= n3;
            n8 -= n5;
        }
        n7 = 0;
        n8 = n + n3;
        for (n4 = 1; n4 < n2; n4 += 2) {
            Hdecomp.a[n8] = nArray[n7++];
            n8 += n5;
        }
    }

    private static void hinv() {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = nx > ny ? nx : ny;
        if (n7 > 1 << (n = (int)(Math.log(n7) / log2 + 0.5))) {
            ++n;
        }
        int[] nArray = new int[(n7 + 1) / 2];
        int n8 = 1;
        int n9 = 1 << n - 1;
        int n10 = n9 << 1;
        int n11 = n9 << 2;
        int n12 = -n9;
        int n13 = n12 << 1;
        int n14 = n12 << 2;
        int n15 = n9 >> 1;
        int n16 = n10 >> 1;
        int n17 = n11 >> 1;
        int n18 = n15 - 1;
        int n19 = n16 - 1;
        int n20 = n17 - 1;
        Hdecomp.a[0] = a[0] + (a[0] >= 0 ? n17 : n20) & n14;
        int n21 = 1;
        int n22 = 1;
        int n23 = nx;
        int n24 = ny;
        int n25 = 1 << n;
        for (int i = n - 1; i >= 0; --i) {
            int n26;
            int n27;
            int n28;
            int n29;
            n21 <<= 1;
            n22 <<= 1;
            if (n23 <= (n25 >>= 1)) {
                --n21;
            } else {
                n23 -= n25;
            }
            if (n24 <= n25) {
                --n22;
            } else {
                n24 -= n25;
            }
            if (i == 0) {
                n18 = 0;
                n8 = 2;
            }
            for (n29 = 0; n29 < n21; ++n29) {
                Hdecomp.unshuffle(ny * n29, n22, 1, nArray);
            }
            for (n28 = 0; n28 < n22; ++n28) {
                Hdecomp.unshuffle(n28, n21, ny, nArray);
            }
            int n30 = n21 % 2;
            int n31 = n22 % 2;
            for (n29 = 0; n29 < n21 - n30; n29 += 2) {
                n27 = ny * n29;
                int n32 = n27 + ny;
                for (n28 = 0; n28 < n22 - n31; n28 += 2) {
                    n5 = a[n27];
                    n4 = a[n32];
                    n3 = a[n27 + 1];
                    n2 = a[n32 + 1];
                    n4 = n4 + (n4 >= 0 ? n16 : n19) & n13;
                    n3 = n3 + (n3 >= 0 ? n16 : n19) & n13;
                    n2 = n2 + (n2 >= 0 ? n15 : n18) & n12;
                    n6 = n2 & n9;
                    n4 = n4 >= 0 ? n4 - n6 : n4 + n6;
                    n3 = n3 >= 0 ? n3 - n6 : n3 + n6;
                    n26 = (n2 ^ n4 ^ n3) & n10;
                    n5 = n5 >= 0 ? n5 + n6 - n26 : n5 + (n6 == 0 ? n26 : n6 - n26);
                    Hdecomp.a[n32 + 1] = n5 + n4 + n3 + n2 >> n8;
                    Hdecomp.a[n32] = n5 + n4 - n3 - n2 >> n8;
                    Hdecomp.a[n27 + 1] = n5 - n4 + n3 - n2 >> n8;
                    Hdecomp.a[n27] = n5 - n4 - n3 + n2 >> n8;
                    n27 += 2;
                    n32 += 2;
                }
                if (n31 == 0) continue;
                n5 = a[n27];
                n4 = a[n32];
                n4 = (n4 >= 0 ? n4 + n16 : n4 + n19) & n13;
                n26 = n4 & n10;
                n5 = n5 >= 0 ? n5 - n26 : n5 + n26;
                Hdecomp.a[n32] = n5 + n4 >> n8;
                Hdecomp.a[n27] = n5 - n4 >> n8;
            }
            if (n30 != 0) {
                n27 = ny * n29;
                for (n28 = 0; n28 < n22 - n31; n28 += 2) {
                    n5 = a[n27];
                    n3 = a[n27 + 1];
                    n3 = (n3 >= 0 ? n3 + n16 : n3 + n19) & n13;
                    n26 = n3 & n10;
                    n5 = n5 >= 0 ? n5 - n26 : n5 + n26;
                    Hdecomp.a[n27 + 1] = n5 + n3 >> n8;
                    Hdecomp.a[n27] = n5 - n3 >> n8;
                    n27 += 2;
                }
                if (n31 != 0) {
                    n5 = a[n27];
                    Hdecomp.a[n27] = n5 >> n8;
                }
            }
            n11 = n10;
            n10 = n9;
            n9 >>= 1;
            n13 = n12;
            n12 >>= 1;
            n16 = n15;
            n19 = n18;
            n18 = (n15 >>= 1) - 1;
        }
        nArray = null;
    }

    static {
        log2 = Math.log(2.0);
        code_magic = new int[]{221, 153};
        nbitplanes = new int[3];
    }
}

