/*
 * Decompiled with CFR 0.152.
 */
package cds.tools;

import cds.aladin.Aladin;
import cds.tools.Util;
import java.awt.FileDialog;
import java.io.File;
import javax.swing.JFileChooser;

public final class CDSFileDialog {
    private Aladin aladin;
    FileDialog fd;
    JFileChooser jfc;
    static final boolean isWin = Util.indexOfIgnoreCase(System.getProperty("os.name"), "win") >= 0;
    private static final String DEFAULT_FILENAME = "-";

    public CDSFileDialog(Aladin aladin) {
        this.aladin = aladin;
        if (isWin) {
            this.fd = new FileDialog(aladin.dialog);
        } else {
            this.jfc = new JFileChooser();
        }
    }

    public String getDirectory() {
        if (isWin) {
            return this.fd.getDirectory();
        }
        File file = this.jfc.getCurrentDirectory();
        return file == null ? null : file.toString();
    }

    public void setDirectory(String string) {
        if (isWin) {
            this.fd.setDirectory(string);
        } else {
            this.jfc.setCurrentDirectory(new File(string));
        }
    }

    public String getFile() {
        if (isWin) {
            this.fd.setFile(DEFAULT_FILENAME);
            this.fd.setVisible(true);
            String string = this.fd.getDirectory();
            String string2 = this.fd.getFile();
            if (string2 != null && string2.equals(DEFAULT_FILENAME)) {
                return string;
            }
            return string2;
        }
        this.jfc.setVisible(true);
        File file = this.jfc.getSelectedFile();
        return file == null ? null : file.toString();
    }
}

