/*
 * Decompiled with CFR 0.152.
 */
package cds.tools;

import cds.tools.CDSConstants;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JPanel;

public final class CDSLabel
extends JPanel
implements CDSConstants {
    static final int MARGE = 10;
    Vector line = null;
    Font font;
    FontMetrics fm;
    int mode;
    String text;
    boolean flagReaffiche = false;

    public CDSLabel() {
    }

    public CDSLabel(String string) {
        this(string, 1, PLAIN);
    }

    public CDSLabel(String string, int n) {
        this(string, n, PLAIN);
    }

    public CDSLabel(String string, int n, Font font) {
        this.mode = n;
        this.font = font;
        this.setFont(font);
        this.fm = Toolkit.getDefaultToolkit().getFontMetrics(font);
        this.setText(string);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        int n = 0;
        this.text = string;
        this.line = new Vector(10);
        while (stringTokenizer.hasMoreTokens()) {
            int n2;
            String string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, " ", true);
            StringBuffer stringBuffer = new StringBuffer();
            while (stringTokenizer2.hasMoreTokens()) {
                stringBuffer.append(stringTokenizer2.nextToken());
                if (stringBuffer.length() <= 80) continue;
                this.line.addElement(stringBuffer.toString());
                n2 = this.fm.stringWidth(stringBuffer.toString());
                if (n < n2) {
                    n = n2;
                }
                stringBuffer = new StringBuffer();
            }
            if (stringBuffer.length() <= 0) continue;
            this.line.addElement(stringBuffer.toString());
            n2 = this.fm.stringWidth(stringBuffer.toString());
            if (n >= n2) continue;
            n = n2;
        }
        if (this.mode == 2) {
            n += 10;
        }
        int n3 = this.line.size() * 17 + 3;
        this.resize(n, n3);
        this.reaffiche();
    }

    @Override
    public Dimension preferredSize() {
        return this.size();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.size();
    }

    @Override
    public Dimension minimumSize() {
        return this.size();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.size();
    }

    private void reaffiche() {
        this.flagReaffiche = true;
        this.repaint();
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.line == null) {
            return;
        }
        int n = 17;
        int n2 = this.line.size();
        int n3 = this.size().width;
        int n4 = this.size().height;
        if (this.flagReaffiche) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, n3, n4);
            this.flagReaffiche = false;
            graphics.setColor(this.getForeground());
        }
        for (int i = 0; i < n2; ++i) {
            String string = (String)this.line.elementAt(i);
            int n5 = this.fm.stringWidth(string);
            int n6 = this.mode == 0 ? 0 : (this.mode == 2 ? n3 - n5 - 10 : n3 / 2 - n5 / 2);
            graphics.drawString(string, n6, n);
            n += 17;
        }
    }
}

