/*
 * Decompiled with CFR 0.152.
 */
package cds.tools;

import cds.astro.Coo;
import cds.tools.Util;
import java.util.Stack;

public final class Computer {
    private static boolean DEBUG = false;
    static final String[] FCTSPARAM = new String[]{"atan2", "atan2d", "atan2Deg", "min", "max", "dist", "skydist", "skyDistDegrees", "dmsToDegrees", "dmsToDegrees"};
    static final int[] FCTNPARAM = new int[]{2, 2, 2, 2, 2, 4, 4, 4, 3, 3};
    static final String[] HELP = new String[]{"x,+,*,/,%,^: addition, subtraction, multiplication, division, modulo, power", "exp(x):   Euler's number 'e' raised to the power of x", "ln(x):    the natural logarithm (base 'e') of x", "log(x):   the base 10 logarithm of x", "sqrt(x):  the correctly rounded positive square root of x", "ceil(x):  the largest (closest to positive infinity) integer value", "floor(x): the smallest (closest to negative infinity) integer value", "round(x): the value of the argument rounded to the nearest integer", "abs(x):   the absolute value of the argument", "sin(x):   trigonometric sine of an angle (x in radians)", "cos(x):   trigonometric cosine of an angle (x in radians)", "tan(x):   trigonometric tangent of an angle (x in degrees)", "asin(x):  the arc sine of a value (result in radians)", "acos(x):  the arc cosine of a value (result in radians)", "atan(x):  the arc tangent of a value (result in radians)", "sinh(x):  the hyperbolic sine of x", "cosh(x):  the hyperbolic cosine of x", "tanh(x):  the hyperbolic tangent of x", "sind,cosd,tand:   trigonometric functions of an angle (x in degress)", "asind,acosd,atad: the arc trigonometric functions (result in degrees)", "rad2deg(a):  the measurement of the angle a in radians", "deg2rad(a):  the measurement of the angle a in degrees", "min(x,y):    the smaller of x and y", "max(x,y):    the larger of x and y", "atan2(x,y):  the angle (in radians) corresponding to x,y in cartesian coordinates", "atan2d(x,y): the angle (in degrees) corresponding to x,y in cartesian coordinates", "dist(x1,y1,x2,y2):        cartesian distance between x1,y1 and x2,y2", "skydist(ra1,de1,ra2,de2): spherical distance (coord in degrees or sexa with : as separator"};
    private static char SEP = (char)44;
    private int step = 0;

    private int getNbParam(String string) {
        int n = Util.indexInArrayOf(string, FCTSPARAM);
        return n < 0 ? 1 : FCTNPARAM[n];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean operate(Stack<Val> stack, Stack<Op> stack2) throws Exception {
        Val val;
        if (stack2.size() == 0 || stack.size() == 0) {
            return false;
        }
        Op op = stack2.peek();
        ++this.step;
        if (op.nbParam == 1) {
            val = stack.peek();
            if (DEBUG) {
                System.out.print(this.step + ")\t" + op.op + "(" + val + ")");
            }
            if (op.op.equals("-")) {
                val.v = -val.v;
            } else if (op.op.equals("+")) {
                val.v = val.v;
            } else if (op.op.equals("exp")) {
                val.v = Math.exp(val.v);
            } else if (op.op.equals("sin")) {
                val.v = Math.sin(val.v);
            } else if (op.op.equals("sind") || op.op.equals("sinDeg")) {
                val.v = Math.sin(Math.toRadians(val.v));
            } else if (op.op.equals("cos")) {
                val.v = Math.cos(val.v);
            } else if (op.op.equals("cosd") || op.op.equals("cosDeg")) {
                val.v = Math.cos(Math.toRadians(val.v));
            } else if (op.op.equals("tan")) {
                val.v = Math.tan(val.v);
            } else if (op.op.equals("tand") || op.op.equals("tanDeg")) {
                val.v = Math.tan(Math.toRadians(val.v));
            } else if (op.op.equals("asin")) {
                val.v = Math.asin(val.v);
            } else if (op.op.equals("asind") || op.op.equals("asinDeg")) {
                val.v = Math.toDegrees(Math.asin(val.v));
            } else if (op.op.equals("acos")) {
                val.v = Math.acos(val.v);
            } else if (op.op.equals("acosd") || op.op.equals("acosDeg")) {
                val.v = Math.toDegrees(Math.acos(val.v));
            } else if (op.op.equals("atan")) {
                val.v = Math.atan(val.v);
            } else if (op.op.equals("atand") || op.op.equals("atanDeg")) {
                val.v = Math.toDegrees(Math.atan(val.v));
            } else if (op.op.equals("sinh")) {
                val.v = Math.sinh(val.v);
            } else if (op.op.equals("cosh")) {
                val.v = Math.cosh(val.v);
            } else if (op.op.equals("tanh")) {
                val.v = Math.tanh(val.v);
            } else if (op.op.equals("sqrt")) {
                val.v = Math.sqrt(val.v);
            } else if (op.op.equals("ln")) {
                val.v = Math.log(val.v);
            } else if (op.op.equals("log1p")) {
                val.v = Math.log1p(val.v);
            } else if (op.op.equals("log")) {
                val.v = Math.log10(val.v);
            } else if (op.op.equals("sqrt")) {
                val.v = Math.sqrt(val.v);
            } else if (op.op.equals("round")) {
                val.v = Math.round(val.v);
            } else if (op.op.equals("ceil")) {
                val.v = Math.ceil(val.v);
            } else if (op.op.equals("floor")) {
                val.v = Math.floor(val.v);
            } else if (op.op.equals("rint")) {
                val.v = Math.rint(val.v);
            } else if (op.op.equals("abs")) {
                val.v = Math.abs(val.v);
            } else if (op.op.equals("toRadians") || op.op.equals("deg2rad")) {
                val.v = Math.toRadians(val.v);
            } else {
                if (!op.op.equals("toDegrees") && !op.op.equals("rad2deg")) throw new Exception("Unknown function [" + op.op + "]");
                val.v = Math.toDegrees(val.v);
            }
        } else {
            if (stack.size() < op.nbParam) {
                return false;
            }
            Val[] valArray = new Val[op.nbParam - 1];
            for (int i = valArray.length - 1; i >= 0; --i) {
                valArray[i] = stack.pop();
            }
            val = stack.peek();
            if (DEBUG) {
                if (this.isUniqCharOp(op.op.charAt(0))) {
                    System.out.print(this.step + ")\t" + val + " " + op.op + " " + valArray[0]);
                } else {
                    System.out.print(this.step + ")\t" + op.op + "(" + val.v);
                    for (Val val2 : valArray) {
                        System.out.print(", " + val2.v);
                    }
                    System.out.print(")");
                }
            }
            if (op.op.equals("-")) {
                val.v -= valArray[0].v;
            } else if (op.op.equals("+")) {
                val.v += valArray[0].v;
            } else if (op.op.equals("*")) {
                val.v *= valArray[0].v;
            } else if (op.op.equals("/")) {
                val.v /= valArray[0].v;
            } else if (op.op.equals("%")) {
                val.v %= valArray[0].v;
            } else if (op.op.equals("^")) {
                val.v = Math.pow(val.v, valArray[0].v);
            } else if (op.op.equals("max")) {
                val.v = Math.max(val.v, valArray[0].v);
            } else if (op.op.equals("min")) {
                val.v = Math.min(val.v, valArray[0].v);
            } else if (op.op.equals("atan2")) {
                val.v = Math.atan2(val.v, valArray[0].v);
            } else if (op.op.equals("atan2d") || op.op.equals("atan2Deg")) {
                val.v = Math.atan2(Math.toRadians(val.v), Math.toRadians(valArray[0].v));
            } else if (op.op.equals("dist")) {
                val.v = Math.hypot(val.v - valArray[1].v, valArray[0].v - valArray[2].v);
            } else if (op.op.equals("skydist") || op.op.equals("skyDistDegrees")) {
                val.v = Coo.distance(val.v, valArray[0].v, valArray[1].v, valArray[2].v);
            } else if (op.op.equals("hms2Degrees")) {
                val.v = 15.0 * (val.v + valArray[0].v / 60.0 + valArray[1].v / 3600.0);
            } else {
                if (!op.op.equals("dms2Degrees")) throw new Exception("Unknown function [" + op.op + "]");
                val.v = val.v + valArray[0].v / 60.0 + valArray[1].v / 3600.0;
            }
        }
        if (DEBUG) {
            System.out.println(" => " + val.v);
        }
        stack2.pop();
        return true;
    }

    private boolean isNumber(Expr expr, int n) {
        char c = expr.ch();
        if (Character.isDigit(c) || c == '.') {
            return true;
        }
        if (expr.pos > n && c == ':') {
            return true;
        }
        if (SEP != ',' && c == ',') {
            return true;
        }
        if (expr.pos > n && !expr.isEnd()) {
            char c2;
            if (!(c != 'E' && c != 'e' || (c2 = expr.s[expr.pos + 1]) != '+' && c2 != '-' && !Character.isDigit(c2))) {
                return true;
            }
            if (!(c != '+' && c != '-' && !Character.isDigit(c) || (c2 = expr.s[expr.pos - 1]) != 'E' && c2 != 'e')) {
                return true;
            }
        }
        return false;
    }

    private boolean isInFctName(Expr expr, int n) {
        char c = expr.ch();
        return expr.pos == n && !Character.isDigit(c) && c != '(' && c != ')' || expr.pos > n && Character.isJavaIdentifierPart(c);
    }

    private boolean isUniqCharOp(char c) {
        return c == '+' || c == '-' || c == '*' || c == '/' || c == '^' || c == '%';
    }

    private Op seeNextOp(Expr expr) {
        int n = expr.pos;
        Op op = this.getNextOp(expr);
        expr.pos = n;
        return op;
    }

    private Op getNextOp(Expr expr) {
        expr.skipBlank();
        if (expr.ch() == '(') {
            return null;
        }
        int n = expr.pos++;
        if (expr.isEnd() || !this.isUniqCharOp(expr.ch())) {
            while (!expr.isEnd() && this.isInFctName(expr, n)) {
                ++expr.pos;
            }
        }
        if (n == expr.pos) {
            return null;
        }
        Op op = new Op(expr.get(n, expr.pos - n), 2);
        return op;
    }

    private Op getNextFct(Expr expr) {
        Op op = this.getNextOp(expr);
        if (op == null) {
            return null;
        }
        op.nbParam = this.getNbParam(op.op);
        return op;
    }

    private String getSubExpr(Expr expr) throws Exception {
        int n = expr.pos;
        int n2 = 0;
        if (expr.ch() != '(') {
            throw new Exception("Missing '(' : " + expr.error());
        }
        while (!expr.isEnd()) {
            char c = expr.ch();
            ++expr.pos;
            if (c == ')') {
                --n2;
            } else if (c == '(') {
                ++n2;
            }
            if (n2 != 0) continue;
            break;
        }
        if (n2 > 0) {
            throw new Exception("Unbalanced parenthesis :" + expr.error());
        }
        return expr.get(n + 1, expr.pos - n - 2);
    }

    private Val getNextVal(Expr expr) throws Exception {
        expr.skipBlank();
        if (!expr.isEnd() && expr.ch() == '(') {
            String string = this.getSubExpr(expr);
            double d = this.computeInternal(string);
            return new Val(d);
        }
        int n = expr.pos;
        while (!expr.isEnd() && this.isNumber(expr, n)) {
            ++expr.pos;
        }
        if (n == expr.pos) {
            return null;
        }
        return new Val(expr.get(n, expr.pos - n));
    }

    private Val getNextParam(Expr expr) throws Exception {
        expr.skipBlank();
        int n = 0;
        int n2 = expr.pos;
        char c = ' ';
        while (!expr.isEnd()) {
            c = expr.ch();
            ++expr.pos;
            if (c == '(') {
                ++n;
            } else if (c == ')') {
                --n;
            }
            if (n != 0 || c != SEP) continue;
        }
        if (n > 0) {
            throw new Exception("Unbalanced parenthesis :" + expr.error());
        }
        String string = expr.get(n2, expr.pos - n2 - (c == SEP ? 1 : 0));
        string = this.sexa2deg(string);
        return new Val(this.computeInternal(string));
    }

    private void stackAndComputeParam(Stack<Val> stack, Stack<Op> stack2, Expr expr) throws Exception {
        int n = stack2.peek().nbParam;
        expr.skipBlank();
        Expr expr2 = new Expr(this.getSubExpr(expr));
        for (int i = 0; i < n; ++i) {
            Val val = this.getNextParam(expr2);
            if (val == null) {
                throw new Exception("Missing parameter :" + expr.error());
            }
            stack.push(val);
        }
        if (!expr2.isEnd()) {
            throw new Exception("Unknown parameter: " + expr2.error());
        }
        this.operate(stack, stack2);
    }

    private void read(Stack<Val> stack, Stack<Op> stack2, Stack<Op> stack3, Expr expr) throws Exception {
        Object object;
        Op op;
        while ((op = this.getNextFct(expr)) != null && this.isUniqCharOp(op.op.charAt(0))) {
            stack3.push(op);
            op = null;
        }
        if (op != null) {
            stack3.push(op);
            this.stackAndComputeParam(stack, stack3, expr);
        } else {
            object = this.getNextVal(expr);
            if (object == null) {
                throw new Exception("Missing number :" + expr.error());
            }
            stack.push((Val)object);
        }
        while (this.operate(stack, stack3)) {
        }
        object = this.seeNextOp(expr);
        while (!stack2.isEmpty() && (object == null || ((Op)object).pri <= stack2.peek().pri) && this.operate(stack, stack2)) {
        }
    }

    private void readNext(Stack<Val> stack, Stack<Op> stack2, Stack<Op> stack3, Expr expr) throws Exception {
        expr.skipBlank();
        if (expr.isEnd()) {
            return;
        }
        Op op = this.getNextOp(expr);
        if (op == null) {
            throw new Exception("Missing operation :" + expr.error());
        }
        stack2.push(op);
        this.read(stack, stack2, stack3, expr);
    }

    private void readFirst(Stack<Val> stack, Stack<Op> stack2, Stack<Op> stack3, Expr expr) throws Exception {
        this.read(stack, stack2, stack3, expr);
    }

    private String sexa2deg(String string) throws Exception {
        int n;
        int n2;
        if (string.length() < 5 || string.indexOf(58) <= 0) {
            return string;
        }
        for (n2 = 0; n2 < string.length(); ++n2) {
            n = string.charAt(n2);
            if (Character.isDigit((char)n) || n == 43 || n == 45 || n == 58 || n == 46) continue;
            return string;
        }
        n2 = 0;
        double d = 15.0;
        if (string.charAt(0) == '-') {
            d = -1.0;
            ++n2;
        } else if (string.charAt(0) == '+') {
            d = 1.0;
            ++n2;
        }
        n = string.indexOf(58, n2);
        double d2 = Double.parseDouble(string.substring(n2, n));
        n2 = n + 1;
        n = string.indexOf(58, n2);
        double d3 = Double.parseDouble(string.substring(n2, n));
        n2 = n + 1;
        double d4 = Double.parseDouble(string.substring(n2));
        String string2 = d * (d2 + d3 / 60.0 + d4 / 3600.0) + "";
        if (DEBUG) {
            System.out.println(++this.step + ")\t" + string + " => " + string2);
        }
        return string2;
    }

    public double computeInternal(String string) throws Exception {
        Stack<Val> stack = new Stack<Val>();
        Stack<Op> stack2 = new Stack<Op>();
        Stack<Op> stack3 = new Stack<Op>();
        Expr expr = new Expr(string);
        this.readFirst(stack, stack2, stack3, expr);
        while (!expr.isEnd()) {
            this.readNext(stack, stack2, stack3, expr);
        }
        if (!expr.isEnd() || stack.size() > 1 || stack2.size() > 0 || stack3.size() > 0) {
            throw new Exception("Truncated expression :" + expr.error());
        }
        return stack.pop().v;
    }

    public static String help() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : HELP) {
            stringBuilder.append(string + "\n");
        }
        return stringBuilder.toString();
    }

    public static void setDebug(boolean bl) {
        DEBUG = bl;
    }

    public static void setSeparator(char c) {
        SEP = c;
    }

    public static double compute(String string) throws Exception {
        if (DEBUG) {
            System.out.println("Computing:\n" + string);
        }
        return new Computer().computeInternal(string);
    }

    public static void main(String[] stringArray) {
        try {
            String string = " -skydist(05:34:43.68,+21:59:28.1,184.50849,-05.79883)*-60 -sin ( -round( 100+1e-03)%(3*2) + -cos(32.2+8^(7-5*max(3,1/8.7) )  )) * -(6-2E+5)";
            Computer.setDebug(true);
            double d = Computer.compute(string);
            System.out.println(string + " = " + d);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    class Expr {
        char[] s;
        int pos;

        Expr(String string) {
            this.s = string.toCharArray();
            this.pos = 0;
        }

        boolean isEnd() {
            return this.pos >= this.s.length;
        }

        char ch() {
            return this.isEnd() ? (char)'\u0000' : this.s[this.pos];
        }

        String get(int n, int n2) {
            return new String(this.s, n, n2);
        }

        String error() {
            return new String(this.s, 0, this.pos) + " ?? " + new String(this.s, this.pos, this.s.length - this.pos);
        }

        void skipBlank() {
            while (this.pos < this.s.length && Character.isSpaceChar(this.s[this.pos])) {
                ++this.pos;
            }
        }
    }

    class Op {
        String op;
        int nbParam;
        int pri;

        Op(String string, int n) {
            this.op = string;
            this.nbParam = n;
            this.pri = 0;
            char c = string.charAt(0);
            if (c == '*' || c == '/' || c == '%') {
                this.pri = 1;
            } else if (c == '^') {
                this.pri = 2;
            }
        }
    }

    class Val {
        double v;

        Val(double d) {
            this.v = d;
        }

        Val(String string) {
            this.v = Double.parseDouble(string);
        }

        public String toString() {
            return this.v + "";
        }
    }
}

