/*
 * Decompiled with CFR 0.152.
 */
package cds.tools;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;

public class MultiPartPostOutputStream {
    private static final String CRLF = "\r\n";
    private static final String PREFIX = "--";
    private static String tmpDir = null;
    private DataOutputStream out = null;
    public String boundary = null;

    public MultiPartPostOutputStream(OutputStream outputStream, String string) {
        if (outputStream == null) {
            throw new IllegalArgumentException("Output stream is required.");
        }
        if (string == null || string.length() == 0) {
            string = MultiPartPostOutputStream.createBoundary();
        }
        this.out = new DataOutputStream(outputStream);
        this.boundary = string;
    }

    public void writeField(String string, String string2) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("Name cannot be null or empty.");
        }
        if (string2 == null) {
            string2 = "";
        }
        this.out.writeBytes(PREFIX);
        this.out.writeBytes(this.boundary);
        this.out.writeBytes(CRLF);
        this.out.writeBytes("Content-Disposition: form-data; name=\"" + string + "\"");
        this.out.writeBytes(CRLF);
        this.out.writeBytes(CRLF);
        this.out.writeBytes(string2);
        this.out.writeBytes(CRLF);
        this.out.flush();
    }

    public void writeFile(String string, String string2, File file, boolean bl) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null.");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("File does not exist.");
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("File cannot be a directory.");
        }
        this.writeFile(string, string2, file.getCanonicalPath(), new FileInputStream(file), bl);
    }

    public void writeFile(String string, String string2, String string3, InputStream inputStream, boolean bl) throws IOException {
        Object object;
        if (inputStream == null) {
            throw new IllegalArgumentException("Input stream cannot be null.");
        }
        if (string3 == null || string3.length() == 0) {
            throw new IllegalArgumentException("File name cannot be null or empty.");
        }
        this.out.writeBytes(PREFIX);
        this.out.writeBytes(this.boundary);
        this.out.writeBytes(CRLF);
        this.out.writeBytes("Content-Disposition: form-data; name=\"" + string + "\"; filename=\"" + string3 + "\"");
        this.out.writeBytes(CRLF);
        if (string2 != null) {
            this.out.writeBytes("Content-Type: " + (bl ? "application/x-gzip" : string2));
            this.out.writeBytes(CRLF);
        }
        this.out.writeBytes(CRLF);
        File file = null;
        if (bl) {
            int n;
            file = tmpDir != null ? File.createTempFile("gzip", "multipart", new File(tmpDir)) : File.createTempFile("gzip", "multipart");
            object = new GZIPOutputStream(new FileOutputStream(file));
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) > 0) {
                ((GZIPOutputStream)object).write(byArray, 0, n);
            }
            inputStream.close();
            ((DeflaterOutputStream)object).flush();
            ((DeflaterOutputStream)object).close();
            inputStream = new FileInputStream(file);
        }
        object = new byte[1024];
        int n = 0;
        while ((n = inputStream.read((byte[])object, 0, ((byte[])object).length)) != -1) {
            this.out.write((byte[])object, 0, n);
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.out.writeBytes(CRLF);
        this.out.flush();
        if (bl) {
            file.delete();
        }
    }

    public void writeFile(String string, String string2, String string3, byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("Data cannot be null.");
        }
        if (string3 == null || string3.length() == 0) {
            throw new IllegalArgumentException("File name cannot be null or empty.");
        }
        this.out.writeBytes(PREFIX);
        this.out.writeBytes(this.boundary);
        this.out.writeBytes(CRLF);
        this.out.writeBytes("Content-Disposition: form-data; name=\"" + string + "\"; filename=\"" + string3 + "\"");
        this.out.writeBytes(CRLF);
        if (string2 != null) {
            this.out.writeBytes("Content-Type: " + string2);
            this.out.writeBytes(CRLF);
        }
        this.out.writeBytes(CRLF);
        this.out.write(byArray, 0, byArray.length);
        this.out.writeBytes(CRLF);
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.writeBytes(PREFIX);
        this.out.writeBytes(this.boundary);
        this.out.writeBytes(PREFIX);
        this.out.writeBytes(CRLF);
        this.out.flush();
        this.out.close();
    }

    public String getBoundary() {
        return this.boundary;
    }

    public static URLConnection createConnection(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        if (uRLConnection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            httpURLConnection.setRequestMethod("POST");
        }
        uRLConnection.setDoInput(true);
        uRLConnection.setDoOutput(true);
        uRLConnection.setUseCaches(false);
        uRLConnection.setDefaultUseCaches(false);
        return uRLConnection;
    }

    public static String createBoundary() {
        return "--------------------" + Long.toString(System.currentTimeMillis(), 16);
    }

    public static String getContentType(String string) {
        return "multipart/form-data; boundary=" + string;
    }

    public static void setTmpDir(String string) {
        tmpDir = string;
    }
}

