/*
 * Decompiled with CFR 0.152.
 */
package cds.tools;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class TwoColorJTable
extends JTable {
    public static Color DEFAULT_ALTERNATE_COLOR = new Color(241, 241, 254);
    private Color alternateColor = DEFAULT_ALTERNATE_COLOR;

    public TwoColorJTable(TableModel tableModel, Color color) {
        super(tableModel);
        this.alternateColor = color;
    }

    public TwoColorJTable() {
    }

    public TwoColorJTable(TableModel tableModel) {
        super(tableModel);
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            JViewport jViewport = (JViewport)this.getParent();
            return jViewport.getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    protected Color colorForRow(int n) {
        return n % 2 == 0 ? this.getBackground() : this.alternateColor;
    }

    @Override
    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        if (!this.isCellSelected(n, n2)) {
            component.setBackground(this.colorForRow(n));
            component.setForeground(UIManager.getColor("Table.foreground"));
        } else {
            component.setBackground(UIManager.getColor("Table.selectionBackground"));
            component.setForeground(UIManager.getColor("Table.selectionForeground"));
        }
        return component;
    }
}

