/*
 * Decompiled with CFR 0.152.
 */
package cds.tools;

import cds.aladin.Aladin;
import cds.aladin.Forme;
import cds.aladin.MyInputStream;
import cds.aladin.Tok;
import cds.image.EPSGraphics;
import cds.tools.Astrodate;
import healpix.essentials.FastMath;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

public final class Util {
    public static String CR = System.getProperty("line.separator");
    public static String FS = System.getProperty("file.separator");
    static DecimalFormat DF = new DecimalFormat();
    static final Color CEBOX;
    static final Color CIBOX;
    private static final Color[] CINT;
    private static final String DEFAULT_FILENAME = "-";
    private static String HEX;
    private static ImageIcon DESC_ICON;
    private static ImageIcon ASC_ICON;
    public static final String[] unites;
    private static String B64;

    public static MyInputStream openAnyStream(String string) throws Exception {
        if (string.startsWith("http:") || string.startsWith("https:") || string.startsWith("ftp:")) {
            return Util.openStream(string);
        }
        FileInputStream fileInputStream = new FileInputStream(string);
        MyInputStream myInputStream = new MyInputStream(fileInputStream);
        return myInputStream.startRead();
    }

    public static MyInputStream openStream(String string) throws Exception {
        return Util.openStream(new URL(string), true, 10000);
    }

    public static MyInputStream openStream(String string, boolean bl, int n) throws Exception {
        return Util.openStream(new URL(string), bl, n);
    }

    public static MyInputStream openStream(URL uRL) throws Exception {
        return Util.openStream(uRL, true, 10000);
    }

    public static MyInputStream openStream(URL uRL, boolean bl, int n) throws Exception {
        Object object;
        URLConnection uRLConnection = uRL.openConnection();
        if (!bl) {
            uRLConnection.setUseCaches(false);
        }
        uRLConnection.setConnectTimeout(n);
        if (uRLConnection instanceof HttpURLConnection) {
            object = (HttpURLConnection)uRLConnection;
            ((URLConnection)object).setRequestProperty("http.agent", "Aladin/v9.033a");
        }
        object = new MyInputStream(Util.openConnectionCheckRedirects(uRLConnection));
        return ((MyInputStream)object).startRead();
    }

    private static InputStream openConnectionCheckRedirects(URLConnection uRLConnection) throws IOException {
        boolean bl;
        int n = 0;
        InputStream inputStream = null;
        do {
            HttpURLConnection httpURLConnection;
            int n2;
            if (uRLConnection instanceof HttpURLConnection) {
                ((HttpURLConnection)uRLConnection).setInstanceFollowRedirects(false);
            }
            inputStream = uRLConnection.getInputStream();
            bl = false;
            if (!(uRLConnection instanceof HttpURLConnection) || (n2 = (httpURLConnection = (HttpURLConnection)uRLConnection).getResponseCode()) < 300 || n2 > 307 || n2 == 306 || n2 == 304) continue;
            URL uRL = httpURLConnection.getURL();
            String string = httpURLConnection.getHeaderField("Location");
            URL uRL2 = null;
            if (string != null) {
                uRL2 = new URL(uRL, string);
            }
            httpURLConnection.disconnect();
            if (uRL2 == null || !uRL2.getProtocol().equals("http") && !uRL2.getProtocol().equals("https") || n >= 5) {
                throw new SecurityException("illegal URL redirect");
            }
            bl = true;
            uRLConnection = uRL2.openConnection();
            try {
                uRLConnection.setUseCaches(httpURLConnection.getUseCaches());
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        } while (bl);
        return inputStream;
    }

    public static boolean matchMaskIgnoreCase(String string, String string2) {
        if (string2 == null || string == null) {
            return false;
        }
        return Util.matchMask(Util.toUpper(string), Util.toUpper(string2));
    }

    public static boolean matchMask(String string, String string2) {
        if (string2 == null || string == null) {
            return false;
        }
        string = string + '\u0000';
        string2 = string2 + '\u0000';
        int n = 0;
        int n2 = 0;
        String string3 = null;
        String string4 = null;
        while (string.charAt(n2) != '\u0000' || string2.charAt(n) != '\u0000') {
            if (string.charAt(n2) == '\\') {
                ++n2;
                continue;
            }
            if (string.charAt(n2) == '*' && (n2 == 0 || string.charAt(n2 - 1) != '\\')) {
                string3 = string.substring(++n2);
                continue;
            }
            if (string3 != null && !string3.equals(string) && string2.charAt(n) == string2.charAt(0)) {
                string4 = string2.substring(n);
            }
            if (string.charAt(n2) == string2.charAt(n) || string.charAt(n2) == '?') {
                if (string.charAt(n2) == '\u0000') {
                    if (string3 == null) {
                        return false;
                    }
                } else {
                    ++n2;
                }
                if (string2.charAt(n) == '\u0000') {
                    return false;
                }
                ++n;
                continue;
            }
            if (string3 != null) {
                string = string3;
                n2 = 0;
                if (string4 != null) {
                    string2 = string4;
                    n = 0;
                    string4 = null;
                    continue;
                }
                if (string3.charAt(0) == string2.charAt(n) && string2.charAt(n) != '\\') continue;
                if (string2.charAt(n) == '\u0000') {
                    return false;
                }
                ++n;
                continue;
            }
            return false;
        }
        return true;
    }

    public static String myRound(double d) {
        int n;
        String string = d + "";
        int n2 = string.indexOf(69);
        if (n2 > 0 && (n = string.indexOf(46)) > 0) {
            if (n + 4 > n2) {
                return string;
            }
            return string.substring(0, n + 4) + string.substring(n2);
        }
        double d2 = Math.abs(d);
        if (d2 > 1000.0) {
            DF.setMaximumFractionDigits(0);
        } else if (d2 > 100.0) {
            DF.setMaximumFractionDigits(1);
        } else if (d2 > 10.0) {
            DF.setMaximumFractionDigits(2);
        } else if (d2 > 1.0) {
            DF.setMaximumFractionDigits(3);
        } else if (d2 > 0.1) {
            DF.setMaximumFractionDigits(4);
        } else if (d2 > 0.01) {
            DF.setMaximumFractionDigits(5);
        } else {
            DF.setMaximumFractionDigits(6);
        }
        return DF.format(d);
    }

    public static String myRound(String string) {
        return Util.myRound(string, 0);
    }

    public static String myRound(String string, int n) {
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[cArray.length];
        int n2 = 0;
        int n3 = 0;
        int n4 = string.indexOf(69);
        if (n4 < 0) {
            n4 = string.indexOf(101);
        }
        int n5 = n4 < 0 ? cArray.length : n4;
        block6: for (int i = 0; i < n5; ++i) {
            switch (n3) {
                case 0: {
                    if (cArray[i] == '.') {
                        if (n == 0) {
                            return new String(cArray2, 0, n2);
                        }
                        n3 = 1;
                    }
                    cArray2[n2++] = cArray[i];
                    continue block6;
                }
                case 1: {
                    if (--n == 0) {
                        n3 = 2;
                    }
                    if (i + 1 < cArray.length && Character.isDigit(cArray[i + 1]) && cArray[i + 1] >= '5') {
                        int n6 = n2++;
                        int n7 = i;
                        char c = cArray[n7];
                        cArray[n7] = (char)(c + '\u0001');
                        cArray2[n6] = c;
                        continue block6;
                    }
                    cArray2[n2++] = cArray[i];
                    continue block6;
                }
                case 2: {
                    if (Character.isDigit(cArray[i])) continue block6;
                    n3 = 3;
                }
                case 3: {
                    cArray2[n2++] = cArray[i];
                }
            }
        }
        String string2 = new String(cArray2, 0, n2);
        if (n4 >= 0) {
            return string2 + string.substring(n4);
        }
        return string2;
    }

    public static String[] split(String string, String string2, char c, char c2, boolean bl) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == c) {
                ++n;
            }
            if (cArray[i] == c2) {
                ++n2;
            }
            if (string2.indexOf(cArray[i]) >= 0 && n == n2) {
                if (stringBuffer.length() > 0) {
                    vector.addElement(bl ? stringBuffer.toString().trim() : stringBuffer.toString());
                }
                stringBuffer = new StringBuffer();
                continue;
            }
            stringBuffer.append(cArray[i]);
        }
        if (stringBuffer.length() > 0) {
            vector.addElement(bl ? stringBuffer.toString().trim() : stringBuffer.toString());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        vector = null;
        return objectArray;
    }

    public static int[] splitAsInt(String string, String string2) {
        String[] stringArray = Util.split(string, string2, '@', '@');
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = Integer.parseInt(stringArray[i]);
        }
        return nArray;
    }

    public static char[] splitAschar(String string, String string2) {
        String[] stringArray = Util.split(string, string2, '@', '@');
        char[] cArray = new char[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            cArray[i] = stringArray[i].charAt(0);
        }
        return cArray;
    }

    public static String[] split(String string, String string2) {
        return Util.split(string, string2, '@', '@');
    }

    public static String[] split(String string, String string2, char c, char c2) {
        return Util.split(string, string2, c, c2, false);
    }

    public static String join(String[] stringArray, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String join(int[] nArray, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(c);
            }
            stringBuffer.append(nArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String join(char[] cArray, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < cArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(c);
            }
            stringBuffer.append(cArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String align(String string, int n) {
        return Util.align(string, n, "");
    }

    public static String align(String string, int n, String string2) {
        int n2 = string.length();
        if (n2 >= n) {
            return string + string2 + " ";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n - n2; ++i) {
            stringBuffer.append(' ');
        }
        return string + string2 + stringBuffer;
    }

    public static String align3(int n) {
        if (n < 10) {
            return "00" + n;
        }
        if (n < 100) {
            return "0" + n;
        }
        return "" + n;
    }

    public static String align2(int n) {
        if (n < 10) {
            return "0" + n;
        }
        return "" + n;
    }

    public static double round(double d, int n) {
        double d2 = Math.pow(10.0, n);
        return (double)Math.round(d * d2) / d2;
    }

    public static String fold(String string) {
        return Util.fold(string, 80, false);
    }

    public static String fold(String string, int n) {
        return Util.fold(string, n, false);
    }

    public static String fold(String string, int n, boolean bl) {
        if (string == null || string.trim().length() == 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        String string2 = !bl ? "\n" : "<BR>";
        StringBuffer stringBuffer = new StringBuffer(cArray.length + 30);
        if (bl) {
            stringBuffer.append("<html>");
        }
        boolean bl2 = true;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n2 < cArray.length) {
            boolean bl3 = Character.isSpaceChar(cArray[n2]);
            if (bl2) {
                if (bl3) {
                    ++n4;
                } else {
                    bl2 = false;
                }
            }
            if (cArray[n2] == '\n') {
                n3 = 0;
                stringBuffer.append(string2);
            } else {
                if (n3 > n + 10 || n3 > n && bl3) {
                    stringBuffer.append(string2);
                    for (int i = 0; i < n4; ++i) {
                        stringBuffer.append(' ');
                    }
                    n3 = 0;
                }
                if (n3 != 0 || !bl3) {
                    stringBuffer.append(cArray[n2]);
                }
            }
            ++n2;
            ++n3;
        }
        if (bl) {
            stringBuffer.append("</html>");
        }
        return stringBuffer.toString();
    }

    public static byte[] getTableCM(ColorModel colorModel, int n) {
        byte[] byArray = new byte[256];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(0xFF & (n == 0 ? colorModel.getRed(i) : (n == 1 ? colorModel.getGreen(i) : colorModel.getBlue(i))));
        }
        return byArray;
    }

    public static Color getReverseColor(Color color) {
        if (color == null) {
            return null;
        }
        return new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue());
    }

    public static void drawEdge(Graphics graphics, int n, int n2) {
        Util.drawEdge(graphics, 0, 0, n, n2);
    }

    public static void drawEdge(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(CIBOX);
        graphics.drawLine(n, n2, n + n3 - 1, n2);
        graphics.drawLine(n, n2, n, n2 + n4 - 1);
        graphics.setColor(Color.lightGray);
        graphics.drawLine(n + n3 - 1, n2 + n4 - 1, n, n2 + n4 - 1);
        graphics.drawLine(n + n3 - 1, n2 + n4 - 1, n + n3 - 1, n2);
    }

    public static void drawCirclePix(Graphics graphics, int n, int n2) {
        graphics.drawLine(n - 1, n2 - 5, n + 2, n2 - 5);
        graphics.drawLine(n - 3, n2 - 4, n - 2, n2 - 4);
        graphics.drawLine(n + 1, n2 - 4, n + 4, n2 - 4);
        graphics.drawLine(n - 4, n2 - 3, n - 4, n2 - 3);
        graphics.drawLine(n + 1, n2 - 3, n + 5, n2 - 3);
        graphics.drawLine(n - 4, n2 - 2, n - 4, n2 - 2);
        graphics.drawLine(n + 1, n2 - 2, n + 5, n2 - 2);
        graphics.drawLine(n - 5, n2 - 1, n - 5, n2 - 1);
        graphics.drawLine(n + 1, n2 - 1, n + 6, n2 - 1);
        graphics.drawLine(n - 5, n2, n - 5, n2);
        graphics.drawLine(n + 1, n2, n + 6, n2);
        graphics.drawLine(n - 5, n2 + 1, n - 5, n2 + 1);
        graphics.drawLine(n + 1, n2 + 1, n + 6, n2 + 1);
        graphics.drawLine(n - 5, n2 + 2, n - 5, n2 + 2);
        graphics.drawLine(n + 1, n2 + 2, n + 6, n2 + 2);
        graphics.drawLine(n - 4, n2 + 3, n - 4, n2 + 3);
        graphics.drawLine(n + 1, n2 + 3, n + 5, n2 + 3);
        graphics.drawLine(n - 4, n2 + 4, n - 4, n2 + 4);
        graphics.drawLine(n + 1, n2 + 4, n + 5, n2 + 4);
        graphics.drawLine(n - 3, n2 + 5, n - 2, n2 + 5);
        graphics.drawLine(n + 1, n2 + 5, n + 4, n2 + 5);
        graphics.drawLine(n - 1, n2 + 6, n + 2, n2 + 6);
    }

    public static void drawCircle8(Graphics graphics, int n, int n2) {
        if (!(graphics instanceof Graphics2D)) {
            graphics.drawOval(n - 4, n2 - 4, 8, 8);
            return;
        }
        graphics.drawLine(n - 3, n2 - 1, n - 3, n2 + 2);
        graphics.drawLine(n + 4, n2 - 1, n + 4, n2 + 2);
        graphics.drawLine(n - 1, n2 - 3, n + 2, n2 - 3);
        graphics.drawLine(n - 1, n2 + 4, n + 2, n2 + 4);
        graphics.drawLine(n - 2, n2 - 2, n - 2, n2 - 2);
        graphics.drawLine(n - 2, n2 + 3, n - 2, n2 + 3);
        graphics.drawLine(n + 3, n2 + 3, n + 3, n2 + 3);
        graphics.drawLine(n + 3, n2 - 2, n + 3, n2 - 2);
    }

    public static void fillCircle8(Graphics graphics, int n, int n2) {
        if (!(graphics instanceof Graphics2D)) {
            graphics.drawOval(n - 4, n2 - 4, 8, 8);
            graphics.fillOval(n - 4, n2 - 4, 8, 8);
            return;
        }
        graphics.fillRect(n - 2, n2 - 2, 6, 6);
        Util.drawCircle8(graphics, n, n2);
    }

    public static void drawCircle7(Graphics graphics, int n, int n2) {
        if (!(graphics instanceof Graphics2D)) {
            graphics.drawOval(n - 3, n2 - 3, 6, 6);
            return;
        }
        graphics.drawLine(n - 3, n2 - 1, n - 3, n2 + 1);
        graphics.drawLine(n + 3, n2 - 1, n + 3, n2 + 1);
        graphics.drawLine(n - 1, n2 - 3, n + 1, n2 - 3);
        graphics.drawLine(n - 1, n2 + 3, n + 1, n2 + 3);
        graphics.drawLine(n - 2, n2 - 2, n - 2, n2 - 2);
        graphics.drawLine(n - 2, n2 + 2, n - 2, n2 + 2);
        graphics.drawLine(n + 2, n2 + 2, n + 2, n2 + 2);
        graphics.drawLine(n + 2, n2 - 2, n + 2, n2 - 2);
    }

    public static void fillCircle7(Graphics graphics, int n, int n2) {
        if (!(graphics instanceof Graphics2D)) {
            graphics.fillOval(n - 3, n2 - 3, 6, 6);
            graphics.drawOval(n - 3, n2 - 3, 6, 6);
            return;
        }
        graphics.fillRect(n - 2, n2 - 2, 5, 5);
        Util.drawCircle7(graphics, n, n2);
    }

    public static void drawCircle5(Graphics graphics, int n, int n2) {
        if (!(graphics instanceof Graphics2D)) {
            graphics.drawOval(n - 2, n2 - 2, 4, 4);
            return;
        }
        graphics.drawLine(n - 2, n2 - 1, n - 2, n2 + 1);
        graphics.drawLine(n + 2, n2 - 1, n + 2, n2 + 1);
        graphics.drawLine(n - 1, n2 - 2, n + 1, n2 - 2);
        graphics.drawLine(n - 1, n2 + 2, n + 1, n2 + 2);
    }

    public static void fillCircle5(Graphics graphics, int n, int n2) {
        if (!(graphics instanceof Graphics2D)) {
            graphics.fillOval(n - 2, n2 - 2, 4, 4);
            graphics.drawOval(n - 2, n2 - 2, 4, 4);
            return;
        }
        graphics.fillRect(n - 1, n2 - 1, 3, 3);
        Util.drawCircle5(graphics, n, n2);
    }

    public static void fillCircle2(Graphics graphics, int n, int n2) {
        if (!(graphics instanceof Graphics2D)) {
            graphics.fillOval(n - 1, n2 - 1, 2, 2);
            graphics.drawOval(n - 1, n2 - 1, 2, 2);
            return;
        }
        graphics.drawLine(n, n2 - 1, n, n2 + 1);
        graphics.drawLine(n - 1, n2, n + 1, n2);
    }

    private static void drawFleche1(Graphics graphics, double d, double d2, double d3, double d4, int n) {
        double d5;
        graphics.drawLine((int)d, (int)d2, (int)d3, (int)d4);
        if (d != d3) {
            d5 = FastMath.atan((d4 - d2) / (d3 - d));
            if (d > d3) {
                d5 += Math.PI;
            }
        } else {
            d5 = d2 < d4 ? 1.5707963267948966 : -1.5707963267948966;
        }
        double d6 = 2.356194490192345;
        double d7 = (double)n * FastMath.cos(d5 + d6);
        double d8 = (double)n * FastMath.sin(d5 + d6);
        double d9 = (double)n * FastMath.cos(d5 - d6);
        double d10 = (double)n * FastMath.sin(d5 - d6);
        graphics.drawLine((int)(d3 + d7), (int)(d4 + d8), (int)d3, (int)d4);
        graphics.drawLine((int)d3, (int)d4, (int)(d3 + d9), (int)(d4 + d10));
    }

    public static void drawFlecheOutLine(Graphics graphics, double d, double d2, double d3, double d4, int n, String string) {
        boolean bl = graphics instanceof Graphics2D;
        Graphics2D graphics2D = bl ? (Graphics2D)graphics : null;
        Object object = null;
        Stroke stroke = null;
        Color color = graphics.getColor();
        if (bl) {
            graphics.setColor(Color.black);
            object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            stroke = graphics2D.getStroke();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setStroke(new BasicStroke(2.4f, 1, 0));
            Util.drawFleche1(graphics, d, d2, d3, d4, n);
            graphics2D.setStroke(stroke);
            graphics.setColor(color);
        }
        Util.drawFleche1(graphics, d, d2, d3, d4, n);
        if (string != null) {
            d3 = d3 < d ? (d3 -= 10.0) : (d3 += 2.0);
            d4 = d4 > d2 ? (d4 += 10.0) : (d4 -= 2.0);
            if (bl) {
                Util.drawStringOutline(graphics, string, (int)d3, (int)d4, null, null);
            } else {
                graphics.drawString(string, (int)d3, (int)d4);
            }
        }
        if (bl) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        }
    }

    public static void drawFleche(Graphics graphics, double d, double d2, double d3, double d4, int n, String string) {
        Util.drawFleche1(graphics, d, d2, d3, d4, n);
        if (string != null) {
            d3 = d3 < d ? (d3 -= 10.0) : (d3 += 2.0);
            d4 = d4 > d2 ? (d4 += 10.0) : (d4 -= 2.0);
            graphics.drawString(string, (int)d3, (int)d4);
        }
    }

    public static void drawFillOval(Graphics graphics, int n, int n2, int n3, int n4, float f, Color color) {
        if (color != null) {
            graphics.setColor(color);
        }
        try {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(Util.getImageComposite(f));
            graphics2D.fillOval(n, n2, n3, n4);
            graphics2D.setComposite(composite);
        }
        catch (Exception exception) {
            // empty catch block
        }
        graphics.drawOval(n, n2, n3, n4);
    }

    public static void drawFillPolygon(Graphics graphics, Polygon polygon, float f, Color color) {
        if (color != null) {
            graphics.setColor(color);
        }
        try {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(Util.getImageComposite(f));
            graphics2D.fillPolygon(polygon);
            graphics2D.setComposite(composite);
        }
        catch (Exception exception) {
            // empty catch block
        }
        graphics.drawPolygon(polygon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawStringOutline(Graphics graphics, String string, int n, int n2, Color color, Color color2) {
        if (color == null) {
            color = graphics.getColor();
        }
        if (color2 == null) {
            color2 = Color.black;
        }
        if (!(graphics instanceof Graphics2D)) {
            graphics.drawString(string, n, n2);
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Color color3 = graphics2D.getColor();
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        AffineTransform affineTransform = graphics2D.getTransform();
        try {
            Font font = graphics2D.getFont();
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
            GlyphVector glyphVector = font.createGlyphVector(fontMetrics.getFontRenderContext(), string);
            Shape shape = glyphVector.getOutline();
            graphics2D.translate(n, n2);
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(new BasicStroke(1.6f, 2, 2));
            graphics.setColor(color2);
            graphics2D.draw(shape);
            graphics2D.setStroke(stroke);
            graphics2D.setColor(color);
            graphics2D.fill(shape);
        }
        finally {
            graphics2D.setTransform(affineTransform);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        graphics2D.setColor(color3);
    }

    public static void drawCartouche(Graphics graphics, int n, int n2, int n3, int n4, float f, Color color, Color color2) {
        Color color3;
        block6: {
            if (n4 % 2 == 1) {
                --n4;
            }
            color3 = graphics.getColor();
            try {
                Graphics2D graphics2D = (Graphics2D)graphics;
                Composite composite = graphics2D.getComposite();
                Composite composite2 = Util.getImageComposite(f);
                graphics2D.setComposite(composite2);
                if (color2 != null) {
                    graphics2D.setColor(color2);
                    graphics2D.fillRect(n, n2, n3, n4);
                    graphics2D.fillArc(n - n4 / 2, n2, n4, n4, 90, 180);
                    graphics2D.fillArc(n + n3 - n4 / 2, n2, n4, n4, 90, -180);
                }
                if (color != null) {
                    graphics2D.setColor(color);
                    graphics2D.drawLine(n, n2, n + n3, n2);
                    graphics2D.drawLine(n, n2 + n4, n + n3, n2 + n4);
                    graphics2D.drawArc(n - n4 / 2, n2, n4, n4, 90, 180);
                    graphics2D.drawArc(n + n3 - n4 / 2, n2, n4, n4, 90, -180);
                }
                graphics2D.setComposite(composite);
            }
            catch (Exception exception) {
                if (color2 != null) {
                    graphics.setColor(color2);
                    graphics.fillRect(n, n2, n3, n4);
                    graphics.fillArc(n - n4 / 2, n2, n4, n4, 90, 180);
                    graphics.fillArc(n + n3 - n4 / 2, n2, n4, n4, 90, -180);
                }
                if (color == null) break block6;
                graphics.setColor(color);
                graphics.drawLine(n, n2, n + n3, n2);
                graphics.drawLine(n, n2 + n4, n + n3, n2 + n4);
                graphics.drawArc(n - n4 / 2, n2, n4, n4, 90, 180);
                graphics.drawArc(n + n3 - n4 / 2, n2, n4, n4, 90, -180);
            }
        }
        graphics.setColor(color3);
    }

    public static void drawRoundRect(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color, Color color2) {
        graphics.setColor(color);
        graphics.drawLine(n + n5, n2, n + n3 - n5, n2);
        graphics.drawLine(n, n2 + n5, n, n2 + n4 - n5);
        graphics.drawArc(n, n2, n5 * 2, n5 * 2, 90, 90);
        graphics.drawArc(n + n3 - n5 * 2, n2, n5 * 2, n5 * 2, 90, -45);
        graphics.drawArc(n, n2 + n4 - n5 * 2, n5 * 2, n5 * 2, 180, 45);
        graphics.setColor(color2);
        graphics.drawLine(n + n5, n2 + n4, n + n3 - n5, n2 + n4);
        graphics.drawLine(n + n3, n2 + n5, n + n3, n2 + n4 - n5);
        graphics.drawArc(n + n3 - 2 * n5, n2 + n4 - 2 * n5, n5 * 2, n5 * 2, 270, 90);
        graphics.drawArc(n + n3 - n5 * 2, n2, n5 * 2, n5 * 2, 45, -45);
        graphics.drawArc(n, n2 + n4 - n5 * 2, n5 * 2, n5 * 2, 225, 45);
    }

    public static void drawStar(Graphics graphics, int n, int n2) {
        graphics.drawLine(n, n2 - 3, n, n2 - 2);
        graphics.drawLine(n - 1, n2 - 1, n + 1, n2 - 1);
        graphics.drawLine(n - 3, n2, n + 3, n2);
        graphics.drawLine(n - 2, n2 + 1, n + 2, n2 + 1);
        graphics.drawLine(n - 1, n2 + 2, n + 1, n2 + 2);
        graphics.drawLine(n - 2, n2 + 3, n - 2, n2 + 3);
        graphics.drawLine(n + 2, n2 + 3, n + 2, n2 + 3);
    }

    public static void drawRadio(Graphics graphics, int n, int n2, Color color, Color color2, Color color3, boolean bl) {
        int n3 = CINT.length + 1;
        if (color2 != null) {
            graphics.setColor(color2);
            graphics.fillRect(n + 1, n2 + 1, n3, n3);
        } else {
            for (int i = 0; i < CINT.length; ++i) {
                graphics.setColor(CINT[i]);
                graphics.drawLine(n + 1, n2 + 1 + i, n + CINT.length, n2 + 1 + i);
            }
        }
        graphics.setColor(color);
        graphics.drawArc(n, n2, n3, n3, 0, 360);
        if (bl) {
            graphics.setColor(color3 == null ? Color.black : color3);
            graphics.fillArc(n + 2, n2 + 2, n3 - 4, n3 - 4, 0, 360);
        }
    }

    public static void drawCheckbox(Graphics graphics, int n, int n2, Color color, Color color2, Color color3, boolean bl) {
        int n3;
        int n4 = CINT.length + 1;
        graphics.setColor(color);
        graphics.drawRect(n, n2, n4, n4);
        if (color2 != null) {
            graphics.setColor(color2);
            graphics.fillRect(n + 1, n2 + 1, n4, n4);
        } else {
            for (n3 = 0; n3 < CINT.length; ++n3) {
                graphics.setColor(CINT[n3]);
                graphics.drawLine(n + 1, n2 + 1 + n3, n + CINT.length, n2 + 1 + n3);
            }
        }
        if (bl) {
            graphics.setColor(color3 == null ? Color.black : color3);
            graphics.fillRect(n + 3, n2 + 4, 2, 5);
            for (n3 = 0; n3 < 4; ++n3) {
                graphics.drawLine(n + 5 + n3, n2 + 6 - n3, n + 5 + n3, n2 + 7 - n3);
            }
        }
    }

    public static void drawEllipse(Graphics graphics, double d, double d2, double d3, double d4, double d5) {
        if (graphics instanceof EPSGraphics) {
            ((EPSGraphics)graphics).drawEllipse(d, d2, d3, d4, d5);
        } else if (!(graphics instanceof Graphics2D)) {
            Util.drawEllipseOld(graphics, d, d2, d3, d4, d5);
        } else {
            Graphics2D graphics2D = (Graphics2D)graphics;
            AffineTransform affineTransform = graphics2D.getTransform();
            d5 = d5 * Math.PI / 180.0;
            graphics2D.rotate(d5, d, d2);
            graphics2D.draw(new Ellipse2D.Double(d - d3, d2 - d4, d3 * 2.0, d4 * 2.0));
            graphics2D.setTransform(affineTransform);
        }
    }

    public static void fillEllipse(Graphics graphics, double d, double d2, double d3, double d4, double d5) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        d5 = d5 * Math.PI / 180.0;
        graphics2D.rotate(d5, d, d2);
        graphics2D.fill(new Ellipse2D.Double(d - d3, d2 - d4, d3 * 2.0, d4 * 2.0));
        graphics2D.setTransform(affineTransform);
    }

    private static void drawEllipseOld(Graphics graphics, double d, double d2, double d3, double d4, double d5) {
        int n;
        d5 = d5 * Math.PI / 180.0;
        int n2 = 30;
        Point[] pointArray = new Point[n2];
        for (n = 0; n < n2; ++n) {
            double d6 = 2.0 * (double)n / (double)n2 * Math.PI;
            double d7 = d3 * FastMath.cos(d6);
            double d8 = d4 * FastMath.sin(d6);
            double d9 = d7 * FastMath.cos(d5) - d8 * FastMath.sin(d5) + d;
            double d10 = d7 * FastMath.sin(d5) + d8 * FastMath.cos(d5) + d2;
            pointArray[n] = new Point((int)d9, (int)d10);
        }
        for (n = 0; n < n2 - 1; ++n) {
            graphics.drawLine(pointArray[n].x, pointArray[n].y, pointArray[n + 1].x, pointArray[n + 1].y);
        }
        graphics.drawLine(pointArray[n2 - 1].x, pointArray[n2 - 1].y, pointArray[0].x, pointArray[0].y);
    }

    public static void toolTip(JComponent jComponent, String string) {
        Util.toolTip(jComponent, string, false);
    }

    public static void toolTip(JComponent jComponent, String string, boolean bl) {
        if (bl) {
            string = Util.fold(string, 40, true);
        }
        String string2 = jComponent.getToolTipText();
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (string2 == string) {
            return;
        }
        if (string2 == null || string == null || !string2.equals(string)) {
            jComponent.setToolTipText(string);
        }
    }

    public static void setCloseShortcut(JFrame jFrame, boolean bl) {
        Util.setCloseShortcut(jFrame, bl, Aladin.aladin);
    }

    public static void setCloseShortcut(final JFrame jFrame, final boolean bl, final Aladin aladin) {
        if (aladin != null) {
            jFrame.getRootPane().registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (aladin.getCommand().robotMode) {
                        aladin.stopRobot(jFrame);
                        return;
                    }
                    if (bl) {
                        jFrame.dispose();
                    } else {
                        jFrame.setVisible(false);
                    }
                }
            }, KeyStroke.getKeyStroke(27, 0), 2);
        }
        jFrame.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (bl) {
                    jFrame.dispose();
                } else {
                    jFrame.setVisible(false);
                }
            }
        }, KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), 2);
    }

    public static void pause(int n) {
        try {
            Thread.currentThread();
            Thread.sleep(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int indexInArrayOf(Object object, Object[] objectArray) {
        if (object == null || objectArray == null) {
            return -1;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (!object.equals(objectArray[i])) continue;
            return i;
        }
        return -1;
    }

    public static int indexInArrayOf(String string, String[] stringArray) {
        return Util.indexInArrayOf(string, stringArray, false);
    }

    public static int indexInArrayOf(String string, String[] stringArray, boolean bl) {
        if (string == null || stringArray == null) {
            return -1;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if ((bl || !string.equals(stringArray[i])) && (!bl || !string.equalsIgnoreCase(stringArray[i]))) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(String string, String string2) {
        return Util.indexOfIgnoreCase(string, string2, 0);
    }

    public static int indexOfIgnoreCase(String string, String string2, int n) {
        string = Util.toUpper(string);
        string2 = Util.toUpper(string2);
        return string.indexOf(string2, n);
    }

    public static String fillWithBlank(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = string.length(); i < n; ++i) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public static String slash(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '/') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(cArray[i]);
        }
        return stringBuffer.toString();
    }

    public static void resetString(StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        if (n == 0) {
            return;
        }
        stringBuffer.delete(0, n);
    }

    public static void resetString(StringBuilder stringBuilder) {
        int n = stringBuilder.length();
        if (n == 0) {
            return;
        }
        stringBuilder.delete(0, n);
    }

    public static String getShortPath(String string, int n) {
        try {
            if (string.length() > n) {
                File file = new File(string);
                StringTokenizer stringTokenizer = new StringTokenizer(file.getCanonicalPath(), FS, true);
                StringBuffer stringBuffer = new StringBuffer();
                n -= file.getName().length();
                String string2 = null;
                while (stringBuffer.length() < n && stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    stringBuffer.append(string2);
                }
                if (stringTokenizer.hasMoreTokens()) {
                    if (string2 != null && !string2.equals(FS)) {
                        stringBuffer.append(stringTokenizer.nextToken());
                    }
                    string2 = stringTokenizer.nextToken();
                    if (stringTokenizer.hasMoreElements()) {
                        stringBuffer.append("..." + FS);
                    }
                    stringBuffer.append(file.getName());
                }
                return stringBuffer.toString();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    public static String concatDir(String string, String string2) {
        return Util.concatDir(string, string2, FS.charAt(0));
    }

    public static String concatDir(String string, String string2, char c) {
        StringBuffer stringBuffer = new StringBuffer(100);
        char c2 = '\u0000';
        char c3 = c == '/' ? (char)'\\' : '/';
        for (int i = 0; i < 2; ++i) {
            if (c2 != c && stringBuffer.length() > 0) {
                stringBuffer.append(c);
            }
            String string3 = i == 0 ? string : string2;
            string3 = string3 == null ? "" : string3.trim();
            int n = string3.length();
            for (int j = 0; j < n; ++j) {
                c2 = string3.charAt(j);
                if (c2 == c3) {
                    c2 = c;
                }
                stringBuffer.append(c2);
            }
        }
        return stringBuffer.toString();
    }

    public static String toUpper(String string) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = Character.toUpperCase(cArray[i]);
        }
        return new String(cArray);
    }

    public static String toLower(String string) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = Character.toLowerCase(cArray[i]);
        }
        return new String(cArray);
    }

    public static String toUpLower(String string) {
        char[] cArray = string.toCharArray();
        boolean bl = true;
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = bl ? Character.toUpperCase(cArray[i]) : Character.toLowerCase(cArray[i]);
            bl = Character.isSpace(cArray[i]);
        }
        return new String(cArray);
    }

    public static JButton getHelpButton(final Component component, final String string) {
        JButton jButton = new JButton(new ImageIcon(Aladin.aladin.getImagette("Help.gif")));
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setBorderPainted(false);
        jButton.setContentAreaFilled(false);
        if (string != null) {
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Aladin.info(component, string);
                }
            });
        }
        return jButton;
    }

    public static boolean isUrlResponding(String string) {
        try {
            return Util.isUrlResponding(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    public static boolean isUrlResponding(URL uRL) {
        try {
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("HEAD");
            int n = httpURLConnection.getResponseCode();
            return n / 100 == 2;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isJPEGColored(String string) throws Exception {
        RandomAccessFile randomAccessFile = null;
        byte[] byArray = null;
        try {
            randomAccessFile = new RandomAccessFile(string, "r");
            byArray = new byte[(int)randomAccessFile.length()];
            randomAccessFile.readFully(byArray);
        }
        finally {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
        return Util.isColoredImage(byArray);
    }

    public static boolean isColoredImage(byte[] byArray) throws Exception {
        JButton jButton = new JButton();
        Image image = Toolkit.getDefaultToolkit().createImage(byArray);
        boolean bl = true;
        while (bl) {
            try {
                MediaTracker mediaTracker = new MediaTracker(Aladin.aladin);
                mediaTracker.addImage(image, 0);
                mediaTracker.waitForID(0);
                bl = false;
            }
            catch (InterruptedException interruptedException) {}
        }
        int n = image.getWidth(jButton);
        int n2 = image.getHeight(jButton);
        if (n == -1) {
            throw new Exception("width = -1");
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(image, 0, 0, jButton);
        graphics.finalize();
        graphics = null;
        int n3 = n * n2;
        int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        bufferedImage.flush();
        bufferedImage = null;
        for (int i = 0; i < n3; ++i) {
            int n4 = nArray[i];
            int n5 = n4 >>> 16 & 0xFF;
            int n6 = n4 >>> 8 & 0xFF;
            int n7 = n4 & 0xFF;
            if (n5 == n6 && n6 == n7) continue;
            return true;
        }
        return false;
    }

    public static long dirSize(File file) {
        if (file == null) {
            return 0L;
        }
        if (file.isFile()) {
            return file.length();
        }
        long l = 0L;
        File[] fileArray = file.listFiles();
        for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            l += Util.dirSize(file2);
        }
        return l;
    }

    public static boolean deleteDir(File file) {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl = Util.deleteDir(new File(file, stringArray[i]));
                if (bl) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static boolean deleteDir(File file, String string) {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl = Util.deleteDir(new File(file, stringArray[i]), string);
                if (bl) continue;
                return false;
            }
        } else if (file.getAbsolutePath().matches(string)) {
            return file.delete();
        }
        return true;
    }

    public static boolean touch(File file, boolean bl) {
        if (file.exists()) {
            if (!file.setLastModified(System.currentTimeMillis())) {
                return false;
            }
        } else if (bl) {
            try {
                return file.createNewFile();
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return true;
    }

    public static void createPath(String string) throws Exception {
        File file = new File(new File(string).getParent());
        file.mkdirs();
        if (!file.exists()) {
            throw new Exception("Cannot create directory for " + string);
        }
    }

    public static String dirBrowser(String string, String string2, JTextField jTextField, int n) {
        if (Aladin.aladin.configuration.isLookAndFeelJava()) {
            return Util.dirBrowserJava(string, string2, jTextField, n);
        }
        return Util.dirBrowserNative(null, string, string2, jTextField);
    }

    public static String dirBrowserJava(String string, String string2, JTextField jTextField, int n) {
        StringBuilder stringBuilder = null;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(new File(string2 == null ? "." : string2));
        jFileChooser.setDialogTitle(string);
        if (n == 3) {
            jFileChooser.setFileSelectionMode(1);
        } else {
            jFileChooser.setFileSelectionMode(2);
            if (n > 0) {
                final FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("Fits files (.fits ...)", "fits", "fit", "ftz", "fits.gz", "ftz.gz", "fz", "fits.bz2");
                final FileNameExtensionFilter object = new FileNameExtensionFilter("Hpx filter", "hpx");
                jFileChooser.addChoosableFileFilter(fileNameExtensionFilter);
                jFileChooser.addChoosableFileFilter(new FileFilter(){

                    @Override
                    public String getDescription() {
                        return "HEALPix Fits maps";
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public boolean accept(File file) {
                        if (file.isDirectory()) {
                            return true;
                        }
                        if (!fileNameExtensionFilter.accept(file) && !object.accept(file)) {
                            return false;
                        }
                        MyInputStream myInputStream = null;
                        try {
                            myInputStream = new MyInputStream(new FileInputStream(file));
                            if ((myInputStream.getType() & 0x100000000L) != 0L) {
                                boolean bl = true;
                                return bl;
                            }
                        }
                        catch (Exception exception) {
                        }
                        finally {
                            if (myInputStream != null) {
                                try {
                                    myInputStream.close();
                                }
                                catch (Exception exception) {}
                            }
                        }
                        return false;
                    }
                });
                if (n > 1) {
                    jFileChooser.addChoosableFileFilter(new FileFilter(){

                        @Override
                        public String getDescription() {
                            return "Hierarchical Progressive Surveys (HiPS)";
                        }

                        @Override
                        public boolean accept(File file) {
                            if (!file.isDirectory()) {
                                return false;
                            }
                            File file2 = new File(file.getAbsolutePath() + FS + "Norder3");
                            return file2.isDirectory();
                        }
                    });
                    jFileChooser.addChoosableFileFilter(new FileFilter(){

                        @Override
                        public String getDescription() {
                            return "Fits cubes";
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public boolean accept(File file) {
                            if (file.isDirectory()) {
                                return true;
                            }
                            if (!fileNameExtensionFilter.accept(file)) {
                                return false;
                            }
                            MyInputStream myInputStream = null;
                            try {
                                myInputStream = new MyInputStream(new FileInputStream(file));
                                if ((myInputStream.getType() & 0x2000000L) != 0L && (myInputStream.getType() & 0x200000L) == 0L) {
                                    boolean bl = true;
                                    return bl;
                                }
                            }
                            catch (Exception exception) {
                            }
                            finally {
                                if (myInputStream != null) {
                                    try {
                                        myInputStream.close();
                                    }
                                    catch (Exception exception) {}
                                }
                            }
                            return false;
                        }
                    });
                    jFileChooser.addChoosableFileFilter(new FileFilter(){

                        @Override
                        public String getDescription() {
                            return "Fits RGB images";
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public boolean accept(File file) {
                            if (file.isDirectory()) {
                                return true;
                            }
                            if (!fileNameExtensionFilter.accept(file)) {
                                return false;
                            }
                            MyInputStream myInputStream = null;
                            try {
                                myInputStream = new MyInputStream(new FileInputStream(file));
                                if ((myInputStream.getType() & 0x200000L) != 0L) {
                                    boolean bl = true;
                                    return bl;
                                }
                            }
                            catch (Exception exception) {
                            }
                            finally {
                                if (myInputStream != null) {
                                    try {
                                        myInputStream.close();
                                    }
                                    catch (Exception exception) {}
                                }
                            }
                            return false;
                        }
                    });
                    jFileChooser.addChoosableFileFilter(new FileFilter(){

                        @Override
                        public String getDescription() {
                            return "Multi-Order Coverage map (MOC)";
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public boolean accept(File file) {
                            if (file.isDirectory()) {
                                return true;
                            }
                            MyInputStream myInputStream = null;
                            try {
                                myInputStream = new MyInputStream(new FileInputStream(file));
                                if ((myInputStream.getType() & 0x1000000000L) != 0L) {
                                    boolean bl = true;
                                    return bl;
                                }
                            }
                            catch (Exception exception) {
                            }
                            finally {
                                if (myInputStream != null) {
                                    try {
                                        myInputStream.close();
                                    }
                                    catch (Exception exception) {}
                                }
                            }
                            return false;
                        }
                    });
                    jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Jpeg or png images (.png, .jpg)", "jpg", "jpeg", "png"));
                    jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("XML tables (.xml, .vot, ...)", "xml", "vot"));
                    jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("ASCII tables (.txt, .csv, .tbl)", "txt", "csv", "tbl"));
                    jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Aladin scripts (.ajs)", "ajs"));
                    jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Aladin stack backups (.aj)", "aj"));
                    jFileChooser.setMultiSelectionEnabled(true);
                }
            }
        }
        if (jFileChooser.showOpenDialog(null) == 0) {
            boolean bl = true;
            for (File file : jFileChooser.getSelectedFiles()) {
                String string3 = file.getAbsolutePath();
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(string3);
                    continue;
                }
                if (bl) {
                    stringBuilder = new StringBuilder(Util.Q(stringBuilder.toString()));
                }
                bl = false;
                stringBuilder.append(" " + Util.Q(string3));
            }
            if (stringBuilder == null && jFileChooser.getSelectedFile() != null) {
                stringBuilder = new StringBuilder(jFileChooser.getSelectedFile() + "");
            }
            if (stringBuilder != null) {
                jTextField.setText(stringBuilder + "");
            }
        }
        return stringBuilder == null ? null : stringBuilder + "";
    }

    private static String Q(String string) {
        return "\"" + string + "\"";
    }

    public static String dirBrowserNative(Frame frame, String string, String string2, JTextField jTextField) {
        FileDialog fileDialog = new FileDialog(frame, string);
        if (string2 != null) {
            fileDialog.setDirectory(string2);
        }
        fileDialog.setFile(DEFAULT_FILENAME);
        fileDialog.setVisible(true);
        String string3 = fileDialog.getDirectory();
        String string4 = fileDialog.getFile();
        boolean bl = false;
        if (string4 != null && string4.equals(DEFAULT_FILENAME)) {
            string4 = "";
            bl = true;
        }
        String string5 = (string3 == null ? "" : string3) + (string4 == null ? "" : string4);
        if (jTextField != null) {
            jTextField.setText(string5);
        }
        if (string4 != null && string4.length() > 0 || bl) {
            return string5;
        }
        return null;
    }

    public static String hex(char c) {
        return Util.hex((int)c);
    }

    public static String hex(int n) {
        return "" + HEX.charAt(n / 16) + HEX.charAt(n % 16);
    }

    public static Composite getFootprintComposite(float f) {
        return AlphaComposite.getInstance(3, f);
    }

    public static Composite getImageComposite(float f) {
        return AlphaComposite.getInstance(3, f);
    }

    public static void drawArea(Aladin aladin, Graphics graphics, Rectangle rectangle, Color color) {
        Util.drawArea(aladin, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, color, 0.15f, true);
    }

    public static void drawArea(Aladin aladin, Graphics graphics, int n, int n2, int n3, int n4, Color color, float f, boolean bl) {
        Color color2 = graphics.getColor();
        graphics.setColor(color);
        if (graphics instanceof Graphics2D && aladin.configuration.isTransparent()) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            Composite composite2 = Util.getImageComposite(f);
            graphics2D.setComposite(composite2);
            graphics2D.fillRect(n, n2, n3, n4);
            graphics2D.setComposite(composite);
            int n5 = n + n3;
            int n6 = n2 + n4;
            if (bl) {
                graphics2D.drawLine(n, n2, n5, n2);
                graphics2D.drawLine(n, n2, n, n6);
                graphics2D.setColor(color);
                graphics2D.drawLine(n5, n6, n5, n2);
                graphics2D.drawLine(n5, n6, n, n6);
            }
        } else if (bl) {
            graphics.drawRect(n, n2, n3, n4);
        }
        graphics.setColor(color2);
    }

    public static ImageIcon getDescSortIcon() {
        if (DESC_ICON == null) {
            DESC_ICON = new ImageIcon(Aladin.aladin.getImagette("arrow_up.gif"));
        }
        return DESC_ICON;
    }

    public static ImageIcon getAscSortIcon() {
        if (ASC_ICON == null) {
            ASC_ICON = new ImageIcon(Aladin.aladin.getImagette("arrow_down.gif"));
        }
        return ASC_ICON;
    }

    public static void decreasePriority(Thread thread, Thread thread2) {
        try {
            thread2.setPriority(thread.getPriority() - 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getDateFromMJD(String string) {
        try {
            String string2 = Astrodate.JDToDate(Astrodate.MJDToJD(Double.parseDouble(string)));
            int n = string2.indexOf("T");
            return n > 0 ? string2.substring(0, n) : string2;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String getTemps(long l) {
        return Util.getTemps(l, false);
    }

    public static String getTemps(long l, boolean bl) {
        long l2;
        StringBuffer stringBuffer = new StringBuffer();
        if (l > 86400000L) {
            l2 = l / 86400000L;
            l -= l2 * 86400000L;
            stringBuffer.append(l2 + "j");
        }
        if (l > 3600000L) {
            l2 = l / 3600000L;
            l -= l2 * 3600000L;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(l2 + "h");
        }
        if (l > 60000L) {
            l2 = l / 60000L;
            l -= l2 * 60000L;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(l2 + "m");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.append(' ');
        }
        stringBuffer.append((bl ? "" + l / 1000L : "" + (double)l / 1000.0) + "s");
        return stringBuffer.toString();
    }

    public static final long getTime() {
        return Util.getTime(1);
    }

    public static final long getTime(int n) {
        return n == 1 ? System.currentTimeMillis() : (n == 0 ? System.nanoTime() : System.currentTimeMillis() / 1000L);
    }

    public static final char getFitsType(String string) {
        int n = string.indexOf(40);
        if (n == -1) {
            n = string.length();
        }
        return string.charAt(n - 1);
    }

    public static final int binSizeOf(String string) throws Exception {
        try {
            int n = string.indexOf(40);
            if (n == -1) {
                n = string.length();
            }
            if (n == 1) {
                return Util.binSizeOf(string.charAt(0), 1);
            }
            if (n > 1 && string.charAt(n - 2) == 'P') {
                return 8;
            }
            int n2 = Integer.parseInt(string.substring(0, n - 1));
            return Util.binSizeOf(string.charAt(n - 1), n2);
        }
        catch (Exception exception) {
            System.err.println("Pb pour " + string);
            throw exception;
        }
    }

    public static final int binSizeOf(char c, int n) {
        if (c == 'X') {
            return n / 8 + (n % 8 > 0 ? 1 : 0);
        }
        int n2 = c == 'L' ? 1 : (c == 'B' ? 1 : (c == 'I' ? 2 : (c == 'J' ? 4 : (c == 'A' ? 1 : (c == 'E' ? 4 : (c == 'D' ? 8 : (c == 'K' ? 8 : (c == 'C' ? 8 : (c == 'M' ? 16 : (c == 'P' ? 8 : 0))))))))));
        return n2 * n;
    }

    public static final String getUnitDisk(long l) {
        return Util.getUnitDisk(l, 2);
    }

    public static final String getUnitDisk(long l, int n) {
        int n2 = 0;
        long l2 = 0L;
        boolean bl = false;
        if (l < 0L) {
            bl = true;
            l = -l;
        }
        while (l >= 1024L && n2 < unites.length - 1) {
            ++n2;
            long l3 = l / 1024L;
            l2 = l % 1024L;
            l = l3;
        }
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(n);
        double d = (double)l + (double)l2 / 1024.0;
        return (bl ? DEFAULT_FILENAME : "") + numberFormat.format(d) + unites[n2];
    }

    public static ArrayList<File> getFiles(String string, String string2) {
        File[] fileArray;
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file : fileArray = new File(string).listFiles()) {
            if (file.isDirectory()) {
                arrayList.addAll(Util.getFiles(file.getAbsolutePath(), string2));
                continue;
            }
            if (!file.getName().endsWith(string2)) continue;
            arrayList.add(file);
        }
        return arrayList;
    }

    public static boolean find(String string, String string2) {
        File[] fileArray;
        for (File file : fileArray = new File(string).listFiles()) {
            if (file.isDirectory()) {
                return Util.find(file.getAbsolutePath(), string2);
            }
            if (!file.getName().endsWith(string2)) continue;
            return true;
        }
        return false;
    }

    public static void httpsInit() {
        HostnameVerifier hostnameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String string, SSLSession sSLSession) {
                System.out.println("Warning: URL Host: " + string + " vs. " + sSLSession.getPeerHost());
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
        TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }};
        try {
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(null, trustManagerArray, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        catch (KeyManagementException keyManagementException) {
            keyManagementException.printStackTrace();
        }
    }

    public static final double tand(double d) {
        return Math.tan(d * (Math.PI / 180));
    }

    public static final double cosd(double d) {
        return Math.cos(d * (Math.PI / 180));
    }

    public static String createVOTable(List<Forme> list) {
        StringBuffer stringBuffer = new StringBuffer().append("<?xml version=\"1.0\"?>\n").append("<VOTABLE version=\"1.2\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n").append("xmlns=\"http://www.ivoa.net/xml/VOTable/v1.2\"\n").append("xmlns:stc=\"http://www.ivoa.net/xml/STC/v1.30\" >\n").append("<RESOURCE>\n").append("<TABLE>\n").append("<GROUP ID=\"J2000\" utype=\"stc:AstroCoords\">\n").append("  <PARAM datatype=\"char\" arraysize=\"*\" ucd=\"pos.frame\" name=\"cooframe\"\n").append("    utype=\"stc:AstroCoords.coord_system_id\" value=\"ICRS\" />\n").append("  <FIELDref ref=\"ra\"/>\n").append("  <FIELDref ref=\"dec\"/>\n").append("</GROUP>\n").append("<FIELD name=\"RA\" ID=\"ra\" ucd=\"pos.eq.ra;meta.main\" ref=\"J2000\"\n").append("  utype=\"stc:AstroCoords.Position2D.Value2.C1\"\n").append("  datatype=\"double\" unit=\"deg\" />\n").append("<FIELD name=\"Dec\" ID=\"dec\" ucd=\"pos.eq.dec;meta.main\" ref=\"J2000\"\n").append("  utype=\"stc:AstroCoords.Position2D.Value2.C2\"\n").append("  datatype=\"double\" unit=\"deg\" />\n").append("<DATA><TABLEDATA>\n");
        for (Forme forme : list) {
            stringBuffer.append(String.format((Locale)null, "<TR><TD>%.5f</TD><TD>%.5f</TD></TR>\n", forme.o[0].getRa(), forme.o[0].getDec()));
        }
        stringBuffer.append("</TABLEDATA></DATA>\n").append("</TABLE>\n").append("</RESOURCE>\n").append("</VOTABLE>");
        return stringBuffer.toString();
    }

    public static String extractJSON(String string, String string2) {
        String string3 = "\"" + string + "\"";
        int n = string2.indexOf(string);
        if (n < 0) {
            return null;
        }
        int n2 = string2.indexOf(34, n + string3.length() + 1);
        if (n2 < 0) {
            return null;
        }
        return Tok.unQuote(new Tok(string2.substring(n2), "},").nextToken());
    }

    public static String toB64(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer((int)((double)byArray.length * 1.25));
        char[] cArray = B64.toCharArray();
        char[] cArray2 = new char[4];
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            int n3 = byArray[n2++] & 0xFF;
            int n4 = n3 << 16;
            cArray2[3] = 61;
            cArray2[2] = 61;
            if (n2 < byArray.length) {
                n3 = byArray[n2++] & 0xFF;
                n4 |= n3 << 8;
                cArray2[2] = '\u0000';
                if (n2 < byArray.length) {
                    n3 = byArray[n2++] & 0xFF;
                    n4 |= n3;
                    cArray2[3] = '\u0000';
                }
            }
            if (cArray2[3] == '\u0000') {
                cArray2[3] = cArray[n4 & 0x3F];
            }
            n4 >>= 6;
            if (cArray2[2] == '\u0000') {
                cArray2[2] = cArray[n4 & 0x3F];
            }
            cArray2[1] = cArray[(n4 >>= 6) & 0x3F];
            cArray2[0] = cArray[(n4 >>= 6) & 0x3F];
            stringBuffer.append(cArray2);
            if ((n += 4) % 64 != 0) continue;
            stringBuffer.append(CR + " ");
        }
        return stringBuffer.toString();
    }

    public static String escapeJSON(String string) {
        if (string.indexOf(34) < 0 && string.indexOf(92) < 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        StringBuilder stringBuilder = new StringBuilder(cArray.length);
        for (int i = 0; i < cArray.length; ++i) {
            char c;
            char c2 = cArray[i];
            if (c2 == '\"') {
                stringBuilder.append('\\');
            } else if (c2 == '\\' && i < cArray.length - 1 && (c = cArray[i + 1]) != 'n' && c != 't') {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    static {
        DF.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        DF.setGroupingSize(0);
        CEBOX = new Color(172, 168, 153);
        CIBOX = new Color(113, 111, 100);
        CINT = new Color[]{new Color(232, 239, 246), new Color(243, 247, 250), new Color(255, 255, 255), new Color(243, 247, 251), new Color(232, 239, 247), new Color(221, 232, 243), new Color(215, 228, 241), new Color(210, 224, 239), new Color(205, 221, 237)};
        HEX = "0123456789ABCDEF";
        unites = new String[]{"B", "KB", "MB", "GB", "TB", "PB", "EB", "ZB"};
        B64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    }
}

