/*
 * Decompiled with CFR 0.152.
 */
package cds.tools.parser;

import cds.astro.Unit;
import cds.tools.parser.Abs;
import cds.tools.parser.AbsOp;
import cds.tools.parser.AbstractOperateur;
import cds.tools.parser.AdditionOp;
import cds.tools.parser.Atan;
import cds.tools.parser.AtanOp;
import cds.tools.parser.BasicOperator;
import cds.tools.parser.ConstantValOp;
import cds.tools.parser.Cos;
import cds.tools.parser.CosOp;
import cds.tools.parser.Deg2Rad;
import cds.tools.parser.Deg2RadOp;
import cds.tools.parser.DivideOp;
import cds.tools.parser.Exp;
import cds.tools.parser.ExpOp;
import cds.tools.parser.Function;
import cds.tools.parser.Log;
import cds.tools.parser.LogOp;
import cds.tools.parser.MultOp;
import cds.tools.parser.NepLog;
import cds.tools.parser.NepLogOp;
import cds.tools.parser.Node;
import cds.tools.parser.Operator;
import cds.tools.parser.ParserException;
import cds.tools.parser.PowerOp;
import cds.tools.parser.Rad2Deg;
import cds.tools.parser.Rad2DegOp;
import cds.tools.parser.Sin;
import cds.tools.parser.SinOp;
import cds.tools.parser.Sqrt;
import cds.tools.parser.SqrtOp;
import cds.tools.parser.SubtractOp;
import cds.tools.parser.Tan;
import cds.tools.parser.TanOp;
import cds.tools.parser.VariableOp;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.text.ParseException;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;

public final class Parser {
    private static HashMap functions;
    private static HashMap operators;
    private static Function[] AVAIL_FUNC;
    private static Class[] AVAIL_OP_CLASSES;
    private static String[] OP_CLASSES_KW;
    private HashMap varsOp = new HashMap(5);
    private int state = 0;
    private static final int ADD = 43;
    private static final int SUBTRACT = 45;
    private static final int DIVIDE = 47;
    private static final int MULTIPLY = 42;
    private static final int POWER = 94;
    private static final int GRP = 40;
    private static final int ENDGRP = 41;
    private static final int UNDERSCORE = 95;
    private static final int OPSQBR = 91;
    private static final int CLSQBR = 93;
    private static final BasicOperator OP_ADD;
    private static final BasicOperator OP_MUL;
    private static final BasicOperator OP_DIV;
    private static final BasicOperator OP_SUB;
    private static final BasicOperator OP_GRP;
    private static final BasicOperator OP_ENDGRP;
    private static final BasicOperator OP_POW;
    private Node root = null;
    private String str;
    AbstractOperateur rootOperator;
    static Class[] FUNC_OPERATOR;

    public Parser() {
        this.str = "0";
    }

    public Parser(String string) {
        this.str = !string.equals("") ? new String(string) : "0";
    }

    private static void initFunc() {
        for (int i = 0; i < AVAIL_FUNC.length; ++i) {
            Parser.addFunc(AVAIL_FUNC[i]);
        }
    }

    private static void initOperators() {
        for (int i = 0; i < OP_CLASSES_KW.length; ++i) {
            operators.put(OP_CLASSES_KW[i], AVAIL_OP_CLASSES[i]);
        }
    }

    public void parseString(String string) {
        this.str = string;
        this.parseString();
    }

    protected static String encodeExpr(String string, HashMap hashMap) {
        int n;
        String string2;
        String[] stringArray = new String[hashMap.size()];
        Iterator iterator = hashMap.keySet().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            stringArray[n2] = string2 = (String)iterator.next();
            ++n2;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = stringArray[i];
            for (n = i + 1; n < stringArray.length; ++n) {
                if (stringArray[n].length() <= string2.length()) continue;
                String string3 = string2;
                string2 = stringArray[n];
                stringArray[n] = string3;
                stringArray[i] = string2;
            }
        }
        String[] stringArray2 = new String[hashMap.size()];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray2[n] = Parser.encodeVariable(stringArray[n]);
        }
        return Parser.putEncodedVariables(string, stringArray, stringArray2);
    }

    private static String putEncodedVariables(String string, String[] stringArray, String[] stringArray2) {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = new String(string);
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = Parser.replace(string2, stringArray[i], stringArray2[i], -1);
        }
        return string2;
    }

    public void parseString() {
        this.str = Parser.encodeExpr(this.str, this.varsOp);
        Stack stack = new Stack();
        Stack stack2 = new Stack();
        StringReader stringReader = new StringReader(this.str);
        StreamTokenizer streamTokenizer = new StreamTokenizer(stringReader);
        streamTokenizer.parseNumbers();
        streamTokenizer.lowerCaseMode(false);
        streamTokenizer.ordinaryChar(43);
        streamTokenizer.ordinaryChar(45);
        streamTokenizer.ordinaryChar(42);
        streamTokenizer.ordinaryChar(47);
        streamTokenizer.ordinaryChar(94);
        streamTokenizer.wordChars(95, 95);
        streamTokenizer.wordChars(91, 93);
        streamTokenizer.wordChars(123, 123);
        streamTokenizer.wordChars(125, 125);
        streamTokenizer.wordChars(32, 32);
        streamTokenizer.wordChars(64, 64);
        streamTokenizer.wordChars(33, 33);
        streamTokenizer.wordChars(126, 126);
        streamTokenizer.wordChars(38, 38);
        streamTokenizer.wordChars(96, 96);
        streamTokenizer.wordChars(92, 92);
        streamTokenizer.wordChars(36, 36);
        streamTokenizer.wordChars(59, 59);
        streamTokenizer.wordChars(58, 58);
        try {
            int n;
            this.state = 0;
            block9: while ((n = streamTokenizer.nextToken()) != -1) {
                switch (this.state) {
                    case 0: {
                        this.parserState0(streamTokenizer, stack, stack2);
                        continue block9;
                    }
                    case 1: {
                        this.parserState1(streamTokenizer, stack, stack2);
                        continue block9;
                    }
                    case 2: {
                        this.parserState2(streamTokenizer, stack, stack2);
                        continue block9;
                    }
                    case 3: {
                        continue block9;
                    }
                }
            }
            this.parserState2(streamTokenizer, stack, stack2);
            this.root = (Node)stack.elementAt(0);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        catch (EmptyStackException emptyStackException) {
            throw new ParserException();
        }
        this.buildOperator();
    }

    private void buildOperator() {
        this.rootOperator = this.buildOperator(this.root);
    }

    private AbstractOperateur buildOperator(Node node) {
        switch (node.type) {
            case 3: {
                return this.getOperateurForFunc(node.svalue, this.buildOperator(node.left));
            }
            case 0: {
                return this.getOperateurForOp(node.op, this.buildOperator(node.left), this.buildOperator(node.right));
            }
            case 2: {
                return this.findVarOp(Parser.decodeVariable(node.svalue));
            }
            case 1: {
                return new ConstantValOp(node.getValue());
            }
        }
        return null;
    }

    private AbstractOperateur getOperateurForFunc(String string, AbstractOperateur abstractOperateur) {
        AbstractOperateur abstractOperateur2;
        try {
            Class clazz = (Class)operators.get(string);
            Constructor constructor = clazz.getConstructor(AbstractOperateur.class);
            abstractOperateur2 = (AbstractOperateur)constructor.newInstance(abstractOperateur);
        }
        catch (Exception exception) {
            return null;
        }
        return abstractOperateur2;
    }

    private AbstractOperateur getOperateurForOp(int n, AbstractOperateur abstractOperateur, AbstractOperateur abstractOperateur2) {
        switch (n) {
            case 43: {
                return new AdditionOp(abstractOperateur, abstractOperateur2);
            }
            case 45: {
                return new SubtractOp(abstractOperateur, abstractOperateur2);
            }
            case 47: {
                return new DivideOp(abstractOperateur, abstractOperateur2);
            }
            case 42: {
                return new MultOp(abstractOperateur, abstractOperateur2);
            }
            case 94: {
                return new PowerOp(abstractOperateur, abstractOperateur2);
            }
        }
        return null;
    }

    public final double eval() {
        return this.rootOperator.compute();
    }

    public final double oldEval() {
        return this.eval(this.root);
    }

    public static void addFunc(Function function) {
        functions.put(function.keyword(), function);
    }

    public void addVar(String string) {
        this.varsOp.put(string, new VariableOp());
    }

    public boolean setVarUnit(String string, String string2) {
        VariableOp variableOp = (VariableOp)this.varsOp.get(string);
        if (variableOp == null) {
            throw new ParserException("method setVar : Unknown variable " + string + " !!!");
        }
        if (string2 == null) {
            string2 = "";
        }
        try {
            Unit unit = new Unit(string2);
            unit.setValue(variableOp.getValue());
            variableOp.setUnit(unit);
        }
        catch (ParseException parseException) {
            return false;
        }
        return true;
    }

    public void setVar(String string, double d) {
        try {
            VariableOp variableOp = (VariableOp)this.varsOp.get(string);
            variableOp.setValue(d);
        }
        catch (NullPointerException nullPointerException) {
            throw new ParserException("method setVar : Unknown variable " + string + " !!!");
        }
    }

    public Iterator getVariables() {
        return this.varsOp.keySet().iterator();
    }

    public boolean isConstant() {
        return !this.getVariables().hasNext();
    }

    private double getVar(String string) {
        VariableOp variableOp = (VariableOp)this.varsOp.get(string);
        if (variableOp == null) {
            throw new ParserException("methode getVar : La variable " + string + " est inconnue!!!");
        }
        return variableOp.getValue();
    }

    private VariableOp findVarOp(String string) {
        return (VariableOp)this.varsOp.get(string);
    }

    private static BasicOperator getOp(int n) {
        switch (n) {
            case 43: {
                return OP_ADD;
            }
            case 45: {
                return OP_SUB;
            }
            case 42: {
                return OP_MUL;
            }
            case 47: {
                return OP_DIV;
            }
            case 94: {
                return OP_POW;
            }
            case 40: {
                return OP_GRP;
            }
            case 41: {
                return OP_ENDGRP;
            }
        }
        return null;
    }

    private double eval(Node node) {
        double d = 0.0;
        if (node == null) {
            throw new ParserException("methode eval : noeud null !!!");
        }
        switch (node.type) {
            case 0: {
                d = this.evalOp(node);
                break;
            }
            case 1: {
                d = node.getValue();
                break;
            }
            case 2: {
                d = this.evalVar(node);
                break;
            }
            case 3: {
                d = this.evalFunc(node);
                break;
            }
            default: {
                throw new ParserException("methode eval : Ce noeud est de type inconnu !!!");
            }
        }
        return d;
    }

    private double evalOp(Node node) {
        double d = 0.0;
        switch (node.op) {
            case 43: {
                if (node.left != null) {
                    d = this.eval(node.left);
                }
                d += this.eval(node.right);
                break;
            }
            case 45: {
                if (node.right != null) {
                    d = this.eval(node.right);
                }
                d = this.eval(node.left) - d;
                break;
            }
            case 47: {
                d = this.eval(node.left);
                d /= this.eval(node.right);
                break;
            }
            case 42: {
                d = this.eval(node.left);
                d *= this.eval(node.right);
                break;
            }
            case 94: {
                d = Math.pow(this.eval(node.left), this.eval(node.right));
                break;
            }
            default: {
                throw new ParserException("methode evalOp : Operateur inconnu !!!");
            }
        }
        return d;
    }

    private double evalFunc(Node node) {
        Function function = (Function)functions.get(node.svalue);
        if (function == null) {
            throw new ParserException("method evalFunc : la fonction " + node.svalue + " est inconnue !!!");
        }
        return function.eval(this.eval(node.left));
    }

    private double evalVar(Node node) {
        VariableOp variableOp = (VariableOp)this.varsOp.get(Parser.decodeVariable(node.svalue));
        if (variableOp == null) {
            throw new ParserException("methode evalVar : la variable " + node.svalue + " est inconnue !!!");
        }
        return variableOp.getValue();
    }

    public Unit evalUnit() throws ParseException {
        return this.evalUnit(this.root);
    }

    private Unit evalUnit(Node node) throws ParseException {
        Unit unit = null;
        if (node == null) {
            throw new ParserException("methode eval : noeud null !!!");
        }
        switch (node.type) {
            case 0: {
                unit = this.evalOpUnit(node);
                break;
            }
            case 1: {
                try {
                    unit = new Unit(new Double(node.getValue()).toString());
                    break;
                }
                catch (ParseException parseException) {
                    System.out.println("Error for a VALUE node");
                    throw parseException;
                }
            }
            case 2: {
                unit = this.evalVarUnit(node);
                break;
            }
            case 3: {
                unit = this.evalFuncUnit(node);
                break;
            }
            default: {
                throw new ParserException("methode eval : Ce noeud est de type inconnu !!!");
            }
        }
        return unit;
    }

    private Unit evalFuncUnit(Node node) throws ParseException {
        Function function = (Function)functions.get(node.svalue);
        if (function == null) {
            throw new ParserException("method evalFunc : la fonction " + node.svalue + " est inconnue !!!");
        }
        return function.evalUnit(this.evalUnit(node.left));
    }

    private Unit evalVarUnit(Node node) throws ParseException {
        VariableOp variableOp = (VariableOp)this.varsOp.get(Parser.decodeVariable(node.svalue));
        if (variableOp == null) {
            throw new ParserException("methode evalVar : la variable " + node.svalue + " est inconnue !!!");
        }
        Unit unit = new Unit(variableOp.getUnit());
        return unit;
    }

    private Unit evalOpUnit(Node node) throws ParseException {
        Unit unit = null;
        switch (node.op) {
            case 43: {
                if (node.left != null) {
                    unit = new Unit(this.evalUnit(node.left));
                }
                unit.plus(this.evalUnit(node.right));
                break;
            }
            case 45: {
                if (node.right != null) {
                    unit = new Unit(this.evalUnit(node.right));
                }
                if (!node.left.valueIsSet()) {
                    unit.setValue(-unit.value);
                    break;
                }
                Unit unit2 = this.evalUnit(node.left);
                unit2.minus(unit);
                unit = unit2;
                break;
            }
            case 47: {
                unit = new Unit(this.evalUnit(node.left));
                unit.div(this.evalUnit(node.right));
                break;
            }
            case 42: {
                unit = new Unit(this.evalUnit(node.left));
                unit.mult(this.evalUnit(node.right));
                break;
            }
            case 94: {
                if (node.right.type == 1) {
                    double d = this.eval(node.right);
                    int n = (int)d;
                    if (Double.valueOf(n + "") == d) {
                        unit = new Unit(this.evalUnit(node.left));
                        unit.power(n);
                        break;
                    }
                    unit = new Unit(this.evalOp(node) + "(" + this.evalUnit((Node)node.left).symbol + ")" + this.eval(node.right));
                    break;
                }
                if (node.left.type == 1) {
                    unit = new Unit(this.evalUnit(node.left));
                    break;
                }
                unit = new Unit(this.evalUnit(node.left));
                break;
            }
            default: {
                throw new ParserException("methode evalOp : Operateur inconnu !!!");
            }
        }
        return unit;
    }

    private static int precedence(int n) {
        switch (n) {
            case 43: {
                return 1;
            }
            case 45: {
                return 2;
            }
            case 42: {
                return 3;
            }
            case 47: {
                return 3;
            }
            case 94: {
                return 5;
            }
        }
        return -1;
    }

    private void parserState0(StreamTokenizer streamTokenizer, Stack stack, Stack stack2) throws IOException {
        switch (streamTokenizer.ttype) {
            case -3: {
                VariableOp variableOp = (VariableOp)this.varsOp.get(Parser.decodeVariable(streamTokenizer.sval));
                if (variableOp != null) {
                    Node node = new Node();
                    node.type = 2;
                    node.svalue = streamTokenizer.sval;
                    stack.push(node);
                    this.state = 2;
                    break;
                }
                Function function = (Function)functions.get(streamTokenizer.sval);
                if (function != null) {
                    stack2.push(function);
                    this.state = 0;
                    break;
                }
                throw new ParserException("Le mot " + streamTokenizer.sval + " est inconnu !");
            }
            case -2: {
                Node node = new Node();
                node.type = 1;
                node.setValue(streamTokenizer.nval);
                stack.push(node);
                this.state = 2;
                break;
            }
            case 43: {
                stack2.push(Parser.getOp(43));
                Node node = new Node();
                node.type = 1;
                stack.push(node);
                this.state = 1;
                break;
            }
            case 45: {
                stack2.push(Parser.getOp(45));
                Node node = new Node();
                node.type = 1;
                stack.push(node);
                this.state = 1;
                break;
            }
            case 40: {
                stack2.push(Parser.getOp(40));
                this.state = 0;
                break;
            }
            default: {
                throw new ParserException("Le parsing a echoue !!");
            }
        }
    }

    private void parserState1(StreamTokenizer streamTokenizer, Stack stack, Stack stack2) throws IOException {
        switch (streamTokenizer.ttype) {
            case -3: {
                VariableOp variableOp = (VariableOp)this.varsOp.get(Parser.decodeVariable(streamTokenizer.sval));
                if (variableOp != null) {
                    Node node = new Node();
                    node.type = 2;
                    node.svalue = streamTokenizer.sval;
                    stack.push(node);
                    this.state = 2;
                    break;
                }
                Function function = (Function)functions.get(streamTokenizer.sval);
                if (function != null) {
                    stack2.push(function);
                    this.state = 0;
                    break;
                }
                throw new ParserException("Le mot " + streamTokenizer.sval + " est inconnu !");
            }
            case -2: {
                Node node = new Node();
                node.type = 1;
                node.setValue(streamTokenizer.nval);
                stack.push(node);
                this.state = 2;
                break;
            }
            case 40: {
                stack2.push(Parser.getOp(40));
                this.state = 0;
                break;
            }
            default: {
                throw new ParserException("Le parsing a echoue !!");
            }
        }
    }

    private void parserState2(StreamTokenizer streamTokenizer, Stack stack, Stack stack2) throws IOException {
        switch (streamTokenizer.ttype) {
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 94: {
                BasicOperator basicOperator = Parser.getOp(streamTokenizer.ttype);
                if (!stack2.empty()) {
                    Operator operator = (Operator)stack2.peek();
                    while (operator.precedence() >= basicOperator.precedence()) {
                        Node node;
                        Node node2;
                        Operator operator2;
                        if (operator.type == 0) {
                            operator2 = (BasicOperator)stack2.pop();
                            node2 = (Node)stack.pop();
                            node = (Node)stack.pop();
                            Node node3 = new Node();
                            node3.type = 0;
                            node3.op = ((BasicOperator)operator2).op;
                            node3.left = node;
                            node3.right = node2;
                            stack.push(node3);
                        } else if (operator.type == 1) {
                            operator2 = (Function)stack2.pop();
                            node2 = (Node)stack.pop();
                            node = new Node();
                            node.type = 3;
                            node.svalue = operator2.keyword();
                            node.left = node2;
                            node.right = null;
                            stack.push(node);
                        }
                        if (stack2.empty()) break;
                        operator = (Operator)stack2.peek();
                    }
                }
                stack2.push(basicOperator);
                this.state = 1;
                break;
            }
            case 41: {
                BasicOperator basicOperator = Parser.getOp(streamTokenizer.ttype);
                if (!stack2.empty()) {
                    Operator operator = (Operator)stack2.pop();
                    while (!operator.keyword().equals("(")) {
                        Node node;
                        Node node4;
                        Operator operator3;
                        if (operator.type == 0) {
                            operator3 = (BasicOperator)operator;
                            node4 = (Node)stack.pop();
                            node = (Node)stack.pop();
                            Node node5 = new Node();
                            node5.type = 0;
                            node5.op = ((BasicOperator)operator3).op;
                            node5.left = node;
                            node5.right = node4;
                            stack.push(node5);
                        } else if (operator.type == 1) {
                            operator3 = (Function)operator;
                            node4 = (Node)stack.pop();
                            node = new Node();
                            node.type = 3;
                            node.svalue = operator3.keyword();
                            node.left = node4;
                            node.right = null;
                            stack.push(node);
                        }
                        if (stack2.empty()) break;
                        operator = (Operator)stack2.pop();
                    }
                }
                this.state = 2;
                break;
            }
            case -1: {
                while (!stack2.empty()) {
                    Node node;
                    Node node6;
                    Operator operator;
                    Operator operator4 = (Operator)stack2.pop();
                    if (operator4.type == 0) {
                        operator = (BasicOperator)operator4;
                        node6 = (Node)stack.pop();
                        node = (Node)stack.pop();
                        Node node7 = new Node();
                        node7.type = 0;
                        node7.op = ((BasicOperator)operator).op;
                        node7.left = node;
                        node7.right = node6;
                        stack.push(node7);
                        continue;
                    }
                    if (operator4.type != 1) continue;
                    operator = (Function)operator4;
                    node6 = (Node)stack.pop();
                    node = new Node();
                    node.type = 3;
                    node.svalue = operator.keyword();
                    node.left = node6;
                    node.right = null;
                    stack.push(node);
                }
                this.state = 0;
                break;
            }
            default: {
                throw new ParserException("Le parsing a echoue !!");
            }
        }
    }

    public static String[] getAvailFunc() {
        String[] stringArray = new String[AVAIL_FUNC.length];
        for (int i = 0; i < AVAIL_FUNC.length; ++i) {
            stringArray[i] = AVAIL_FUNC[i].keyword();
        }
        return stringArray;
    }

    protected static final String encodeVariable(String string) {
        if (string == null) {
            return null;
        }
        String string2 = new String(string);
        string2 = string2.replace('+', '@');
        string2 = string2.replace('-', '!');
        string2 = string2.replace('*', '~');
        string2 = string2.replace('/', '&');
        string2 = string2.replace('.', '`');
        string2 = string2.replace('(', '\\');
        string2 = string2.replace(')', '^');
        return string2;
    }

    protected static String decodeVariable(String string) {
        if (string == null) {
            return null;
        }
        String string2 = new String(string);
        string2 = string2.replace('@', '+');
        string2 = string2.replace('!', '-');
        string2 = string2.replace('~', '*');
        string2 = string2.replace('&', '/');
        string2 = string2.replace('`', '.');
        string2 = string2.replace('\\', '(');
        string2 = string2.replace('^', ')');
        return string2;
    }

    public String getExpr() {
        return this.str;
    }

    public static String replace(String string, String string2, String string3, int n) {
        if (string == null || string2 == null || string3 == null || string2.length() == 0 || n == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n2 = 0;
        int n3 = 0;
        while ((n3 = string.indexOf(string2, n2)) != -1) {
            stringBuffer.append(string.substring(n2, n3)).append(string3);
            n2 = n3 + string2.length();
            if (--n != 0) continue;
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    static {
        AVAIL_FUNC = new Function[]{new Sin(), new Cos(), new Tan(), new Log(), new NepLog(), new Abs(), new Deg2Rad(), new Rad2Deg(), new Sqrt(), new Exp(), new Atan()};
        AVAIL_OP_CLASSES = new Class[]{SinOp.class, CosOp.class, TanOp.class, LogOp.class, NepLogOp.class, AbsOp.class, Deg2RadOp.class, Rad2DegOp.class, SqrtOp.class, ExpOp.class, AtanOp.class};
        OP_CLASSES_KW = new String[]{"sin", "cos", "tan", "log", "ln", "abs", "deg2rad", "rad2deg", "sqrt", "exp", "atan"};
        functions = new HashMap(10);
        operators = new HashMap(10);
        Parser.initFunc();
        Parser.initOperators();
        OP_ADD = new BasicOperator(Parser.precedence(43), 43);
        OP_MUL = new BasicOperator(Parser.precedence(42), 42);
        OP_DIV = new BasicOperator(Parser.precedence(47), 47);
        OP_SUB = new BasicOperator(Parser.precedence(45), 45);
        OP_GRP = new BasicOperator(0, 40);
        OP_ENDGRP = new BasicOperator(0, 41);
        OP_POW = new BasicOperator(Parser.precedence(94), 94);
        FUNC_OPERATOR = new Class[0];
    }
}

