/*
 * Decompiled with CFR 0.152.
 */
package cds.tools.pixtools;

import healpix.essentials.HealpixBase;
import healpix.essentials.Pointing;
import healpix.essentials.RangeSet;
import healpix.essentials.Scheme;
import healpix.essentials.Vec3;
import java.util.ArrayList;

public final class CDSHealpix {
    public static final int MAXORDER = 29;
    private static HealpixBase[] hpxBase = new HealpixBase[30];
    public static final double cPr = Math.PI / 180;
    private static final int[] A = new int[]{3, 2, 0, 1};

    public static HealpixBase getHealpixBase(int n) throws Exception {
        if (hpxBase[n] == null) {
            CDSHealpix.hpxBase[n] = new HealpixBase((int)CDSHealpix.pow2(n), Scheme.NESTED);
        }
        return hpxBase[n];
    }

    private static int init(long l) throws Exception {
        int n = (int)CDSHealpix.log2(l);
        if (hpxBase[n] != null) {
            return n;
        }
        CDSHealpix.hpxBase[n] = new HealpixBase((int)l, Scheme.NESTED);
        return n;
    }

    public static double[] pix2ang_nest(long l, long l2) throws Exception {
        Pointing pointing = hpxBase[CDSHealpix.init(l)].pix2ang(l2);
        return new double[]{pointing.theta, pointing.phi};
    }

    public static long ang2pix_nest(long l, double d, double d2) throws Exception {
        return hpxBase[CDSHealpix.init(l)].ang2pix(new Pointing(d, d2));
    }

    public static long[] query_disc(long l, double d, double d2, double d3) throws Exception {
        return CDSHealpix.query_disc(l, d, d2, d3, true);
    }

    public static long[] query_disc(long l, double d, double d2, double d3, boolean bl) throws Exception {
        RangeSet rangeSet;
        int n = CDSHealpix.init(l);
        RangeSet rangeSet2 = rangeSet = bl ? hpxBase[n].queryDiscInclusive(CDSHealpix.pointing(d, d2), d3, 4) : hpxBase[n].queryDisc(CDSHealpix.pointing(d, d2), d3);
        if (rangeSet == null) {
            return new long[0];
        }
        return rangeSet.toArray();
    }

    public static long[] query_polygon(long l, ArrayList<double[]> arrayList) throws Exception {
        int n = CDSHealpix.init(l);
        Pointing[] pointingArray = new Pointing[arrayList.size()];
        int n2 = 0;
        for (double[] dArray : arrayList) {
            pointingArray[n2++] = CDSHealpix.pointing(dArray[0], dArray[1]);
        }
        RangeSet rangeSet = hpxBase[n].queryPolygonInclusive(pointingArray, 4);
        if (rangeSet == null) {
            return new long[0];
        }
        return rangeSet.toArray();
    }

    private static double dec(Pointing pointing) {
        return (1.5707963267948966 - pointing.theta) / (Math.PI / 180);
    }

    private static double ra(Pointing pointing) {
        return pointing.phi / (Math.PI / 180);
    }

    public static Pointing pointing(double d, double d2) {
        return new Pointing(1.5707963267948966 - Math.PI / 180 * d2, d * (Math.PI / 180));
    }

    public static double[][] corners(long l, long l2) throws Exception {
        Vec3[] vec3Array = hpxBase[CDSHealpix.init(l)].boundaries(l2, 1);
        double[][] dArray = new double[vec3Array.length][2];
        for (int i = 0; i < vec3Array.length; ++i) {
            Pointing pointing = new Pointing(vec3Array[i]);
            int n = A[i];
            dArray[n][0] = CDSHealpix.ra(pointing);
            dArray[n][1] = CDSHealpix.dec(pointing);
        }
        return dArray;
    }

    public static double[][] borders(long l, long l2, int n) throws Exception {
        Vec3[] vec3Array = hpxBase[CDSHealpix.init(l)].boundaries(l2, n);
        double[][] dArray = new double[vec3Array.length][2];
        for (int i = 0; i < vec3Array.length; ++i) {
            Pointing pointing = new Pointing(vec3Array[i]);
            dArray[i][0] = CDSHealpix.ra(pointing);
            dArray[i][1] = CDSHealpix.dec(pointing);
        }
        return dArray;
    }

    public static long[] neighbours(long l, long l2) throws Exception {
        return hpxBase[CDSHealpix.init(l)].neighbours(l2);
    }

    public static long nest2ring(long l, long l2) throws Exception {
        return hpxBase[CDSHealpix.init(l)].nest2ring(l2);
    }

    public static long ring2nest(long l, long l2) throws Exception {
        return hpxBase[CDSHealpix.init(l)].ring2nest(l2);
    }

    public static double pixRes(long l) {
        double d = 0.0;
        double d2 = Math.toDegrees(1.0);
        double d3 = Math.PI * 4 * d2 * d2;
        double d4 = d3 * 3600.0 * 3600.0;
        long l2 = 12L * l * l;
        d = d4 / (double)l2;
        d = Math.sqrt(d);
        return d;
    }

    static long nsidepix2uniq(long l, long l2) {
        return 4L * l * l + l2;
    }

    static long[] uniq2nsidepix(long l) {
        return CDSHealpix.uniq2nsidepix(l, null);
    }

    static long[] uniq2nsidepix(long l, long[] lArray) {
        if (lArray == null) {
            lArray = new long[2];
        }
        long l2 = CDSHealpix.log2(l / 4L) / 2L;
        lArray[0] = CDSHealpix.pow2(l2);
        lArray[1] = l - 4L * lArray[0] * lArray[0];
        return lArray;
    }

    public static final long pow2(long l) {
        return 1L << (int)l;
    }

    public static final long log2(long l) {
        int n = 0;
        while (l >>> ++n > 0L) {
        }
        return --n;
    }

    public static double[] radecToPolar(double[] dArray) {
        return CDSHealpix.radecToPolar(dArray, new double[2]);
    }

    public static double[] radecToPolar(double[] dArray, double[] dArray2) {
        dArray2[0] = 1.5707963267948966 - dArray[1] / 180.0 * Math.PI;
        dArray2[1] = dArray[0] / 180.0 * Math.PI;
        return dArray2;
    }

    public static double[] polarToRadec(double[] dArray) {
        return CDSHealpix.polarToRadec(dArray, new double[2]);
    }

    public static double[] polarToRadec(double[] dArray, double[] dArray2) {
        dArray2[1] = (1.5707963267948966 - dArray[0]) * 180.0 / Math.PI;
        dArray2[0] = dArray[1] * 180.0 / Math.PI;
        return dArray2;
    }
}

