/*
 * Decompiled with CFR 0.152.
 */
package cds.tools.pixtools;

import cds.aladin.Coord;
import cds.aladin.HealpixKey;
import cds.aladin.Localisation;
import cds.aladin.PointD;
import cds.aladin.Projection;
import cds.aladin.ViewSimple;
import cds.moc.MocCell;
import cds.tools.pixtools.CDSHealpix;
import java.awt.Graphics;
import java.awt.Polygon;

public final class Hpix
extends MocCell {
    private static final int[] ORDRE = new int[]{0, 1, 3, 2};
    private int frame;
    private long ovIZ;
    private PointD[] viewCorners;
    private Coord[] corners;
    private int nNull;
    private boolean computeCorners;

    public Hpix(String string) throws Exception {
        int n = string.indexOf(47);
        this.init(Integer.parseInt(string.substring(0, n)), Long.parseLong(string.substring(n + 1)), 3);
    }

    public Hpix(int n, long l) {
        this.init(n, l, 3);
    }

    public Hpix(int n, long l, int n2) {
        this.init(n, l, n2);
    }

    public int getFrame() {
        return this.frame;
    }

    public Coord[] getCorners() {
        if (!this.computeCorners) {
            this.computeCorners();
        }
        return this.corners;
    }

    public void fill(Graphics graphics, ViewSimple viewSimple) {
        PointD[] pointDArray = this.getProjViewCorners(viewSimple);
        if (pointDArray == null) {
            return;
        }
        double d = this.getMaxSize(viewSimple);
        Polygon polygon = new Polygon();
        int n = -1;
        for (int i = 0; i < pointDArray.length; ++i) {
            int n2 = ORDRE[i];
            if (pointDArray[n2] == null || n >= 0 && HealpixKey.dist(pointDArray, n, n2) > d * d) continue;
            polygon.addPoint((int)pointDArray[n2].x, (int)pointDArray[n2].y);
            n = n2;
        }
        graphics.fillPolygon(polygon);
    }

    public void draw(Graphics graphics, ViewSimple viewSimple, boolean bl) {
        double d;
        int n;
        int n2;
        int n3;
        PointD[] pointDArray = this.getProjViewCorners(viewSimple);
        if (pointDArray == null) {
            return;
        }
        boolean bl2 = true;
        double d2 = Double.MAX_VALUE;
        for (n3 = 0; n3 < 4; ++n3) {
            n2 = ORDRE[n3 == 0 ? 3 : n3 - 1];
            n = ORDRE[n3];
            if (pointDArray[n2] == null || pointDArray[n] == null) {
                bl2 = false;
                continue;
            }
            d = Math.sqrt(HealpixKey.dist(pointDArray, n2, n));
            if (!(d < d2)) continue;
            d2 = d;
        }
        if (d2 == Double.MAX_VALUE) {
            d2 = 0.0;
        }
        if (bl2) {
            for (n3 = 0; n3 < 4; ++n3) {
                n2 = ORDRE[n3 == 0 ? 3 : n3 - 1];
                n = ORDRE[n3];
                if (pointDArray[n2] == null || pointDArray[n] == null) {
                    bl2 = false;
                    continue;
                }
                d = Math.sqrt(HealpixKey.dist(pointDArray, n2, n));
                if (d > 1.0 && d2 > 0.0 && d > 6.0 * d2) {
                    bl2 = false;
                    continue;
                }
                if (!bl) continue;
                graphics.drawLine((int)pointDArray[n2].x, (int)pointDArray[n2].y, (int)pointDArray[n].x, (int)pointDArray[n].y);
            }
        }
    }

    public double getDiag2(ViewSimple viewSimple) {
        PointD[] pointDArray = this.getProjViewCorners(viewSimple);
        if (pointDArray == null) {
            return 0.0;
        }
        if (pointDArray[0] == null || pointDArray[1] == null || pointDArray[2] == null || pointDArray[3] == null) {
            return 0.0;
        }
        double d = HealpixKey.dist(pointDArray, 3, 0);
        double d2 = HealpixKey.dist(pointDArray, 2, 1);
        return Math.max(d, d2);
    }

    public boolean isPoleCorner() {
        long l = CDSHealpix.pow2(this.order);
        l *= l;
        long l2 = 12L * l;
        for (int i = 1; i <= 4; ++i) {
            long l3 = l * (long)i;
            if (this.npix != l3 - 1L && this.npix != l2 - l3) continue;
            return true;
        }
        return false;
    }

    public PointD[] getProjViewCorners(ViewSimple viewSimple) {
        int n;
        long l = viewSimple.getIZ();
        if (this.ovIZ == l) {
            if (this.nNull > 1) {
                return null;
            }
            return this.viewCorners;
        }
        Projection projection = viewSimple.getProj();
        Coord[] coordArray = this.getCorners();
        if (projection == null || coordArray == null) {
            return null;
        }
        this.nNull = 0;
        if (this.viewCorners == null) {
            this.viewCorners = new PointD[coordArray.length];
        }
        for (n = 0; n < coordArray.length; ++n) {
            Coord coord = coordArray[n];
            projection.getXY(coord);
            if (Double.isNaN(coord.x)) {
                ++this.nNull;
                if (this.nNull > 1) {
                    return null;
                }
                this.viewCorners[n] = null;
                continue;
            }
            if (this.viewCorners[n] == null) {
                this.viewCorners[n] = new PointD(coord.x, coord.y);
                continue;
            }
            this.viewCorners[n].x = coord.x;
            this.viewCorners[n].y = coord.y;
        }
        for (n = 0; n < coordArray.length; ++n) {
            if (this.viewCorners[n] == null) continue;
            viewSimple.getViewCoordDble(this.viewCorners[n], this.viewCorners[n].x, this.viewCorners[n].y);
        }
        this.ovIZ = l;
        return this.viewCorners;
    }

    public boolean isOutView(ViewSimple viewSimple) {
        return this.isOutView(viewSimple, null);
    }

    public boolean isOutView(ViewSimple viewSimple, PointD[] pointDArray) {
        double d;
        double d2;
        if (viewSimple.isAllSky()) {
            return false;
        }
        int n = viewSimple.getWidth();
        int n2 = viewSimple.getHeight();
        if (pointDArray == null) {
            pointDArray = this.getProjViewCorners(viewSimple);
        }
        if (pointDArray == null) {
            return true;
        }
        if (pointDArray[0] == null || pointDArray[1] == null || pointDArray[2] == null || pointDArray[3] == null) {
            return false;
        }
        double d3 = d2 = pointDArray[0].x;
        double d4 = d = pointDArray[0].y;
        for (int i = 1; i < 4; ++i) {
            if (pointDArray[i].x < d3) {
                d3 = pointDArray[i].x;
            } else if (pointDArray[i].x > d2) {
                d2 = pointDArray[i].x;
            }
            if (pointDArray[i].y < d4) {
                d4 = pointDArray[i].y;
                continue;
            }
            if (!(pointDArray[i].y > d)) continue;
            d = pointDArray[i].y;
        }
        if (d3 < 0.0 && d2 < 0.0 || d3 >= (double)n && d2 >= (double)n) {
            return true;
        }
        return d4 < 0.0 && d < 0.0 || d4 >= (double)n2 && d >= (double)n2;
    }

    @Override
    public String toString() {
        return this.order + "/" + this.npix + (this.computeCorners ? ": " + this.corners[0] + " / " + this.corners[1] + " / " + this.corners[2] + " / " + this.corners[3] : "");
    }

    private void init(int n, long l, int n2) {
        this.order = n;
        this.npix = l;
        this.frame = n2;
        this.computeCorners = false;
    }

    private void computeCorners() {
        try {
            long l = CDSHealpix.pow2(this.order);
            double[][] dArray = CDSHealpix.corners(l, this.npix);
            this.corners = new Coord[4];
            for (int i = 0; i < dArray.length; ++i) {
                this.corners[i] = new Coord(dArray[i][0], dArray[i][1]);
            }
            this.corners = this.computeCornersToICRS(this.corners);
            this.computeCorners = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Coord[] computeCornersToICRS(Coord[] coordArray) {
        if (this.frame == 0) {
            return coordArray;
        }
        for (int i = 0; i < 4; ++i) {
            coordArray[i] = Localisation.frameToFrame(coordArray[i], this.frame, 0);
        }
        return coordArray;
    }

    private double getMaxSize(ViewSimple viewSimple) {
        double d = 200.0;
        if (!viewSimple.isAllSky()) {
            double d2 = CDSHealpix.pixRes(CDSHealpix.pow2(this.order)) / 3600.0;
            double d3 = viewSimple.getPixelSize();
            d = d2 / d3 * 4.0;
        }
        return d;
    }
}

