/*
 * Decompiled with CFR 0.152.
 */
package cds.tools.pixtools;

import cds.aladin.Coord;
import cds.tools.pixtools.CDSHealpix;
import java.io.File;

public class Util {
    public static final int DIRSIZE = 10000;
    public static final String FS = cds.tools.Util.FS;
    public static final String CR = cds.tools.Util.CR;
    private static double twothird = 0.6666666666666666;
    static int[] HPX1024XY = new int[0x100001];

    public static Coord[] getCorners(int n, long l) throws Exception {
        return Util.getCorners(null, n, l);
    }

    public static Coord[] getCorners(Coord[] coordArray, int n, long l) throws Exception {
        long l2 = CDSHealpix.pow2(n);
        double[][] dArray = CDSHealpix.corners(l2, l);
        if (coordArray == null) {
            coordArray = new Coord[4];
        }
        for (int i = 0; i < 4; ++i) {
            coordArray[i] = new Coord(dArray[i][0], dArray[i][1]);
        }
        return coordArray;
    }

    public static String getFilePath(String string, int n, long l) {
        return Util.getFilePath(string, n, l, 0);
    }

    public static String getFilePath(String string, int n, long l, int n2) {
        String string2 = string != null && string.length() > 0 ? string : "";
        String string3 = Util.getFilePath(n, l, n2);
        return cds.tools.Util.concatDir(string2, string3);
    }

    public static String getFilePath(int n, long l) {
        return Util.getFilePath(n, l, 0);
    }

    public static String getFilePath(int n, long l, int n2) {
        return "Norder" + n + "/Dir" + l / 10000L * 10000L + "/Npix" + l + (n2 <= 0 ? "" : "_" + n2);
    }

    public static int getOrderFromPath(String string) {
        int n = string.indexOf("Norder");
        if (n == -1) {
            return -1;
        }
        int n2 = Integer.parseInt(string.substring(n + 6, string.indexOf(FS, n)));
        return n2;
    }

    public static long getNpixFromPath(String string) {
        int n = string.lastIndexOf("Npix");
        if (n < 0) {
            return -1L;
        }
        int n2 = string.indexOf(95, n);
        if (n2 < 0) {
            n2 = string.indexOf(46, n);
        }
        if (n2 < 0) {
            n2 = string.length();
        }
        return Long.parseLong(string.substring(n + 4, n2));
    }

    public static long getNDirFromPath(String string) {
        int n = string.indexOf("Dir");
        long l = Long.parseLong(string.substring(n + 3, string.indexOf(FS, n)));
        return l;
    }

    public static int getMaxOrderByPath(String string) {
        int n = -1;
        File file = new File(string);
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                int n2;
                String string2;
                if (!fileArray[i].isDirectory() || !(string2 = fileArray[i].getName()).startsWith("Norder") || (n2 = Integer.parseInt(string2.substring(6))) <= n) continue;
                n = n2;
            }
        }
        return n;
    }

    public static int computeNFiles(File file) {
        int n = 0;
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                int n2 = Util.computeNFiles(new File(file, stringArray[i]));
                n += n2;
            }
        } else {
            ++n;
        }
        return n;
    }

    private static void fillUp(int[] nArray, int n, int[] nArray2) {
        int n2;
        int n3 = n * n;
        int[][] nArray3 = new int[4][n3 / 4];
        int[] nArray4 = new int[4];
        for (n2 = 0; n2 < n3; ++n2) {
            int n4 = n2 % n < n / 2 ? 0 : 1;
            int n5 = n2 < n3 / 2 ? 1 : 0;
            int n6 = n4 << 1 | n5;
            int n7 = nArray2 == null ? n2 : nArray2[n2];
            nArray[n7] = nArray[n7] << 2 | n6;
            int n8 = n6;
            int n9 = nArray4[n8];
            nArray4[n8] = n9 + 1;
            nArray3[n6][n9] = n7;
        }
        if (n3 > 4) {
            for (n2 = 0; n2 < 4; ++n2) {
                Util.fillUp(nArray, n / 2, nArray3[n2]);
            }
        }
    }

    public static int[] createHpx2xy(int n) {
        int[] nArray = null;
        int[] nArray2 = null;
        if (n == 0) {
            nArray2 = new int[]{0};
            return nArray2;
        }
        int n2 = (int)CDSHealpix.pow2(n);
        nArray = new int[n2 * n2];
        nArray2 = new int[n2 * n2];
        Util.fillUp(nArray, n2, null);
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[nArray[i]] = i;
        }
        return nArray2;
    }

    public static int[] createXy2Hpx(int n) {
        int[] nArray = null;
        if (n == 0) {
            nArray = new int[]{0};
            return nArray;
        }
        int n2 = (int)CDSHealpix.pow2(n);
        nArray = new int[n2 * n2];
        Util.fillUp(nArray, n2, null);
        return nArray;
    }

    public static int[] hpx2XY(int n) {
        int[] nArray = new int[2];
        nArray[1] = HPX1024XY[n + 1] / 1024;
        nArray[0] = HPX1024XY[n + 1] - nArray[1] * 1024;
        return nArray;
    }

    public static int[] hpx2XY(long l, int n) {
        double d = 0.0;
        double d2 = Math.pow(2.0, n) * Math.pow(2.0, n);
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        for (int i = n - 1; i >= 0; --i) {
            d2 = Math.pow(2.0, i + 1) * Math.pow(2.0, i + 1);
            if ((double)l <= d + (d2 - d) / 4.0) {
                nArray[i] = 0;
                nArray2[i] = 0;
                continue;
            }
            if ((double)l <= d + (d2 - d) / 2.0) {
                nArray[i] = 1;
                nArray2[i] = 0;
                l -= (long)Math.pow(4.0, i);
                continue;
            }
            if ((double)l <= d + 3.0 * (d2 - d) / 4.0) {
                nArray[i] = 0;
                nArray2[i] = 1;
                l -= 2L * (long)Math.pow(4.0, i);
                continue;
            }
            if (!((double)l <= d2)) continue;
            nArray[i] = 1;
            nArray2[i] = 1;
            l -= 3L * (long)Math.pow(4.0, i);
        }
        int[] nArray3 = new int[]{0, 0};
        for (int i = 0; i < n; ++i) {
            nArray3[0] = (int)((long)nArray3[0] + (long)nArray[i] * (long)Math.pow(2.0, i));
            nArray3[1] = (int)((long)nArray3[1] + (long)nArray2[i] * (long)Math.pow(2.0, i));
        }
        return nArray3;
    }

    public static long XY2Hpx(int n, int n2, int n3) {
        double d = 0.0;
        double d2 = Math.pow(2.0, n3);
        double d3 = 0.0;
        double d4 = Math.pow(2.0, n3);
        int[] nArray = new int[n3];
        for (int i = n3 - 1; i >= 0; --i) {
            double d5 = (d + d2) / 2.0;
            double d6 = (d3 + d4) / 2.0;
            if ((double)n < d5 && (double)n2 < d6) {
                nArray[i] = 0;
                d2 = d5;
                d4 = d6;
                continue;
            }
            if ((double)n >= d5 && (double)n2 < d6) {
                nArray[i] = 1;
                d = d5;
                d4 = d6;
                continue;
            }
            if ((double)n < d5 && (double)n2 >= d6) {
                nArray[i] = 2;
                d3 = d6;
                d2 = d5;
                continue;
            }
            if (!((double)n >= d5) || !((double)n2 >= d6)) continue;
            nArray[i] = 3;
            d = d5;
            d3 = d6;
        }
        long l = 0L;
        for (int i = 0; i < n3; ++i) {
            l += (long)nArray[i] * (long)Math.pow(4.0, i);
        }
        return l;
    }

    public static long RingNum(long l, double d, boolean bl) {
        long l2 = 0L;
        l2 = bl ? (long)Math.floor((double)l * (2.0 - 1.5 * d)) : (long)Math.ceil((double)l * (2.0 - 1.5 * d));
        if (d > twothird && (l2 = bl ? (long)Math.floor((double)l * Math.sqrt(3.0 * (1.0 - d))) : (long)Math.ceil((double)l * Math.sqrt(3.0 * (1.0 - d)))) == 0L) {
            l2 = 1L;
        }
        if (d < -twothird) {
            l2 = bl ? (long)Math.floor((double)l * Math.sqrt(3.0 * (1.0 + d))) : (long)Math.ceil((double)l * Math.sqrt(3.0 * (1.0 + d)));
            if (l2 == 0L) {
                l2 = 1L;
            }
            l2 = 4L * l - l2;
        }
        return l2;
    }

    public static final int nside(int n) {
        return 1 << n;
    }

    public static final int order(int n) {
        int n2 = 0;
        while (n >>> ++n2 > 0) {
        }
        return --n2;
    }

    public static final long nbrPix(int n) {
        return 12L * (long)n * (long)n;
    }

    public static final long idx(long l, int n, int n2) {
        if (n < n2) {
            throw new IllegalArgumentException("'orderFrom' must be greatest than 'orderTo'!");
        }
        return l >>> (n - n2 << 1);
    }

    public static final int min(int n, int n2, int n3) {
        if (n2 > n3) {
            throw new IllegalArgumentException("'orderFrom' must be smaller than 'orderTo'!");
        }
        return n << (n3 - n2 << 1);
    }

    public static final int max(int n, int n2, int n3) {
        if (n2 > n3) {
            throw new IllegalArgumentException("'orderFrom' must be smaller than 'orderTo'!");
        }
        return (++n << (n3 - n2 << 1)) - 1;
    }
}

