/*
 * Decompiled with CFR 0.152.
 */
package cds.vizier;

import java.awt.Font;
import java.awt.Toolkit;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class VizieRList
extends JList {
    protected JTextField catalog;
    protected JButton getReadMe;
    protected int hCaracterCount = 0;
    protected MyList list;
    static final boolean LSCREEN = Toolkit.getDefaultToolkit().getScreenSize().width > 1000;
    protected static final int SIZE = LSCREEN ? 12 : 10;
    protected static Font COURIER = new Font("Monospaced", 0, SIZE);

    public VizieRList(JTextField jTextField, JButton jButton, Vector vector) {
        this(jTextField, jButton, vector, 20);
    }

    public VizieRList(JTextField jTextField, JButton jButton, Vector vector, int n) {
        this.setVisibleRowCount(n);
        this.catalog = jTextField;
        this.getReadMe = jButton;
        this.setFont(COURIER);
        this.list = new MyList();
        this.setModel(this.list);
        this.preSelection(vector);
        this.addListSelectionListener(new ListenList());
    }

    public VizieRList(Vector vector) {
        this(null, null, vector, 20);
    }

    public void preSelection(Vector vector) {
        this.list.initList(vector);
    }

    public Vector getList() {
        return this.list.v;
    }

    public void resetList() {
        this.getSelectionModel().clearSelection();
    }

    public JTextField getCatalogField() {
        return this.catalog;
    }

    public JTextField getCatalogTextField() {
        return this.catalog;
    }

    public void setReadMeButton(JButton jButton) {
        this.getReadMe = jButton;
    }

    public void setCatalogTextField(JTextField jTextField) {
        this.catalog = jTextField;
    }

    public JButton getReadMeButton() {
        return this.getReadMe;
    }

    public int getHCaracterCount() {
        return this.hCaracterCount;
    }

    class ListenList
    implements ListSelectionListener {
        ListenList() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            Object object;
            Object object2;
            int n;
            Object object3 = "";
            Object[] objectArray = VizieRList.this.getSelectedValues();
            for (n = 0; n < objectArray.length; ++n) {
                object2 = new StringTokenizer((String)objectArray[n], " :");
                object = ((StringTokenizer)object2).nextToken();
                object3 = !((String)object3).equals("") ? (String)object3 + "," + (String)object : object;
            }
            if (VizieRList.this.catalog != null) {
                VizieRList.this.catalog.setText((String)object3);
            }
            if (VizieRList.this.getReadMe != null) {
                VizieRList.this.getReadMe.setEnabled(n == 1);
                object2 = (String)VizieRList.this.getSelectedValue();
                if (object2 != null) {
                    object = new StringTokenizer((String)object2, " :");
                    String string = ((StringTokenizer)object).nextToken();
                }
            }
        }
    }

    class MyList
    implements ListModel {
        private Vector v;

        MyList() {
        }

        protected int initList(Vector vector) {
            this.v = (Vector)vector.clone();
            int n = 0;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                int n2 = ((String)enumeration.nextElement()).length();
                if (n2 <= n) continue;
                n = n2;
            }
            return n;
        }

        protected void add(String string) {
            this.v.add(string);
        }

        public Object getElementAt(int n) {
            return this.v.elementAt(n);
        }

        @Override
        public int getSize() {
            return this.v.size();
        }

        @Override
        public void addListDataListener(ListDataListener listDataListener) {
        }

        @Override
        public void removeListDataListener(ListDataListener listDataListener) {
        }
    }
}

