/*
 * Decompiled with CFR 0.152.
 */
package cds.vizier;

import cds.aladin.Aladin;
import cds.aladin.Chaine;
import cds.aladin.MyInputStream;
import cds.aladin.MyLabel;
import cds.aladin.ServerVizieR;
import cds.tools.CDSConstants;
import cds.tools.CDSMethods;
import cds.vizier.VizieRQuery;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.DataInputStream;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class VizieRPanel
extends JPanel
implements CDSConstants {
    protected MyLabel titre = null;
    protected JTextField tauthor = new JTextField(15);
    protected JTextField ttarget = new JTextField(15);
    protected JTextField tradius = new JTextField(15);
    protected JComboBox unit = new JComboBox();
    protected JComboBox coordinate = null;
    protected DataInputStream vizierStream = null;
    protected int outputMode = 1;
    protected JList[] lk;
    private MyList resList = new MyList();
    protected JList resultat = new JList(this.resList);
    protected String target = null;
    protected String radius = null;
    protected int nSection;
    protected Aladin aladin;
    static final String SUBMIT = "SUBMIT";
    String DEFAULT_TITRE;
    String KEYWORD;
    static final String TITRE = "Copyright CDS, a changer";
    static final int DEFAULTROWS = 6;
    VizieRQuery vq = null;
    private ServerVizieR vizier;
    protected BorderLayout borderLayout1 = new BorderLayout();
    private int oc = 0;

    protected void setTitre(String string) {
        String string2 = null;
        String string3 = string2 = string == null ? this.DEFAULT_TITRE : "Click directly on the SUBMIT button to retrieve all VizieR catalogs around " + string + "\n or include constraints below to reduce the number of matching catalogs.";
        if (string2 != null) {
            this.titre.setText(string2);
        } else {
            this.titre.setText("probleme");
        }
    }

    protected void createChaine() {
        VizieRPanel vizieRPanel = this;
        Chaine chaine = vizieRPanel.aladin.getChaine();
        this.DEFAULT_TITRE = chaine.getString("VZINFO2");
        this.KEYWORD = chaine.getString("VZKEYWORD");
    }

    public VizieRPanel(ServerVizieR serverVizieR, int n, boolean bl, String string, String string2, int n2) {
        try {
            this.vizier = serverVizieR;
            this.aladin = serverVizieR.aladin;
            this.createChaine();
            this.outputMode = n;
            this.vq = new VizieRQuery();
            this.vq.setGLU(this.aladin.glu);
            if (!this.vq.metaDataQuery() || this.vq.getNameKey().size() == 0) {
                System.err.println("VizieR meta query error " + (this.vq.getMetaError() == null ? "" : this.vq.getMetaError()));
            }
            this.nSection = this.vq.getNameKey().size();
            this.setLayout(this.borderLayout1);
            this.makeForm(bl, string, string2, n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public VizieRQuery getVizieRQuery() {
        return this.vq;
    }

    protected static void makeCursor(Component component, int n) {
        while (component != null && !(component instanceof Frame)) {
            component = component.getParent();
        }
        if (component == null) {
            return;
        }
        ((Frame)component).setCursor(n == 1 ? 3 : (n == 2 ? 12 : (n == 3 ? 1 : (n == 4 ? 13 : (n == 5 ? 8 : (n == 6 ? 2 : 0))))));
    }

    private void waitCursor() {
        this.makeCursor(1);
    }

    private void defaultCursor() {
        this.makeCursor(0);
    }

    private void makeCursor(int n) {
        if (this.oc == n) {
            return;
        }
        VizieRPanel.makeCursor(this, n);
        if (this.resultat != null) {
            VizieRPanel.makeCursor(this.resultat, n);
        }
        VizieRPanel.makeCursor(this.tauthor, n);
        for (int i = 0; i < this.lk.length; ++i) {
            VizieRPanel.makeCursor(this.lk[i], n);
        }
        this.oc = n;
    }

    private String getSectionName(String string) {
        int n;
        char[] cArray = string.toCharArray();
        for (n = 0; n < cArray.length && cArray[n] != '.'; ++n) {
        }
        return n == cArray.length ? string : new String(cArray, n + 1, cArray.length - n - 1);
    }

    protected static void makeAdd(Container container, Component component, String string) {
        try {
            container.add(component, string);
        }
        catch (Error error) {
            container.add(string, component);
        }
    }

    protected void makeForm(boolean bl, String string, String string2, int n) {
        JLabel jLabel;
        GridBagLayout gridBagLayout;
        JPanel jPanel = null;
        JPanel jPanel2 = null;
        JPanel jPanel3 = null;
        JPanel jPanel4 = null;
        JPanel jPanel5 = null;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.titre = new MyLabel(this.DEFAULT_TITRE, 1, PLAIN);
        this.titre.setBackground(Aladin.BLUE);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(3, 3));
        jPanel = new JPanel();
        jPanel.setBackground(Aladin.BLUE);
        jPanel.setLayout(new BorderLayout(3, 3));
        jPanel.setFont(BOLD);
        JPanel jPanel6 = new JPanel();
        jPanel6.setBackground(Aladin.BLUE);
        jPanel6.setLayout(new BorderLayout(3, 3));
        VizieRPanel.makeAdd(jPanel, new JLabel(this.KEYWORD), "West");
        VizieRPanel.makeAdd(jPanel, this.tauthor, "Center");
        if (string == null && string2 == null) {
            jPanel3 = new JPanel();
            gridBagLayout = new GridBagLayout();
            jPanel3.setLayout(gridBagLayout);
            jPanel3.setFont(BOLD);
            jLabel = new JLabel("Target ");
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.1;
            gridBagConstraints.anchor = 15;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel3.add(jLabel);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.1;
            gridBagConstraints.ipadx = 50;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagLayout.setConstraints(this.ttarget, gridBagConstraints);
            jPanel3.add(this.ttarget);
            this.coordinate = new JComboBox();
            this.coordinate.addItem("today");
            this.coordinate.addItem("J2000");
            this.coordinate.addItem("B1975");
            this.coordinate.addItem("B1950");
            this.coordinate.addItem("B1900");
            this.coordinate.addItem("B1875");
            this.coordinate.addItem("B1855");
            this.coordinate.addItem("Galactic");
            this.coordinate.addItem("Supergal.");
            this.coordinate.setSelectedItem("J2000");
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 6;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.1;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagLayout.setConstraints(this.coordinate, gridBagConstraints);
            jPanel3.add(this.coordinate);
            jLabel = new JLabel("Radius ");
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 8;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.1;
            gridBagConstraints.anchor = 15;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel3.add(jLabel);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 10;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.1;
            gridBagConstraints.weighty = 0.1;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagLayout.setConstraints(this.tradius, gridBagConstraints);
            jPanel3.add(this.tradius);
            this.tradius.setText("10.0");
            this.unit = new JComboBox();
            this.unit.addItem("deg");
            this.unit.addItem("arcmin");
            this.unit.addItem("arcsec");
            this.unit.setSelectedItem("arcmin");
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 11;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.1;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagLayout.setConstraints(this.unit, gridBagConstraints);
            jPanel3.add(this.unit);
        } else {
            if (string2 != null) {
                this.tradius.setText(string2);
            }
            if (string != null) {
                this.ttarget.setText(string);
            }
        }
        jPanel4 = new JPanel();
        gridBagLayout = new GridBagLayout();
        jPanel4.setLayout(gridBagLayout);
        jPanel4.setFont(BOLD);
        jPanel4.setBackground(Aladin.BLUE);
        gridBagConstraints = new GridBagConstraints();
        this.lk = new JList[this.nSection];
        jLabel = null;
        for (int i = 0; i < this.nSection; ++i) {
            jLabel = new JLabel();
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = i;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.1;
            gridBagConstraints.weighty = 0.1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 15;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jLabel.setText(this.getSectionName((String)this.vq.getNameKey().elementAt(i)));
            jPanel4.add(jLabel);
            Vector vector = (Vector)this.vq.gethKey().get(this.vq.getNameKey().elementAt(i));
            if (n < 0) {
                this.lk[i] = new JList(vector);
            } else {
                this.lk[i] = new JList(vector);
                this.lk[i].setVisibleRowCount(n);
                this.lk[i].setSelectionMode(2);
                this.lk[i].addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent listSelectionEvent) {
                        VizieRPanel.this.vizier.resetCatalog();
                    }
                });
            }
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = i;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(0, 2, 0, 2);
            JScrollPane jScrollPane = new JScrollPane(this.lk[i]);
            gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
            jPanel4.add(jScrollPane);
        }
        jPanel5 = new JPanel();
        jPanel5.setBackground(Aladin.BLUE);
        jPanel5.setLayout(new FlowLayout(2));
        jPanel5.setFont(BOLD);
        VizieRPanel.makeAdd(jPanel6, this.titre, "North");
        VizieRPanel.makeAdd(jPanel6, jPanel, "Center");
        if (string == null && string2 == null && bl) {
            VizieRPanel.makeAdd(jPanel6, jPanel3, "South");
        }
        JPanel jPanel7 = new JPanel();
        jPanel7.setBackground(Aladin.BLUE);
        jPanel7.setLayout(new BorderLayout(3, 3));
        VizieRPanel.makeAdd(jPanel7, jPanel4, "Center");
        VizieRPanel.makeAdd(jPanel7, jPanel5, "South");
        VizieRPanel.makeAdd(this, jPanel6, "North");
        VizieRPanel.makeAdd(this, jPanel7, "Center");
        this.setTitre(this.target);
    }

    public static void resetList(JList jList) {
        jList.clearSelection();
    }

    public void resetAll() {
        this.tauthor.setText("");
        if (this.ttarget != null) {
            this.ttarget.setText("");
            this.tradius.setText("10.0");
        }
        for (int i = 0; i < this.nSection; ++i) {
            VizieRPanel.resetList(this.lk[i]);
        }
    }

    public boolean submit() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        this.waitCursor();
        for (n = 0; n < this.nSection; n += 1) {
            int[] nArray = this.lk[n].getSelectedIndices();
            for (int i = 0; i < nArray.length; ++i) {
                CDSMethods.append(stringBuffer, (String)this.vq.getNameKey().elementAt(n), (String)this.lk[n].getModel().getElementAt(nArray[i]));
            }
        }
        n = this.vq.submit(this.ttarget.getText(), this.tradius.getText(), (String)this.unit.getSelectedItem(), this.tauthor.getText(), stringBuffer.toString(), this.outputMode, this.resList.getList()) ? 1 : 0;
        this.defaultCursor();
        return n != 0;
    }

    public boolean submit(String string, String string2) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        this.waitCursor();
        for (n = 0; n < this.nSection; n += 1) {
            int[] nArray = this.lk[n].getSelectedIndices();
            for (int i = 0; i < nArray.length; ++i) {
                CDSMethods.append(stringBuffer, (String)this.vq.getNameKey().elementAt(n), (String)this.lk[n].getModel().getElementAt(nArray[i]));
            }
        }
        n = this.vq.submit(string, string2, (String)this.unit.getSelectedItem(), (String)this.coordinate.getSelectedItem(), this.tauthor.getText(), stringBuffer.toString(), this.outputMode, this.resList.getList()) ? 1 : 0;
        this.defaultCursor();
        return n != 0;
    }

    public String[] getSelection(String string) {
        try {
            if (string.compareTo("MISSION") == 0) {
                String[] stringArray = new String[this.vq.getvArchives().size()];
                for (int i = 0; i < this.vq.getvArchives().size(); ++i) {
                    stringArray[i] = new String((String)this.vq.getvArchives().elementAt(i));
                }
                return stringArray;
            }
            if (string.compareTo("SURVEY") == 0) {
                String[] stringArray = new String[this.vq.getvSurveys().size()];
                for (int i = 0; i < this.vq.getvSurveys().size(); ++i) {
                    stringArray[i] = new String((String)this.vq.getvSurveys().elementAt(i));
                }
                return stringArray;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(arrayIndexOutOfBoundsException);
        }
        return null;
    }

    public MyInputStream getResultStream() {
        return this.vq.getResultStream();
    }

    public JList getResultList() {
        return this.resultat;
    }

    public Vector getResultVector() {
        return this.resList.getList();
    }

    public JTextField getAuthor() {
        return this.tauthor;
    }

    public JList getList(int n) {
        return this.lk[n];
    }

    public int getListCount() {
        return this.lk.length;
    }

    public void setLabel(String string) {
        this.titre.setText(string);
    }

    class MyList
    implements ListModel {
        private Vector v = new Vector();

        MyList() {
        }

        protected void initList(Vector vector) {
            this.v = (Vector)vector.clone();
        }

        protected Vector getList() {
            return this.v;
        }

        protected void add(String string) {
            this.v.add(string);
        }

        public Object getElementAt(int n) {
            return this.v.elementAt(n);
        }

        @Override
        public int getSize() {
            return this.v.size();
        }

        @Override
        public void addListDataListener(ListDataListener listDataListener) {
        }

        @Override
        public void removeListDataListener(ListDataListener listDataListener) {
        }
    }
}

